/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableList;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprOrStatements;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeClass;

public class UsedGlobalVariables {
    public static ImmutableList<VarDef> getUsedGlobals(ExprOrStatements e) {
        NameRef nameRef;
        NameLink def;
        ImmutableList.Builder result = ImmutableList.builder();
        if (e instanceof FunctionCall) {
            FunctionCall funcCall = (FunctionCall)e;
            FuncLink f = funcCall.attrFuncLink();
            if (f != null) {
                result.addAll(f.getDef().attrUsedGlobalVariables());
            }
        } else if (e instanceof ExprNewObject) {
            ExprNewObject exprNewObject = (ExprNewObject)e;
            ConstructorDef constr = exprNewObject.attrConstructorDef();
            if (constr != null) {
                result.addAll(constr.getBody().attrUsedGlobalVariables());
            }
        } else if (e instanceof ExprDestroy) {
            ExprDestroy stmtDestroy = (ExprDestroy)e;
            WurstType t = stmtDestroy.getDestroyedObj().attrTyp();
            if (t instanceof WurstTypeClass) {
                WurstTypeClass ct = (WurstTypeClass)t;
                OnDestroyDef ondestr = ct.getClassDef().getOnDestroy();
                result.addAll(ondestr.getBody().attrUsedGlobalVariables());
            }
        } else if (e instanceof NameRef && (def = (nameRef = (NameRef)e).attrNameLink()).getDef() instanceof GlobalVarDef) {
            GlobalVarDef varDef = (GlobalVarDef)def.getDef();
            result.add((Object)varDef);
        }
        for (int i = 0; i < e.size(); ++i) {
            Element child = e.get(i);
            if (!(child instanceof ExprOrStatements)) continue;
            ExprOrStatements child2 = (ExprOrStatements)child;
            result.addAll(child2.attrUsedGlobalVariables());
        }
        return result.build();
    }

    public static ImmutableList<VarDef> getUsedGlobals(FunctionImplementation func) {
        return func.getBody().attrUsedGlobalVariables();
    }

    public static ImmutableList<VarDef> getUsedGlobals(NativeFunc nativeFunc) {
        return ImmutableList.of();
    }

    public static ImmutableList<VarDef> getUsedGlobals(TupleDef tupleDef) {
        return ImmutableList.of();
    }

    public static ImmutableList<VarDef> getReadGlobals(ExprOrStatements e) {
        ImmutableList.Builder result = ImmutableList.builder();
        UsedGlobalVariables.collectReadGlobals(e, (ImmutableList.Builder<VarDef>)result);
        return result.build();
    }

    private static void collectReadGlobals(Element e, ImmutableList.Builder<VarDef> result) {
        if (e instanceof FunctionCall) {
            FunctionCall funcRef = (FunctionCall)e;
            FuncLink f = funcRef.attrFuncLink();
            if (f != null) {
                result.addAll(f.getDef().attrReadGlobalVariables());
            }
        } else if (e instanceof ExprNewObject) {
            ExprNewObject exprNewObject = (ExprNewObject)e;
            ConstructorDef constr = exprNewObject.attrConstructorDef();
            if (constr != null) {
                result.addAll(constr.getBody().attrReadGlobalVariables());
            }
        } else if (e instanceof ExprDestroy) {
            ExprDestroy stmtDestroy = (ExprDestroy)e;
            WurstType t = stmtDestroy.getDestroyedObj().attrTyp();
            if (t instanceof WurstTypeClass) {
                WurstTypeClass ct = (WurstTypeClass)t;
                OnDestroyDef ondestr = ct.getClassDef().getOnDestroy();
                result.addAll(ondestr.getBody().attrReadGlobalVariables());
            }
        } else if (e instanceof NameRef) {
            NameLink def;
            NameRef nameRef = (NameRef)e;
            if ((!(e.getParent() instanceof StmtSet) || ((StmtSet)e.getParent()).getUpdatedExpr() != e) && (def = nameRef.attrNameLink()).getDef() instanceof GlobalVarDef) {
                GlobalVarDef varDef = (GlobalVarDef)def.getDef();
                result.add((Object)varDef);
            }
        } else if (e instanceof ExprClosure) {
            return;
        }
        for (int i = 0; i < e.size(); ++i) {
            Element child = e.get(i);
            if (child instanceof ExprOrStatements) {
                ExprOrStatements child2 = (ExprOrStatements)child;
                result.addAll(child2.attrReadGlobalVariables());
                continue;
            }
            UsedGlobalVariables.collectReadGlobals(child, result);
        }
    }

    public static ImmutableList<VarDef> getReadGlobals(FunctionImplementation func) {
        return func.getBody().attrReadGlobalVariables();
    }

    public static ImmutableList<VarDef> getReadGlobals(NativeFunc nativeFunc) {
        return ImmutableList.of();
    }

    public static ImmutableList<VarDef> getReadGlobals(TupleDef tupleDef) {
        return ImmutableList.of();
    }

    public static ImmutableList<VarDef> getReadGlobals(InitBlock initBlock) {
        return initBlock.getBody().attrReadGlobalVariables();
    }
}

