/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.Vertex;

public class CollisionShape
extends MDXObject {
    private Node _node;
    private Type _type = Type.CUBE;
    private final LinkedHashSet<Vertex> _vertices = new ObservableLinkedHashSet<Vertex>();
    private float _radius = 0.0f;

    @Nonnull
    public Node getNode() {
        return this._node;
    }

    public void setNode(@Nonnull Node node) {
        this._node = node;
    }

    @Nonnull
    public Type getType() {
        return this._type;
    }

    public void setType(@Nonnull Type type) {
        this._type = type;
    }

    public LinkedHashSet<Vertex> getVertices() {
        return this._vertices;
    }

    public float getRadius() {
        return this._radius;
    }

    public void setRadius(float radius) {
        this._radius = radius;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        this._node.write(stream);
        stream.writeUInt32(this._type.ordinal());
        for (Vertex vertex : this.getVertices()) {
            vertex.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public CollisionShape(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._node = new Node(stream);
        long typeL = stream.readUInt32("type");
        if (typeL >= (long)Type.values().length) {
            throw new IllegalArgumentException("type out of bounds 0-" + Type.values().length + " (" + typeL + ")");
        }
        this._type = Type.values()[(int)typeL];
        long verticesCount = 0L;
        switch (this._type) {
            case CUBE: {
                verticesCount = 2L;
                break;
            }
            case PLANE: {
                verticesCount = 1L;
            }
        }
        while (verticesCount > 0L) {
            this._vertices.add(new Vertex(stream));
            --verticesCount;
        }
        boolean hasRadius = false;
        switch (this._type) {
            case SPHERE: {
                hasRadius = true;
                break;
            }
            case CYLINDER: {
                hasRadius = true;
            }
        }
        if (hasRadius) {
            this._radius = stream.readFloat32("radius").floatValue();
        }
    }

    public CollisionShape() {
        this._node = new Node();
    }

    public static enum Type {
        CUBE,
        PLANE,
        SPHERE,
        CYLINDER;

    }
}

