/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VisibilityTrack;

public class ParticleEmitter
extends MDXObject {
    private long _inclusiveSize = 0L;
    private Node _node;
    private float _emissionRate = 0.0f;
    private float _gravity = 0.0f;
    private float _longitude = 0.0f;
    private float _latitude = 0.0f;
    private String _fileName = "unset";
    private float _lifespan = 0.0f;
    private float _initialSpeed = 0.0f;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<EmissionRateTrackChunk> _emissionRateTrackChunks = new ObservableLinkedHashSet<EmissionRateTrackChunk>();
    private final LinkedHashSet<GravityTrackChunk> _gravityTrackChunks = new ObservableLinkedHashSet<GravityTrackChunk>();
    private List<LongitudeTrackChunk> _longitudeTrackChunks = new ArrayList<LongitudeTrackChunk>();
    private final LinkedHashSet<LatitudeTrackChunk> _latitudeTrackChunks = new ObservableLinkedHashSet<LatitudeTrackChunk>();
    private final LinkedHashSet<LifespanTrackChunk> _lifespanTrackChunks = new ObservableLinkedHashSet<LifespanTrackChunk>();
    private final LinkedHashSet<SpeedTrackChunk> _speedTrackChunks = new ObservableLinkedHashSet<SpeedTrackChunk>();
    private final LinkedHashSet<VisibilityTrackChunk> _visibilityTrackChunks = new ObservableLinkedHashSet<VisibilityTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public Node getNode() {
        return this._node;
    }

    public void setNode(@Nonnull Node node) {
        this._node = node;
    }

    public float getEmissionRate() {
        return this._emissionRate;
    }

    public void setEmissionRate(float emissionRate) {
        this._emissionRate = emissionRate;
    }

    public float getGravity() {
        return this._gravity;
    }

    public void setGravity(float gravity) {
        this._gravity = gravity;
    }

    public float getLongitude() {
        return this._longitude;
    }

    public void setLongitude(float longitude) {
        this._longitude = longitude;
    }

    public float getLatitude() {
        return this._latitude;
    }

    public void setLatitude(float latitude) {
        this._latitude = latitude;
    }

    public String getFileName() {
        return this._fileName;
    }

    public float getLifespan() {
        return this._lifespan;
    }

    public void setLifespan(float lifespan) {
        this._lifespan = lifespan;
    }

    public float getInitialSpeed() {
        return this._initialSpeed;
    }

    public void setInitialSpeed(float initialSpeed) {
        this._initialSpeed = initialSpeed;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<EmissionRateTrackChunk> getEmissionRateTrackChunks() {
        return this._emissionRateTrackChunks;
    }

    public void addEmissionRateTrackChunk(@Nonnull EmissionRateTrackChunk val) {
        this._chunks.add(val);
        this._emissionRateTrackChunks.add(val);
    }

    public LinkedHashSet<GravityTrackChunk> getGravityTrackChunks() {
        return this._gravityTrackChunks;
    }

    public void addGravityTrackChunk(@Nonnull GravityTrackChunk val) {
        this._chunks.add(val);
        this._gravityTrackChunks.add(val);
    }

    public List<LongitudeTrackChunk> getLongitudeTrackChunks() {
        return new ArrayList<LongitudeTrackChunk>(this._longitudeTrackChunks);
    }

    public void addLongitudeTrackChunk(@Nonnull LongitudeTrackChunk val) {
        this._chunks.add(val);
        this._longitudeTrackChunks.add(val);
    }

    public LinkedHashSet<LatitudeTrackChunk> getLatitudeTrackChunks() {
        return this._latitudeTrackChunks;
    }

    public void addLatitudeTrackChunk(@Nonnull LatitudeTrackChunk val) {
        this._chunks.add(val);
        this._latitudeTrackChunks.add(val);
    }

    public LinkedHashSet<LifespanTrackChunk> getLifespanTrackChunks() {
        return this._lifespanTrackChunks;
    }

    public void addLifespanTrackChunk(@Nonnull LifespanTrackChunk val) {
        this._chunks.add(val);
        this._lifespanTrackChunks.add(val);
    }

    public LinkedHashSet<SpeedTrackChunk> getSpeedTrackChunks() {
        return this._speedTrackChunks;
    }

    public void addSpeedTrackChunk(@Nonnull SpeedTrackChunk val) {
        this._chunks.add(val);
        this._speedTrackChunks.add(val);
    }

    public LinkedHashSet<VisibilityTrackChunk> getVisibilityTrackChunks() {
        return this._visibilityTrackChunks;
    }

    public void addVisibilityTrackChunk(@Nonnull VisibilityTrackChunk val) {
        this._chunks.add(val);
        this._visibilityTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        this._node.write(stream);
        stream.writeFloat32(this._emissionRate);
        stream.writeFloat32(this._gravity);
        stream.writeFloat32(this._longitude);
        stream.writeFloat32(this._latitude);
        stream.writeBytes(Arrays.copyOf(this._fileName.getBytes(), 260));
        stream.writeFloat32(this._lifespan);
        stream.writeFloat32(this._initialSpeed);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public ParticleEmitter(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._node = new Node(stream);
        this._emissionRate = stream.readFloat32("emissionRate").floatValue();
        this._gravity = stream.readFloat32("gravity").floatValue();
        this._longitude = stream.readFloat32("longitude").floatValue();
        this._latitude = stream.readFloat32("latitude").floatValue();
        this._fileName = new String(stream.readBytes(260, "spawnModeLFileName"), StandardCharsets.US_ASCII);
        this._lifespan = stream.readFloat32("lifespan").floatValue();
        this._initialSpeed = stream.readFloat32("initialVelocity").floatValue();
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(EmissionRateTrackChunk.TOKEN, () -> this.addEmissionRateTrackChunk(new EmissionRateTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(GravityTrackChunk.TOKEN, () -> this.addGravityTrackChunk(new GravityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(LongitudeTrackChunk.TOKEN, () -> this.addLongitudeTrackChunk(new LongitudeTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(LatitudeTrackChunk.TOKEN, () -> this.addLatitudeTrackChunk(new LatitudeTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(LifespanTrackChunk.TOKEN, () -> this.addLifespanTrackChunk(new LifespanTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(SpeedTrackChunk.TOKEN, () -> this.addSpeedTrackChunk(new SpeedTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(VisibilityTrackChunk.TOKEN, () -> this.addVisibilityTrackChunk(new VisibilityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public ParticleEmitter() {
        this._node = new Node();
    }

    public static class VisibilityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPEV");
        private final LinkedHashSet<VisibilityTrack> _visibilityTracks = new ObservableLinkedHashSet<VisibilityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._visibilityTracks;
        }

        public LinkedHashSet<VisibilityTrack> getVisibilityTracks() {
            return this._visibilityTracks;
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._visibilityTracks.add(new VisibilityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }
    }

    public static class SpeedTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPES");
        private final LinkedHashSet<SpeedTrack> _speedTracks = new ObservableLinkedHashSet<SpeedTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._speedTracks;
        }

        public LinkedHashSet<SpeedTrack> getSpeedTracks() {
            return this._speedTracks;
        }

        public SpeedTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._speedTracks.add(new SpeedTrack(stream, this.getInterpolationType(), format));
            }
        }

        public SpeedTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class SpeedTrack
        extends Track {
            private float _speed;
            private float _inTan_speed;
            private float _outTan_speed;

            public float getSpeed() {
                return this._speed;
            }

            public void setSpeed(float speed) {
                this._speed = speed;
            }

            public float getInTanSpeed() {
                return this._inTan_speed;
            }

            public void setInTanSpeed(float speed) {
                this._inTan_speed = speed;
            }

            public float getOutTanSpeed() {
                return this._outTan_speed;
            }

            public void setOutTanSpeed(float speed) {
                this._outTan_speed = speed;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._speed = stream.readFloat32("speed").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_speed = stream.readFloat32("inTan_speed").floatValue();
                    this._outTan_speed = stream.readFloat32("outTan_speed").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._speed);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_speed);
                    stream.writeFloat32(this._outTan_speed);
                }
            }

            public SpeedTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class LifespanTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPEL");
        private final LinkedHashSet<LifespanTrack> _lifespanTracks = new ObservableLinkedHashSet<LifespanTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._lifespanTracks;
        }

        public LinkedHashSet<LifespanTrack> getLifespanTracks() {
            return this._lifespanTracks;
        }

        public LifespanTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._lifespanTracks.add(new LifespanTrack(stream, this.getInterpolationType(), format));
            }
        }

        public LifespanTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class LifespanTrack
        extends Track {
            private float _lifespan;
            private float _inTan_lifespan;
            private float _outTan_lifespan;

            public float getLifespan() {
                return this._lifespan;
            }

            public void setLifespan(float lifespan) {
                this._lifespan = lifespan;
            }

            public float getInTanLifespan() {
                return this._inTan_lifespan;
            }

            public void setInTanLifespan(float lifespan) {
                this._inTan_lifespan = lifespan;
            }

            public float getOutTanLifespan() {
                return this._outTan_lifespan;
            }

            public void setOutTanLifespan(float lifespan) {
                this._outTan_lifespan = lifespan;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._lifespan = stream.readFloat32("lifespan").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_lifespan = stream.readFloat32("inTan_lifespan").floatValue();
                    this._outTan_lifespan = stream.readFloat32("outTan_lifespan").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._lifespan);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_lifespan);
                    stream.writeFloat32(this._outTan_lifespan);
                }
            }

            public LifespanTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class LatitudeTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPLT");
        private final LinkedHashSet<LatitudeTrack> _latitudeTracks = new ObservableLinkedHashSet<LatitudeTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._latitudeTracks;
        }

        public LinkedHashSet<LatitudeTrack> getLatitudeTracks() {
            return this._latitudeTracks;
        }

        public LatitudeTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._latitudeTracks.add(new LatitudeTrack(stream, this.getInterpolationType(), format));
            }
        }

        public LatitudeTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class LatitudeTrack
        extends Track {
            private float _latitude;
            private float _inTan_latitude;
            private float _outTan_latitude;

            public float getLatitude() {
                return this._latitude;
            }

            public void setLatitude(float latitude) {
                this._latitude = latitude;
            }

            public float getInTanLatitude() {
                return this._inTan_latitude;
            }

            public void setInTanLatitude(float latitude) {
                this._inTan_latitude = latitude;
            }

            public float getOutTanLatitude() {
                return this._outTan_latitude;
            }

            public void setOutTanLatitude(float latitude) {
                this._outTan_latitude = latitude;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._latitude = stream.readFloat32("latitude").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_latitude = stream.readFloat32("inTan_latitude").floatValue();
                    this._outTan_latitude = stream.readFloat32("outTan_latitude").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._latitude);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_latitude);
                    stream.writeFloat32(this._outTan_latitude);
                }
            }

            public LatitudeTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class LongitudeTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPLN");
        private final LinkedHashSet<LongitudeTrack> _longitudeTracks = new ObservableLinkedHashSet<LongitudeTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._longitudeTracks;
        }

        public LinkedHashSet<LongitudeTrack> getLongitudeTracks() {
            return this._longitudeTracks;
        }

        public LongitudeTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._longitudeTracks.add(new LongitudeTrack(stream, this.getInterpolationType(), format));
            }
        }

        public LongitudeTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class LongitudeTrack
        extends Track {
            private float _longitude;
            private float _inTan_longitude;
            private float _outTan_longitude;

            public float getLongitude() {
                return this._longitude;
            }

            public void setLongitude(float longitude) {
                this._longitude = longitude;
            }

            public float getInTanLongitude() {
                return this._inTan_longitude;
            }

            public void setInTanLongitude(float longitude) {
                this._inTan_longitude = longitude;
            }

            public float getOutTanLongitude() {
                return this._outTan_longitude;
            }

            public void setOutTanLongitude(float longitude) {
                this._outTan_longitude = longitude;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._longitude = stream.readFloat32("longitude").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_longitude = stream.readFloat32("inTan_longitude").floatValue();
                    this._outTan_longitude = stream.readFloat32("outTan_longitude").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._longitude);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_longitude);
                    stream.writeFloat32(this._outTan_longitude);
                }
            }

            public LongitudeTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class GravityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPEG");
        private final LinkedHashSet<GravityTrack> _gravityTracks = new ObservableLinkedHashSet<GravityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._gravityTracks;
        }

        public LinkedHashSet<GravityTrack> getGravityTracks() {
            return this._gravityTracks;
        }

        public GravityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._gravityTracks.add(new GravityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public GravityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class GravityTrack
        extends Track {
            private float _gravity;
            private float _inTan_gravity;
            private float _outTan_gravity;

            public float getGravity() {
                return this._gravity;
            }

            public void setGravity(float gravity) {
                this._gravity = gravity;
            }

            public float getInTanGravity() {
                return this._inTan_gravity;
            }

            public void setInTanGravity(float gravity) {
                this._inTan_gravity = gravity;
            }

            public float getOutTanGravity() {
                return this._outTan_gravity;
            }

            public void setOutTanGravity(float gravity) {
                this._outTan_gravity = gravity;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._gravity = stream.readFloat32("gravity").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_gravity = stream.readFloat32("inTan_gravity").floatValue();
                    this._outTan_gravity = stream.readFloat32("outTan_gravity").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._gravity);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_gravity);
                    stream.writeFloat32(this._outTan_gravity);
                }
            }

            public GravityTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class EmissionRateTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KPEE");
        private final LinkedHashSet<EmissionRateTrack> _emissionRateTracks = new ObservableLinkedHashSet<EmissionRateTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._emissionRateTracks;
        }

        public LinkedHashSet<EmissionRateTrack> getEmissionRateTracks() {
            return this._emissionRateTracks;
        }

        public EmissionRateTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._emissionRateTracks.add(new EmissionRateTrack(stream, this.getInterpolationType(), format));
            }
        }

        public EmissionRateTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class EmissionRateTrack
        extends Track {
            private float _emissionRate;
            private float _inTan_emissionRate;
            private float _outTan_emissionRate;

            public float getEmissionRate() {
                return this._emissionRate;
            }

            public void setEmissionRate(float emissionRate) {
                this._emissionRate = emissionRate;
            }

            public float getInTanEmissionRate() {
                return this._inTan_emissionRate;
            }

            public void setInTanEmissionRate(float emissionRate) {
                this._inTan_emissionRate = emissionRate;
            }

            public float getOutTanEmissionRate() {
                return this._outTan_emissionRate;
            }

            public void setOutTanEmissionRate(float emissionRate) {
                this._outTan_emissionRate = emissionRate;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._emissionRate = stream.readFloat32("emissionRate").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_emissionRate = stream.readFloat32("inTan_emissionRate").floatValue();
                    this._outTan_emissionRate = stream.readFloat32("outTan_emissionRate").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._emissionRate);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_emissionRate);
                    stream.writeFloat32(this._outTan_emissionRate);
                }
            }

            public EmissionRateTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }
}

