/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import dorkbox.bytes.ArrayExtensionsKt;
import dorkbox.bytes.LZ4Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J0\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J.\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J&\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J&\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J.\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J.\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011J.\u0010#\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013J\u001e\u0010#\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013J&\u0010#\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013J&\u0010#\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013J.\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013J.\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Ldorkbox/bytes/LZ4Util;", "", "()V", "xxHashFactory", "Ljava/lang/ThreadLocal;", "Lnet/jpountz/xxhash/XXHashFactory;", "getXxHashFactory", "()Ljava/lang/ThreadLocal;", "xxHashFactory$delegate", "Lkotlin/Lazy;", "updateDigest32", "", "hash32", "Lnet/jpountz/xxhash/StreamingXXHash32;", "data", "Ljava/io/InputStream;", "bufferSize", "", "start", "", "length", "updateDigest64", "hash64", "Lnet/jpountz/xxhash/StreamingXXHash64;", "xxHash32", "file", "Ljava/io/File;", "seed", "inputStream", "byteArray", "", "string", "", "xxHash32WithSalt", "saltBytes", "xxHash64", "xxHash64WithSalt", "ByteUtilities"})
@SourceDebugExtension(value={"SMAP\nLZ4Util.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LZ4Util.kt\ndorkbox/bytes/LZ4Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
public final class LZ4Util {
    @NotNull
    public static final LZ4Util INSTANCE = new LZ4Util();
    @NotNull
    private static final Lazy xxHashFactory$delegate;

    private LZ4Util() {
    }

    private final ThreadLocal<XXHashFactory> getXxHashFactory() {
        Lazy lazy = xxHashFactory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-xxHashFactory>(...)");
        return (ThreadLocal)object;
    }

    private final void updateDigest32(StreamingXXHash32 hash32, InputStream data, int bufferSize, long start, long length) {
        long skipped = data.skip(start);
        if (skipped != start) {
            throw new IllegalArgumentException("Unable to skip " + start + " bytes. Only able to skip " + skipped + " bytes instead");
        }
        long readLength = length;
        int adjustedBufferSize = (long)bufferSize > readLength ? (int)readLength : bufferSize;
        byte[] buffer = new byte[adjustedBufferSize];
        int read = 1;
        while (read > 0 && readLength > 0L) {
            read = (long)adjustedBufferSize > readLength ? data.read(buffer, 0, (int)readLength) : data.read(buffer, 0, adjustedBufferSize);
            hash32.update(buffer, 0, read);
            readLength -= (long)read;
        }
    }

    private final void updateDigest64(StreamingXXHash64 hash64, InputStream data, int bufferSize, long start, long length) {
        long skipped = data.skip(start);
        if (skipped != start) {
            throw new IllegalArgumentException("Unable to skip " + start + " bytes. Only able to skip " + skipped + " bytes instead");
        }
        long readLength = length;
        int adjustedBufferSize = (long)bufferSize > readLength ? (int)readLength : bufferSize;
        byte[] buffer = new byte[adjustedBufferSize];
        int read = 1;
        while (read > 0 && readLength > 0L) {
            read = (long)adjustedBufferSize > readLength ? data.read(buffer, 0, (int)readLength) : data.read(buffer, 0, adjustedBufferSize);
            hash64.update(buffer, 0, read);
            readLength -= (long)read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int xxHash32(@NotNull File file, long start, long length, int bufferSize, int seed) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash32 streamingXXHash32 = xxHash.newStreamingHash32(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash32);
        StreamingXXHash32 hash32 = streamingXXHash32;
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            INSTANCE.updateDigest32(hash32, it, bufferSize, start, length);
            int n = hash32.getValue();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long xxHash64(@NotNull File file, long start, long length, int bufferSize, long seed) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash64 streamingXXHash64 = xxHash.newStreamingHash64(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash64);
        StreamingXXHash64 hash64 = streamingXXHash64;
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            INSTANCE.updateDigest64(hash64, it, bufferSize, start, length);
            long l = hash64.getValue();
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final int xxHash32(@NotNull byte[] byteArray, int start, int length, int seed) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash32 streamingXXHash32 = xxHash.newStreamingHash32(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash32);
        StreamingXXHash32 hash32 = streamingXXHash32;
        hash32.update(byteArray, start, length);
        return hash32.getValue();
    }

    public final long xxHash64(@NotNull byte[] byteArray, int start, int length, long seed) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash64 streamingXXHash64 = xxHash.newStreamingHash64(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash64);
        StreamingXXHash64 hash64 = streamingXXHash64;
        hash64.update(byteArray, start, length);
        return hash64.getValue();
    }

    public final int xxHash32(@NotNull String string, int start, int length, int seed) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash32 streamingXXHash32 = xxHash.newStreamingHash32(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash32);
        StreamingXXHash32 hash32 = streamingXXHash32;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        byte[] charToBytes = ArrayExtensionsKt.toBytes16(cArray, start, length);
        hash32.update(charToBytes, 0, charToBytes.length);
        return hash32.getValue();
    }

    public final long xxHash64(@NotNull String string, int start, int length, long seed) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash64 streamingXXHash64 = xxHash.newStreamingHash64(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash64);
        StreamingXXHash64 hash64 = streamingXXHash64;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        byte[] charToBytes = ArrayExtensionsKt.toBytes16(cArray, start, length);
        hash64.update(charToBytes, 0, charToBytes.length);
        return hash64.getValue();
    }

    public final int xxHash32WithSalt(@NotNull String string, @NotNull byte[] saltBytes, int start, int length, int seed) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)saltBytes, (String)"saltBytes");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash32 streamingXXHash32 = xxHash.newStreamingHash32(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash32);
        StreamingXXHash32 hash32 = streamingXXHash32;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        byte[] charToBytes = ArrayExtensionsKt.toBytes16(cArray, start, length);
        hash32.update(charToBytes, 0, charToBytes.length);
        hash32.update(saltBytes, 0, saltBytes.length);
        return hash32.getValue();
    }

    public final long xxHash64WithSalt(@NotNull String string, @NotNull byte[] saltBytes, int start, int length, long seed) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)saltBytes, (String)"saltBytes");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash64 streamingXXHash64 = xxHash.newStreamingHash64(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash64);
        StreamingXXHash64 hash64 = streamingXXHash64;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        byte[] charToBytes = ArrayExtensionsKt.toBytes16(cArray, start, length);
        hash64.update(charToBytes, 0, charToBytes.length);
        hash64.update(saltBytes, 0, saltBytes.length);
        return hash64.getValue();
    }

    public final int xxHash32WithSalt(@NotNull byte[] string, @NotNull byte[] saltBytes, int start, int length, int seed) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)saltBytes, (String)"saltBytes");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash32 streamingXXHash32 = xxHash.newStreamingHash32(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash32);
        StreamingXXHash32 hash32 = streamingXXHash32;
        hash32.update(string, start, length);
        hash32.update(saltBytes, 0, saltBytes.length);
        return hash32.getValue();
    }

    public final long xxHash64WithSalt(@NotNull byte[] string, @NotNull byte[] saltBytes, int start, int length, long seed) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)saltBytes, (String)"saltBytes");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash64 streamingXXHash64 = xxHash.newStreamingHash64(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash64);
        StreamingXXHash64 hash64 = streamingXXHash64;
        hash64.update(string, start, length);
        hash64.update(saltBytes, 0, saltBytes.length);
        return hash64.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int xxHash32(@NotNull InputStream inputStream, int bufferSize, int seed) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash32 streamingXXHash32 = xxHash.newStreamingHash32(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash32);
        StreamingXXHash32 hash32 = streamingXXHash32;
        byte[] buffer = new byte[bufferSize];
        int read = 0;
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            while (true) {
                int n;
                int it2 = n = it.read(buffer);
                boolean bl2 = false;
                read = it2;
                if (n <= 0) break;
                hash32.update(buffer, 0, read);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return hash32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long xxHash64(@NotNull InputStream inputStream, int bufferSize, long seed) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        XXHashFactory xxHash = this.getXxHashFactory().get();
        StreamingXXHash64 streamingXXHash64 = xxHash.newStreamingHash64(seed);
        Intrinsics.checkNotNull((Object)streamingXXHash64);
        StreamingXXHash64 hash64 = streamingXXHash64;
        byte[] buffer = new byte[bufferSize];
        int read = 0;
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            while (true) {
                int n;
                int it2 = n = it.read(buffer);
                boolean bl2 = false;
                read = it2;
                if (n <= 0) break;
                hash64.update(buffer, 0, read);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return hash64.getValue();
    }

    static {
        try {
            Class.forName("net.jpountz.xxhash.XXHashFactory");
        }
        catch (Exception e) {
            System.err.println("Please add the LZMA library to your classpath, for example: implementation(\"org.lz4:lz4-java:1.8.0\")");
            throw e;
        }
        xxHashFactory$delegate = LazyKt.lazy((Function0)xxHashFactory.2.INSTANCE);
    }
}

