/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.crigges.jmpq3.AttributesFile;
import systems.crigges.jmpq3.BlockTable;
import systems.crigges.jmpq3.HashTable;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.Listfile;
import systems.crigges.jmpq3.MPQOpenOption;
import systems.crigges.jmpq3.MpqFile;
import systems.crigges.jmpq3.compression.RecompressOptions;
import systems.crigges.jmpq3.security.MPQEncryption;
import systems.crigges.jmpq3.security.MPQHashGenerator;

public class JMpqEditor
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final int ARCHIVE_HEADER_MAGIC = ByteBuffer.wrap(new byte[]{77, 80, 81, 26}).order(ByteOrder.LITTLE_ENDIAN).getInt();
    public static final int USER_DATA_HEADER_MAGIC = ByteBuffer.wrap(new byte[]{77, 80, 81, 27}).order(ByteOrder.LITTLE_ENDIAN).getInt();
    private static final int KEY_HASH_TABLE;
    private static final int KEY_BLOCK_TABLE;
    public static File tempDir;
    private AttributesFile attributes;
    private final boolean legacyCompatibility;
    private final SeekableByteChannel fc;
    private long headerOffset;
    private int headerSize;
    private long archiveSize;
    private int formatVersion;
    private int sectorSizeShift;
    private int discBlockSize;
    private long hashPos;
    private long blockPos;
    private int hashSize;
    private int blockSize;
    private HashTable hashTable;
    private BlockTable blockTable;
    private Listfile listFile = new Listfile();
    private final IdentityHashMap<String, ByteBuffer> filenameToData = new IdentityHashMap();
    private boolean keepHeaderOffset = true;
    private int newHeaderSize;
    private long newArchiveSize;
    private int newFormatVersion;
    private int newSectorSizeShift;
    private int newDiscBlockSize;
    private long newHashPos;
    private long newBlockPos;
    private int newHashSize;
    private int newBlockSize;
    private boolean canWrite;

    public JMpqEditor(Path mpqArchive, MPQOpenOption ... openOptions) throws JMpqException {
        this.canWrite = !Arrays.asList(openOptions).contains((Object)MPQOpenOption.READ_ONLY);
        this.legacyCompatibility = Arrays.asList(openOptions).contains((Object)MPQOpenOption.FORCE_V0);
        this.log.debug(mpqArchive.toString());
        try {
            OpenOption[] openOptionArray;
            this.setupTempDir();
            if (this.canWrite) {
                OpenOption[] openOptionArray2 = new OpenOption[3];
                openOptionArray2[0] = StandardOpenOption.CREATE;
                openOptionArray2[1] = StandardOpenOption.READ;
                openOptionArray = openOptionArray2;
                openOptionArray2[2] = StandardOpenOption.WRITE;
            } else {
                OpenOption[] openOptionArray3 = new OpenOption[1];
                openOptionArray = openOptionArray3;
                openOptionArray3[0] = StandardOpenOption.READ;
            }
            OpenOption[] fcOptions = openOptionArray;
            this.fc = FileChannel.open(mpqArchive, fcOptions);
            this.readMpq();
        }
        catch (IOException e) {
            throw new JMpqException(mpqArchive.toAbsolutePath() + ": " + e.getMessage());
        }
    }

    public JMpqEditor(byte[] mpqArchive, MPQOpenOption ... openOptions) throws JMpqException {
        this.canWrite = !Arrays.asList(openOptions).contains((Object)MPQOpenOption.READ_ONLY);
        this.legacyCompatibility = Arrays.asList(openOptions).contains((Object)MPQOpenOption.FORCE_V0);
        try {
            this.setupTempDir();
            this.fc = new SeekableInMemoryByteChannel(mpqArchive);
            this.readMpq();
        }
        catch (IOException e) {
            throw new JMpqException("Byte array mpq: " + e.getMessage());
        }
    }

    private void readMpq() throws IOException {
        this.headerOffset = this.searchHeader();
        this.readHeaderSize();
        this.readHeader();
        this.checkLegacyCompat();
        this.readHashTable();
        this.readBlockTable();
        this.readListFile();
        this.readAttributesFile();
    }

    public JMpqEditor(File mpqArchive, MPQOpenOption ... openOptions) throws IOException {
        this(mpqArchive.toPath(), openOptions);
    }

    @Deprecated
    public JMpqEditor(File mpqArchive) throws IOException {
        this(mpqArchive.toPath(), MPQOpenOption.FORCE_V0);
    }

    private void checkLegacyCompat() throws IOException {
        if (this.legacyCompatibility) {
            this.archiveSize = Math.min(this.archiveSize, this.fc.size() - this.headerOffset);
            this.blockSize = (int)Math.min((long)this.blockSize, (this.archiveSize - this.blockPos) / 16L);
        }
    }

    private void readAttributesFile() {
        if (this.hasFile("(attributes)")) {
            try {
                this.attributes = new AttributesFile(this.extractFileAsBytes("(attributes)"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setExternalListfile(File externalListfilePath) {
        if (!this.canWrite) {
            this.log.warn("The mpq was opened as readonly, setting an external listfile will have no effect.");
            return;
        }
        if (!externalListfilePath.exists()) {
            this.log.warn("External MPQ File: " + externalListfilePath.getAbsolutePath() + " does not exist and will not be used");
            return;
        }
        try {
            this.listFile = new Listfile(Files.readAllBytes(externalListfilePath.toPath()));
            this.checkListfileEntries();
        }
        catch (Exception ex) {
            this.log.warn("Could not apply external listfile: " + externalListfilePath.getAbsolutePath());
        }
    }

    private void readListFile() {
        if (this.hasFile("(listfile)")) {
            try {
                this.listFile = new Listfile(this.extractFileAsBytes("(listfile)"));
                this.checkListfileEntries();
            }
            catch (Exception e) {
                this.log.warn("Extracting the mpq's listfile failed. It cannot be rebuild.", (Throwable)e);
            }
        } else {
            this.log.warn("The mpq doesn't contain a listfile. It cannot be rebuild.");
            this.canWrite = false;
        }
    }

    private void checkListfileEntries() throws JMpqException {
        int hiddenFiles = (this.hasFile("(attributes)") ? 2 : 1) + (this.hasFile("(signature)") ? 1 : 0);
        if (this.canWrite) {
            this.checkListfileCompleteness(hiddenFiles);
        }
    }

    private void checkListfileCompleteness(int hiddenFiles) throws JMpqException {
        if (this.listFile.getFiles().size() <= this.blockTable.getAllVaildBlocks().size() - hiddenFiles) {
            this.log.warn("mpq's listfile is incomplete. Blocks without listfile entry will be discarded");
        }
        for (String fileName : this.listFile.getFiles()) {
            if (this.hasFile(fileName)) continue;
            this.log.warn("listfile entry does not exist in archive and will be discarded: " + fileName);
        }
        this.listFile.getFileMap().entrySet().removeIf(file -> !this.hasFile((String)file.getValue()));
    }

    private void readBlockTable() throws IOException {
        ByteBuffer blockBuffer = ByteBuffer.allocate(this.blockSize * 16).order(ByteOrder.LITTLE_ENDIAN);
        this.fc.position(this.headerOffset + this.blockPos);
        JMpqEditor.readFully(blockBuffer, this.fc);
        blockBuffer.rewind();
        this.blockTable = new BlockTable(blockBuffer);
    }

    private void readHashTable() throws IOException {
        ByteBuffer hashBuffer = ByteBuffer.allocate(this.hashSize * 16);
        this.fc.position(this.headerOffset + this.hashPos);
        JMpqEditor.readFully(hashBuffer, this.fc);
        hashBuffer.rewind();
        MPQEncryption decrypt = new MPQEncryption(KEY_HASH_TABLE, true);
        decrypt.processSingle(hashBuffer);
        hashBuffer.rewind();
        this.hashTable = new HashTable(this.hashSize);
        this.hashTable.readFromBuffer(hashBuffer);
    }

    private void readHeaderSize() throws IOException {
        ByteBuffer probe = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        this.fc.position(this.headerOffset + 4L);
        JMpqEditor.readFully(probe, this.fc);
        this.headerSize = probe.getInt(0);
        if (this.legacyCompatibility) {
            this.headerSize = 32;
        } else if (this.headerSize < 32 || 208 < this.headerSize) {
            throw new JMpqException("Bad header size.");
        }
    }

    private void setupTempDir() throws JMpqException {
        try {
            File[] files;
            Path path = Paths.get(System.getProperty("java.io.tmpdir") + "jmpq", new String[0]);
            tempDir = path.toFile();
            if (!tempDir.exists()) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            if ((files = tempDir.listFiles()) != null) {
                for (File f : files) {
                    f.delete();
                }
            }
        }
        catch (IOException e) {
            try {
                tempDir = Files.createTempDirectory("jmpq", new FileAttribute[0]).toFile();
            }
            catch (IOException e1) {
                throw new JMpqException(e1);
            }
        }
    }

    private long searchHeader() throws IOException {
        ByteBuffer probe = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        long fileSize = this.fc.size();
        long filePos = 0L;
        while (filePos + (long)probe.capacity() < fileSize) {
            probe.rewind();
            this.fc.position(filePos);
            JMpqEditor.readFully(probe, this.fc);
            int sample = probe.getInt(0);
            if (sample == ARCHIVE_HEADER_MAGIC) {
                return filePos;
            }
            if (sample == USER_DATA_HEADER_MAGIC && !this.legacyCompatibility) {
                probe.rewind();
                this.fc.position(filePos + 8L);
                JMpqEditor.readFully(probe, this.fc);
                filePos += (long)probe.getInt(0) & 0xFFFFFFFFL;
                filePos &= 0xFFFFFFFFFFFFFE00L;
            }
            filePos += 512L;
        }
        throw new JMpqException("No MPQ archive in file.");
    }

    private void readHeader() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.headerSize).order(ByteOrder.LITTLE_ENDIAN);
        JMpqEditor.readFully(buffer, this.fc);
        buffer.rewind();
        this.archiveSize = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.formatVersion = buffer.getShort();
        if (this.legacyCompatibility) {
            this.formatVersion = 0;
        }
        this.sectorSizeShift = buffer.getShort();
        this.discBlockSize = 512 * (1 << this.sectorSizeShift);
        this.hashPos = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.blockPos = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.hashSize = buffer.getInt() & 0xFFFFFFF;
        this.blockSize = buffer.getInt();
        if (this.formatVersion >= 1) {
            buffer.getLong();
            this.hashPos |= ((long)buffer.getShort() & 0xFFFFL) << 32;
            this.blockPos |= ((long)buffer.getShort() & 0xFFFFL) << 32;
        }
        if (this.formatVersion >= 2) {
            this.archiveSize = buffer.getLong();
            buffer.getLong();
            buffer.getLong();
        }
        if (this.formatVersion >= 3) {
            buffer.getLong();
            buffer.getLong();
            buffer.getLong();
            buffer.getLong();
            buffer.getLong();
            buffer.getInt();
            byte[] md5 = new byte[16];
            buffer.get(md5);
            buffer.get(md5);
            buffer.get(md5);
            buffer.get(md5);
            buffer.get(md5);
            buffer.get(md5);
        }
    }

    private void writeHeader(MappedByteBuffer buffer) {
        buffer.putInt(this.newHeaderSize);
        buffer.putInt((int)this.newArchiveSize);
        buffer.putShort((short)this.newFormatVersion);
        buffer.putShort((short)this.newSectorSizeShift);
        buffer.putInt((int)this.newHashPos);
        buffer.putInt((int)this.newBlockPos);
        buffer.putInt(this.newHashSize);
        buffer.putInt(this.newBlockSize);
    }

    private void calcNewTableSize() {
        int current;
        int target = this.listFile.getFiles().size() + 2;
        for (current = 2; current < target; current *= 2) {
        }
        this.newHashSize = current * 2;
        this.newBlockSize = this.listFile.getFiles().size() + 2;
    }

    public void extractAllFiles(File dest) throws JMpqException {
        if (!dest.isDirectory()) {
            throw new JMpqException("Destination location isn't a directory");
        }
        if (this.hasFile("(listfile)") && this.listFile != null) {
            File temp;
            for (String s : this.listFile.getFiles()) {
                String normalized = File.separatorChar == '\\' ? s : s.replace("\\", File.separator);
                this.log.debug("extracting: " + normalized);
                File temp2 = new File(dest.getAbsolutePath() + File.separator + normalized);
                temp2.getParentFile().mkdirs();
                if (!this.hasFile(s)) continue;
                try {
                    this.extractFile(s, temp2);
                }
                catch (JMpqException e) {
                    this.log.warn("File possibly corrupted and could not be extracted: " + s);
                }
            }
            if (this.hasFile("(attributes)")) {
                temp = new File(dest.getAbsolutePath() + File.separator + "(attributes)");
                this.extractFile("(attributes)", temp);
            }
            temp = new File(dest.getAbsolutePath() + File.separator + "(listfile)");
            this.extractFile("(listfile)", temp);
        } else {
            ArrayList<BlockTable.Block> blocks = this.blockTable.getAllVaildBlocks();
            try {
                int i = 0;
                for (BlockTable.Block b : blocks) {
                    if (b.hasFlag(65536)) continue;
                    ByteBuffer buf = ByteBuffer.allocate(b.getCompressedSize()).order(ByteOrder.LITTLE_ENDIAN);
                    this.fc.position(this.headerOffset + (long)b.getFilePos());
                    JMpqEditor.readFully(buf, this.fc);
                    buf.rewind();
                    MpqFile f = new MpqFile(buf, b, this.discBlockSize, "");
                    f.extractToFile(new File(dest.getAbsolutePath() + File.separator + i));
                    ++i;
                }
            }
            catch (IOException e) {
                throw new JMpqException(e);
            }
        }
    }

    public int getTotalFileCount() throws JMpqException {
        return this.blockTable.getAllVaildBlocks().size();
    }

    public void extractFile(String name, File dest) throws JMpqException {
        try {
            MpqFile f = this.getMpqFile(name);
            f.extractToFile(dest);
        }
        catch (Exception e) {
            throw new JMpqException(e);
        }
    }

    public byte[] extractFileAsBytes(String name) throws JMpqException {
        try {
            MpqFile f = this.getMpqFile(name);
            return f.extractToBytes();
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    public String extractFileAsString(String name) throws JMpqException {
        try {
            byte[] f = this.extractFileAsBytes(name);
            return new String(f);
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    public boolean hasFile(String name) {
        try {
            this.hashTable.getBlockIndexOfFile(name);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public List<String> getFileNames() {
        return new ArrayList<String>(this.listFile.getFiles());
    }

    public void extractFile(String name, OutputStream dest) throws JMpqException {
        try {
            MpqFile f = this.getMpqFile(name);
            f.extractToOutputStream(dest);
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    public MpqFile getMpqFile(String name) throws IOException {
        int pos = this.hashTable.getBlockIndexOfFile(name);
        BlockTable.Block b = this.blockTable.getBlockAtPos(pos);
        ByteBuffer buffer = ByteBuffer.allocate(b.getCompressedSize()).order(ByteOrder.LITTLE_ENDIAN);
        this.fc.position(this.headerOffset + (long)b.getFilePos());
        JMpqEditor.readFully(buffer, this.fc);
        buffer.rewind();
        return new MpqFile(buffer, b, this.discBlockSize, name);
    }

    public MpqFile getMpqFileByBlock(BlockTable.Block block) throws IOException {
        if (block.hasFlag(65536)) {
            throw new IOException("cant access this block");
        }
        ByteBuffer buffer = ByteBuffer.allocate(block.getCompressedSize()).order(ByteOrder.LITTLE_ENDIAN);
        this.fc.position(this.headerOffset + (long)block.getFilePos());
        JMpqEditor.readFully(buffer, this.fc);
        buffer.rewind();
        return new MpqFile(buffer, block, this.discBlockSize, "");
    }

    public List<MpqFile> getMpqFilesByBlockTable() throws IOException {
        ArrayList<MpqFile> mpqFiles = new ArrayList<MpqFile>();
        ArrayList<BlockTable.Block> list = this.blockTable.getAllVaildBlocks();
        for (BlockTable.Block block : list) {
            try {
                MpqFile mpqFile = this.getMpqFileByBlock(block);
                mpqFiles.add(mpqFile);
            }
            catch (IOException iOException) {}
        }
        return mpqFiles;
    }

    public void deleteFile(String name) {
        if (!this.canWrite) {
            throw new NonWritableChannelException();
        }
        if (this.listFile.containsFile(name)) {
            this.listFile.removeFile(name);
            this.filenameToData.remove(name);
        }
    }

    public void insertByteArray(String name, byte[] input, boolean override) throws NonWritableChannelException, IllegalArgumentException {
        if (!this.canWrite) {
            throw new NonWritableChannelException();
        }
        if (!override && this.listFile.containsFile(name)) {
            throw new IllegalArgumentException("Archive already contains file with name: " + name);
        }
        this.listFile.addFile(name);
        ByteBuffer data = ByteBuffer.wrap(input);
        this.filenameToData.put(name, data);
    }

    public void insertByteArray(String name, byte[] input) throws NonWritableChannelException, IllegalArgumentException {
        this.insertByteArray(name, input, false);
    }

    public void insertFile(String name, File file) throws IOException, IllegalArgumentException {
        this.insertFile(name, file, false);
    }

    public void insertFile(String name, File file, boolean override) throws IOException, IllegalArgumentException {
        if (!this.canWrite) {
            throw new NonWritableChannelException();
        }
        this.log.info("insert file: " + name);
        if (!override && this.listFile.containsFile(name)) {
            throw new IllegalArgumentException("Archive already contains file with name: " + name);
        }
        try {
            this.listFile.addFile(name);
            ByteBuffer data = ByteBuffer.wrap(Files.readAllBytes(file.toPath()));
            this.filenameToData.put(name, data);
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    public void closeReadOnly() throws IOException {
        this.fc.close();
    }

    @Override
    public void close() throws IOException {
        this.close(true, true, false);
    }

    public void close(boolean buildListfile, boolean buildAttributes, boolean recompress) throws IOException {
        this.close(buildListfile, buildAttributes, new RecompressOptions(recompress));
    }

    public void close(boolean buildListfile, boolean buildAttributes, RecompressOptions options) throws IOException {
        if (!this.canWrite || !this.fc.isOpen()) {
            this.fc.close();
            this.log.debug("closed readonly mpq.");
            return;
        }
        long t = System.nanoTime();
        this.log.debug("Building mpq");
        if (this.listFile == null) {
            this.fc.close();
            return;
        }
        File temp = File.createTempFile("jmpq", "temp", tempDir);
        temp.deleteOnExit();
        try (FileChannel writeChannel = FileChannel.open(temp.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            ByteBuffer headerReader = ByteBuffer.allocate((int)((this.keepHeaderOffset ? this.headerOffset : 0L) + 4L)).order(ByteOrder.LITTLE_ENDIAN);
            this.fc.position(this.keepHeaderOffset ? 0L : this.headerOffset);
            JMpqEditor.readFully(headerReader, this.fc);
            headerReader.rewind();
            writeChannel.write(headerReader);
            this.newFormatVersion = this.formatVersion;
            switch (this.newFormatVersion) {
                case 0: {
                    this.newHeaderSize = 32;
                    break;
                }
                case 1: {
                    this.newHeaderSize = 44;
                    break;
                }
                case 2: 
                case 3: {
                    this.newHeaderSize = 208;
                }
            }
            this.newSectorSizeShift = options.recompress ? Math.min(options.newSectorSizeShift, 15) : this.sectorSizeShift;
            this.newDiscBlockSize = options.recompress ? 512 * (1 << this.newSectorSizeShift) : this.discBlockSize;
            this.calcNewTableSize();
            ArrayList<BlockTable.Block> newBlocks = new ArrayList<BlockTable.Block>();
            ArrayList<String> newFiles = new ArrayList<String>();
            ArrayList<String> existingFiles = new ArrayList<String>(this.listFile.getFiles());
            this.sortListfileEntries(existingFiles);
            this.log.debug("Sorted blocks");
            if (this.attributes != null) {
                this.attributes.setNames(existingFiles);
            }
            long currentPos = (this.keepHeaderOffset ? this.headerOffset : 0L) + (long)this.headerSize;
            for (String string : this.filenameToData.keySet()) {
                existingFiles.remove(string);
            }
            for (String string : existingFiles) {
                if (options.recompress && !string.endsWith(".wav")) {
                    ByteBuffer extracted = ByteBuffer.wrap(this.extractFileAsBytes(string));
                    this.filenameToData.put(string, extracted);
                    continue;
                }
                newFiles.add(string);
                int pos = this.hashTable.getBlockIndexOfFile(string);
                BlockTable.Block b = this.blockTable.getBlockAtPos(pos);
                ByteBuffer buf = ByteBuffer.allocate(b.getCompressedSize()).order(ByteOrder.LITTLE_ENDIAN);
                this.fc.position(this.headerOffset + (long)b.getFilePos());
                JMpqEditor.readFully(buf, this.fc);
                buf.rewind();
                MpqFile f = new MpqFile(buf, b, this.discBlockSize, string);
                MappedByteBuffer fileWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, b.getCompressedSize());
                BlockTable.Block newBlock = new BlockTable.Block(currentPos - (this.keepHeaderOffset ? this.headerOffset : 0L), 0, 0, b.getFlags());
                newBlocks.add(newBlock);
                f.writeFileAndBlock(newBlock, fileWriter);
                currentPos += (long)b.getCompressedSize();
            }
            this.log.debug("Added existing files");
            HashMap<String, ByteBuffer> newFileMap = new HashMap<String, ByteBuffer>();
            for (String newFileName : this.filenameToData.keySet()) {
                ByteBuffer newFile = this.filenameToData.get(newFileName);
                newFiles.add(newFileName);
                newFileMap.put(newFileName, newFile);
                MappedByteBuffer fileWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, (long)newFile.limit() * 2L);
                BlockTable.Block newBlock = new BlockTable.Block(currentPos - (this.keepHeaderOffset ? this.headerOffset : 0L), 0, 0, 0);
                newBlocks.add(newBlock);
                MpqFile.writeFileAndBlock(newFile.array(), newBlock, fileWriter, this.newDiscBlockSize, options);
                currentPos += (long)newBlock.getCompressedSize();
                this.log.debug("Added file " + newFileName);
            }
            this.log.debug("Added new files");
            if (buildListfile && !this.listFile.getFiles().isEmpty()) {
                newFiles.add("(listfile)");
                byte[] byArray = this.listFile.asByteArray();
                MappedByteBuffer fileWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, (long)byArray.length * 2L);
                BlockTable.Block newBlock = new BlockTable.Block(currentPos - (this.keepHeaderOffset ? this.headerOffset : 0L), 0, 0, -2147286528);
                newBlocks.add(newBlock);
                MpqFile.writeFileAndBlock(byArray, newBlock, fileWriter, this.newDiscBlockSize, "(listfile)", options);
                currentPos += (long)newBlock.getCompressedSize();
                this.log.debug("Added listfile");
            }
            this.newBlockSize = newBlocks.size();
            this.newHashPos = currentPos - (this.keepHeaderOffset ? this.headerOffset : 0L);
            this.newBlockPos = this.newHashPos + (long)this.newHashSize * 16L;
            int n = this.newHashSize;
            HashTable hashTable = new HashTable(n);
            int blockIndex = 0;
            for (String file : newFiles) {
                hashTable.setFileBlockIndex(file, (short)0, blockIndex++);
            }
            ByteBuffer hashTableBuffer = ByteBuffer.allocate(n * 16);
            hashTable.writeToBuffer(hashTableBuffer);
            hashTableBuffer.flip();
            MPQEncryption encrypt = new MPQEncryption(KEY_HASH_TABLE, false);
            encrypt.processSingle(hashTableBuffer);
            hashTableBuffer.flip();
            writeChannel.position(currentPos);
            JMpqEditor.writeFully(hashTableBuffer, writeChannel);
            currentPos = writeChannel.position();
            MappedByteBuffer blocktableWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, (long)this.newBlockSize * 16L);
            blocktableWriter.order(ByteOrder.LITTLE_ENDIAN);
            BlockTable.writeNewBlocktable(newBlocks, this.newBlockSize, blocktableWriter);
            this.newArchiveSize = (currentPos += (long)this.newBlockSize * 16L) + 1L - (this.keepHeaderOffset ? this.headerOffset : 0L);
            MappedByteBuffer headerWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, (this.keepHeaderOffset ? this.headerOffset : 0L) + 4L, (long)this.headerSize + 4L);
            headerWriter.order(ByteOrder.LITTLE_ENDIAN);
            this.writeHeader(headerWriter);
            MappedByteBuffer tempReader = writeChannel.map(FileChannel.MapMode.READ_WRITE, 0L, currentPos + 1L);
            tempReader.position(0);
            this.fc.position(0L);
            this.fc.write(tempReader);
            this.fc.truncate(this.fc.position());
            this.fc.close();
        }
        t = System.nanoTime() - t;
        this.log.debug("Rebuild complete. Took: " + t / 1000000L + "ms");
    }

    private void sortListfileEntries(ArrayList<String> remainingFiles) {
        remainingFiles.sort((o1, o2) -> {
            int pos1 = 999999999;
            int pos2 = 999999999;
            try {
                pos1 = this.hashTable.getBlockIndexOfFile((String)o1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                pos2 = this.hashTable.getBlockIndexOfFile((String)o2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return pos1 - pos2;
        });
    }

    private static void readFully(ByteBuffer buffer, ReadableByteChannel src) throws IOException {
        while (buffer.hasRemaining()) {
            if (src.read(buffer) >= 1) continue;
            throw new EOFException("Cannot read enough bytes.");
        }
    }

    private static void writeFully(ByteBuffer buffer, WritableByteChannel dest) throws IOException {
        while (buffer.hasRemaining()) {
            if (dest.write(buffer) >= 1) continue;
            throw new EOFException("Cannot write enough bytes.");
        }
    }

    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setKeepHeaderOffset(boolean keepHeaderOffset) {
        this.keepHeaderOffset = keepHeaderOffset;
    }

    public BlockTable getBlockTable() {
        return this.blockTable;
    }

    public String toString() {
        return "JMpqEditor [headerSize=" + this.headerSize + ", archiveSize=" + this.archiveSize + ", formatVersion=" + this.formatVersion + ", discBlockSize=" + this.discBlockSize + ", hashPos=" + this.hashPos + ", blockPos=" + this.blockPos + ", hashSize=" + this.hashSize + ", blockSize=" + this.blockSize + ", hashMap=" + this.hashTable + "]";
    }

    public Collection<String> getListfileEntries() {
        return Collections.unmodifiableCollection(this.listFile.getFiles());
    }

    static {
        MPQHashGenerator hasher = MPQHashGenerator.getFileKeyGenerator();
        hasher.process("(hash table)");
        KEY_HASH_TABLE = hasher.getHash();
        hasher.reset();
        hasher.process("(block table)");
        KEY_BLOCK_TABLE = hasher.getHash();
    }
}

