/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.dataTypes.app.LoadingScreenBackground;
import net.moonlightflower.wc3libs.dataTypes.app.TerrainFog;
import net.moonlightflower.wc3libs.dataTypes.app.TerrainFogType;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class W3F {
    public static final File CAMPAIGN_PATH = new File("war3campaign.w3f");
    private int _savesAmount = 0;
    private int _editorVersion = 0;
    private String _name;
    private String _difficulty;
    private String _author;
    private String _description;
    private Flags _flags = Flags.valueOf(0);
    private LoadingScreenBackground _campaignBackground;
    private File _minimapPath;
    private AmbientSound _ambientSound;
    private TerrainFog _terrainFog;
    private UIRace _uiRace;
    private List<MapEntry> _maps = new ArrayList<MapEntry>();
    private List<ListedMapEntry> _listedMaps = new ArrayList<ListedMapEntry>();

    public int getSavesAmount() {
        return this._savesAmount;
    }

    public void setSavesAmount(int val) {
        this._savesAmount = val;
    }

    public int getEditorVersion() {
        return this._editorVersion;
    }

    public void setEditorVersion(int val) {
        this._editorVersion = val;
    }

    public String getCampaignName() {
        return this._name;
    }

    public void setCampaignName(String val) {
        this._name = val;
    }

    public String getDifficulty() {
        return this._difficulty;
    }

    public void setDifficulty(String val) {
        this._difficulty = val;
    }

    public String getCampaignAuthor() {
        return this._author;
    }

    public void setCampaignAuthor(String val) {
        this._author = val;
    }

    public String getCampaignDescription() {
        return this._description;
    }

    public void setCampaignDescription(String val) {
        this._description = val;
    }

    @Nonnull
    public Flags getFlags() {
        return this._flags;
    }

    public void setFlags(@Nonnull Flags val) {
        this._flags = val;
    }

    public boolean getFlag(@Nonnull Flags.Flag flag) {
        return this._flags.containsFlag(flag);
    }

    public void setFlag(@Nonnull Flags.Flag flag, boolean val) {
        this._flags.setFlag(flag, val);
    }

    @Nullable
    public LoadingScreenBackground getCampaignBackground() {
        return this._campaignBackground;
    }

    public void setCampaignBackground(@Nullable LoadingScreenBackground val) {
        this._campaignBackground = val;
    }

    private void setCampaignBackground(int index, String customPath) {
        if (index < 0) {
            this.setCampaignBackground(new LoadingScreenBackground.CustomBackground(new File(customPath)));
        } else if (index > 0) {
            this.setCampaignBackground(LoadingScreenBackground.PresetBackground.valueOf(index));
        } else {
            this.setCampaignBackground(null);
        }
    }

    @Nullable
    public File getMinimapPath() {
        return this._minimapPath;
    }

    public void setMinimapPath(@Nullable File val) {
        this._minimapPath = val;
    }

    @Nullable
    public AmbientSound getAmbientSound() {
        return this._ambientSound;
    }

    public void setAmbientSound(@Nullable AmbientSound val) {
        this._ambientSound = val;
    }

    private void setAmbientSound(int val, String path) {
        if (val < 0) {
            this.setAmbientSound(new CustomAmbientSound(new File(path)));
        } else if (val > 0) {
            this.setAmbientSound(PresetAmbientSound.valueOf(val));
        } else {
            this.setAmbientSound(null);
        }
    }

    @Nullable
    public TerrainFog getTerrainFog() {
        return this._terrainFog;
    }

    public void setTerrainFog(@Nullable TerrainFog val) {
        this._terrainFog = val;
    }

    public UIRace getUIRace() {
        return this._uiRace;
    }

    public void setUIRace(UIRace val) {
        this._uiRace = val;
    }

    @Nonnull
    public List<MapEntry> getMaps() {
        return this._maps;
    }

    private void addMap(@Nonnull MapEntry val) {
        this._maps.add(val);
    }

    @Nonnull
    public MapEntry addMap() {
        MapEntry map = new MapEntry();
        this.addMap(map);
        return map;
    }

    @Nonnull
    public List<ListedMapEntry> getListedMaps() {
        return this._listedMaps;
    }

    private void addListedMap(@Nonnull ListedMapEntry val) {
        this._listedMaps.add(val);
    }

    @Nonnull
    public ListedMapEntry addListedMap() {
        ListedMapEntry map = new ListedMapEntry();
        this.addListedMap(map);
        return map;
    }

    public void print(@Nonnull PrintStream outStream) {
        int i;
        outStream.println(String.format("savesAmount: %d", this.getSavesAmount()));
        outStream.println(String.format("editorVersion: %d", this.getEditorVersion()));
        outStream.println(String.format("campaignName: %s", this.getCampaignName()));
        outStream.println(String.format("difficulty: %s", this.getDifficulty()));
        outStream.println(String.format("author: %s", this.getCampaignAuthor()));
        outStream.println(String.format("description: %s", this.getCampaignDescription()));
        outStream.println(String.format("flags: %s", this.getFlags()));
        outStream.println(String.format("campaignBackground: %s", this.getCampaignBackground()));
        outStream.println(String.format("minimapPath: %s", this.getMinimapPath()));
        outStream.println(String.format("ambientSound: %s", this.getAmbientSound()));
        outStream.println(String.format("terrainFog: %s", this.getTerrainFog()));
        outStream.println(String.format("uiRace: %s", this.getUIRace()));
        for (i = 0; i < this._maps.size(); ++i) {
            outStream.println(String.format("mapEntry %d:", i));
            this._maps.get(i).print(outStream);
        }
        for (i = 0; i < this._listedMaps.size(); ++i) {
            outStream.println(String.format("listedMapEntry %d:", i));
            this._listedMaps.get(i).print(outStream);
        }
    }

    public void print() {
        this.print(System.out);
    }

    private void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3F_0x1.getVersion(), version);
        this.setSavesAmount(stream.readInt32("savesAmount"));
        this.setEditorVersion(stream.readInt32("editorVersion"));
        this.setCampaignName(stream.readString("campaignName"));
        this.setDifficulty(stream.readString("difficulty"));
        this.setCampaignAuthor(stream.readString("author"));
        this.setCampaignDescription(stream.readString("description"));
        this.setFlags(Flags.valueOf(stream.readInt32("flags")));
        this.setCampaignBackground(stream.readInt32("backgroundIndex"), stream.readString("backgroundCustomPath"));
        this.setMinimapPath(new File(stream.readString("minimapPath")));
        this.setAmbientSound(stream.readInt32("ambientSoundVal"), stream.readString("ambientSoundPath"));
        TerrainFogType terrainFogType = TerrainFogType.valueOf(stream.readInt32("type"));
        War3Real terrainFogZStart = stream.readReal("zStart");
        War3Real terrainFogZEnd = stream.readReal("zEnd");
        War3Real terrainFogDensity = stream.readReal("density");
        Color terrainFogColor = Color.fromRGBA255(stream.readUByte("red").shortValue(), stream.readUByte("green").shortValue(), stream.readUByte("blue").shortValue(), stream.readUByte("alpha").shortValue());
        if (terrainFogType != null) {
            this.setTerrainFog(new TerrainFog(terrainFogType, terrainFogZStart, terrainFogZEnd, terrainFogDensity, terrainFogColor));
        }
        this.setUIRace(UIRace.valueOf(stream.readInt32("uiRace")));
        int mapsCount = stream.readInt32("mapsCount");
        for (int i = 0; i < mapsCount; ++i) {
            this.addMap(new MapEntry(stream, EncodingFormat.W3F_0x1));
        }
        int listedMapsCount = stream.readInt32("listedMapsCount");
        for (int i = 0; i < listedMapsCount; ++i) {
            this.addListedMap(new ListedMapEntry(stream, EncodingFormat.W3F_0x1));
        }
    }

    private void write_0x1(@Nonnull Wc3BinOutputStream stream) {
        int i;
        stream.writeInt32(EncodingFormat.W3F_0x1.getVersion());
        stream.writeInt32(this.getSavesAmount());
        stream.writeInt32(this.getEditorVersion());
        stream.writeString(this.getCampaignName());
        stream.writeString(this.getDifficulty());
        stream.writeString(this.getCampaignAuthor());
        stream.writeString(this.getCampaignDescription());
        stream.writeInt32(this.getFlags().toInt());
        LoadingScreenBackground background = this.getCampaignBackground();
        stream.writeInt32(background instanceof LoadingScreenBackground.PresetBackground ? ((LoadingScreenBackground.PresetBackground)background).getIndex() : -1);
        stream.writeString(background instanceof LoadingScreenBackground.CustomBackground ? ((LoadingScreenBackground.CustomBackground)background).getCustomPath().toString() : null);
        stream.writeString(this.getMinimapPath() != null ? this.getMinimapPath().toString() : null);
        AmbientSound ambientSound = this.getAmbientSound();
        if (ambientSound != null) {
            stream.writeInt32(ambientSound instanceof PresetAmbientSound ? ((PresetAmbientSound)ambientSound).getIndex() : -1);
            stream.writeString(ambientSound instanceof CustomAmbientSound ? ((CustomAmbientSound)ambientSound).getCustomPath().toString() : null);
        } else {
            stream.writeInt32(0);
            stream.writeString((String)null);
        }
        TerrainFog terrainFog = this.getTerrainFog();
        stream.writeInt32(terrainFog != null ? terrainFog.getType() : War3Int.valueOf(0));
        stream.writeReal(terrainFog != null ? terrainFog.getZStart() : War3Real.valueOf(0.0f));
        stream.writeReal(terrainFog != null ? terrainFog.getZEnd() : War3Real.valueOf(0.0f));
        stream.writeReal(terrainFog != null ? terrainFog.getDensity() : War3Real.valueOf(0.0f));
        Color terrainFogColor = terrainFog != null ? terrainFog.getColor() : null;
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getRed255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getGreen255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getBlue255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getAlpha255() : 0);
        stream.writeInt32(this.getUIRace().getVal());
        stream.writeInt32(this.getMaps().size());
        for (i = 0; i < this.getMaps().size(); ++i) {
            this.getMaps().get(i).write(stream, EncodingFormat.W3F_0x1);
        }
        stream.writeInt32(this.getListedMaps().size());
        for (i = 0; i < this.getListedMaps().size(); ++i) {
            this.getListedMaps().get(i).write(stream, EncodingFormat.W3F_0x1);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws Exception {
        int version = stream.readInt32("version");
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws Exception {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case W3F_0x1: {
                this.read_0x1(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case W3F_0x1: 
            case AUTO: {
                this.write_0x1(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream, EncodingFormat.AUTO);
    }

    private void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public W3F() {
    }

    public W3F(@Nonnull File file) throws Exception {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream);
        inStream.close();
    }

    @Nonnull
    public static W3F ofCampaignFile(@Nonnull File mapFile) throws Exception {
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(CAMPAIGN_PATH);
        MpqPort.Out.Result portResult = port.commit(mapFile);
        if (!portResult.getExports().containsKey(CAMPAIGN_PATH)) {
            throw new IOException("could not extract info file");
        }
        InputStream inStream = portResult.getInputStream(CAMPAIGN_PATH);
        W3F w3f = new W3F();
        w3f.read(new Wc3BinInputStream(inStream));
        return w3f;
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat W3F_0x1 = new EncodingFormat(Enum.W3F_0x1, 1);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            W3F_0x1;

        }
    }

    public static class ListedMapEntry {
        private String _unknown;
        private String _mapPath;

        @Nullable
        public String getUnknown() {
            return this._unknown;
        }

        public void setUnknown(@Nullable String val) {
            this._unknown = val;
        }

        public String getMapPath() {
            return this._mapPath;
        }

        public void setMapPath(String val) {
            this._mapPath = val;
        }

        public void print(@Nonnull PrintStream outStream) {
            outStream.println(String.format("unknown: %s", this.getUnknown()));
            outStream.println(String.format("mapPath: %s", this.getMapPath()));
        }

        public void print() {
            this.print(System.out);
        }

        private void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setUnknown(stream.readString());
            this.setMapPath(stream.readString());
        }

        private void write_0x1(@Nonnull Wc3BinOutputStream stream) {
            stream.writeString(this.getUnknown());
            stream.writeString(this.getMapPath());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3F_0x1: {
                    this.read_0x1(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3F_0x1: 
                case AUTO: {
                    this.write_0x1(stream);
                }
            }
        }

        public ListedMapEntry(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public ListedMapEntry() {
        }
    }

    public static class MapEntry {
        private boolean _isVisible = false;
        private String _chapterTitle;
        private String _mapTitle;
        private String _mapPath;

        public boolean isVisible() {
            return this._isVisible;
        }

        public void setVisible(boolean val) {
            this._isVisible = true;
        }

        @Nonnull
        public String getChapterTitle() {
            return this._chapterTitle;
        }

        public void setChapterTitle(@Nonnull String val) {
            this._chapterTitle = val;
        }

        @Nonnull
        public String getMapTitle() {
            return this._mapTitle;
        }

        public void setMapTitle(@Nonnull String val) {
            this._mapTitle = val;
        }

        @Nonnull
        public String getMapPath() {
            return this._mapPath;
        }

        public void setMapPath(@Nonnull String val) {
            this._mapPath = val;
        }

        public void print(@Nonnull PrintStream outStream) {
            outStream.println(String.format("isVisible: %s", this.isVisible()));
            outStream.println(String.format("chapterTitle: %s", this.getChapterTitle()));
            outStream.println(String.format("mapTitle: %s", this.getMapTitle()));
            outStream.println(String.format("mapPath: %s", this.getMapPath()));
        }

        public void print() {
            this.print(System.out);
        }

        private void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setVisible(stream.readInt32() > 0);
            this.setChapterTitle(stream.readString());
            this.setMapTitle(stream.readString());
            this.setMapPath(stream.readString());
        }

        private void write_0x1(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.isVisible() ? 1 : 0);
            stream.writeString(this.getChapterTitle());
            stream.writeString(this.getMapTitle());
            stream.writeString(this.getMapPath());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3F_0x1: {
                    this.read_0x1(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3F_0x1: 
                case AUTO: {
                    this.write_0x1(stream);
                }
            }
        }

        public MapEntry(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public MapEntry() {
        }
    }

    public static class UIRace {
        private static Map<Integer, UIRace> _map = new LinkedHashMap<Integer, UIRace>();
        public static final UIRace HUMAN = new UIRace(0, "HUMAN");
        public static final UIRace ORC = new UIRace(1, "ORC");
        public static final UIRace UNDEAD = new UIRace(2, "UNDEAD");
        public static final UIRace NIGHTELF = new UIRace(3, "NIGHTELF");
        private int _val;
        private String _label;

        public int getVal() {
            return this._val;
        }

        public String getLabel() {
            return this._label;
        }

        public String toString() {
            return this.getLabel();
        }

        @Nullable
        public static UIRace valueOf(int val) {
            return _map.get(val);
        }

        private UIRace(int val, @Nonnull String label) {
            _map.put(val, this);
            this._val = val;
            this._label = String.format("WESTRING_RACE_%s", label);
        }
    }

    public static class CustomAmbientSound
    extends AmbientSound {
        private File _path = null;

        public File getCustomPath() {
            return this._path;
        }

        public String toString() {
            return this.getCustomPath().toString();
        }

        public CustomAmbientSound(@Nonnull File path) {
            this._path = path;
        }
    }

    public static class PresetAmbientSound
    extends AmbientSound {
        private static Map<Integer, AmbientSound> _map = new LinkedHashMap<Integer, AmbientSound>();
        public static final PresetAmbientSound TUTORIAL = new PresetAmbientSound(0, "TUTORIAL");
        public static final PresetAmbientSound HUMAN = new PresetAmbientSound(1, "HUMAN");
        public static final PresetAmbientSound ORC = new PresetAmbientSound(2, "ORC");
        public static final PresetAmbientSound UNDEAD = new PresetAmbientSound(3, "UNDEAD");
        public static final PresetAmbientSound NIGHTELF = new PresetAmbientSound(4, "NIGHTELF");
        public static final PresetAmbientSound NIGHTELF_EXPANSION = new PresetAmbientSound(5, "NIGHTELFEXP");
        public static final PresetAmbientSound HUMAN_EXPANSION = new PresetAmbientSound(6, "HUMANEXP");
        public static final PresetAmbientSound UNDEAD_EXPANSION = new PresetAmbientSound(7, "UNDEADEXP");
        private int _index;
        private String _label;

        public int getIndex() {
            return this._index;
        }

        public String getLabel() {
            return this._label;
        }

        public String toString() {
            return this._label;
        }

        public static AmbientSound valueOf(int index) {
            return _map.get(index);
        }

        private PresetAmbientSound(int index, @Nonnull String label) {
            _map.put(index, this);
            this._index = index;
            this._label = String.format("WESTRING_AMBIENTSOUND_%s", label);
        }
    }

    public static class AmbientSound {
    }

    public static class Flags
    extends FlagsInt {
        @Override
        public DataType decode(Object val) {
            return null;
        }

        @Override
        public Object toSLKVal() {
            return null;
        }

        @Override
        public Object toTXTVal() {
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            Flag[] flags = Flag.values();
            if (flags.length > 0) {
                for (Flag flag : flags) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(String.format("%s=%s", flag.toString(), this.containsFlag(flag)));
                }
            }
            return String.format("%s [%s]", Integer.toBinaryString(this.toInt()), sb.toString());
        }

        protected Flags(int val) {
            super(val);
        }

        public static Flags valueOf(int val) {
            return new Flags(val);
        }

        public static class Flag
        extends FlagsInt.Flag {
            private static List<Flag> _all = new ArrayList<Flag>();
            public static final Flag VAR_DIFFICULTY = new Flag(0, "varDifficulty");
            public static final Flag CONTAINS_EXPANSION_MAPS = new Flag(1, "containsExpansionMaps");

            public static Flag[] values() {
                Flag[] flags = new Flag[_all.size()];
                return _all.toArray(flags);
            }

            private Flag(int pos, @Nonnull String label) {
                super(label, pos);
                _all.add(this);
            }
        }
    }
}

