/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeUnion
extends WurstType {
    WurstType typeA;
    WurstType typeB;

    private WurstTypeUnion(WurstType typeA, WurstType typeB) {
        this.typeA = typeA;
        this.typeB = typeB;
    }

    public static WurstType create(WurstType a, WurstType b, Element loc) {
        if (a instanceof WurstTypeUnknown) {
            return b;
        }
        if (b instanceof WurstTypeUnknown) {
            return a;
        }
        if (a.isSubtypeOf(b, loc)) {
            return b;
        }
        if (b.isSubtypeOf(a, loc)) {
            return a;
        }
        return new WurstTypeUnion(a, b);
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if ((mapping = this.typeA.matchAgainstSupertype(other, location, mapping, variablePosition)) == null) {
            return null;
        }
        return this.typeB.matchAgainstSupertype(other, location, mapping, variablePosition);
    }

    @Override
    public String getName() {
        return "(" + this.typeA.getName() + " or " + this.typeB.getName() + ")";
    }

    @Override
    public String getFullName() {
        return "(" + this.typeA.getFullName() + " or " + this.typeB.getFullName() + ")";
    }

    @Override
    public ImType imTranslateType(ImTranslator tr) {
        return this.typeA.imTranslateType(tr);
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        return this.typeA.getDefaultValue(tr);
    }

    @Override
    protected boolean isNullable() {
        return this.typeA.isNullable() || this.typeB.isNullable();
    }

    public WurstType getTypeA() {
        return this.typeA;
    }

    public WurstType getTypeB() {
        return this.typeB;
    }
}

