/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.Bin;
import net.moonlightflower.wc3libs.bin.BinState;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class W3C {
    public static final File GAME_PATH = new File("war3map.w3c");
    private List<Camera> _cameras = new ArrayList<Camera>();

    @Nonnull
    public List<Camera> getCameras() {
        return this._cameras;
    }

    private void addCamera(@Nonnull Camera val) {
        this._cameras.add(val);
    }

    @Nonnull
    public Camera addCamera() {
        Camera camera = new Camera();
        this.addCamera(camera);
        return camera;
    }

    public void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.WPM_0x0.getVersion(), version);
        int camsCount = stream.readInt32("camsCount");
        for (int i = 0; i < camsCount; ++i) {
            this.addCamera(new Camera(stream, EncodingFormat.WPM_0x0));
        }
    }

    public void write_0x0(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.WPM_0x0.getVersion());
        stream.writeInt32(this.getCameras().size());
        for (Camera camera : this.getCameras()) {
            camera.write(stream, EncodingFormat.WPM_0x0);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32();
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case W3C_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case W3C_0x0: 
            case AUTO: {
                this.write_0x0(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    private void read(@Nonnull InputStream inStream, @Nonnull EncodingFormat format) throws IOException {
        this.read(new Wc3BinInputStream(inStream), format);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public W3C(@Nonnull Wc3BinInputStream inStream) throws BinStream.StreamException {
        this.read(inStream);
    }

    public W3C(@Nonnull File file) throws IOException {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream);
        inStream.close();
    }

    public W3C() {
    }

    @Nonnull
    public static W3C ofMapFile(@Nonnull File mapFile) throws IOException {
        if (!mapFile.exists()) {
            throw new IOException(String.format("file %s does not exist", mapFile));
        }
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(GAME_PATH);
        MpqPort.Out.Result portResult = port.commit(mapFile);
        if (!portResult.getExports().containsKey(GAME_PATH)) {
            throw new IOException("could not extract w3c file");
        }
        Wc3BinInputStream inStream = new Wc3BinInputStream(portResult.getInputStream(GAME_PATH));
        W3C w3c = new W3C();
        w3c.read(inStream);
        inStream.close();
        return w3c;
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat WPM_0x0 = new EncodingFormat(Enum.W3C_0x0, 0);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            W3C_0x0;

        }
    }

    public static class Camera
    extends Bin {
        public <T extends DataType> T get(@Nonnull State<T> state) {
            try {
                return state.tryCastVal(super.get(state));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(@Nonnull State<T> state, @Nullable T val) {
            super.set(state, val);
        }

        public <T extends DataType> void reset(@Nonnull State<T> state) {
            super.set((BinState<?>)state, (DataType)state.getDefVal());
        }

        public void init() {
            for (State state : State.values(State.class)) {
                ((Bin)this).set(state, (DataType)state.getDefVal());
            }
        }

        public Coords2DF getTarget() {
            return this.get(State.ART_TARGET);
        }

        public void setTarget(Coords2DF val) {
            this.set(State.ART_TARGET, (DataType)val);
        }

        public War3Real getZOffset() {
            return this.get(State.ART_Z_OFFSET);
        }

        public void setZOffset(War3Real val) {
            this.set(State.ART_Z_OFFSET, (DataType)val);
        }

        public War3Real getRotation() {
            return this.get(State.ART_ROTATION);
        }

        public void setRotation(War3Real val) {
            this.set(State.ART_ROTATION, (DataType)val);
        }

        public War3Real getAngleOfAttack() {
            return this.get(State.ART_ANGLE_OF_ATTACK);
        }

        public void setAngleOfAttack(War3Real val) {
            this.set(State.ART_ANGLE_OF_ATTACK, (DataType)val);
        }

        public War3Real getRoll() {
            return this.get(State.ART_ROLL);
        }

        public void setRoll(War3Real val) {
            this.set(State.ART_ROLL, (DataType)val);
        }

        public War3Real getDist() {
            return this.get(State.ART_DIST);
        }

        public void setDist(War3Real val) {
            this.set(State.ART_DIST, (DataType)val);
        }

        public War3Real getFieldOfView() {
            return this.get(State.ART_FIELD_OF_VIEW);
        }

        public void setFieldOfView(War3Real val) {
            this.set(State.ART_FIELD_OF_VIEW, (DataType)val);
        }

        public War3Real getFarZ() {
            return this.get(State.ART_FAR_Z);
        }

        public void setFarZ(War3Real val) {
            this.set(State.ART_FAR_Z, (DataType)val);
        }

        public War3Real getUnknown() {
            return this.get(State.ART_UNKNOWN);
        }

        public void setUnknown(War3Real val) {
            this.set(State.ART_UNKNOWN, (DataType)val);
        }

        public War3String getCineName() {
            return this.get(State.EDITOR_CINE_NAME);
        }

        public void setCineName(War3String val) {
            this.set(State.EDITOR_CINE_NAME, (DataType)val);
        }

        public void write_0x0(@Nonnull Wc3BinOutputStream stream) {
            Coords2DF target = this.getTarget();
            stream.writeFloat32(target.getX());
            stream.writeFloat32(target.getY());
            stream.writeFloat32(this.getZOffset());
            stream.writeFloat32(this.getRotation());
            stream.writeFloat32(this.getAngleOfAttack());
            stream.writeFloat32(this.getDist());
            stream.writeFloat32(this.getRoll());
            stream.writeFloat32(this.getFieldOfView());
            stream.writeFloat32(this.getFarZ());
            stream.writeFloat32(this.getUnknown());
            stream.writeString(this.getCineName());
        }

        public void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setTarget(new Coords2DF(stream.readFloat32("targetX").floatValue(), stream.readFloat32("targetY").floatValue()));
            this.setZOffset(stream.readReal("zOffset"));
            this.setRotation(stream.readReal("rotation"));
            this.setAngleOfAttack(stream.readReal("angleOfAttack"));
            this.setDist(stream.readReal("dist"));
            this.setRoll(stream.readReal("roll"));
            this.setFieldOfView(stream.readReal("fieldOfView"));
            this.setFarZ(stream.readReal("farZ"));
            this.setUnknown(stream.readReal("unknown"));
            this.setCineName(War3String.valueOf(stream.readString("cineName")));
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3C_0x0: {
                    this.read_0x0(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3C_0x0: 
                case AUTO: {
                    this.write_0x0(stream);
                }
            }
        }

        public Camera(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this();
            this.read(stream, format);
        }

        public Camera() {
            this.init();
        }

        public static class State<T extends DataType>
        extends BinState<T> {
            public static final State<Coords2DF> ART_TARGET = new State<Coords2DF>("target", Coords2DF.class, new Coords2DF(0.0f, 0.0f));
            public static final State<War3Real> ART_Z_OFFSET = new State<War3Real>("zOffset", War3Real.class, War3Real.valueOf(0.0f));
            public static final State<War3Real> ART_ROTATION = new State<War3Real>("rotation", War3Real.class, War3Real.valueOf(0.0f));
            public static final State<War3Real> ART_ANGLE_OF_ATTACK = new State<War3Real>("angleOfAttack", War3Real.class, War3Real.valueOf(0.0f));
            public static final State<War3Real> ART_ROLL = new State<War3Real>("roll", War3Real.class, War3Real.valueOf(0.0f));
            public static final State<War3Real> ART_DIST = new State<War3Real>("dist", War3Real.class, War3Real.valueOf(0.0f));
            public static final State<War3Real> ART_FIELD_OF_VIEW = new State<War3Real>("fieldOfView", War3Real.class, War3Real.valueOf(0.0f));
            public static final State<War3Real> ART_FAR_Z = new State<War3Real>("farZ", War3Real.class, War3Real.valueOf(10000.0f));
            public static final State<War3Real> ART_UNKNOWN = new State<War3Real>("unknown", War3Real.class, War3Real.valueOf(100.0f));
            public static final State<War3String> EDITOR_CINE_NAME = new State<War3String>("cineName", War3String.class, War3String.valueOf("unnamed"));

            public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
                super(idString, typeInfo, defVal);
            }

            public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
                super(idString, typeInfo);
            }

            public State(@Nonnull String idString, @Nonnull Class<T> type) {
                super(idString, type);
            }

            public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
                super(idString, type, defVal);
            }
        }
    }
}

