/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.bin.app.IMP_0x1;
import net.moonlightflower.wc3libs.bin.app.IMP_Streamable;

public class IMP {
    public static final String GAME_PATH = "war3map.imp";
    public static final File CAMPAIGN_PATH = new File("war3campaign.imp");
    protected List<Obj> _objs = new ArrayList<Obj>();

    public List<Obj> getObjs() {
        return this._objs;
    }

    public void addObj(@Nonnull Obj val) {
        this._objs.add(val);
    }

    @Nonnull
    public Obj addObj() {
        Obj obj = new Obj();
        this.addObj(obj);
        return obj;
    }

    public void merge(@Nonnull IMP other) {
        for (Obj obj : other.getObjs()) {
            this.addObj(obj);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        IMP_0x1 other = null;
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case IMP_0x1: {
                other = new IMP_0x1(stream);
            }
        }
        if (other != null) {
            this.merge(other);
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        IMP other = null;
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case IMP_0x1: 
            case AUTO: {
                other = new IMP_0x1();
            }
        }
        other.merge(this);
        other.write(stream);
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream stream = new Wc3BinOutputStream(file);
        this.write(stream);
        stream.close();
    }

    public IMP(@Nonnull File file) throws IOException {
        this(new Wc3BinInputStream(file));
    }

    public IMP(Wc3BinInputStream inputStream) throws IOException {
        this.read(inputStream);
        inputStream.close();
    }

    public IMP() {
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat IMP_0x1 = new EncodingFormat(Enum.IMP_0x1, 1);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            IMP_0x1;

        }
    }

    public static class Obj
    implements IMP_Streamable {
        protected String _path;
        protected StdFlag _stdFlag = StdFlag.CUSTOM;

        public String getPath() {
            return this._path;
        }

        public void setPath(String val) {
            this._path = val;
        }

        public StdFlag getStdFlag() {
            return this._stdFlag;
        }

        public void setStdFlag(StdFlag val) {
            this._stdFlag = val;
        }

        private void merge(@Nonnull Obj other) {
            this._path = other.getPath();
            this._stdFlag = other.getStdFlag();
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            IMP_0x1.Obj other = null;
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case IMP_0x1: {
                    other = new IMP_0x1.Obj(stream);
                }
            }
            if (other != null) {
                this.merge(other);
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            Obj other = null;
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case IMP_0x1: 
                case AUTO: {
                    other = new IMP_0x1.Obj();
                }
            }
            other.merge(this);
            other.write(stream);
        }

        @Override
        public void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.read(stream, EncodingFormat.AUTO);
        }

        @Override
        public void write(@Nonnull Wc3BinOutputStream stream) {
            this.write(stream, EncodingFormat.AUTO);
        }

        public Obj(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Obj() {
        }
    }

    public static class StdFlag {
        private static final Map<Integer, StdFlag> _map = new LinkedHashMap<Integer, StdFlag>();
        public static final StdFlag CUSTOM = new StdFlag(10, 13);
        public static final StdFlag STD = new StdFlag(0, 5, 8);
        int _val;

        public int getVal() {
            return this._val;
        }

        public static StdFlag fromVal(int val) {
            return _map.get(val);
        }

        private StdFlag(int ... vals) {
            int[] nArray = vals;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int val;
                this._val = val = nArray[i];
                _map.put(val, this);
            }
        }
    }
}

