/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinInputStream;
import net.moonlightflower.wc3libs.bin.BinStream;

public class StdBinInputStream
extends BinInputStream {
    public byte readByte(@Nonnull String label) throws IOException {
        this.logBegin();
        byte ret = this.readByte();
        this.log("byte", label, ret);
        return ret;
    }

    public int readWord() throws IOException {
        try {
            return (this.readByte() & 0xFF) + ((this.readByte() & 0xFF) << 8);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
    }

    public int readWord(@Nonnull String label) throws IOException {
        this.logBegin();
        int ret = this.readWord();
        this.log("word", label, ret);
        return ret;
    }

    public int readUWord() throws IOException {
        return this.readWord() & 0xFFFF;
    }

    public int readUWord(String label) throws IOException {
        return this.readWord(label) & 0xFFFF;
    }

    public int readDoubleWord() throws IOException {
        try {
            return this.readByte() + (this.readByte() << 8) + (this.readByte() << 16) + (this.readByte() << 24);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
    }

    public int readDoubleWord(@Nonnull String label) throws IOException {
        this.logBegin();
        int ret = this.readDoubleWord();
        this.log("dword", label, ret);
        return ret;
    }

    public String readString() throws BinStream.StreamException {
        try {
            long cutPos;
            for (cutPos = this.getPos(); cutPos < this.size() && this.get(cutPos) != 0; ++cutPos) {
            }
            long size = cutPos - this.getPos();
            if (size == 0L) {
                this.setPos(Math.min(cutPos + 1L, this.size() - 1L));
                return "";
            }
            StringBuilder sb = new StringBuilder();
            while (size > 0L) {
                int sizeI = (int)size;
                byte[] retBytes = new byte[sizeI];
                int i = 0;
                while ((long)i < size) {
                    retBytes[i] = this.get(this.getPos() + (long)i);
                    ++i;
                }
                this.setPos(Math.min(cutPos + 1L, this.size() - 1L));
                sb.append(new String(retBytes, StandardCharsets.UTF_8));
                size -= (long)sizeI;
            }
            return sb.toString();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    public String readString(@Nonnull String label) throws IOException {
        this.logBegin();
        String ret = this.readString();
        this.log("string", label, ret);
        return ret;
    }

    public StdBinInputStream(@Nonnull InputStream inStream) throws IOException {
        super(inStream);
    }

    public StdBinInputStream(@Nonnull File file) throws IOException {
        super(file);
    }
}

