/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;

public class UTF8 {
    public static String BOM = "\ufeff";
    private final Vector<String> _lines = new Vector();
    private final Iterator<String> _linesItr;

    public String readLine() {
        if (!this._linesItr.hasNext()) {
            return null;
        }
        return this._linesItr.next();
    }

    public String readAll(boolean addLineSeparator) {
        StringBuilder sb = new StringBuilder();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        sb.append(line);
        while ((line = this.readLine()) != null) {
            if (addLineSeparator) {
                sb.append(System.lineSeparator());
            }
            sb.append(line);
        }
        return sb.toString();
    }

    public String readAll() {
        StringBuilder sb = new StringBuilder();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        sb.append(line);
        while ((line = this.readLine()) != null) {
            sb.append(System.lineSeparator());
            sb.append(line);
        }
        return sb.toString();
    }

    private List<String> readLines(String s, boolean includeLineEnding) throws IOException {
        ArrayList<String> ret;
        block11: {
            int pos;
            ret = new ArrayList<String>();
            int endPos = pos = 0;
            if (s.length() == 0) {
                return ret;
            }
            do {
                if (s.charAt(endPos) == '\n') {
                    if (includeLineEnding) {
                        ret.add(s.substring(pos, endPos + 1));
                    } else {
                        ret.add(s.substring(pos, endPos));
                    }
                    endPos = pos = endPos + 1;
                    continue;
                }
                if (pos + 2 < s.length() && s.substring(pos, pos + 2).equals("\r\n")) {
                    if (includeLineEnding) {
                        ret.add(s.substring(pos, ++endPos + 1));
                    } else {
                        ret.add(s.substring(pos, endPos));
                        ++endPos;
                    }
                    endPos = pos = endPos + 1;
                    continue;
                }
                if (s.charAt(pos) == '\r') {
                    if (includeLineEnding) {
                        ret.add(s.substring(pos, endPos + 1));
                    } else {
                        ret.add(s.substring(pos, endPos));
                    }
                    endPos = pos = endPos + 1;
                    continue;
                }
                ++endPos;
            } while (endPos <= s.length() - 1);
            if (pos == endPos) break block11;
            ret.add(s.substring(pos, s.length()));
        }
        return ret;
    }

    private String inStreamToString(InputStream inStream) throws IOException {
        int length;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((length = inStream.read(buf)) != -1) {
            os.write(buf, 0, length);
        }
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    public UTF8(@Nonnull InputStream inStream, boolean includeBOM, boolean includeLineEndings) throws IOException {
        String s = this.inStreamToString(inStream);
        List<String> lines = this.readLines(s, includeLineEndings);
        if (!includeBOM && !lines.isEmpty() && lines.get(0).startsWith(BOM)) {
            lines.set(0, lines.get(0).substring(BOM.length()));
        }
        this._lines.addAll(lines);
        this._linesItr = this._lines.iterator();
    }

    public UTF8(@Nonnull InputStream inStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            if (line != null) {
                if (line.startsWith(BOM)) {
                    line = line.substring(BOM.length());
                }
                this._lines.addElement(line);
                while ((line = reader.readLine()) != null) {
                    this._lines.add(line);
                }
            }
        }
        this._linesItr = this._lines.iterator();
    }

    public UTF8() {
        this._linesItr = this._lines.iterator();
    }
}

