/*
 * Decompiled with CFR 0.152.
 */
package global;

import file.SetupApp;
import global.CLIParser;
import global.InstallationManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import ui.ErrorDialog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lglobal/CLIParser;", "", "()V", "log", "Lmu/KLogger;", "getVersionFomJar", "", "parseCMDLine", "input", "", "showWurstInUse", "WurstSetup"})
@SourceDebugExtension(value={"SMAP\nCLIParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLIParser.kt\nglobal/CLIParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1#2:62\n1855#3,2:63\n*S KotlinDebug\n*F\n+ 1 CLIParser.kt\nglobal/CLIParser\n*L\n39#1:63,2\n*E\n"})
public final class CLIParser {
    @NotNull
    public static final CLIParser INSTANCE = new CLIParser();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    private CLIParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getVersionFomJar() {
        String string;
        log.debug("running wurst to extract the version");
        String[] stringArray = new String[]{"java", "-jar", ((Object)InstallationManager.INSTANCE.getCompilerJar().toAbsolutePath()).toString(), "--version"};
        Process proc = Runtime.getRuntime().exec(stringArray);
        proc.waitFor(100L, TimeUnit.MILLISECONDS);
        InputStream inputStream = proc.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        String input = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        InputStream inputStream2 = proc.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        object = inputStream2;
        object2 = Charsets.UTF_8;
        Reader bl = new InputStreamReader((InputStream)object, (Charset)object2);
        int n2 = 8192;
        object = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader(bl, n2);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl2 = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String err = string;
        if (((CharSequence)err).length() > 0) {
            log.error(err);
        }
        if (StringsKt.contains((CharSequence)err, (CharSequence)"AccessDeniedException", (boolean)true)) {
            this.showWurstInUse();
        } else if (StringsKt.contains$default((CharSequence)err, (CharSequence)"Exception", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)err, (CharSequence)"Failed", (boolean)false, (int)2, null)) {
            log.error("Classifying installation as outdated due to " + err);
            InstallationManager.INSTANCE.setStatus(InstallationManager.InstallationStatus.INSTALLED_OUTDATED);
        } else {
            this.parseCMDLine(input);
        }
    }

    private final void parseCMDLine(String input) {
        log.debug("parsing CMD output: " + input);
        CharSequence charSequence = input;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)System.getProperty("line.separator"), (String)"getProperty(...)");
        List lines = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (!InstallationManager.INSTANCE.isJenkinsBuilt(line)) continue;
            log.debug("Found jenkins build string " + line);
            InstallationManager.INSTANCE.setCurrentCompilerVersion(InstallationManager.INSTANCE.getJenkinsBuildVer(line));
            InstallationManager.INSTANCE.setStatus(InstallationManager.InstallationStatus.INSTALLED_OUTDATED);
        }
        if (InstallationManager.INSTANCE.getStatus() != InstallationManager.InstallationStatus.INSTALLED_OUTDATED) {
            log.debug("Failed to extract jenkins version from " + input);
            throw new Error("Installation failed!");
        }
    }

    public final void showWurstInUse() {
        if (SetupApp.INSTANCE.getSetup().isGUILaunch()) {
            new ErrorDialog("The Wurst compiler is currently in use.\nPlease close all running instances and vscode, then retry.", true);
        }
        log.error("The Wurst compiler is currently in use.\nPlease close all running instances and vscode, then retry.");
    }
}

