/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.jurst;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassDefs;
import de.peeeq.wurstscript.ast.ClassSlot;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.EnumMembers;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FuncDefs;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDefs;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.Indexes;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.ModuleInstanciations;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.ModuleUses;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.SuperConstructorCall;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchCases;
import de.peeeq.wurstscript.ast.SwitchDefaultCase;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WPackages;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.ast.WShortParameters;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.jass.AntlrJassParseTreeTransformer;
import de.peeeq.wurstscript.jurst.antlr.JurstParser;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.Nullable;

public class AntlrJurstParseTreeTransformer {
    private final String file;
    private final ErrorHandler cuErrorHandler;
    private final LineOffsets lineOffsets;
    private boolean isJassCode = true;

    public AntlrJurstParseTreeTransformer(String file, ErrorHandler cuErrorHandler, LineOffsets lineOffsets) {
        this.file = file;
        this.cuErrorHandler = cuErrorHandler;
        this.lineOffsets = lineOffsets;
    }

    public CompilationUnit transform(JurstParser.CompilationUnitContext cu) {
        JassToplevelDeclarations jassDecls = Ast.JassToplevelDeclarations(new JassToplevelDeclaration[0]);
        WPackages packages = Ast.WPackages(new WPackage[0]);
        try {
            for (JurstParser.TopLevelDeclarationContext decl : cu.decls) {
                if (decl.jassTopLevelDeclaration() != null) {
                    jassDecls.add(this.transformJassToplevelDecl(decl.jassTopLevelDeclaration()));
                    continue;
                }
                if (decl.wpackage() == null) continue;
                packages.add(this.transformPackage(decl.wpackage()));
            }
        }
        catch (CompileError e) {
            this.cuErrorHandler.sendError(e);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return Ast.CompilationUnit(new CompilationUnitInfo(this.cuErrorHandler), jassDecls, packages);
    }

    private JassToplevelDeclaration transformJassToplevelDecl(JurstParser.JassTopLevelDeclarationContext d) {
        if (d.jassFuncDef() != null) {
            return this.transformJassFuncDef(d.jassFuncDef());
        }
        if (d.jassGlobalsBlock() != null) {
            return this.transformJassGlobalsBlock(d.jassGlobalsBlock());
        }
        if (d.jassNativeDecl() != null) {
            return this.transformJassNativeDecl(d.jassNativeDecl());
        }
        if (d.jassTypeDecl() != null) {
            return this.transformJassTypeDecl(d.jassTypeDecl());
        }
        throw this.error(d, "unhandled case: " + this.text(d));
    }

    private Identifier text(@Nullable ParserRuleContext c) {
        if (c == null) {
            return Ast.Identifier(new WPos(this.file, this.lineOffsets, 1, 0), "");
        }
        return Ast.Identifier(this.source(c), c.getText());
    }

    private String rawText(@Nullable ParserRuleContext c) {
        if (c == null) {
            return "";
        }
        return c.getText();
    }

    private JassToplevelDeclaration transformJassTypeDecl(JurstParser.JassTypeDeclContext t) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        Identifier name = this.text(t.name);
        OptTypeExpr optTyp = this.transformOptionalType(t.typeExpr());
        return Ast.NativeType(this.source(t), modifiers, name, optTyp);
    }

    private JassToplevelDeclaration transformJassNativeDecl(JurstParser.JassNativeDeclContext n) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        FuncSig sig = this.transformFuncSig(n.jassFuncSignature());
        return Ast.NativeFunc(this.source(n), modifiers, sig.name, sig.formalParameters, sig.returnType);
    }

    private JassToplevelDeclaration transformJassGlobalsBlock(JurstParser.JassGlobalsBlockContext g) {
        JassGlobalBlock result = Ast.JassGlobalBlock(new GlobalVarDef[0]);
        for (JurstParser.JassGlobalDeclContext v : g.jassGlobalDecl()) {
            Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
            if (v.constant != null) {
                modifiers.add(Ast.ModConstant(this.source(v.constant)));
            }
            OptTypeExpr optTyp = this.transformOptionalType(v.typeExpr());
            Identifier name = this.text(v.name);
            OptExpr initialExpr = this.transformOptionalExpr(v.initial);
            result.add(Ast.GlobalVarDef(this.source(v), modifiers, optTyp, name, initialExpr));
        }
        return result;
    }

    private JassToplevelDeclaration transformJassFuncDef(JurstParser.JassFuncDefContext f) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        FuncSig sig = this.transformFuncSig(f.jassFuncSignature());
        WStatements body = this.transformJassLocals(f.jassLocals);
        body.addAll((Collection)this.transformJassStatements(f.jassStatements()).removeAll());
        return Ast.FuncDef(this.source(f), modifiers, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private WStatements transformJassLocals(List<JurstParser.JassLocalContext> jassLocals) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (JurstParser.JassLocalContext l : jassLocals) {
            Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
            OptTypeExpr optTyp = this.transformOptionalType(l.typeExpr());
            Identifier name = this.text(l.name);
            OptExpr initialExpr = this.transformOptionalExpr(l.initial);
            result.add(Ast.LocalVarDef(this.source(l), modifiers, optTyp, name, initialExpr));
        }
        return result;
    }

    private WStatements transformJassStatements(JurstParser.JassStatementsContext stmts) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (JurstParser.JassStatementContext s : stmts.jassStatement()) {
            result.add(this.transformJassStatement(s));
        }
        return result;
    }

    private WStatement transformJassStatement(JurstParser.JassStatementContext s) {
        if (s.jassStatementCall() != null) {
            return this.transformJassStatementCall(s.jassStatementCall());
        }
        if (s.jassStatementExithwhen() != null) {
            return this.transformJassStatementExitwhen(s.jassStatementExithwhen());
        }
        if (s.jassStatementIf() != null) {
            return this.transformJassStatementIf(s.jassStatementIf());
        }
        if (s.jassStatementLoop() != null) {
            return this.transformJassStatementLoop(s.jassStatementLoop());
        }
        if (s.jassStatementReturn() != null) {
            return this.transformJassStatementReturn(s.jassStatementReturn());
        }
        if (s.jassStatementSet() != null) {
            return this.transformJassStatementSet(s.jassStatementSet());
        }
        throw this.error(s, "unhandled case: " + this.text(s));
    }

    private WStatement transformJassStatementSet(JurstParser.JassStatementSetContext s) {
        return Ast.StmtSet(this.source(s), this.transformAssignable(s.left), this.transformExpr(s.right));
    }

    private WStatement transformJassStatementReturn(JurstParser.JassStatementReturnContext s) {
        return Ast.StmtReturn(this.source(s), this.transformOptionalExpr(s.expr()));
    }

    private WStatement transformJassStatementLoop(JurstParser.JassStatementLoopContext s) {
        return Ast.StmtLoop(this.source(s), this.transformJassStatements(s.jassStatements()));
    }

    private WStatement transformJassStatementIf(JurstParser.JassStatementIfContext s) {
        WStatements thenBlock = this.transformJassStatements(s.thenStatements);
        WStatements elseBlock = this.transformJassElseIfs(s.jassElseIfs());
        return Ast.StmtIf(this.source(s), this.transformExpr(s.cond), thenBlock, elseBlock, !this.isEndif(s.jassElseIfs()));
    }

    private boolean isEndif(JurstParser.JassElseIfsContext s) {
        return s.ENDIF() != null;
    }

    private WStatements transformJassElseIfs(@Nullable JurstParser.JassElseIfsContext s) {
        if (s == null) {
            return Ast.WStatements(new WStatement[0]);
        }
        if (s.cond != null) {
            return Ast.WStatements(Ast.StmtIf(this.source(s), this.transformExpr(s.cond), this.transformJassStatements(s.thenStatements), this.transformJassElseIfs(s.jassElseIfs()), !this.isEndif(s.jassElseIfs())));
        }
        if (s.elseStmts != null) {
            return this.transformJassStatements(s.elseStmts);
        }
        return Ast.WStatements(new WStatement[0]);
    }

    private WStatement transformJassStatementExitwhen(JurstParser.JassStatementExithwhenContext s) {
        return Ast.StmtExitwhen(this.source(s), this.transformExpr(s.cond));
    }

    private WStatement transformJassStatementCall(JurstParser.JassStatementCallContext s) {
        return this.transformFunctionCall(s.exprFunctionCall());
    }

    private WPackage transformPackage(JurstParser.WpackageContext p) {
        this.isJassCode = false;
        WPos source = this.source(p);
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        WImports imports = Ast.WImports(new WImport[0]);
        for (JurstParser.IdContext idContext : p.requires) {
            imports.add(Ast.WImport(this.source(idContext), true, false, this.text(idContext)));
        }
        for (JurstParser.WImportContext wImportContext : p.imports) {
            imports.add(this.transformImport(wImportContext));
        }
        WEntities elements = Ast.WEntities(new WEntity[0]);
        for (JurstParser.EntityContext e : p.entities) {
            if (e.globalsBlock() != null) {
                for (JurstParser.VarDefContext v : e.globalsBlock().vars) {
                    GlobalVarDef en = this.transformVardef(v);
                    elements.add(en);
                }
                continue;
            }
            WEntity en = this.transformEntity(e);
            if (en == null) continue;
            elements.add(en);
        }
        if (p.initializer != null) {
            WPos wPos = this.source(p.initializer);
            Identifier funcName = this.text(p.initializer);
            elements.add(Ast.InitBlock(wPos, Ast.WStatements(Ast.ExprFunctionCall(wPos, funcName, Ast.TypeExprList(new TypeExpr[0]), Ast.Arguments(new Expr[0])))));
        }
        this.isJassCode = true;
        return Ast.WPackage(source, modifiers, this.text(p.name), imports, elements);
    }

    private @Nullable WEntity transformEntity(JurstParser.EntityContext e) {
        try {
            if (e.nativeType() != null) {
                return this.transformNativeType(e.nativeType());
            }
            if (e.funcDef() != null) {
                return this.transformFuncDef(e.funcDef());
            }
            if (e.varDef() != null) {
                return this.transformVardef(e.varDef());
            }
            if (e.initBlock() != null) {
                return this.transformInit(e.initBlock());
            }
            if (e.nativeDef() != null) {
                return this.transformNativeDef(e.nativeDef());
            }
            if (e.classDef() != null) {
                return this.transformClassDef(e.classDef());
            }
            if (e.enumDef() != null) {
                return this.transformEnumDef(e.enumDef());
            }
            if (e.moduleDef() != null) {
                return this.transformModuleDef(e.moduleDef());
            }
            if (e.interfaceDef() != null) {
                return this.transformInterfaceDef(e.interfaceDef());
            }
            if (e.tupleDef() != null) {
                return this.transformTupleDef(e.tupleDef());
            }
            if (e.extensionFuncDef() != null) {
                return this.transformExtensionFuncDef(e.extensionFuncDef());
            }
            if (e.functionInterfaceDef() != null) {
                return null;
            }
            if (e.exception != null) {
                return null;
            }
            throw this.error(e, "entity not implemented " + this.text(e));
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
    }

    private WEntity transformExtensionFuncDef(JurstParser.ExtensionFuncDefContext f) {
        WPos src = this.source(f);
        Modifiers modifiers = this.transformModifiers(f.modifiersWithDoc());
        TypeExpr extendedType = this.transformTypeExpr(f.receiverType);
        FuncSig sig = this.transformFuncSig(f.funcSignature());
        WStatements body = this.transformStatements(f.statementsBlock());
        return Ast.ExtensionFuncDef(src, modifiers, extendedType, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private Modifiers transformModifiers(JurstParser.ModifiersWithDocContext ms) {
        Modifiers result = Ast.Modifiers(new Modifier[0]);
        if (ms.hotdocComment() != null) {
            result.add(Ast.WurstDoc(this.source(ms.hotdocComment()), ms.hotdocComment().getText()));
        }
        for (JurstParser.ModifierContext m : ms.modifiers) {
            result.add(this.transformModifier(m));
        }
        return result;
    }

    private Modifier transformModifier(JurstParser.ModifierContext m) {
        WPos src = this.source(m);
        if (m.annotation() != null) {
            JurstParser.AnnotationContext a = m.annotation();
            return Ast.Annotation(src, Ast.Identifier(this.source(a.name), a.name.getText().substring(1)), Ast.Arguments(Ast.ExprStringVal(this.source(a.message), a.message.getText())));
        }
        switch (m.modType.getType()) {
            case 17: {
                return Ast.VisibilityPublic(src);
            }
            case 22: {
                return Ast.VisibilityPrivate(src);
            }
            case 23: {
                return Ast.VisibilityProtected(src);
            }
            case 18: 
            case 19: {
                return Ast.VisibilityPublicread(src);
            }
            case 34: {
                return Ast.ModStatic(src);
            }
            case 36: {
                return Ast.ModOverride(src);
            }
            case 33: {
                return Ast.ModAbstract(src);
            }
            case 48: {
                return Ast.ModConstant(src);
            }
            case 20: {
                return this.annotation(src, "delegate", "internal");
            }
            case 21: {
                return this.annotation(src, "stub", "internal");
            }
        }
        throw this.error(m, "modifier not implemented");
    }

    private Modifier annotation(WPos src, String name, String message) {
        return Ast.Annotation(src, Ast.Identifier(src, name), Ast.Arguments(Ast.ExprStringVal(src, message)));
    }

    private WEntity transformTupleDef(JurstParser.TupleDefContext t) {
        WPos src = this.source(t);
        Modifiers modifiers = this.transformModifiers(t.modifiersWithDoc());
        Identifier name = this.text(t.name);
        WParameters parameters = this.transformFormalParameters(t.formalParameters(), false);
        NoTypeExpr returnTyp = Ast.NoTypeExpr();
        return Ast.TupleDef(src, modifiers, name, parameters, returnTyp);
    }

    private WEntity transformInterfaceDef(JurstParser.InterfaceDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        TypeParamDefs typeParameters = this.transformTypeParams(i.typeParams());
        TypeExprList extendsList = Ast.TypeExprList(new TypeExpr[0]);
        for (JurstParser.TypeExprContext ex : i.extended) {
            extendsList.add(this.transformTypeExpr(ex));
        }
        ClassSlotResult slots = this.transformClassSlots(src, i.classSlots());
        return Ast.InterfaceDef(src, modifiers, name, typeParameters, extendsList, slots.methods, slots.vars, slots.constructors, slots.moduleInstanciations, slots.moduleUses, slots.onDestroy);
    }

    private ClassSlotResult transformClassSlots(WPos src, @Nullable JurstParser.ClassSlotsContext slots) {
        ClassSlotResult result = new ClassSlotResult();
        if (slots != null && slots.slots != null) {
            for (JurstParser.ClassSlotContext slot : slots.slots) {
                ClassSlot s = this.transformClassSlot(slot);
                if (s instanceof ConstructorDef) {
                    result.constructors.add((ConstructorDef)s);
                    continue;
                }
                if (s instanceof FuncDef) {
                    result.methods.add((FuncDef)s);
                    continue;
                }
                if (s instanceof ModuleUse) {
                    result.moduleUses.add((ModuleUse)s);
                    continue;
                }
                if (s instanceof OnDestroyDef) {
                    if (result.onDestroy == null) {
                        result.onDestroy = (OnDestroyDef)s;
                        continue;
                    }
                    throw new CompileError(s.attrSource(), "ondestroy already defined.");
                }
                if (s instanceof GlobalVarDef) {
                    result.vars.add((GlobalVarDef)s);
                    continue;
                }
                if (s instanceof ClassDef) {
                    result.innerClasses.add((ClassDef)s);
                    continue;
                }
                if (s == null) continue;
                throw this.error(slot, "unexpected classslot: " + s.getClass().getSimpleName());
            }
        }
        if (result.onDestroy == null) {
            result.onDestroy = Ast.OnDestroyDef(src.artificial(), Ast.WStatements(new WStatement[0]));
        }
        return result;
    }

    private @Nullable ClassSlot transformClassSlot(JurstParser.ClassSlotContext s) {
        try {
            if (s.constructorDef() != null) {
                return this.transformConstructorDef(s.constructorDef());
            }
            if (s.moduleUse() != null) {
                return this.transformModuleUse(s.moduleUse());
            }
            if (s.ondestroyDef() != null) {
                return this.transformOndestroyDef(s.ondestroyDef());
            }
            if (s.varDef() != null) {
                return this.transformVardef(s.varDef());
            }
            if (s.funcDef() != null) {
                return this.transformFuncDef(s.funcDef());
            }
            if (s.exception != null) {
                return null;
            }
            throw this.error(s, "not matched: " + this.text(s));
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
    }

    private OnDestroyDef transformOndestroyDef(JurstParser.OndestroyDefContext o) {
        return Ast.OnDestroyDef(this.source(o), this.transformStatements(o.statementsBlock()));
    }

    private ClassSlot transformModuleUse(JurstParser.ModuleUseContext u) {
        return Ast.ModuleUse(this.source(u), this.text(u.moduleName), this.transformTypeArgs(u.typeArgs()));
    }

    private ConstructorDef transformConstructorDef(JurstParser.ConstructorDefContext c) {
        WPos source = this.source(c);
        Modifiers modifiers = this.transformModifiers(c.modifiersWithDoc());
        WParameters parameters = this.transformFormalParameters(c.formalParameters(), false);
        WStatements body = this.transformStatementList(c.stmts);
        boolean isExplicit = c.superArgs != null;
        Arguments superArgs = this.transformExprs(c.superArgs);
        SuperConstructorCall superCall = isExplicit ? Ast.SomeSuperConstructorCall(this.source(c.superArgs), this.source(c.superArgs), superArgs) : Ast.NoSuperConstructorCall();
        return Ast.ConstructorDef(source, modifiers, parameters, superCall, body);
    }

    private WStatements transformStatementList(List<JurstParser.StatementContext> stmts) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (JurstParser.StatementContext s : stmts) {
            result.add(this.transformStatement(s));
        }
        return result;
    }

    private WEntity transformModuleDef(JurstParser.ModuleDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        TypeParamDefs typeParameters = this.transformTypeParams(i.typeParams());
        ClassSlotResult slots = this.transformClassSlots(src, i.classSlots());
        return Ast.ModuleDef(src, modifiers, name, typeParameters, slots.innerClasses, slots.methods, slots.vars, slots.constructors, slots.moduleInstanciations, slots.moduleUses, slots.onDestroy);
    }

    private WEntity transformEnumDef(JurstParser.EnumDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        EnumMembers members = Ast.EnumMembers(new EnumMember[0]);
        for (JurstParser.IdContext m : i.enumMembers) {
            members.add(Ast.EnumMember(this.source(m), Ast.Modifiers(new Modifier[0]), this.text(m)));
        }
        return Ast.EnumDef(src, modifiers, name, members);
    }

    private WEntity transformClassDef(JurstParser.ClassDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        TypeParamDefs typeParameters = this.transformTypeParams(i.typeParams());
        OptTypeExpr extendedClass = this.transformOptionalType(i.extended);
        TypeExprList implementsList = Ast.TypeExprList(new TypeExpr[0]);
        for (JurstParser.TypeExprContext ex : i.implemented) {
            implementsList.add(this.transformTypeExpr(ex));
        }
        ClassSlotResult slots = this.transformClassSlots(src, i.classSlots());
        return Ast.ClassDef(src, modifiers, name, typeParameters, extendedClass, implementsList, slots.innerClasses, slots.methods, slots.vars, slots.constructors, slots.moduleInstanciations, slots.moduleUses, slots.onDestroy);
    }

    private NativeType transformNativeType(JurstParser.NativeTypeContext n) {
        OptTypeExpr extended = n.extended != null ? Ast.TypeExprSimple(this.source(n.extended), Ast.NoTypeExpr(), this.rawText(n.extended), Ast.TypeExprList(new TypeExpr[0])) : Ast.NoTypeExpr();
        return Ast.NativeType(this.source(n), Ast.Modifiers(new Modifier[0]), this.text(n.name), extended);
    }

    private FuncDef transformFuncDef(JurstParser.FuncDefContext f) {
        FuncSig sig = this.transformFuncSig(f.funcSignature());
        Modifiers modifiers = this.transformModifiers(f.modifiersWithDoc());
        WStatements body = this.transformStatements(f.statementsBlock());
        return Ast.FuncDef(this.source(f), modifiers, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private GlobalVarDef transformVardef(JurstParser.VarDefContext v) {
        WPos source = this.source(v);
        Modifiers modifiers = this.transformModifiers(v.modifiersWithDoc());
        if (v.constant != null) {
            modifiers.add(Ast.ModConstant(this.source(v.constant)));
        }
        OptExpr initialExpr = this.transformOptionalExpr(v.initial);
        Identifier name = this.text(v.name);
        OptTypeExpr optTyp = this.transformOptionalType(v.varType);
        if (v.arraySizes != null && !v.arraySizes.isEmpty()) {
            if (optTyp instanceof TypeExprArray) {
                TypeExprArray arType = (TypeExprArray)optTyp;
                arType.setArraySize(this.transformOptionalExpr(v.arraySizes.get(0)));
                if (v.arraySizes.size() > 1) {
                    throw this.error(v.arraySizes.get(1), "Only one-dimensional arrays are supported currently.");
                }
            } else {
                throw this.error(v.arraySizes.get(0), "Array size can only be given for array types.");
            }
        }
        return Ast.GlobalVarDef(source, modifiers, optTyp, name, initialExpr);
    }

    private InitBlock transformInit(JurstParser.InitBlockContext i) {
        return Ast.InitBlock(this.source(i), this.transformStatements(i.statementsBlock()));
    }

    private WStatements transformStatements(@Nullable JurstParser.StatementsBlockContext b) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        if (b != null) {
            for (JurstParser.StatementContext s : b.statement()) {
                result.add(this.transformStatement(s));
            }
        }
        return result;
    }

    private WStatement transformStatement(JurstParser.StatementContext s) {
        if (s.stmtIf() != null) {
            return this.transformIf(s.stmtIf());
        }
        if (s.stmtWhile() != null) {
            return this.transformWhile(s.stmtWhile());
        }
        if (s.localVarDef() != null) {
            return this.transformLocalVarDef(s.localVarDef());
        }
        if (s.stmtSet() != null) {
            return this.transformStmtSet(s.stmtSet());
        }
        if (s.stmtCall() != null) {
            return this.transformCall(s.stmtCall());
        }
        if (s.stmtReturn() != null) {
            return this.transformReturn(s.stmtReturn());
        }
        if (s.stmtForLoop() != null) {
            return this.transformForLoop(s.stmtForLoop());
        }
        if (s.stmtBreak() != null) {
            return Ast.StmtExitwhen(this.source(s), Ast.ExprBoolVal(this.source(s), true));
        }
        if (s.stmtSkip() != null) {
            return Ast.StmtSkip(this.source(s));
        }
        if (s.stmtSwitch() != null) {
            return this.transformSwitch(s.stmtSwitch());
        }
        if (s.stmtLoop() != null) {
            return this.transformLoop(s.stmtLoop());
        }
        if (s.stmtExitwhen() != null) {
            return this.transformExitwhen(s.stmtExitwhen());
        }
        if (s.exception != null) {
            return Ast.StmtErr(this.source(s));
        }
        throw this.error(s, "not implemented: " + this.text(s) + "\n" + s.toStringTree());
    }

    private WStatement transformExitwhen(JurstParser.StmtExitwhenContext s) {
        return Ast.StmtExitwhen(this.source(s), this.transformExpr(s.expr()));
    }

    private WStatement transformLoop(JurstParser.StmtLoopContext s) {
        return Ast.StmtLoop(this.source(s), this.transformStatements(s.statementsBlock()));
    }

    private WStatement transformSwitch(JurstParser.StmtSwitchContext s) {
        Expr expr = this.transformExpr(s.expr());
        SwitchCases cases = Ast.SwitchCases(new SwitchCase[0]);
        for (JurstParser.SwitchCaseContext c : s.switchCase()) {
            Expr e = this.transformExpr(c.expr());
            WStatements stmts = this.transformStatements(c.statementsBlock());
            cases.add(Ast.SwitchCase(this.source(c), Ast.ExprList(e), stmts));
        }
        SwitchDefaultCase switchDefault = s.switchDefaultCase() != null ? Ast.SwitchDefaultCaseStatements(this.source(s.switchDefaultCase()), this.transformStatements(s.switchDefaultCase().statementsBlock())) : Ast.NoDefaultCase();
        return Ast.SwitchStmt(this.source(s), expr, cases, switchDefault);
    }

    private WStatement transformWhile(JurstParser.StmtWhileContext s) {
        return Ast.StmtWhile(this.source(s), this.transformExpr(s.cond), this.transformStatements(s.statementsBlock()));
    }

    private ExprDestroy transformExprDestroy(JurstParser.ExprDestroyContext e) {
        return this.transformExprDestroyObject(this.source(e), e.expr());
    }

    private ExprDestroy transformExprDestroyObject(WPos source, JurstParser.ExprContext e) {
        return Ast.ExprDestroy(source, this.transformExpr(e));
    }

    private StmtReturn transformReturn(JurstParser.StmtReturnContext s) {
        return Ast.StmtReturn(this.source(s), this.transformOptionalExpr(s.expr()));
    }

    private WStatement transformStmtSet(JurstParser.StmtSetContext s) {
        NameRef updatedExpr = this.transformAssignable(s.left);
        WPos src = this.source(s);
        if (s.assignOp != null) {
            Expr right = this.transformExpr(s.right);
            WurstOperator op = this.getAssignOp(s.assignOp);
            if (op != null) {
                right = Ast.ExprBinary(src, updatedExpr.copy(), op, right);
            }
            return Ast.StmtSet(src, updatedExpr, right);
        }
        if (s.incOp != null) {
            ExprBinary right = Ast.ExprBinary(src, updatedExpr.copy(), WurstOperator.PLUS, Ast.ExprIntVal(src, "1"));
            return Ast.StmtSet(src, updatedExpr, right);
        }
        if (s.decOp != null) {
            ExprBinary right = Ast.ExprBinary(src, updatedExpr.copy(), WurstOperator.MINUS, Ast.ExprIntVal(src, "1"));
            return Ast.StmtSet(src, updatedExpr, right);
        }
        if (s.exception != null) {
            return Ast.StmtErr(src);
        }
        throw this.error(s, "set-statment not implemented");
    }

    private @Nullable WurstOperator getAssignOp(Token assignOp) {
        switch (assignOp.getType()) {
            case 126: {
                return WurstOperator.PLUS;
            }
            case 127: {
                return WurstOperator.MINUS;
            }
            case 128: {
                return WurstOperator.MULT;
            }
            case 129: {
                return WurstOperator.DIV_REAL;
            }
            case 119: {
                return null;
            }
        }
        throw this.error(this.source(assignOp), "unhandled assign op: " + this.text(assignOp));
    }

    private NameRef transformAssignable(JurstParser.ExprAssignableContext e) {
        if (e.exprMemberVar() != null) {
            return this.transformExprMemberVar(e.exprMemberVar());
        }
        if (e.exprVarAccess() != null) {
            return this.transformExprVarAccess(e.exprVarAccess());
        }
        return Ast.ExprVarAccess(this.source(e), this.text(e));
    }

    private NameRef transformExprVarAccess(JurstParser.ExprVarAccessContext e) {
        if (e.indexes() == null || e.indexes().isEmpty()) {
            return Ast.ExprVarAccess(this.source(e), this.text(e.varname));
        }
        return Ast.ExprVarArrayAccess(this.source(e), this.text(e.varname), this.transformIndexes(e.indexes()));
    }

    private NameRef transformExprMemberVar(JurstParser.ExprMemberVarContext e) {
        return this.transformExprMemberVarAccess2(this.source(e), e.expr(), e.dots, e.varname, e.indexes());
    }

    private NameRef transformExprMemberVarAccess2(WPos source, JurstParser.ExprContext e_expr, Token e_dots, JurstParser.IdContext varname2, @Nullable List<JurstParser.IndexesContext> indexList) {
        Expr left = this.transformExpr(e_expr);
        if (left instanceof ExprEmpty) {
            left = Ast.ExprThis(left.getSource());
        }
        Identifier varName = this.text(varname2);
        if (indexList != null && !indexList.isEmpty()) {
            Indexes indexes = this.transformIndexes(indexList);
            if (e_dots.getType() == 113) {
                return Ast.ExprMemberArrayVarDot(source, left, varName, indexes);
            }
            return Ast.ExprMemberArrayVarDotDot(source, left, varName, indexes);
        }
        if (e_dots.getType() == 113) {
            return Ast.ExprMemberVarDot(source, left, varName);
        }
        return Ast.ExprMemberVarDotDot(source, left, varName);
    }

    private String text(@Nullable Token t) {
        if (t == null) {
            return "";
        }
        return t.getText();
    }

    private WStatement transformForLoop(JurstParser.StmtForLoopContext s) {
        if (s.forRangeLoop() != null) {
            return this.transformForRangeLoop(s.forRangeLoop());
        }
        if (s.forIteratorLoop() != null) {
            return this.transformForIteratorLoop(s.forIteratorLoop());
        }
        throw this.error(s, "for loop not implemented: " + this.text(s));
    }

    private WStatement transformForRangeLoop(JurstParser.ForRangeLoopContext s) {
        WPos source = this.source(s);
        LocalVarDef loopVar = this.transformLocalVarDef(s.loopVar);
        loopVar.setInitialExpr(this.transformExpr(s.start));
        Expr to = this.transformExpr(s.end);
        Expr step = s.step == null ? Ast.ExprIntVal(this.source(s.direction), "1") : this.transformExpr(s.step);
        WStatements body = this.transformStatements(s.statementsBlock());
        if (s.direction.getType() == 58) {
            return Ast.StmtForRangeUp(source, loopVar, to, step, body);
        }
        if (s.direction.getType() == 59) {
            return Ast.StmtForRangeDown(source, loopVar, to, step, body);
        }
        throw this.error(s, "for range loop not implemented: " + this.text(s));
    }

    private LocalVarDef transformLocalVarDef(JurstParser.LocalVarDefInlineContext v) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        OptTypeExpr optTyp = this.transformOptionalType(v.typeExpr());
        Identifier name = this.text(v.name);
        NoExpr initialExpr = Ast.NoExpr();
        return Ast.LocalVarDef(this.source(v), modifiers, optTyp, name, initialExpr);
    }

    private WStatement transformForIteratorLoop(JurstParser.ForIteratorLoopContext s) {
        WPos source = this.source(s);
        LocalVarDef loopVar = this.transformLocalVarDef(s.loopVar);
        Expr in = this.transformExpr(s.iteratorExpr);
        WStatements body = this.transformStatements(s.statementsBlock());
        if (s.iterStyle.getType() == 9) {
            return Ast.StmtForIn(source, loopVar, in, body);
        }
        return Ast.StmtForFrom(source, loopVar, in, body);
    }

    private LocalVarDef transformLocalVarDef(JurstParser.LocalVarDefContext l) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        if (l.let != null) {
            modifiers.add(Ast.ModConstant(this.source(l.let)));
        }
        OptTypeExpr optTyp = this.transformOptionalType(l.type);
        Identifier name = this.text(l.name);
        OptExpr initialExpr = this.transformOptionalExpr(l.initial);
        return Ast.LocalVarDef(this.source(l), modifiers, optTyp, name, initialExpr);
    }

    private OptExpr transformOptionalExpr(@Nullable JurstParser.ExprContext e) {
        if (e == null) {
            return Ast.NoExpr();
        }
        Expr r = this.transformExpr(e);
        if (r instanceof ExprEmpty) {
            return Ast.NoExpr();
        }
        return r;
    }

    private WStatement transformCall(JurstParser.StmtCallContext c) {
        if (c.exprFunctionCall() != null) {
            return this.transformFunctionCall(c.exprFunctionCall());
        }
        if (c.exprMemberMethod() != null) {
            return this.transformMemberMethodCall(c.exprMemberMethod());
        }
        if (c.exprNewObject() != null) {
            return this.transformExprNewObject(c.exprNewObject());
        }
        if (c.exprDestroy() != null) {
            return this.transformExprDestroy(c.exprDestroy());
        }
        return Ast.StmtErr(this.source(c));
    }

    private ExprNewObject transformExprNewObject(JurstParser.ExprNewObjectContext e) {
        Identifier typeName = this.text(e.className);
        TypeExprList typeArgs = this.transformTypeArgs(e.typeArgs());
        Arguments args = this.transformExprs(e.exprList());
        return Ast.ExprNewObject(this.source(e), typeName, typeArgs, args);
    }

    private WStatement transformMemberMethodCall(JurstParser.ExprMemberMethodContext e) {
        WPos source = this.source(e);
        JurstParser.ExprContext receiver = e.receiver;
        Token dots = e.dots;
        JurstParser.IdContext funcName = e.funcName;
        JurstParser.TypeArgsContext typeArgs = e.typeArgs();
        JurstParser.ExprListContext args = e.exprList();
        return this.transformMemberMethodCall2(source, receiver, dots, funcName, typeArgs, args);
    }

    private ExprMemberMethod transformMemberMethodCall2(WPos source, JurstParser.ExprContext receiver, Token dots, JurstParser.IdContext funcName, JurstParser.TypeArgsContext typeArgs, JurstParser.ExprListContext args) {
        Expr left = this.transformExpr(receiver);
        if (left instanceof ExprEmpty) {
            left = Ast.ExprThis(left.getSource());
        }
        if (dots.getType() == 113) {
            return Ast.ExprMemberMethodDot(source, left, this.text(funcName), this.transformTypeArgs(typeArgs), this.transformExprs(args));
        }
        return Ast.ExprMemberMethodDotDot(source, left, this.text(funcName), this.transformTypeArgs(typeArgs), this.transformExprs(args));
    }

    private ExprFunctionCall transformFunctionCall(JurstParser.ExprFunctionCallContext c) {
        return Ast.ExprFunctionCall(this.source(c), this.text(c.funcName), this.transformTypeArgs(c.typeArgs()), this.transformExprs(c.exprList()));
    }

    private Arguments transformExprs(@Nullable JurstParser.ExprListContext es) {
        Arguments result = Ast.Arguments(new Expr[0]);
        if (es != null) {
            for (JurstParser.ExprContext e : es.exprs) {
                result.add(this.transformExpr(e));
            }
        }
        if (result.size() == 1 && result.get(0) instanceof ExprEmpty) {
            result.clear();
        }
        return result;
    }

    private WStatement transformIf(JurstParser.StmtIfContext i) {
        Expr cond = this.transformExpr(i.cond);
        WStatements thenBlock = this.transformStatements(i.thenStatements);
        WStatements elseBlock = this.transformElseBlock(i.elseStatements());
        return Ast.StmtIf(this.source(i), cond, thenBlock, elseBlock, !this.isEndif(i.elseStatements()));
    }

    private boolean isEndif(JurstParser.ElseStatementsContext s) {
        return s.ENDIF() != null;
    }

    private WStatements transformElseBlock(@Nullable JurstParser.ElseStatementsContext es) {
        if (es == null) {
            return Ast.WStatements(new WStatement[0]);
        }
        if (es.cond != null) {
            WStatements thenBlock = this.transformStatements(es.thenStatements);
            WStatements elseBlock = this.transformElseBlock(es.elseStatements());
            return Ast.WStatements(Ast.StmtIf(this.source(es), this.transformExpr(es.cond), thenBlock, elseBlock, !this.isEndif(es.elseStatements())));
        }
        if (es.statementsBlock() != null) {
            return this.transformStatements(es.statementsBlock());
        }
        return Ast.WStatements(new WStatement[0]);
    }

    private Expr transformExpr(JurstParser.ExprContext e) {
        ParseTree right;
        WPos source = this.source(e);
        if (e.exprPrimary() != null) {
            return this.transformExprPrimary(e.exprPrimary());
        }
        if (e.left != null && e.right != null && e.op != null) {
            return Ast.ExprBinary(source, this.transformExpr(e.left), this.transformOp(e.op), this.transformExpr(e.right));
        }
        if (e.op != null && e.op.getType() == 42) {
            return Ast.ExprUnary(source, WurstOperator.NOT, this.transformExpr(e.right));
        }
        if (e.op != null && e.op.getType() == 108) {
            return Ast.ExprUnary(source, WurstOperator.UNARY_MINUS, this.transformExpr(e.right));
        }
        if (e.castToType != null) {
            return Ast.ExprCast(source, this.transformTypeExpr(e.castToType), this.transformExpr(e.left));
        }
        if (e.dotsVar != null) {
            return this.transformExprMemberVarAccess2(source, e.receiver, e.dotsVar, e.varName, e.indexes());
        }
        if (e.dotsCall != null) {
            return this.transformMemberMethodCall2(source, e.receiver, e.dotsCall, e.funcName, e.typeArgs(), e.exprList());
        }
        if (e.instaneofType != null) {
            return Ast.ExprInstanceOf(source, this.transformTypeExpr(e.instaneofType), this.transformExpr(e.left));
        }
        if (e.destroyedObject != null) {
            return this.transformExprDestroyObject(this.source(e), e.destroyedObject);
        }
        ParseTree left = this.getLeftParseTree(e);
        if (left != null) {
            source = source.withLeftPos(1 + this.stopPos(left));
        }
        if ((right = this.getRightParseTree(e)) != null) {
            source = source.withRightPos(this.beginPos(right));
        }
        return Ast.ExprEmpty(source);
    }

    private int beginPos(ParseTree left) {
        if (left instanceof ParserRuleContext) {
            ParserRuleContext left2 = (ParserRuleContext)left;
            return left2.getStart().getStartIndex();
        }
        if (left instanceof TerminalNode) {
            TerminalNode left2 = (TerminalNode)left;
            return left2.getSymbol().getStartIndex();
        }
        throw new Error("unhandled case: " + left.getClass() + "  // " + left);
    }

    private int stopPos(ParseTree left) {
        if (left instanceof ParserRuleContext) {
            ParserRuleContext left2 = (ParserRuleContext)left;
            return left2.getStop().getStopIndex();
        }
        if (left instanceof TerminalNode) {
            TerminalNode left2 = (TerminalNode)left;
            return left2.getSymbol().getStopIndex();
        }
        throw new Error("unhandled case: " + left.getClass() + "  // " + left);
    }

    private @Nullable ParseTree getLeftParseTree(@Nullable ParserRuleContext e) {
        if (e == null || e.getParent() == null) {
            return null;
        }
        ParserRuleContext parent = e.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i) != e) continue;
            if (i > 0) {
                return parent.getChild(i - 1);
            }
            return this.getLeftParseTree(parent);
        }
        return null;
    }

    private @Nullable ParseTree getRightParseTree(@Nullable ParserRuleContext e) {
        if (e == null || e.getParent() == null) {
            return null;
        }
        ParserRuleContext parent = e.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i) != e) continue;
            if (i < parent.getChildCount() - 1) {
                return parent.getChild(i + 1);
            }
            return this.getRightParseTree(parent);
        }
        return null;
    }

    private WurstOperator transformOp(Token op) {
        switch (op.getType()) {
            case 41: {
                return WurstOperator.OR;
            }
            case 40: {
                return WurstOperator.AND;
            }
            case 120: {
                return WurstOperator.EQ;
            }
            case 121: {
                return WurstOperator.NOTEQ;
            }
            case 123: {
                return WurstOperator.LESS_EQ;
            }
            case 122: {
                return WurstOperator.LESS;
            }
            case 125: {
                return WurstOperator.GREATER_EQ;
            }
            case 124: {
                return WurstOperator.GREATER;
            }
            case 106: {
                return WurstOperator.PLUS;
            }
            case 108: {
                return WurstOperator.MINUS;
            }
            case 110: {
                return WurstOperator.MULT;
            }
            case 111: {
                return WurstOperator.DIV_REAL;
            }
            case 54: {
                return WurstOperator.DIV_INT;
            }
            case 112: {
                return WurstOperator.MOD_REAL;
            }
            case 55: {
                return WurstOperator.MOD_INT;
            }
            case 42: {
                return WurstOperator.NOT;
            }
        }
        throw this.error(this.source(op), "operator not implemented: " + this.text(op));
    }

    private Expr transformExprPrimary(JurstParser.ExprPrimaryContext e) {
        if (e.atom != null) {
            return this.transformAtom(e.atom);
        }
        if (e.varname != null) {
            if (e.indexes() != null && !e.indexes().isEmpty()) {
                Indexes index = this.transformIndexes(e.indexes());
                return Ast.ExprVarArrayAccess(this.source(e), this.text(e.varname), index);
            }
            return Ast.ExprVarAccess(this.source(e), this.text(e.varname));
        }
        if (e.expr() != null) {
            return this.transformExpr(e.expr());
        }
        if (e.exprFunctionCall() != null) {
            return this.transformFunctionCall(e.exprFunctionCall());
        }
        if (e.exprNewObject() != null) {
            return this.transformExprNewObject(e.exprNewObject());
        }
        if (e.exprClosure() != null) {
            return this.transformClosure(e.exprClosure());
        }
        if (e.exprStatementsBlock() != null) {
            return this.transformExprStatementsBlock(e.exprStatementsBlock());
        }
        if (e.exprFuncRef() != null) {
            return this.transformExprFuncRef(e.exprFuncRef());
        }
        throw this.error(e, "primary expr not implemented " + this.text(e));
    }

    private ExprFuncRef transformExprFuncRef(JurstParser.ExprFuncRefContext e) {
        String scopeName = e.scopeName == null ? "" : this.rawText(e.scopeName);
        Identifier funcName = this.text(e.funcName);
        return Ast.ExprFuncRef(this.source(e), scopeName, funcName);
    }

    private ExprStatementsBlock transformExprStatementsBlock(JurstParser.ExprStatementsBlockContext e) {
        return Ast.ExprStatementsBlock(this.source(e), this.transformStatements(e.statementsBlock()));
    }

    private ExprClosure transformClosure(JurstParser.ExprClosureContext e) {
        WParameters parameters = this.transformFormalParameters(e.formalParameters(), true);
        Expr implementation = this.transformExpr(e.expr());
        WShortParameters sparameters = Ast.WShortParameters(new WShortParameter[0]);
        for (WParameter p : parameters) {
            sparameters.add(Ast.WShortParameter(p.getSource(), p.getModifiers().copy(), p.getTyp().copy(), p.getNameId().copy()));
        }
        return Ast.ExprClosure(this.source(e), this.source(e.arrow), sparameters, implementation);
    }

    private Indexes transformIndexes(List<JurstParser.IndexesContext> indexList) {
        Indexes result = Ast.Indexes(new Expr[0]);
        for (JurstParser.IndexesContext i : indexList) {
            result.add(this.transformExpr(i.expr()));
        }
        return result;
    }

    private Expr transformAtom(Token a) {
        WPos source = this.source(a);
        switch (a.getType()) {
            case 141: {
                return Ast.ExprIntVal(source, this.text(a));
            }
            case 140: {
                return Ast.ExprRealVal(source, this.text(a));
            }
            case 139: {
                return Ast.ExprStringVal(source, this.getStringVal(source, this.text(a)));
            }
            case 12: {
                return Ast.ExprNull(source);
            }
            case 62: {
                return Ast.ExprBoolVal(source, true);
            }
            case 63: {
                return Ast.ExprBoolVal(source, false);
            }
            case 43: {
                if (this.isJassCode) {
                    return Ast.ExprVarAccess(source, Ast.Identifier(source, "this"));
                }
                return Ast.ExprThis(source);
            }
            case 66: {
                return Ast.ExprSuper(source);
            }
        }
        throw this.error(this.source(a), "atom not implemented: " + this.text(a));
    }

    private String getStringVal(WPos source, String text) {
        StringBuilder res = new StringBuilder();
        AntlrJassParseTreeTransformer.buildStringVal(source, text, res);
        return res.toString();
    }

    private WEntity transformNativeDef(JurstParser.NativeDefContext n) {
        Modifiers modifiers = this.transformModifiers(n.modifiersWithDoc());
        FuncSig sig = this.transformFuncSig(n.funcSignature());
        return Ast.NativeFunc(this.source(n), modifiers, sig.name, sig.formalParameters, sig.returnType);
    }

    private FuncSig transformFuncSig(JurstParser.FuncSignatureContext s) {
        TypeParamDefs typeParams = this.transformTypeParams(s.typeParams());
        WParameters formalParameters = this.transformFormalParameters(s.formalParameters(), false);
        OptTypeExpr returnType = this.transformOptionalType(s.returnType);
        return new FuncSig(this.text(s.name), typeParams, formalParameters, returnType);
    }

    private FuncSig transformFuncSig(JurstParser.JassFuncSignatureContext s) {
        TypeParamDefs typeParams = Ast.TypeParamDefs(new TypeParamDef[0]);
        WParameters formalParameters = Ast.WParameters(new WParameter[0]);
        for (JurstParser.FormalParameterContext p : s.args) {
            formalParameters.add(this.transformFormalParameter(p, false));
        }
        OptTypeExpr returnType = this.transformOptionalType(s.returnType);
        return new FuncSig(this.text(s.name), typeParams, formalParameters, returnType);
    }

    private OptTypeExpr transformOptionalType(@Nullable JurstParser.TypeExprContext t) {
        if (t == null) {
            return Ast.NoTypeExpr();
        }
        return this.transformTypeExpr(t);
    }

    private TypeExpr transformTypeExpr(JurstParser.TypeExprContext t) throws Error {
        OptTypeExpr scopeType = t.typeExpr() != null ? this.transformTypeExpr(t.typeExpr()) : Ast.NoTypeExpr();
        if (t.thistype != null) {
            return Ast.TypeExprThis(this.source(t), scopeType);
        }
        if (t.typeName != null) {
            return Ast.TypeExprSimple(this.source(t), scopeType, this.text(t.typeName), this.transformTypeArgs(t.typeArgs()));
        }
        if (t.typeExpr() != null) {
            JurstParser.ExprContext arrSize = null;
            if (t.arraySizes != null && !t.arraySizes.isEmpty()) {
                arrSize = t.arraySizes.get(0);
                if (t.arraySizes.size() > 1) {
                    throw this.error(t.arraySizes.get(1), "Currently only one dimension is allowed for arrays.");
                }
            }
            return Ast.TypeExprArray(this.source(t), (TypeExpr)scopeType, this.transformOptionalExpr(arrSize));
        }
        return Ast.TypeExprSimple(this.source(t), scopeType, "", Ast.TypeExprList(new TypeExpr[0]));
    }

    private CompileError error(WPos source, String msg) {
        return new CompileError(source, msg);
    }

    private CompileError error(ParserRuleContext source, String msg) {
        return new CompileError(this.source(source), msg);
    }

    private TypeExprList transformTypeArgs(@Nullable JurstParser.TypeArgsContext typeArgs) {
        TypeExprList result = Ast.TypeExprList(new TypeExpr[0]);
        if (typeArgs != null) {
            for (JurstParser.TypeExprContext e : typeArgs.args) {
                result.add(this.transformTypeExpr(e));
            }
        }
        return result;
    }

    private WParameters transformFormalParameters(JurstParser.FormalParametersContext ps, boolean makeConstant) {
        WParameters result = Ast.WParameters(new WParameter[0]);
        for (JurstParser.FormalParameterContext p : ps.params) {
            result.add(this.transformFormalParameter(p, makeConstant));
        }
        return result;
    }

    private WParameter transformFormalParameter(JurstParser.FormalParameterContext p, boolean makeConstant) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        if (makeConstant) {
            modifiers.add(Ast.ModConstant(this.source(p).artificial()));
        }
        return Ast.WParameter(this.source(p), modifiers, this.transformTypeExpr(p.typeExpr()), this.text(p.name));
    }

    private TypeParamDefs transformTypeParams(@Nullable JurstParser.TypeParamsContext typeParams) {
        TypeParamDefs result = Ast.TypeParamDefs(new TypeParamDef[0]);
        if (typeParams != null) {
            for (JurstParser.TypeParamContext p : typeParams.params) {
                result.add(this.transformTypeParam(p));
            }
        }
        return result;
    }

    private TypeParamDef transformTypeParam(JurstParser.TypeParamContext p) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        return Ast.TypeParamDef(this.source(p), modifiers, this.text(p.name), Ast.NoTypeParamConstraints());
    }

    private WImport transformImport(JurstParser.WImportContext i) {
        return Ast.WImport(this.source(i), i.isPublic != null, i.isInitLater != null, this.text(i.importedPackage));
    }

    private WPos source(ParserRuleContext p) {
        return new WPos(this.file, this.lineOffsets, p.start.getStartIndex(), p.stop.getStopIndex() + 1);
    }

    private WPos source(Token p) {
        return new WPos(this.file, this.lineOffsets, p.getStartIndex(), p.getStopIndex() + 1);
    }

    static class ClassSlotResult {
        public ClassDefs innerClasses = Ast.ClassDefs(new ClassDef[0]);
        public ConstructorDefs constructors = Ast.ConstructorDefs(new ConstructorDef[0]);
        public ModuleInstanciations moduleInstanciations = Ast.ModuleInstanciations(new ModuleInstanciation[0]);
        public GlobalVarDefs vars = Ast.GlobalVarDefs(new GlobalVarDef[0]);
        public FuncDefs methods = Ast.FuncDefs(new FuncDef[0]);
        public ModuleUses moduleUses = Ast.ModuleUses(new ModuleUse[0]);
        public @Nullable OnDestroyDef onDestroy = null;

        ClassSlotResult() {
        }
    }

    static class FuncSig {
        Identifier name;
        TypeParamDefs typeParams;
        WParameters formalParameters;
        OptTypeExpr returnType;

        public FuncSig(Identifier name, TypeParamDefs typeParams, WParameters formalParameters, OptTypeExpr returnType) {
            this.name = name;
            this.typeParams = typeParams;
            this.formalParameters = formalParameters;
            this.returnType = returnType;
        }
    }
}

