/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import config.WurstProjectConfigData;
import de.peeeq.wurstio.Pjass;
import de.peeeq.wurstio.TimeTaker;
import de.peeeq.wurstio.WurstCompilerJassImpl;
import de.peeeq.wurstio.languageserver.requests.RunTests;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstio.utils.FileUtils;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.intermediatelang.interpreter.ILStackFrame;
import de.peeeq.wurstscript.jassAst.JassProg;
import de.peeeq.wurstscript.jassprinter.JassPrinter;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;

public class CompilationProcess {
    private final WurstGui gui;
    private final RunArgs runArgs;
    private final TimeTaker timeTaker;

    public CompilationProcess(WurstGui gui, RunArgs runArgs) {
        this.gui = gui;
        this.runArgs = runArgs;
        this.timeTaker = runArgs.isMeasureTimes() ? new TimeTaker.Recording() : new TimeTaker.Default();
    }

    @Nullable CharSequence doCompilation(@Nullable MpqEditor mpqEditor, boolean isProd) throws IOException {
        return this.doCompilation(mpqEditor, null, isProd);
    }

    @Nullable CharSequence doCompilation(@Nullable MpqEditor mpqEditor, @Nullable File projectFolder, boolean isProd) throws IOException {
        boolean pjassError;
        WurstCompilerJassImpl compiler = new WurstCompilerJassImpl(this.timeTaker, projectFolder, this.gui, mpqEditor, this.runArgs);
        this.gui.sendProgress("Check input map");
        if (mpqEditor != null && !mpqEditor.canWrite()) {
            WLogger.severe("The supplied map is invalid/corrupted/protected and Wurst cannot write to it.\nPlease supply a valid .w3x input map that can be opened in the world editor.");
        }
        for (String file : this.runArgs.getFiles()) {
            compiler.loadFiles(file);
        }
        WurstModel model = this.timeTaker.measure("parse files", compiler::parseFiles);
        if (this.gui.getErrorCount() > 0) {
            return null;
        }
        if (model == null) {
            return null;
        }
        this.timeTaker.measure("Typecheck program", () -> compiler.checkProg(model));
        if (this.gui.getErrorCount() > 0) {
            return null;
        }
        this.timeTaker.measure("Translate program to Im", () -> compiler.translateProgToIm(model));
        if (this.gui.getErrorCount() > 0) {
            return null;
        }
        if (this.runArgs.isRunTests()) {
            this.timeTaker.measure("Run tests", () -> this.runTests(compiler.getImTranslator(), compiler, this.runArgs.getTestTimeout()));
        }
        this.timeTaker.measure("Run compiletime functions", () -> compiler.runCompiletime(new WurstProjectConfigData(), isProd, false));
        JassProg jassProg = this.timeTaker.measure("Transform program to Jass", compiler::transformProgToJass);
        if (jassProg == null || this.gui.getErrorCount() > 0) {
            return null;
        }
        boolean withSpace = !this.runArgs.isOptimize();
        this.gui.sendProgress("Printing Jass");
        JassPrinter printer = new JassPrinter(withSpace, jassProg);
        CharSequence mapScript = this.timeTaker.measure("Print Jass", printer::printProg);
        File outputMapscript = this.timeTaker.measure("Print Jass", () -> this.writeMapscript(mapScript));
        if (!this.runArgs.isDisablePjass() && (pjassError = this.timeTaker.measure("Run PJass", () -> this.runPjass(outputMapscript)).booleanValue())) {
            return null;
        }
        this.timeTaker.printReport();
        return mapScript;
    }

    private boolean runPjass(File outputMapscript) {
        File commonJ = new File(outputMapscript.getParent(), "common.j");
        File blizzJ = new File(outputMapscript.getParent(), "blizzard.j");
        Pjass.Result pJassResult = commonJ.exists() && blizzJ.exists() ? Pjass.runPjass(outputMapscript, commonJ.getAbsolutePath(), blizzJ.getAbsolutePath()) : Pjass.runPjass(outputMapscript);
        WLogger.info(pJassResult.getMessage());
        if (!pJassResult.isOk()) {
            for (CompileError err : pJassResult.getErrors()) {
                this.gui.sendError(err);
            }
            return true;
        }
        return false;
    }

    private File writeMapscript(CharSequence mapScript) {
        this.gui.sendProgress("Writing output file");
        File outputMapscript = this.runArgs.getOutFile() != null ? new File(this.runArgs.getOutFile()) : new File("./temp/output.j");
        outputMapscript.getParentFile().mkdirs();
        try {
            FileUtils.write(mapScript, outputMapscript);
            return outputMapscript;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void runTests(ImTranslator translator, WurstCompilerJassImpl compiler, int testTimeout) {
        final PrintStream out = System.out;
        this.gui.sendProgress("Running tests");
        System.out.println("Running tests");
        RunTests runTests = new RunTests(Optional.empty(), 0, 0, Optional.empty(), testTimeout){

            @Override
            protected void print(String message) {
                out.print(message);
            }
        };
        runTests.runTests(translator, compiler.getImProg(), Optional.empty(), Optional.empty());
        for (RunTests.TestFailure e : runTests.getFailTests()) {
            this.gui.sendError(new CompileError(e.getFunction(), e.getMessage()));
            if (!this.runArgs.isGui()) continue;
            for (ILStackFrame sf : Utils.iterateReverse(e.getStackTrace().getStackFrames())) {
                this.gui.sendError(sf.makeCompileError());
            }
        }
        System.out.println("Finished running tests");
    }
}

