/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableArrayList;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Vertex;

public class VertexNormalChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("NRMS");
    private final ArrayList<Vertex> _vertices = new ObservableArrayList<Vertex>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public ArrayList<Vertex> getVertices() {
        return this._vertices;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this._vertices.size());
        for (Vertex vertex : this._vertices) {
            vertex.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public VertexNormalChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        for (long verticesCount = stream.readUInt32("verticesCount").longValue(); verticesCount > 0L; --verticesCount) {
            this._vertices.add(new Vertex(stream));
        }
    }

    public VertexNormalChunk() {
    }
}

