/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VisibilityTrack;

public class ParticleEmitter2
extends MDXObject {
    private long _inclusiveSize = 0L;
    private Node _node;
    private float _speed = 0.0f;
    private float _variation = 0.0f;
    private float _latitude = 0.0f;
    private float _gravity = 0.0f;
    private float _lifespan = 0.0f;
    private float _emissionRate = 0.0f;
    private float _width = 0.0f;
    private float _length = 0.0f;
    private FilterMode _filterMode = FilterMode.BLEND;
    private long _rows = 0L;
    private long _columns = 0L;
    private HeadTailFlag _headTailFlag = HeadTailFlag.HEAD;
    private float _tailLength = 0.0f;
    private float _time = 0.0f;
    private Color _startColor;
    private Color _midColor;
    private Color _endColor;
    private float _startScaling = 0.0f;
    private float _midScaling = 0.0f;
    private float _endScaling = 0.0f;
    private long _startHeadInterval = 0L;
    private long _midHeadInterval = 0L;
    private long _endHeadInterval = 0L;
    private long _startHeadDecayInterval = 0L;
    private long _midHeadDecayInterval = 0L;
    private long _endHeadDecayInterval = 0L;
    private long _startTailInterval = 0L;
    private long _midTailInterval = 0L;
    private long _endTailInterval = 0L;
    private long _startTailDecayInterval = 0L;
    private long _midTailDecayInterval = 0L;
    private long _endTailDecayInterval = 0L;
    private long _textureId = 0L;
    private long _squirt = 0L;
    private long _priorityPlane = 0L;
    private long _replaceableId = 0L;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<EmissionRateTrackChunk> _emissionRateTrackChunks = new ObservableLinkedHashSet<EmissionRateTrackChunk>();
    private final LinkedHashSet<GravityTrackChunk> _gravityTrackChunks = new ObservableLinkedHashSet<GravityTrackChunk>();
    private final LinkedHashSet<LatitudeTrackChunk> _latitudeTrackChunks = new ObservableLinkedHashSet<LatitudeTrackChunk>();
    private final LinkedHashSet<SpeedTrackChunk> _speedTrackChunks = new ObservableLinkedHashSet<SpeedTrackChunk>();
    private final LinkedHashSet<VisibilityTrackChunk> _visibilityTrackChunks = new ObservableLinkedHashSet<VisibilityTrackChunk>();
    private final LinkedHashSet<VariationTrackChunk> _variationTrackChunks = new ObservableLinkedHashSet<VariationTrackChunk>();
    private final LinkedHashSet<LengthTrackChunk> _lengthTrackChunks = new ObservableLinkedHashSet<LengthTrackChunk>();
    private final LinkedHashSet<WidthTrackChunk> _widthTrackChunks = new ObservableLinkedHashSet<WidthTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public Node getNode() {
        return this._node;
    }

    public void setNode(@Nonnull Node node) {
        this._node = node;
    }

    public float getSpeed() {
        return this._speed;
    }

    public void setSpeed(float speed) {
        this._speed = speed;
    }

    public float getVariation() {
        return this._variation;
    }

    public void setVariation(float variation) {
        this._variation = variation;
    }

    public float getLatitude() {
        return this._latitude;
    }

    public void setLatitude(float latitude) {
        this._latitude = latitude;
    }

    public float getGravity() {
        return this._gravity;
    }

    public void setGravity(float gravity) {
        this._gravity = gravity;
    }

    public float getLifespan() {
        return this._lifespan;
    }

    public void setLifespan(float lifespan) {
        this._lifespan = lifespan;
    }

    public float getEmissionRate() {
        return this._emissionRate;
    }

    public void setEmissionRate(float emissionRate) {
        this._emissionRate = emissionRate;
    }

    public float getWidth() {
        return this._width;
    }

    public void setWidth(float width) {
        this._width = width;
    }

    public float getLength() {
        return this._length;
    }

    public void setLength(float length) {
        this._length = length;
    }

    public void squish() {
        this._speed = (float)(Math.floor(this._speed * 1000.0f) / 1000.0);
        this._variation = (float)(Math.floor(this._variation * 1000.0f) / 1000.0);
        this._latitude = (float)(Math.floor(this._latitude * 1000.0f) / 1000.0);
        this._gravity = (float)(Math.floor(this._gravity * 1000.0f) / 1000.0);
        this._emissionRate = (float)(Math.floor(this._emissionRate * 1000.0f) / 1000.0);
        this._width = (float)(Math.floor(this._width * 1000.0f) / 1000.0);
        this._length = (float)(Math.floor(this._length * 1000.0f) / 1000.0);
    }

    @Nonnull
    public FilterMode getFilterMode() {
        return this._filterMode;
    }

    public void setFilterMode(@Nonnull FilterMode filterMode) {
        this._filterMode = filterMode;
    }

    public long getRows() {
        return this._rows;
    }

    public void setRows(long rows) {
        this._rows = rows;
    }

    public long getColumns() {
        return this._columns;
    }

    public void setColumns(long columns) {
        this._columns = columns;
    }

    @Nonnull
    public HeadTailFlag getHeadTailFlag() {
        return this._headTailFlag;
    }

    public void setHeadTailFlag(@Nonnull HeadTailFlag headTailFlag) {
        this._headTailFlag = headTailFlag;
    }

    public float getTailLength() {
        return this._tailLength;
    }

    public void setTailLength(float tailLength) {
        this._tailLength = tailLength;
    }

    public float getTime() {
        return this._time;
    }

    public void setTime(float time) {
        this._time = time;
    }

    @Nonnull
    public Color getStartColor() {
        return this._startColor;
    }

    public void setStartColor(@Nonnull Color startColor) {
        this._startColor = startColor;
    }

    @Nonnull
    public Color getMidColor() {
        return this._midColor;
    }

    public void setMidColor(@Nonnull Color midColor) {
        this._midColor = midColor;
    }

    @Nonnull
    public Color getEndColor() {
        return this._endColor;
    }

    public void setEndColor(@Nonnull Color endColor) {
        this._endColor = endColor;
    }

    public float getStartScaling() {
        return this._startScaling;
    }

    public void setStartScaling(float startScaling) {
        this._startScaling = startScaling;
    }

    public float getMidScaling() {
        return this._midScaling;
    }

    public void setMidScaling(float midScaling) {
        this._midScaling = midScaling;
    }

    public float getEndScaling() {
        return this._endScaling;
    }

    public void setEndScaling(float endScaling) {
        this._endScaling = endScaling;
    }

    public long getStartHeadInterval() {
        return this._startHeadInterval;
    }

    public void setStartHeadInterval(long startHeadInterval) {
        this._startHeadInterval = startHeadInterval;
    }

    public long getMidHeadInterval() {
        return this._midHeadInterval;
    }

    public void setMidHeadInterval(long midHeadInterval) {
        this._midHeadInterval = midHeadInterval;
    }

    public long getEndHeadInterval() {
        return this._endHeadInterval;
    }

    public void setEndHeadInterval(long endHeadInterval) {
        this._endHeadInterval = endHeadInterval;
    }

    public long getStartHeadDecayInterval() {
        return this._startHeadDecayInterval;
    }

    public void setStartHeadDecayInterval(long startHeadDecayInterval) {
        this._startHeadDecayInterval = startHeadDecayInterval;
    }

    public long getMidHeadDecayInterval() {
        return this._midHeadDecayInterval;
    }

    public void setMidHeadDecayInterval(long midHeadDecayInterval) {
        this._midHeadDecayInterval = midHeadDecayInterval;
    }

    public long getEndHeadDecayInterval() {
        return this._endHeadDecayInterval;
    }

    public void setEndHeadDecayInterval(long endHeadDecayInterval) {
        this._endHeadDecayInterval = endHeadDecayInterval;
    }

    public long getStartTailInterval() {
        return this._startTailInterval;
    }

    public void setStartTailInterval(long startTailInterval) {
        this._startTailInterval = startTailInterval;
    }

    public long getMidTailInterval() {
        return this._midTailInterval;
    }

    public void setMidTailInterval(long midTailInterval) {
        this._midTailInterval = midTailInterval;
    }

    public long getEndTailInterval() {
        return this._endTailInterval;
    }

    public void setEndTailInterval(long endTailInterval) {
        this._endTailInterval = endTailInterval;
    }

    public long getStartTailDecayInterval() {
        return this._startTailDecayInterval;
    }

    public void setStartTailDecayInterval(long startTailDecayInterval) {
        this._startTailDecayInterval = startTailDecayInterval;
    }

    public long getMidTailDecayInterval() {
        return this._midTailDecayInterval;
    }

    public void setMidTailDecayInterval(long midTailDecayInterval) {
        this._midTailDecayInterval = midTailDecayInterval;
    }

    public long getEndTailDecayInterval() {
        return this._endTailDecayInterval;
    }

    public void setEndTailDecayInterval(long endTailDecayInterval) {
        this._endTailDecayInterval = endTailDecayInterval;
    }

    public long getTextureId() {
        return this._textureId;
    }

    public void setTextureId(long textureId) {
        this._textureId = textureId;
    }

    public long getSquirt() {
        return this._squirt;
    }

    public void setSquirt(long squirt) {
        this._squirt = squirt;
    }

    public long getPriorityPlane() {
        return this._priorityPlane;
    }

    public void setPriorityPlane(long priorityPlane) {
        this._priorityPlane = priorityPlane;
    }

    public long getReplaceableId() {
        return this._replaceableId;
    }

    public void setReplaceableId(long replaceableId) {
        this._replaceableId = replaceableId;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    private void addChunk(@Nonnull Chunk val) {
        this._chunks.add(val);
    }

    public LinkedHashSet<EmissionRateTrackChunk> getEmissionRateTrackChunks() {
        return this._emissionRateTrackChunks;
    }

    public void addEmissionRateTrackChunk(@Nonnull EmissionRateTrackChunk val) {
        this._chunks.add(val);
        this._emissionRateTrackChunks.add(val);
    }

    public LinkedHashSet<GravityTrackChunk> getGravityTrackChunks() {
        return this._gravityTrackChunks;
    }

    public void addGravityTrackChunk(@Nonnull GravityTrackChunk val) {
        this._chunks.add(val);
        this._gravityTrackChunks.add(val);
    }

    public LinkedHashSet<LatitudeTrackChunk> getLatitudeTrackChunks() {
        return this._latitudeTrackChunks;
    }

    public void addLatitudeTrackChunk(@Nonnull LatitudeTrackChunk val) {
        this._chunks.add(val);
        this._latitudeTrackChunks.add(val);
    }

    public LinkedHashSet<SpeedTrackChunk> getSpeedTrackChunks() {
        return this._speedTrackChunks;
    }

    public void addSpeedTrackChunk(@Nonnull SpeedTrackChunk val) {
        this._chunks.add(val);
        this._speedTrackChunks.add(val);
    }

    public LinkedHashSet<VisibilityTrackChunk> getVisibilityTrackChunks() {
        return this._visibilityTrackChunks;
    }

    public void addVisibilityTrackChunk(@Nonnull VisibilityTrackChunk val) {
        this._chunks.add(val);
        this._visibilityTrackChunks.add(val);
    }

    public LinkedHashSet<VariationTrackChunk> getVariationTrackChunks() {
        return this._variationTrackChunks;
    }

    public void addVariationTrackChunk(@Nonnull VariationTrackChunk val) {
        this._chunks.add(val);
        this._variationTrackChunks.add(val);
    }

    public LinkedHashSet<LengthTrackChunk> getLengthTrackChunks() {
        return this._lengthTrackChunks;
    }

    public void addLengthTrackChunk(@Nonnull LengthTrackChunk val) {
        this._chunks.add(val);
        this._lengthTrackChunks.add(val);
    }

    public LinkedHashSet<WidthTrackChunk> getWidthTrackChunks() {
        return this._widthTrackChunks;
    }

    public void addWidthTrackChunk(@Nonnull WidthTrackChunk val) {
        this._chunks.add(val);
        this._widthTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        this._node.write(stream);
        stream.writeFloat32(this._speed);
        stream.writeFloat32(this._variation);
        stream.writeFloat32(this._latitude);
        stream.writeFloat32(this._gravity);
        stream.writeFloat32(this._lifespan);
        stream.writeFloat32(this._emissionRate);
        stream.writeFloat32(this._length);
        stream.writeFloat32(this._width);
        stream.writeUInt32(this._filterMode.ordinal());
        stream.writeUInt32(this._rows);
        stream.writeUInt32(this._columns);
        stream.writeUInt32(this._headTailFlag.ordinal());
        stream.writeFloat32(this._tailLength);
        stream.writeFloat32(this._time);
        stream.writeFloat32((float)this._startColor.getBlue255() / 255.0f);
        stream.writeFloat32((float)this._startColor.getGreen255() / 255.0f);
        stream.writeFloat32((float)this._startColor.getRed255() / 255.0f);
        stream.writeFloat32((float)this._midColor.getBlue255() / 255.0f);
        stream.writeFloat32((float)this._midColor.getGreen255() / 255.0f);
        stream.writeFloat32((float)this._midColor.getRed255() / 255.0f);
        stream.writeFloat32((float)this._endColor.getBlue255() / 255.0f);
        stream.writeFloat32((float)this._endColor.getGreen255() / 255.0f);
        stream.writeFloat32((float)this._endColor.getRed255() / 255.0f);
        stream.writeUInt8(this._startColor.getAlpha255());
        stream.writeUInt8(this._midColor.getAlpha255());
        stream.writeUInt8(this._endColor.getAlpha255());
        stream.writeFloat32(this._startScaling);
        stream.writeFloat32(this._midScaling);
        stream.writeFloat32(this._endScaling);
        stream.writeUInt32(this._startHeadInterval);
        stream.writeUInt32(this._midHeadInterval);
        stream.writeUInt32(this._endHeadInterval);
        stream.writeUInt32(this._startHeadDecayInterval);
        stream.writeUInt32(this._midHeadDecayInterval);
        stream.writeUInt32(this._endHeadDecayInterval);
        stream.writeUInt32(this._startTailInterval);
        stream.writeUInt32(this._midTailInterval);
        stream.writeUInt32(this._endTailInterval);
        stream.writeUInt32(this._startTailDecayInterval);
        stream.writeUInt32(this._midTailDecayInterval);
        stream.writeUInt32(this._endTailDecayInterval);
        stream.writeUInt32(this._textureId);
        stream.writeUInt32(this._squirt);
        stream.writeUInt32(this._priorityPlane);
        stream.writeUInt32(this._replaceableId);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public ParticleEmitter2(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._node = new Node(stream);
        this._speed = stream.readFloat32("speed").floatValue();
        this._variation = stream.readFloat32("variation").floatValue();
        this._latitude = stream.readFloat32("latitude").floatValue();
        this._gravity = stream.readFloat32("gravity").floatValue();
        this._lifespan = stream.readFloat32("lifespan").floatValue();
        this._emissionRate = stream.readFloat32("emissionRate").floatValue();
        this._length = stream.readFloat32("length").floatValue();
        this._width = stream.readFloat32("width").floatValue();
        long filterModeL = stream.readUInt32("filterMode");
        if (filterModeL >= (long)FilterMode.values().length) {
            throw new IllegalArgumentException("filterMode out of bounds 0-" + FilterMode.values().length + " (" + filterModeL + ")");
        }
        this._filterMode = FilterMode.values()[(int)filterModeL];
        this._rows = stream.readUInt32("rows");
        this._columns = stream.readUInt32("columns");
        long headTailFlagL = stream.readUInt32("headTailFlag");
        if (headTailFlagL >= (long)HeadTailFlag.values().length) {
            throw new IllegalArgumentException("headTailFlags out of bounds 0-" + HeadTailFlag.values().length + " (" + headTailFlagL + ")");
        }
        this._headTailFlag = HeadTailFlag.values()[(int)headTailFlagL];
        this._tailLength = stream.readFloat32("tailLength").floatValue();
        this._time = stream.readFloat32("time").floatValue();
        this._startColor = Color.fromBGR255((int)(stream.readFloat32("startColorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("startColorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("startColorRed").floatValue() * 255.0f));
        this._midColor = Color.fromBGR255((int)(stream.readFloat32("midColorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("midColorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("midColorRed").floatValue() * 255.0f));
        this._endColor = Color.fromBGR255((int)(stream.readFloat32("endColorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("endColorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("endColorRed").floatValue() * 255.0f));
        this._startColor = Color.fromBGRA255(this._startColor.getBlue255(), this._startColor.getGreen255(), this._startColor.getRed255(), stream.readUInt8("startColorAlpha").shortValue());
        this._midColor = Color.fromBGRA255(this._midColor.getBlue255(), this._midColor.getGreen255(), this._midColor.getRed255(), stream.readUInt8("midColorAlpha").shortValue());
        this._endColor = Color.fromBGRA255(this._endColor.getBlue255(), this._endColor.getGreen255(), this._endColor.getRed255(), stream.readUInt8("endColorAlpha").shortValue());
        this._startScaling = stream.readFloat32("startScaling").floatValue();
        this._midScaling = stream.readFloat32("midScaling").floatValue();
        this._endScaling = stream.readFloat32("endScaling").floatValue();
        this._startHeadInterval = stream.readUInt32("startHeadInterval");
        this._midHeadInterval = stream.readUInt32("midHeadInterval");
        this._endHeadInterval = stream.readUInt32("endHeadInterval");
        this._startHeadDecayInterval = stream.readUInt32("startHeadDecayInterval");
        this._midHeadDecayInterval = stream.readUInt32("midHeadDecayInterval");
        this._endHeadDecayInterval = stream.readUInt32("endHeadDecayInterval");
        this._startTailInterval = stream.readUInt32("startTailInterval");
        this._midTailInterval = stream.readUInt32("midTailInterval");
        this._endTailInterval = stream.readUInt32("endTailInterval");
        this._startTailDecayInterval = stream.readUInt32("startTailDecayInterval");
        this._midTailDecayInterval = stream.readUInt32("midTailDecayInterval");
        this._endTailDecayInterval = stream.readUInt32("endTailDecayInterval");
        this._textureId = stream.readUInt32("textureId");
        this._squirt = stream.readUInt32("squirt");
        this._priorityPlane = stream.readUInt32("priorityPlane");
        this._replaceableId = stream.readUInt32("replaceableId");
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(EmissionRateTrackChunk.TOKEN, () -> this.addEmissionRateTrackChunk(new EmissionRateTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(GravityTrackChunk.TOKEN, () -> this.addGravityTrackChunk(new GravityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(LatitudeTrackChunk.TOKEN, () -> this.addLatitudeTrackChunk(new LatitudeTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(SpeedTrackChunk.TOKEN, () -> this.addSpeedTrackChunk(new SpeedTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(VisibilityTrackChunk.TOKEN, () -> this.addVisibilityTrackChunk(new VisibilityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(VariationTrackChunk.TOKEN, () -> this.addVariationTrackChunk(new VariationTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(LengthTrackChunk.TOKEN, () -> this.addLengthTrackChunk(new LengthTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(WidthTrackChunk.TOKEN, () -> this.addWidthTrackChunk(new WidthTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public ParticleEmitter2() {
        this._node = new Node();
        this._startColor = Color.fromBGRA255(0, 0, 0, 0);
        this._midColor = Color.fromBGRA255(0, 0, 0, 0);
        this._endColor = Color.fromBGRA255(0, 0, 0, 0);
    }

    public static class WidthTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2W");
        private final LinkedHashSet<WidthTrack> _widthTracks = new ObservableLinkedHashSet<WidthTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._widthTracks;
        }

        public LinkedHashSet<WidthTrack> getWidthTracks() {
            return this._widthTracks;
        }

        public WidthTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._widthTracks.add(new WidthTrack(stream, this.getInterpolationType(), format));
            }
        }

        public WidthTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class WidthTrack
        extends Track {
            private float _width;
            private float _inTan_width;
            private float _outTan_width;

            public float getWidth() {
                return this._width;
            }

            public void setWidth(float width) {
                this._width = width;
            }

            public float getInTanWidth() {
                return this._inTan_width;
            }

            public void setInTanWidth(float width) {
                this._inTan_width = width;
            }

            public float getOutTanWidth() {
                return this._outTan_width;
            }

            public void setOutTanWidth(float width) {
                this._outTan_width = width;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._width = stream.readFloat32("width").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_width = stream.readFloat32("inTan_width").floatValue();
                    this._outTan_width = stream.readFloat32("outTan_width").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._width);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_width);
                    stream.writeFloat32(this._outTan_width);
                }
            }

            public WidthTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class LengthTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2N");
        private final LinkedHashSet<LengthTrack> _lengthTracks = new ObservableLinkedHashSet<LengthTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._lengthTracks;
        }

        public LinkedHashSet<LengthTrack> getLengthTracks() {
            return this._lengthTracks;
        }

        public LengthTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._lengthTracks.add(new LengthTrack(stream, this.getInterpolationType(), format));
            }
        }

        public LengthTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class LengthTrack
        extends Track {
            private float _length;
            private float _inTan_length;
            private float _outTan_length;

            public float getLength() {
                return this._length;
            }

            public void setLength(float length) {
                this._length = length;
            }

            public float getInTanLength() {
                return this._inTan_length;
            }

            public void setInTanLength(float length) {
                this._inTan_length = length;
            }

            public float getOutTanLength() {
                return this._outTan_length;
            }

            public void setOutTanLength(float length) {
                this._outTan_length = length;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._length = stream.readFloat32("length").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_length = stream.readFloat32("inTan_length").floatValue();
                    this._outTan_length = stream.readFloat32("outTan_length").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._length);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_length);
                    stream.writeFloat32(this._outTan_length);
                }
            }

            public LengthTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class VariationTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2R");
        private final LinkedHashSet<VariationTrack> _variationTracks = new ObservableLinkedHashSet<VariationTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._variationTracks;
        }

        public LinkedHashSet<VariationTrack> getVariationTracks() {
            return this._variationTracks;
        }

        public VariationTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._variationTracks.add(new VariationTrack(stream, this.getInterpolationType(), format));
            }
        }

        public VariationTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class VariationTrack
        extends Track {
            private float _variation;
            private float _inTan_variation;
            private float _outTan_variation;

            public float getVariation() {
                return this._variation;
            }

            public void setVariation(float variation) {
                this._variation = variation;
            }

            public float getInTanVariation() {
                return this._inTan_variation;
            }

            public void setInTanVariation(float variation) {
                this._inTan_variation = variation;
            }

            public float getOutTanVariation() {
                return this._outTan_variation;
            }

            public void setOutTanVariation(float variation) {
                this._outTan_variation = variation;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._variation = stream.readFloat32("variation").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_variation = stream.readFloat32("inTan_variation").floatValue();
                    this._outTan_variation = stream.readFloat32("outTan_variation").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._variation);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_variation);
                    stream.writeFloat32(this._outTan_variation);
                }
            }

            public VariationTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class VisibilityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2V");
        private final LinkedHashSet<VisibilityTrack> _visibilityTracks = new ObservableLinkedHashSet<VisibilityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._visibilityTracks;
        }

        public LinkedHashSet<VisibilityTrack> getVisibilityTracks() {
            return this._visibilityTracks;
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._visibilityTracks.add(new VisibilityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }
    }

    public static class SpeedTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2S");
        private final LinkedHashSet<SpeedTrack> _speedTracks = new ObservableLinkedHashSet<SpeedTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._speedTracks;
        }

        public LinkedHashSet<SpeedTrack> getSpeedTracks() {
            return this._speedTracks;
        }

        public SpeedTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._speedTracks.add(new SpeedTrack(stream, this.getInterpolationType(), format));
            }
        }

        public SpeedTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class SpeedTrack
        extends Track {
            private float _speed;
            private float _inTan_speed;
            private float _outTan_speed;

            public float getSpeed() {
                return this._speed;
            }

            public void setSpeed(float speed) {
                this._speed = speed;
            }

            public float getInTanSpeed() {
                return this._inTan_speed;
            }

            public void setInTanSpeed(float speed) {
                this._inTan_speed = speed;
            }

            public float getOutTanSpeed() {
                return this._outTan_speed;
            }

            public void setOutTanSpeed(float speed) {
                this._outTan_speed = speed;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._speed = stream.readFloat32("speed").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_speed = stream.readFloat32("inTan_speed").floatValue();
                    this._outTan_speed = stream.readFloat32("outTan_speed").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._speed);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_speed);
                    stream.writeFloat32(this._outTan_speed);
                }
            }

            public SpeedTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class LatitudeTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2L");
        private final LinkedHashSet<LatitudeTrack> _latitudeTracks = new ObservableLinkedHashSet<LatitudeTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._latitudeTracks;
        }

        public LinkedHashSet<LatitudeTrack> getLatitudeTracks() {
            return this._latitudeTracks;
        }

        public LatitudeTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._latitudeTracks.add(new LatitudeTrack(stream, this.getInterpolationType(), format));
            }
        }

        public LatitudeTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class LatitudeTrack
        extends Track {
            private float _latitude;
            private float _inTan_latitude;
            private float _outTan_latitude;

            public float getLatitude() {
                return this._latitude;
            }

            public void setLatitude(float latitude) {
                this._latitude = latitude;
            }

            public float getInTanLatitude() {
                return this._inTan_latitude;
            }

            public void setInTanLatitude(float latitude) {
                this._inTan_latitude = latitude;
            }

            public float getOutTanLatitude() {
                return this._outTan_latitude;
            }

            public void setOutTanLatitude(float latitude) {
                this._outTan_latitude = latitude;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._latitude = stream.readFloat32("latitude").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_latitude = stream.readFloat32("inTan_latitude").floatValue();
                    this._outTan_latitude = stream.readFloat32("outTan_latitude").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._latitude);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_latitude);
                    stream.writeFloat32(this._outTan_latitude);
                }
            }

            public LatitudeTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class GravityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2G");
        private final LinkedHashSet<GravityTrack> _gravityTracks = new ObservableLinkedHashSet<GravityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._gravityTracks;
        }

        public LinkedHashSet<GravityTrack> getGravityTracks() {
            return this._gravityTracks;
        }

        public GravityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._gravityTracks.add(new GravityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public GravityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class GravityTrack
        extends Track {
            private float _gravity;
            private float _inTan_gravity;
            private float _outTan_gravity;

            public float getGravity() {
                return this._gravity;
            }

            public void setGravity(float gravity) {
                this._gravity = gravity;
            }

            public float getInTanGravity() {
                return this._inTan_gravity;
            }

            public void setInTanGravity(float gravity) {
                this._inTan_gravity = gravity;
            }

            public float getOutTanGravity() {
                return this._outTan_gravity;
            }

            public void setOutTanGravity(float gravity) {
                this._outTan_gravity = gravity;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._gravity = stream.readFloat32("gravity").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_gravity = stream.readFloat32("inTan_gravity").floatValue();
                    this._outTan_gravity = stream.readFloat32("outTan_gravity").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._gravity);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_gravity);
                    stream.writeFloat32(this._outTan_gravity);
                }
            }

            public GravityTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class EmissionRateTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KP2E");
        private final LinkedHashSet<EmissionRateTrack> _emissionRateTracks = new ObservableLinkedHashSet<EmissionRateTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._emissionRateTracks;
        }

        public LinkedHashSet<EmissionRateTrack> getEmissionRateTracks() {
            return this._emissionRateTracks;
        }

        public EmissionRateTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._emissionRateTracks.add(new EmissionRateTrack(stream, this.getInterpolationType(), format));
            }
        }

        public EmissionRateTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class EmissionRateTrack
        extends Track {
            private float _emissionRate;
            private float _inTan_emissionRate;
            private float _outTan_emissionRate;

            public float getEmissionRate() {
                return this._emissionRate;
            }

            public void setEmissionRate(float emissionRate) {
                this._emissionRate = emissionRate;
            }

            public float getInTanEmissionRate() {
                return this._inTan_emissionRate;
            }

            public void setInTanEmissionRate(float emissionRate) {
                this._inTan_emissionRate = emissionRate;
            }

            public float getOutTanEmissionRate() {
                return this._outTan_emissionRate;
            }

            public void setOutTanEmissionRate(float emissionRate) {
                this._outTan_emissionRate = emissionRate;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._emissionRate = stream.readFloat32("emissionRate").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_emissionRate = stream.readFloat32("inTan_emissionRate").floatValue();
                    this._outTan_emissionRate = stream.readFloat32("outTan_emissionRate").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._emissionRate);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_emissionRate);
                    stream.writeFloat32(this._outTan_emissionRate);
                }
            }

            public EmissionRateTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static enum HeadTailFlag {
        HEAD,
        TAIL,
        BOTH;

    }

    public static enum FilterMode {
        BLEND,
        ADDITIVE,
        MODULATE,
        MODULATE_2X,
        ALPHA_KEY;

    }
}

