/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Layer;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;

public class Material
extends MDXObject {
    private long _inclusiveSive;
    private long _priorityPlane;
    private long _flags;
    private final LinkedHashSet<Layer> _layers = new LinkedHashSet();
    public final Id LAYERS_TOKEN = Id.valueOf("LAYS");

    public long getInclusiveSize() {
        return this._inclusiveSive;
    }

    public long getPriorityPlane() {
        return this._priorityPlane;
    }

    public long getFlags() {
        return this._flags;
    }

    public LinkedHashSet<Layer> getLayers() {
        return new LinkedHashSet<Layer>(this._layers);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        stream.writeUInt32(this._priorityPlane);
        stream.writeUInt32(this._flags);
        stream.writeId(this.LAYERS_TOKEN);
        stream.writeUInt32(this.getLayers().size());
        for (Layer layer : this.getLayers()) {
            layer.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Material(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSive = stream.readUInt32("inclusiveSize");
        this._priorityPlane = stream.readUInt32("priorityPlane");
        this._flags = stream.readUInt32("flags");
        Id layersToken = stream.readId("layersToken");
        if (!layersToken.equals(this.LAYERS_TOKEN)) {
            throw new IllegalArgumentException("invalid " + this.LAYERS_TOKEN + " token (" + layersToken + ")");
        }
        for (long layersCount = stream.readUInt32("layersCount").longValue(); layersCount > 0L; --layersCount) {
            this._layers.add(new Layer(stream));
        }
    }

    public static enum Flag {
        CONST_COLOR(1),
        UNKNOWN_A(2),
        UNKNOWN_B(4),
        UNKNOWN_C(8),
        SORT_PRIMITIVES_FAR_Z(16),
        FULL_RESOLUTION(32);

        private int _index;

        public int getIndex() {
            return this._index;
        }

        private Flag(int index) {
            this._index = index;
        }
    }
}

