/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;

public class Layer
extends MDXObject {
    private long _inclusiveSive = 0L;
    private long _filterMode = 0L;
    private long _shadingFlags;
    private long _textureId;
    private long _textureAnimId;
    private long _coordId;
    private float _alpha;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<TextureTrackChunk> _textureTrackChunks = new ObservableLinkedHashSet<TextureTrackChunk>();
    private List<AlphaTrackChunk> _alphaTrackChunks = new ArrayList<AlphaTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSive;
    }

    public long getFilterModeL() {
        return this._filterMode;
    }

    public void setFilterModeL(long filterModeL) {
        this._filterMode = filterModeL;
    }

    @Nullable
    public FilterMode getFilterMode() {
        if (this._filterMode != (long)((int)this._filterMode)) {
            return null;
        }
        return FilterMode.values()[(int)this._filterMode];
    }

    public void setFilterMode(@Nonnull FilterMode val) {
        this._filterMode = val.ordinal();
    }

    public long getShadingFlags() {
        return this._shadingFlags;
    }

    public void setShadingFlags(long val) {
        this._shadingFlags = val;
    }

    public long getTextureId() {
        return this._textureId;
    }

    public void setTextureId(long textureId) {
        this._textureId = textureId;
    }

    public long getTextureAnimId() {
        return this._textureAnimId;
    }

    public void setTextureAnimId() {
        this._textureAnimId = this._textureAnimId;
    }

    public long getCoordId() {
        return this._coordId;
    }

    public void setCoordId(long coordId) {
        this._coordId = coordId;
    }

    public float getAlpha() {
        return this._alpha;
    }

    public void setAlpha(float alpha) {
        this._alpha = alpha;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<TextureTrackChunk> getTextureTrackChunks() {
        return this._textureTrackChunks;
    }

    public void addTextureTrackChunk(@Nonnull TextureTrackChunk val) {
        this._chunks.add(val);
        this._textureTrackChunks.add(val);
    }

    public List<AlphaTrackChunk> getAlphaTrackChunks() {
        return new ArrayList<AlphaTrackChunk>(this._alphaTrackChunks);
    }

    public void addAlphaTrackChunk(@Nonnull AlphaTrackChunk val) {
        this._chunks.add(val);
        this._alphaTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        stream.writeUInt32(this._filterMode);
        stream.writeUInt32(this._shadingFlags);
        stream.writeUInt32(this._textureId);
        stream.writeUInt32(this._textureAnimId);
        stream.writeUInt32(this._coordId);
        stream.writeFloat32(this._alpha);
        for (TextureTrackChunk textureTrackChunk : this.getTextureTrackChunks()) {
            textureTrackChunk.write(stream);
        }
        for (AlphaTrackChunk alphaTrackChunk : this.getAlphaTrackChunks()) {
            alphaTrackChunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Layer(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSive = stream.readUInt32("inclusiveSize");
        this._filterMode = stream.readUInt32("filterMode");
        this._shadingFlags = stream.readUInt32("shadingFlags");
        this._textureId = stream.readUInt32("texId");
        this._textureAnimId = stream.readUInt32("texAnimId");
        this._coordId = stream.readUInt32("coordId");
        this._alpha = stream.readFloat32("alpha").floatValue();
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(TextureTrackChunk.TOKEN, () -> this.addTextureTrackChunk(new TextureTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(AlphaTrackChunk.TOKEN, () -> this.addAlphaTrackChunk(new AlphaTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public Layer() {
    }

    public static class AlphaTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KMTA");
        private final LinkedHashSet<AlphaTrack> _alphaTracks = new ObservableLinkedHashSet<AlphaTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._alphaTracks;
        }

        public LinkedHashSet<AlphaTrack> getAlphaTracks() {
            return this._alphaTracks;
        }

        public AlphaTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._alphaTracks.add(new AlphaTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AlphaTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AlphaTrack
        extends Track {
            private float _alpha;
            private float _inTan_alpha;
            private float _outTan_alpha;

            public float getAlpha() {
                return this._alpha;
            }

            public void setAlpha(float alpha) {
                this._alpha = alpha;
            }

            public float getInTanAlpha() {
                return this._inTan_alpha;
            }

            public void setInTanAlpha(float alpha) {
                this._inTan_alpha = alpha;
            }

            public float getOutTanAlpha() {
                return this._outTan_alpha;
            }

            public void setOutTanAlpha(float alpha) {
                this._outTan_alpha = alpha;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._alpha = stream.readFloat32("alpha").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_alpha = stream.readFloat32("inTan_alpha").floatValue();
                    this._outTan_alpha = stream.readFloat32("outTan_alpha").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._alpha);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_alpha);
                    stream.writeFloat32(this._outTan_alpha);
                }
            }

            public AlphaTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class TextureTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KMTF");
        private final LinkedHashSet<TextureTrack> _textureTracks = new ObservableLinkedHashSet<TextureTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._textureTracks;
        }

        public LinkedHashSet<TextureTrack> getTextureTracks() {
            return this._textureTracks;
        }

        public TextureTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._textureTracks.add(new TextureTrack(stream, this.getInterpolationType(), format));
            }
        }

        public TextureTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class TextureTrack
        extends Track {
            private long _textureId;
            private long _inTan_textureId;
            private long _outTan_textureId;

            public long getTextureId() {
                return this._textureId;
            }

            public void setTextureId(long textureId) {
                this._textureId = textureId;
            }

            public long getInTanTextureId() {
                return this._inTan_textureId;
            }

            public void setInTanTextureId(long textureId) {
                this._inTan_textureId = textureId;
            }

            public long getOutTanTextureId() {
                return this._outTan_textureId;
            }

            public void setOutTanTextureId(long textureId) {
                this._outTan_textureId = textureId;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._textureId = stream.readUInt32("textureId");
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_textureId = stream.readUInt32("inTan_textureId");
                    this._outTan_textureId = stream.readUInt32("outTan_textureId");
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeUInt32(this._textureId);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeUInt32(this._inTan_textureId);
                    stream.writeUInt32(this._outTan_textureId);
                }
            }

            public TextureTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static enum ShadingFlag {
        UNSHADED(1),
        SPHERE_ENV_MAP(2),
        UNKNOWN_A(4),
        UNKNOWN_B(8),
        TWO_SIDED(16),
        UNFOGGED(32),
        NO_DEPTH_TEST(64),
        NO_DEPTH_SET(128);

        private int _index;

        public int getIndex() {
            return this._index;
        }

        private ShadingFlag(int index) {
            this._index = index;
        }
    }

    public static enum FilterMode {
        NONE(0),
        TRANSPARENT(1),
        BLEND(2),
        ADDITIVE(3),
        ADD_ALPHA(4),
        MODULATE(5),
        MODULATE_2X(6);


        private FilterMode(int index) {
        }
    }
}

