/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Face;

public class FaceChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("PVTX");
    private final LinkedHashSet<Face> _faces = new ObservableLinkedHashSet<Face>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public LinkedHashSet<Face> getFaces() {
        return this._faces;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this._faces.size());
        for (Face face : this._faces) {
            face.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public FaceChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        for (long facesCount = stream.readUInt32("facesCount").longValue(); facesCount > 0L; --facesCount) {
            this._faces.add(new Face(stream));
        }
    }

    public FaceChunk() {
    }
}

