/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;

public abstract class Chunk
extends MDXObject {
    public abstract Id getToken();

    public class Header {
        private long _size = 0L;
        private long _sizePos = 0L;
        private long _afterPos = 0L;
        private Wc3BinOutputStream _stream;

        public long getSize() {
            return this._size;
        }

        public void write_0x0(@Nonnull Wc3BinOutputStream stream) {
            this._stream = stream;
            this._stream.writeId(Chunk.this.getToken());
            this._sizePos = this._stream.getPos();
            this._stream.writeUInt32(this._size);
            this._afterPos = this._stream.getPos();
        }

        public void rewrite() {
            long endPos = this._stream.getPos();
            this._stream.setPos(this._sizePos);
            this._stream.writeUInt32(endPos - this._afterPos);
            this._stream.setPos(endPos);
        }

        public void write(@Nonnull Wc3BinOutputStream stream) {
            this.write_0x0(stream);
        }

        public void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            Id header_token = stream.readId("header_token");
            if (!header_token.equals(Chunk.this.getToken())) {
                throw new IllegalArgumentException("invalid " + Chunk.this.getToken() + " startToken (" + header_token + ")");
            }
            this._size = stream.readUInt32("header_size");
        }

        public Header(Wc3BinInputStream stream) throws BinStream.StreamException {
            this();
            this.read_0x0(stream);
        }

        public Header() {
        }
    }
}

