/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ADPCM {
    private static final byte INITIAL_ADPCM_STEP_INDEX = 44;
    private static final byte[] CHANGE_TABLE = new byte[]{-1, 0, -1, 4, -1, 2, -1, 6, -1, 1, -1, 5, -1, 3, -1, 7, -1, 1, -1, 5, -1, 3, -1, 7, -1, 2, -1, 4, -1, 6, -1, 8};
    private static final short[] STEP_TABLE = new short[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    private final Channel[] state;

    public ADPCM(int channelmax) {
        this.state = new Channel[channelmax];
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = new Channel();
        }
    }

    public void decompress(ByteBuffer in, ByteBuffer out, int channeln) {
        in.order(ByteOrder.LITTLE_ENDIAN);
        out.order(ByteOrder.LITTLE_ENDIAN);
        byte stepshift = (byte)(in.getShort() >>> 8);
        for (int i = 0; i < channeln; ++i) {
            Channel chan = this.state[i];
            chan.stepIndex = (byte)44;
            chan.sampleValue = in.getShort();
            out.putShort(chan.sampleValue);
        }
        int current = 0;
        block6: while (in.hasRemaining()) {
            byte op = in.get();
            Channel chan = this.state[current];
            if ((op & 0x80) != 0) {
                switch (op & 0x7F) {
                    case 0: {
                        if (chan.stepIndex != 0) {
                            chan.stepIndex = (byte)(chan.stepIndex - 1);
                        }
                        out.putShort(chan.sampleValue);
                        current = (current + 1) % channeln;
                        continue block6;
                    }
                    case 1: {
                        chan.stepIndex = (byte)(chan.stepIndex + 8);
                        if (chan.stepIndex < STEP_TABLE.length) continue block6;
                        chan.stepIndex = (byte)(STEP_TABLE.length - 1);
                        continue block6;
                    }
                    case 2: {
                        current = (current + 1) % channeln;
                        continue block6;
                    }
                }
                chan.stepIndex = (byte)(chan.stepIndex - 8);
                if (chan.stepIndex >= 0) continue;
                chan.stepIndex = 0;
                continue;
            }
            short stepbase = STEP_TABLE[chan.stepIndex];
            short step = (short)(stepbase >>> stepshift);
            for (int i = 0; i < 6; ++i) {
                if ((op & 0xFF & 1 << i) == 0) continue;
                step = (short)(step + (stepbase >> i));
            }
            chan.sampleValue = (op & 0x40) != 0 ? (short)Math.max(chan.sampleValue - step, Short.MIN_VALUE) : (short)Math.min(chan.sampleValue + step, Short.MAX_VALUE);
            out.putShort(chan.sampleValue);
            chan.stepIndex = (byte)(chan.stepIndex + CHANGE_TABLE[op & 0x1F]);
            if (chan.stepIndex < 0) {
                chan.stepIndex = 0;
            } else if (chan.stepIndex >= STEP_TABLE.length) {
                chan.stepIndex = (byte)(STEP_TABLE.length - 1);
            }
            current = (current + 1) % channeln;
        }
    }

    private static class Channel {
        public short sampleValue;
        public byte stepIndex;

        private Channel() {
        }
    }
}

