/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\f\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u001e\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u001e\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJF\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$J\u0016\u0010\"\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006,"}, d2={"Ldorkbox/util/MathUtil;", "", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "clamp", "", "value", "min", "max", "", "", "", "intersectRange", "", "ax1", "ax2", "bx1", "bx2", "intersectRect", "x1", "y1", "w1", "h1", "x2", "y2", "w2", "h2", "isEven", "isInteger", "string", "isLong", "isNumber", "character", "", "sizeLimit", "isPowerOfTwo", "nextPowerOfTwo", "numberOfDigits", "number", "stripTrailingNonDigits", "text", "Utilities"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();

    private MathUtil() {
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    public final boolean isInteger(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.isNumber(string, 10L);
    }

    public final boolean isLong(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.isNumber(string, 19L);
    }

    public final boolean isNumber(char character) {
        return Intrinsics.compare((int)character, (int)48) >= 0 && Intrinsics.compare((int)character, (int)57) <= 0;
    }

    public final boolean isNumber(@NotNull String string, long sizeLimit) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (sizeLimit <= 0L) {
            return false;
        }
        int length = string.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (string.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        if ((long)(length - i) > sizeLimit) {
            return false;
        }
        while (i < length) {
            char c = string.charAt(i);
            if (Intrinsics.compare((int)c, (int)48) < 0 || Intrinsics.compare((int)c, (int)57) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final int numberOfDigits(long number) {
        long number2 = number;
        if (number2 < 0L) {
            number2 = -number2;
        }
        return number2 < 10000L ? (number2 < 100L ? (number2 < 10L ? 1 : 2) : (number2 < 1000L ? 3 : 4)) : (number2 < 1000000000000L ? (number2 < 100000000L ? (number2 < 1000000L ? (number2 < 100000L ? 5 : 6) : (number2 < 10000000L ? 7 : 8)) : (number2 < 10000000000L ? (number2 < 1000000000L ? 9 : 10) : (number2 < 100000000000L ? 11 : 12))) : (number2 < 10000000000000000L ? (number2 < 100000000000000L ? (number2 < 10000000000000L ? 13 : 14) : (number2 < 1000000000000000L ? 15 : 16)) : (number2 < 1000000000000000000L ? (number2 < 100000000000000000L ? 17 : 18) : 19)));
    }

    public final int stripTrailingNonDigits(@NotNull String text) {
        int numberIndex;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return 0;
        }
        int length = text.length();
        for (numberIndex = 0; numberIndex < length && Character.isDigit(text.charAt(numberIndex)); ++numberIndex) {
        }
        String string = text.substring(0, numberIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String substring = string;
        try {
            return Integer.parseInt(substring);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public final boolean isEven(int value) {
        return (value & 1) == 0;
    }

    public final int nextPowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public final boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public final boolean intersectRect(double x1, double y1, double w1, double h1, double x2, double y2, double w2, double h2) {
        return this.intersectRange(x1, x1 + w1, x2, x2 + w2) && this.intersectRange(y1, y1 + h1, y2, y2 + h2);
    }

    public final boolean intersectRange(double ax1, double ax2, double bx1, double bx2) {
        return Math.max(ax1, bx1) <= Math.min(ax2, bx2);
    }

    public final int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public final long clamp(long value, long min, long max) {
        return Math.max(min, Math.min(max, value));
    }

    public final float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public final double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }
}

