/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.compression;

import java.nio.ByteBuffer;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.compression.ADPCM;
import systems.crigges.jmpq3.compression.Exploder;
import systems.crigges.jmpq3.compression.Huffman;
import systems.crigges.jmpq3.compression.JzLibHelper;
import systems.crigges.jmpq3.compression.RecompressOptions;
import systems.crigges.jmpq3.compression.ZopfliHelper;

public class CompressionUtil {
    private static ADPCM ADPCM;
    private static Huffman huffman;
    private static ZopfliHelper zopfli;
    private static final byte FLAG_HUFFMAN = 1;
    public static final byte FLAG_DEFLATE = 2;
    private static final byte FLAG_IMPLODE = 8;
    private static final byte FLAG_BZIP2 = 16;
    private static final byte FLAG_SPARSE = 32;
    private static final byte FLAG_ADPCM1C = 64;
    private static final byte FLAG_ADPCM2C = -128;
    private static final byte FLAG_LMZA = 18;

    public static byte[] compress(byte[] temp, RecompressOptions recompress) {
        if (recompress.recompress && recompress.useZopfli && zopfli == null) {
            zopfli = new ZopfliHelper();
        }
        return recompress.useZopfli ? zopfli.deflate(temp, recompress.iterations) : JzLibHelper.deflate(temp, recompress.recompress);
    }

    public static byte[] decompress(byte[] sector, int compressedSize, int uncompressedSize) throws JMpqException {
        ByteBuffer newOut;
        boolean isHuffmanCompressed;
        if (compressedSize == uncompressedSize) {
            return sector;
        }
        byte compressionType = sector[0];
        ByteBuffer out = ByteBuffer.wrap(new byte[uncompressedSize]);
        ByteBuffer in = ByteBuffer.wrap(sector);
        in.position(1);
        boolean flip = false;
        boolean isLZMACompressed = (compressionType & 0x12) != 0;
        boolean isBzip2Compressed = (compressionType & 0x10) != 0;
        boolean isImploded = (compressionType & 8) != 0;
        boolean isSparseCompressed = (compressionType & 0x20) != 0;
        boolean isDeflated = (compressionType & 2) != 0;
        boolean bl = isHuffmanCompressed = (compressionType & 1) != 0;
        if (isDeflated) {
            out.put(JzLibHelper.inflate(sector, 1, uncompressedSize));
            out.position(0);
            flip = !flip;
        } else {
            if (isLZMACompressed) {
                throw new JMpqException("Unsupported compression LZMA");
            }
            if (isBzip2Compressed) {
                throw new JMpqException("Unsupported compression Bzip2");
            }
            if (isImploded) {
                byte[] output = new byte[uncompressedSize];
                Exploder.pkexplode(sector, output, 1);
                out.put(output);
                out.position(0);
                boolean bl2 = flip = !flip;
            }
        }
        if (isSparseCompressed) {
            throw new JMpqException("Unsupported compression sparse");
        }
        if (isHuffmanCompressed) {
            if (huffman == null) {
                huffman = new Huffman();
            }
            (flip ? in : out).clear();
            huffman.Decompress(flip ? out : in, flip ? in : out);
            out.limit(out.position());
            in.position(0);
            out.position(0);
            boolean bl3 = flip = !flip;
        }
        if ((compressionType & 0xFFFFFF80) != 0) {
            if (ADPCM == null) {
                ADPCM = new ADPCM(2);
            }
            newOut = ByteBuffer.wrap(new byte[uncompressedSize]);
            ADPCM.decompress(flip ? out : in, newOut, 2);
            (flip ? out : in).position(0);
            return newOut.array();
        }
        if ((compressionType & 0x40) != 0) {
            if (ADPCM == null) {
                ADPCM = new ADPCM(2);
            }
            newOut = ByteBuffer.wrap(new byte[uncompressedSize]);
            ADPCM.decompress(flip ? out : in, newOut, 1);
            (flip ? out : in).position(0);
            return newOut.array();
        }
        return (flip ? out : in).array();
    }

    public static byte[] explode(byte[] sector, int compressedSize, int uncompressedSize) throws JMpqException {
        if (compressedSize == uncompressedSize) {
            return sector;
        }
        ByteBuffer out = ByteBuffer.wrap(new byte[uncompressedSize]);
        byte[] output = new byte[uncompressedSize];
        Exploder.pkexplode(sector, output, 0);
        out.put(output);
        out.position(0);
        return out.array();
    }
}

