/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Printable;
import net.moonlightflower.wc3libs.misc.Printer;
import net.moonlightflower.wc3libs.misc.Translator;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.txt.TXTSectionId;
import net.moonlightflower.wc3libs.txt.TXTState;
import net.moonlightflower.wc3libs.txt.UTF8;

public class TXT
implements Printable {
    private final Section _defaultSection = new Section((TXTSectionId)null);
    private final Map<TXTSectionId, Section> _sections = new LinkedHashMap<TXTSectionId, Section>();

    @Override
    public void print(@Nonnull Printer printer) {
        this.getDefaultSection().print(printer);
        for (Section section : this.getSections().values()) {
            if (section.getId() != null) {
                printer.beginGroup(String.format("[%s]", section.getId()));
            }
            section.print(printer);
            if (section.getId() == null) continue;
            printer.endGroup();
        }
    }

    @Nonnull
    public Map<TXTSectionId, Section> getSections() {
        return this._sections;
    }

    public Section getDefaultSection() {
        return this._defaultSection;
    }

    public Section getSection(@Nonnull TXTSectionId id) {
        return this.getSections().get(id);
    }

    protected void addSection(@Nonnull Section val) {
        this._sections.put(val.getId(), val);
    }

    public Section addSection(@Nonnull TXTSectionId id) {
        if (this._sections.containsKey(id)) {
            return this.getSection(id);
        }
        Section section = new Section(id);
        this.addSection(section);
        return section;
    }

    public boolean containsKey(@Nonnull FieldId key) {
        if (this._defaultSection.containsField(key)) {
            return true;
        }
        for (Section section : this.getSections().values()) {
            if (!section.containsField(key)) continue;
            return true;
        }
        return false;
    }

    public DataType get(@Nonnull FieldId key) throws Section.FieldDoesNotExistException {
        if (this._defaultSection.containsField(key)) {
            return this._defaultSection.get(key);
        }
        for (Section section : this.getSections().values()) {
            if (!section.containsField(key)) continue;
            return section.get(key);
        }
        return null;
    }

    public void set(@Nonnull FieldId key, @Nullable DataType val) {
        this._defaultSection.addField(key).set(val);
    }

    public void merge(@Nonnull TXT other, boolean overwrite) {
        this._defaultSection.merge(other._defaultSection, overwrite);
        for (Map.Entry<TXTSectionId, Section> entry : other.getSections().entrySet()) {
            TXTSectionId sectionId = entry.getKey();
            Section otherSection = entry.getValue();
            Section section = this.addSection(sectionId);
            section.merge(otherSection, overwrite);
        }
    }

    public void merge(@Nonnull TXT other) {
        this.merge(other, true);
    }

    public void set(@Nonnull Section section, @Nonnull FieldId field, @Nullable DataType val) {
        this.addSection(section);
        section.set(field, val);
    }

    public void set(@Nonnull String section, @Nonnull String field, @Nullable String val) {
        this.set(this.addSection(TXTSectionId.valueOf(section)), FieldId.valueOf(field), War3String.valueOf(val));
    }

    public void set(@Nonnull String field, @Nullable String val) {
        this._defaultSection.set(field, val);
    }

    public void read(@Nonnull InputStream inStream) throws IOException {
        String line;
        Section curSection = this._defaultSection;
        UTF8 reader = new UTF8(inStream);
        while ((line = reader.readLine()) != null) {
            Pattern valPattern;
            Matcher valMatcher;
            String lineTrimmed;
            if ((line = line.replaceAll("//.*", "")).matches("^\\s*$")) continue;
            Pattern sectionPattern = Pattern.compile("^\\[(.+)\\]$");
            Matcher sectionMatcher = sectionPattern.matcher(lineTrimmed = line.replaceAll("\\s", ""));
            if (sectionMatcher.matches()) {
                TXTSectionId sectionId = TXTSectionId.valueOf(sectionMatcher.group(1));
                curSection = this.addSection(sectionId);
            }
            if (!(valMatcher = (valPattern = Pattern.compile("([^=]+)=(.+)")).matcher(line)).matches()) continue;
            curSection.setLine(FieldId.valueOf(valMatcher.group(1)), valMatcher.group(2));
        }
    }

    public void read(@Nonnull File file) throws IOException {
        InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        this.read(inStream);
        inStream.close();
    }

    public void write(@Nonnull BufferedWriter writer, @Nullable Translator translator) throws IOException {
        this._defaultSection.write(writer, translator);
        for (Section section : this.getSections().values()) {
            section.write(writer, translator);
        }
    }

    public void write(@Nonnull OutputStream outStream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outStream));
        this.write(writer, null);
        writer.close();
    }

    public void write(@Nonnull File file, @Nullable Translator translator) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)Orient.createFileOutputStream(file), StandardCharsets.UTF_8));
        this.write(writer, translator);
        writer.close();
    }

    public void write(@Nonnull File file) throws IOException {
        this.write(file, null);
    }

    public TXT(@Nonnull File file) throws IOException {
        this.read(file);
    }

    public TXT() {
    }

    public TXT(@Nonnull InputStream inStream) throws IOException {
        this.read(inStream);
    }

    @Nonnull
    public static TXT ofGameFile(@Nonnull File inFile) throws Exception {
        MpqPort.Out.Result portResult = new JMpqPort().getGameFiles(inFile);
        if (!portResult.getExports().containsKey(inFile)) {
            throw new IOException(String.format("could not extract %s file", inFile.toString()));
        }
        byte[] bytes = portResult.getExports().get(inFile).getOutBytes();
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        TXT txt = new TXT(inStream);
        ((InputStream)inStream).close();
        return txt;
    }

    public static class Section
    implements Printable {
        protected final Map<FieldId, Field> _fields = new LinkedHashMap<FieldId, Field>();
        protected final Map<FieldId, Field> _fieldsLower = new LinkedHashMap<FieldId, Field>();
        private final TXTSectionId _id;

        @Override
        public void print(@Nonnull Printer printer) {
            if (this.getId() != null) {
                printer.print(this.getId().toString());
            }
            for (Field field : this.getFields().values()) {
                printer.beginGroup(field);
                field.print(printer);
                printer.endGroup();
            }
        }

        @Nonnull
        public Map<FieldId, ? extends Field> getFields() {
            return new LinkedHashMap<FieldId, Field>(this._fields);
        }

        @Nullable
        public Field getField(@Nonnull FieldId fieldId) throws FieldDoesNotExistException {
            return this._fieldsLower.get(fieldId.lower());
        }

        public boolean containsField(@Nonnull FieldId fieldId) {
            return this._fieldsLower.containsKey(fieldId.lower());
        }

        public void removeField(@Nonnull FieldId fieldId) {
            this._fields.remove(fieldId.lower());
            this._fieldsLower.remove(fieldId.lower());
        }

        public DataType get(@Nonnull FieldId fieldId, int index) throws FieldDoesNotExistException {
            Field field = this.getField(fieldId);
            if (field == null) {
                throw new FieldDoesNotExistException(fieldId);
            }
            return field.get(index);
        }

        public DataType get(@Nonnull FieldId fieldId) throws FieldDoesNotExistException {
            return this.get(fieldId, 0);
        }

        protected void addField(@Nonnull Field field) {
            this._fields.put(field.getId(), field);
            this._fieldsLower.put(field.getId().lower(), field);
        }

        public Field addField(@Nonnull FieldId fieldId) {
            if (this.containsField(fieldId)) {
                try {
                    return this.getField(fieldId);
                }
                catch (FieldDoesNotExistException fieldDoesNotExistException) {
                    // empty catch block
                }
            }
            Field field = new Field(fieldId);
            this.addField(field);
            return field;
        }

        public void set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            String fieldIdString = fieldId.toString();
            if (fieldIdString.startsWith("//")) {
                return;
            }
            this.addField(fieldId).set(val);
        }

        public void set(@Nonnull String key, @Nullable String val) {
            this.set(FieldId.valueOf(key), War3String.valueOf(val));
        }

        public <T extends DataType> void set(@Nonnull TXTState<T> state, T val) {
            this.set((FieldId)state.getFieldId(), (DataType)val);
        }

        public void setLine(@Nonnull FieldId fieldId, @Nonnull String val) {
            String fieldIdString = fieldId.toString();
            if (fieldIdString.startsWith("//")) {
                return;
            }
            this.addField(fieldId).setLine(val);
        }

        public void merge(@Nonnull Section otherSection, boolean overwrite) {
            for (Map.Entry<FieldId, ? extends Field> entry : otherSection.getFields().entrySet()) {
                FieldId fieldId = entry.getKey();
                Field otherField = entry.getValue();
                Field field = this.addField(fieldId);
                field.merge(otherField, overwrite);
            }
        }

        public void print(@Nonnull PrintStream outStream) {
            for (Map.Entry<FieldId, ? extends Field> fieldEntry : this.getFields().entrySet()) {
                FieldId fieldId = fieldEntry.getKey();
                Field field = fieldEntry.getValue();
                outStream.print(String.format("\t%s: ", fieldId.toString()));
                int c = 0;
                for (DataType val : field.getVals()) {
                    outStream.print(val);
                    if (c > 0) {
                        outStream.print("; ");
                    }
                    ++c;
                }
                outStream.println();
            }
        }

        public void print() {
            this.print(System.out);
        }

        @Nullable
        public TXTSectionId getId() {
            return this._id;
        }

        public void write(@Nonnull BufferedWriter writer, @Nullable Translator translator) throws IOException {
            if (this.getId() != null) {
                writer.write(String.format("[%s]", this.getId().toString()));
                writer.newLine();
            }
            for (Map.Entry<FieldId, ? extends Field> fieldEntry : this.getFields().entrySet()) {
                FieldId fieldId = fieldEntry.getKey();
                Field field = fieldEntry.getValue();
                String valLine = field.getValLine(translator);
                writer.write(String.format("%s=%s", fieldId.toString(), valLine));
                writer.newLine();
            }
        }

        public Section(@Nullable TXTSectionId id) {
            this._id = id;
        }

        public Section(@Nonnull String name) {
            this(TXTSectionId.valueOf(name));
        }

        public static class FieldDoesNotExistException
        extends Exception {
            public FieldDoesNotExistException(@Nonnull FieldId fieldId) {
                super(fieldId.toString());
            }
        }

        public static class Field
        implements Printable {
            private final List<DataType> _vals = new ArrayList<DataType>();
            private final FieldId _id;

            @Nonnull
            public List<DataType> getVals() {
                return this._vals;
            }

            @Nonnull
            public String getValLine(@Nullable Translator translator) {
                StringBuilder s = new StringBuilder();
                int c = 0;
                for (DataType val : this.getVals()) {
                    Object valS;
                    if (c > 0) {
                        s.append(",");
                    }
                    Object object = valS = val == null ? null : val.toTXTVal().toString();
                    if (valS != null) {
                        if (translator != null) {
                            valS = translator.translate((String)valS);
                        }
                        if (((String)valS).length() == 0 || ((String)valS).contains(",") || ((String)valS).contains(";")) {
                            valS = "\"" + (String)valS + "\"";
                        }
                        s.append((String)valS);
                    }
                    ++c;
                }
                return s.toString();
            }

            @Nullable
            public DataType get(int index) {
                return this._vals.get(index);
            }

            @Nullable
            public DataType get() {
                return this.get(0);
            }

            public void clear() {
                this._vals.clear();
            }

            public void ensureSize(int size) {
                while (this._vals.size() < size) {
                    this._vals.add(null);
                }
            }

            public void set(@Nullable DataType val, int index) {
                this.ensureSize(index + 1);
                this._vals.set(index, val);
            }

            public void set(@Nullable DataType val) {
                this.clear();
                this.set(val, 0);
            }

            @Nullable
            private static String dequote(@Nullable String s) {
                if (s == null) {
                    return null;
                }
                Pattern pattern = Pattern.compile("^\"(.*)\"$");
                Matcher matcher = pattern.matcher(s);
                if (matcher.find()) {
                    s = matcher.group(1);
                }
                return s;
            }

            @Nonnull
            public static List<String> tokenize(@Nonnull String line) {
                if (line.length() == 0) {
                    return new ArrayList<String>();
                }
                ArrayList<String> ret = new ArrayList<String>();
                int startPos = 0;
                while (startPos < line.length()) {
                    String val;
                    int endPos;
                    if (line.charAt(startPos) == '\"') {
                        endPos = line.indexOf(34, startPos + 1);
                        if (endPos == -1) {
                            endPos = line.length() - 1;
                        }
                        val = line.substring(startPos, endPos + 1);
                        val = Field.dequote(val);
                        ret.add(val);
                        startPos = endPos + 1;
                        continue;
                    }
                    if (line.charAt(startPos) == ',' && startPos > 0 && line.charAt(startPos - 1) == '\"') {
                        ++startPos;
                        continue;
                    }
                    endPos = line.indexOf(44, startPos);
                    endPos = endPos == -1 ? line.length() - 1 : --endPos;
                    val = endPos < startPos ? "" : line.substring(startPos, endPos + 1);
                    ret.add(val);
                    startPos = endPos + 2;
                }
                return ret;
            }

            public void setLine(@Nonnull String line) {
                this.clear();
                List<String> tokenize = Field.tokenize(line);
                for (String val : tokenize) {
                    this._vals.add(War3String.valueOf(val));
                }
            }

            public void add(@Nullable DataType val) {
                this._vals.add(val);
            }

            public void merge(@Nonnull Field otherField, boolean overwrite) {
                if (overwrite) {
                    if (this.getId().lower().equals(FieldId.valueOf("buttonpos"))) {
                        ArrayList<DataType> otherVals = new ArrayList<DataType>(otherField.getVals());
                        this.ensureSize(otherVals.size());
                        for (int i = 0; i < otherVals.size(); ++i) {
                            if (otherVals.get(i) == null) continue;
                            this._vals.set(i, (DataType)otherVals.get(i));
                        }
                    } else {
                        this._vals.clear();
                        this._vals.addAll(otherField.getVals());
                    }
                } else {
                    for (DataType val : otherField.getVals()) {
                        this.add(val);
                    }
                }
            }

            public void merge(@Nonnull Field otherField) {
                this.merge(otherField, true);
            }

            @Nonnull
            public FieldId getId() {
                return this._id;
            }

            @Nonnull
            public String toString() {
                return this._id.toString();
            }

            public Field(@Nonnull FieldId id) {
                this._id = id;
            }

            @Override
            public void print(@Nonnull Printer printer) {
                printer.print(this.getId() + ": " + this.getValLine(null));
            }
        }
    }
}

