/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port.win;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.GameExeFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;

public class WinTelemetryGameVersionFinder
extends GameVersionFinder {
    private static final byte[] KEY = new byte[]{84, 101, 108, 101, 109, 101, 116, 114, 121, 46, 80, 114, 111, 103, 114, 97, 109, 86, 101, 114, 115, 105, 111, 110, 61};

    @Nonnull
    private GameVersion getVersion(@Nonnull File file) throws IOException {
        FileChannel ch1 = new RandomAccessFile(file, "r").getChannel();
        long size = ch1.size();
        MappedByteBuffer m1 = ch1.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        byte[] buffer = new byte[KEY.length];
        ByteBuffer verBuffer = ByteBuffer.allocate(15);
        int pos = 0;
        while ((long)pos < size - (long)KEY.length - 1L) {
            ((ByteBuffer)m1).position(pos);
            m1.get(buffer);
            if (Arrays.equals(buffer, KEY)) {
                byte b = m1.get();
                while (verBuffer.get(verBuffer.position()) != 0 || b != 0) {
                    verBuffer.put(b);
                    b = m1.get();
                }
                String verString = new String(verBuffer.array()).substring(0, verBuffer.position());
                return new GameVersion(verString);
            }
            ++pos;
        }
        throw new IOException("telemetry data could not be extracted");
    }

    @Override
    @Nonnull
    public GameVersion find() throws NotFoundException {
        GameExeFinder gameExeFinder = Context.getService(GameExeFinder.class);
        try {
            File gameExeFile = (File)gameExeFinder.get();
            return this.getVersion(gameExeFile);
        }
        catch (Exception e) {
            throw new NotFoundException(e);
        }
    }
}

