/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VertexGroup;

public class VertexGroupChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("GNDX");
    private final LinkedHashSet<VertexGroup> _vertexGroups = new ObservableLinkedHashSet<VertexGroup>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public LinkedHashSet<VertexGroup> getVertexGroups() {
        return this._vertexGroups;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this.getVertexGroups().size());
        for (VertexGroup vertexGroup : this.getVertexGroups()) {
            vertexGroup.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public VertexGroupChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        for (long vertexGroupsCount = stream.readUInt32("vertexGroupsCount").longValue(); vertexGroupsCount > 0L; --vertexGroupsCount) {
            this._vertexGroups.add(new VertexGroup(stream));
        }
    }

    public VertexGroupChunk() {
    }
}

