/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VisibilityTrack;

public class Light
extends MDXObject {
    private long _inclusiveSize = 0L;
    private Node _node;
    private Type _type = Type.OMNI;
    private float _attenuationStart = 0.0f;
    private float _attenuationEnd = 0.0f;
    private Color _color;
    private float _intensity = 0.0f;
    private Color _ambientColor;
    private float _ambientIntensity;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<AttenuationStartTrackChunk> _attenuationStartTrackChunks = new ObservableLinkedHashSet<AttenuationStartTrackChunk>();
    private final LinkedHashSet<AttenuationEndTrackChunk> _attenuationEndTrackChunks = new ObservableLinkedHashSet<AttenuationEndTrackChunk>();
    private final LinkedHashSet<ColorTrackChunk> _colorTrackChunks = new ObservableLinkedHashSet<ColorTrackChunk>();
    private final LinkedHashSet<IntensityTrackChunk> _intensityTrackChunks = new ObservableLinkedHashSet<IntensityTrackChunk>();
    private final LinkedHashSet<AmbientIntensityTrackChunk> _ambientIntensityTrackChunks = new ObservableLinkedHashSet<AmbientIntensityTrackChunk>();
    private final LinkedHashSet<AmbientColorTrackChunk> _ambientColorTrackChunks = new ObservableLinkedHashSet<AmbientColorTrackChunk>();
    private final LinkedHashSet<VisibilityTrackChunk> _visibilityTrackChunks = new ObservableLinkedHashSet<VisibilityTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public Node getNode() {
        return this._node;
    }

    public void setNode(@Nonnull Node node) {
        this._node = node;
    }

    @Nonnull
    public Type getType() {
        return this._type;
    }

    public void setType(@Nonnull Type type) {
        this._type = type;
    }

    public float getAttenuationStart() {
        return this._attenuationStart;
    }

    public void setAttenuationStart(float attenuationStart) {
        this._attenuationStart = attenuationStart;
    }

    public float getAttenuationEnd() {
        return this._attenuationEnd;
    }

    public void setAttenuationEnd(float attenuationEnd) {
        this._attenuationEnd = attenuationEnd;
    }

    @Nonnull
    public Color getColor() {
        return this._color;
    }

    public void setColor(@Nonnull Color color) {
        this._color = color;
    }

    public float getIntensity() {
        return this._intensity;
    }

    public void setIntensity(float intensity) {
        this._intensity = intensity;
    }

    @Nonnull
    public Color getAmbientColor() {
        return this._ambientColor;
    }

    public void setAmbientColor(@Nonnull Color ambientColor) {
        this._ambientColor = ambientColor;
    }

    public float getAmbientIntensity() {
        return this._ambientIntensity;
    }

    public void setAmbientIntensity(float ambientIntensity) {
        this._ambientIntensity = ambientIntensity;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<AttenuationStartTrackChunk> getAttenuationStartTrackChunks() {
        return this._attenuationStartTrackChunks;
    }

    public void addAttenuationStartTrackChunk(@Nonnull AttenuationStartTrackChunk val) {
        this._chunks.add(val);
        this._attenuationStartTrackChunks.add(val);
    }

    public LinkedHashSet<AttenuationEndTrackChunk> getAttenuationEndTrackChunks() {
        return this._attenuationEndTrackChunks;
    }

    public void addAttenuationEndTrackChunk(@Nonnull AttenuationEndTrackChunk val) {
        this._chunks.add(val);
        this._attenuationEndTrackChunks.add(val);
    }

    public LinkedHashSet<ColorTrackChunk> getColorTrackChunks() {
        return this._colorTrackChunks;
    }

    public void addColorTrackChunk(@Nonnull ColorTrackChunk val) {
        this._chunks.add(val);
        this._colorTrackChunks.add(val);
    }

    public LinkedHashSet<IntensityTrackChunk> getIntensityTrackChunks() {
        return this._intensityTrackChunks;
    }

    public void addIntensityTrackChunk(@Nonnull IntensityTrackChunk val) {
        this._chunks.add(val);
        this._intensityTrackChunks.add(val);
    }

    public LinkedHashSet<AmbientIntensityTrackChunk> getAmbientIntensityTrackChunks() {
        return this._ambientIntensityTrackChunks;
    }

    public void addAmbientIntensityTrackChunk(@Nonnull AmbientIntensityTrackChunk val) {
        this._chunks.add(val);
        this._ambientIntensityTrackChunks.add(val);
    }

    public LinkedHashSet<AmbientColorTrackChunk> getAmbientColorTrackChunks() {
        return this._ambientColorTrackChunks;
    }

    public void addAmbientColorTrackChunk(@Nonnull AmbientColorTrackChunk val) {
        this._chunks.add(val);
        this._ambientColorTrackChunks.add(val);
    }

    public LinkedHashSet<VisibilityTrackChunk> getVisibilityTrackChunks() {
        return this._visibilityTrackChunks;
    }

    public void addVisibilityTrackChunk(@Nonnull VisibilityTrackChunk val) {
        this._chunks.add(val);
        this._visibilityTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        this._node.write(stream);
        stream.writeUInt32(this._type.ordinal());
        stream.writeFloat32(this._attenuationStart);
        stream.writeFloat32(this._attenuationEnd);
        stream.writeFloat32(this._color.getBlue255());
        stream.writeFloat32(this._color.getGreen255());
        stream.writeFloat32(this._color.getRed255());
        stream.writeFloat32(this._intensity);
        stream.writeFloat32(this._ambientColor.getBlue255());
        stream.writeFloat32(this._ambientColor.getGreen255());
        stream.writeFloat32(this._ambientColor.getRed255());
        stream.writeFloat32(this._ambientIntensity);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Light(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._node = new Node(stream);
        long typeL = stream.readUInt32("type");
        if (typeL >= (long)Type.values().length) {
            throw new IllegalArgumentException("type out of bounds 0-" + Type.values().length + " (" + typeL + ")");
        }
        this._type = Type.values()[(int)typeL];
        this._attenuationStart = stream.readFloat32("attenuationStart").floatValue();
        this._attenuationEnd = stream.readFloat32("attenuationEnd").floatValue();
        this._color = Color.fromBGR255((int)(stream.readFloat32("color_blue").floatValue() * 255.0f), (int)(stream.readFloat32("color_green").floatValue() * 255.0f), (int)(stream.readFloat32("color_red").floatValue() * 255.0f));
        this._intensity = stream.readFloat32("intensity").floatValue();
        this._ambientColor = Color.fromBGR255((int)(stream.readFloat32("ambientColor_blue").floatValue() * 255.0f), (int)(stream.readFloat32("ambientColor_green").floatValue() * 255.0f), (int)(stream.readFloat32("ambientColor_red").floatValue() * 255.0f));
        this._ambientIntensity = stream.readFloat32("ambientIntensity").floatValue();
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(AttenuationStartTrackChunk.TOKEN, () -> this.addAttenuationStartTrackChunk(new AttenuationStartTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(AttenuationEndTrackChunk.TOKEN, () -> this.addAttenuationEndTrackChunk(new AttenuationEndTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(ColorTrackChunk.TOKEN, () -> this.addColorTrackChunk(new ColorTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(IntensityTrackChunk.TOKEN, () -> this.addIntensityTrackChunk(new IntensityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(AmbientIntensityTrackChunk.TOKEN, () -> this.addAmbientIntensityTrackChunk(new AmbientIntensityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(AmbientColorTrackChunk.TOKEN, () -> this.addAmbientColorTrackChunk(new AmbientColorTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(VisibilityTrackChunk.TOKEN, () -> this.addVisibilityTrackChunk(new VisibilityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public Light() {
        this._color = Color.fromBGRA255(0, 0, 0, 0);
        this._ambientColor = Color.fromBGRA255(0, 0, 0, 0);
    }

    public static class VisibilityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLAV");
        private final LinkedHashSet<VisibilityTrack> _visibilityTracks = new ObservableLinkedHashSet<VisibilityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._visibilityTracks;
        }

        public LinkedHashSet<VisibilityTrack> getVisibilityTracks() {
            return this._visibilityTracks;
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._visibilityTracks.add(new VisibilityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }
    }

    public static class AmbientColorTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLBC");
        private final LinkedHashSet<AmbientColorTrack> _ambientColorTracks = new ObservableLinkedHashSet<AmbientColorTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._ambientColorTracks;
        }

        public LinkedHashSet<AmbientColorTrack> getAlphaTracks() {
            return this._ambientColorTracks;
        }

        public AmbientColorTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._ambientColorTracks.add(new AmbientColorTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AmbientColorTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AmbientColorTrack
        extends Track {
            private Color _color;
            private Color _inTan_color;
            private Color _outTan_color;

            @Nonnull
            public Color getColor() {
                return this._color;
            }

            public void setColor(@Nonnull Color color) {
                this._color = color;
            }

            @Nonnull
            public Color getInTanColor() {
                return this._inTan_color;
            }

            public void setInTanColor(@Nonnull Color color) {
                this._inTan_color = color;
            }

            @Nonnull
            public Color getOutTanColor() {
                return this._outTan_color;
            }

            public void setOutTanColor(@Nonnull Color color) {
                this._outTan_color = color;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._color = Color.fromBGR255((int)(stream.readFloat32("colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("colorRed").floatValue() * 255.0f));
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_color = Color.fromBGR255((int)(stream.readFloat32("inTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorRed").floatValue() * 255.0f));
                    this._outTan_color = Color.fromBGR255((int)(stream.readFloat32("outTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorRed").floatValue() * 255.0f));
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32((float)this._color.getBlue255() / 255.0f);
                stream.writeFloat32((float)this._color.getGreen255() / 255.0f);
                stream.writeFloat32((float)this._color.getRed255() / 255.0f);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32((float)this._inTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getRed255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getRed255() / 255.0f);
                }
            }

            public AmbientColorTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class AmbientIntensityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLBI");
        private final LinkedHashSet<AmbientIntensityTrack> _ambientIntensityTracks = new ObservableLinkedHashSet<AmbientIntensityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._ambientIntensityTracks;
        }

        public LinkedHashSet<AmbientIntensityTrack> getAmbientIntensityTracks() {
            return this._ambientIntensityTracks;
        }

        public AmbientIntensityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._ambientIntensityTracks.add(new AmbientIntensityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AmbientIntensityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AmbientIntensityTrack
        extends Track {
            private float _ambientIntensity;
            private float _inTan_ambientIntensity;
            private float _outTan_ambientIntensity;

            public float getAmbientIntensity() {
                return this._ambientIntensity;
            }

            public void setAmbientIntensity(float ambientIntensity) {
                this._ambientIntensity = ambientIntensity;
            }

            public float getInTanAmbientIntensity() {
                return this._inTan_ambientIntensity;
            }

            public void setInTanAmbientIntensity(float ambientIntensity) {
                this._inTan_ambientIntensity = ambientIntensity;
            }

            public float getOutTanAmbientIntensity() {
                return this._outTan_ambientIntensity;
            }

            public void setOutTanAmbientIntensity(float ambientIntensity) {
                this._outTan_ambientIntensity = ambientIntensity;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._ambientIntensity = stream.readFloat32("ambientIntensity").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_ambientIntensity = stream.readFloat32("inTan_ambientIntensity").floatValue();
                    this._outTan_ambientIntensity = stream.readFloat32("outTan_ambientIntensity").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._ambientIntensity);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_ambientIntensity);
                    stream.writeFloat32(this._outTan_ambientIntensity);
                }
            }

            public AmbientIntensityTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class IntensityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLAI");
        private final LinkedHashSet<IntensityTrack> _intensityTracks = new ObservableLinkedHashSet<IntensityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._intensityTracks;
        }

        public LinkedHashSet<IntensityTrack> getIntensityTracks() {
            return this._intensityTracks;
        }

        public IntensityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._intensityTracks.add(new IntensityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public IntensityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class IntensityTrack
        extends Track {
            private float _intensity;
            private float _inTan_intensity;
            private float _outTan_intensity;

            public float getIntensity() {
                return this._intensity;
            }

            public void setIntensity(float intensity) {
                this._intensity = intensity;
            }

            public float getInTanIntensity() {
                return this._inTan_intensity;
            }

            public void setInTanIntensity(float intensity) {
                this._inTan_intensity = intensity;
            }

            public float getOutTanIntensity() {
                return this._outTan_intensity;
            }

            public void setOutTanIntensity(float intensity) {
                this._outTan_intensity = intensity;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._intensity = stream.readFloat32("intensity").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_intensity = stream.readFloat32("inTan_intensity").floatValue();
                    this._outTan_intensity = stream.readFloat32("outTan_intensity").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._intensity);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_intensity);
                    stream.writeFloat32(this._outTan_intensity);
                }
            }

            public IntensityTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class ColorTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLAC");
        private final LinkedHashSet<ColorTrack> _colorTracks = new ObservableLinkedHashSet<ColorTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._colorTracks;
        }

        public LinkedHashSet<ColorTrack> getAlphaTracks() {
            return this._colorTracks;
        }

        public ColorTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._colorTracks.add(new ColorTrack(stream, this.getInterpolationType(), format));
            }
        }

        public ColorTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class ColorTrack
        extends Track {
            private Color _color;
            private Color _inTan_color;
            private Color _outTan_color;

            @Nonnull
            public Color getColor() {
                return this._color;
            }

            public void setColor(@Nonnull Color color) {
                this._color = color;
            }

            @Nonnull
            public Color getInTanColor() {
                return this._inTan_color;
            }

            public void setInTanColor(@Nonnull Color color) {
                this._inTan_color = color;
            }

            @Nonnull
            public Color getOutTanColor() {
                return this._outTan_color;
            }

            public void setOutTanColor(@Nonnull Color color) {
                this._outTan_color = color;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._color = Color.fromBGR255((int)(stream.readFloat32("colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("colorRed").floatValue() * 255.0f));
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_color = Color.fromBGR255((int)(stream.readFloat32("inTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorRed").floatValue() * 255.0f));
                    this._outTan_color = Color.fromBGR255((int)(stream.readFloat32("outTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorRed").floatValue() * 255.0f));
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32((float)this._color.getBlue255() / 255.0f);
                stream.writeFloat32((float)this._color.getGreen255() / 255.0f);
                stream.writeFloat32((float)this._color.getRed255() / 255.0f);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32((float)this._inTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getRed255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getRed255() / 255.0f);
                }
            }

            public ColorTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class AttenuationEndTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLAE");
        private final LinkedHashSet<AttenuationEndTrack> _attenuationEndTracks = new ObservableLinkedHashSet<AttenuationEndTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._attenuationEndTracks;
        }

        public LinkedHashSet<AttenuationEndTrack> getAttenuationEndTracks() {
            return this._attenuationEndTracks;
        }

        public AttenuationEndTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._attenuationEndTracks.add(new AttenuationEndTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AttenuationEndTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AttenuationEndTrack
        extends Track {
            private float _alpha;
            private float _inTan_alpha;
            private float _outTan_alpha;

            public float getAlpha() {
                return this._alpha;
            }

            public void setAlpha(float alpha) {
                this._alpha = alpha;
            }

            public float getInTanAlpha() {
                return this._inTan_alpha;
            }

            public void setInTanAlpha(float alpha) {
                this._inTan_alpha = alpha;
            }

            public float getOutTanAlpha() {
                return this._outTan_alpha;
            }

            public void setOutTanAlpha(float alpha) {
                this._outTan_alpha = alpha;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._alpha = stream.readFloat32("alpha").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_alpha = stream.readFloat32("inTan_alpha").floatValue();
                    this._outTan_alpha = stream.readFloat32("outTan_alpha").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._alpha);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_alpha);
                    stream.writeFloat32(this._outTan_alpha);
                }
            }

            public AttenuationEndTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class AttenuationStartTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KLAS");
        private final LinkedHashSet<AttenuationStartTrack> _attenuationStartTracks = new ObservableLinkedHashSet<AttenuationStartTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._attenuationStartTracks;
        }

        public LinkedHashSet<AttenuationStartTrack> getAttenuationStartTracks() {
            return this._attenuationStartTracks;
        }

        public AttenuationStartTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._attenuationStartTracks.add(new AttenuationStartTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AttenuationStartTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AttenuationStartTrack
        extends Track {
            private float _alpha;
            private float _inTan_alpha;
            private float _outTan_alpha;

            public float getAlpha() {
                return this._alpha;
            }

            public void setAlpha(float alpha) {
                this._alpha = alpha;
            }

            public float getInTanAlpha() {
                return this._inTan_alpha;
            }

            public void setInTanAlpha(float alpha) {
                this._inTan_alpha = alpha;
            }

            public float getOutTanAlpha() {
                return this._outTan_alpha;
            }

            public void setOutTanAlpha(float alpha) {
                this._outTan_alpha = alpha;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._alpha = stream.readFloat32("alpha").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_alpha = stream.readFloat32("inTan_alpha").floatValue();
                    this._outTan_alpha = stream.readFloat32("outTan_alpha").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._alpha);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_alpha);
                    stream.writeFloat32(this._outTan_alpha);
                }
            }

            public AttenuationStartTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static enum Type {
        OMNI,
        DIRECTIONAL,
        AMBIENT;

    }
}

