/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.exeversion;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.moonlightflower.wc3libs.misc.exeversion.CallableInputStreamProcessor;
import net.moonlightflower.wc3libs.misc.exeversion.ExeVersion;
import net.moonlightflower.wc3libs.misc.exeversion.VersionExtractionException;

public class ExeVersionWmic
implements ExeVersion {
    private static final Pattern versionPattern = Pattern.compile("Version=([0-9.]*)");

    public static String getVersion(String exePath) throws VersionExtractionException {
        int exitCode;
        int stdErrLines;
        Process wmic;
        Objects.requireNonNull(exePath);
        String exePathForWmic = exePath.replaceAll("[/\\\\]", "\\\\\\\\");
        ProcessBuilder wmicBuilder = new ProcessBuilder("wmic", "datafile", "where", "name='" + exePathForWmic + "'", "get", "Version", "/value");
        try {
            wmic = wmicBuilder.start();
        }
        catch (IOException e) {
            throw new VersionExtractionException("Failed to start wmic to get version of exe file: " + exePathForWmic, e);
        }
        StringBuilder strErrBuilder = new StringBuilder();
        StringBuilder strOutBuilder = new StringBuilder();
        AtomicReference versionRef = new AtomicReference(Optional.empty());
        CallableInputStreamProcessor stdOutReader = new CallableInputStreamProcessor(wmic.getInputStream(), line -> {
            if (line.length() > 0) {
                strOutBuilder.append((String)line);
                Matcher matcher = versionPattern.matcher((CharSequence)line);
                if (matcher.lookingAt()) {
                    versionRef.set(Optional.of(matcher.group(1)));
                }
            }
        });
        CallableInputStreamProcessor stdErrReader = new CallableInputStreamProcessor(wmic.getErrorStream(), line -> {
            if (line.length() > 0) {
                strErrBuilder.append((String)line);
            }
        });
        ExecutorService es = Executors.newFixedThreadPool(2);
        Future<Integer> stdOutFuture = es.submit(stdOutReader);
        Future<Integer> stdErrFuture = es.submit(stdErrReader);
        while (true) {
            try {
                stdOutFuture.get();
                stdErrLines = stdErrFuture.get();
                exitCode = wmic.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        es.shutdownNow();
        Optional version = versionRef.get();
        if (version.isPresent()) {
            return (String)version.get();
        }
        if (exitCode == 0 && stdErrLines == 0) {
            return "";
        }
        throw new VersionExtractionException(exePathForWmic, exitCode, strOutBuilder.toString(), strErrBuilder.toString());
    }
}

