/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.misc.FieldId;

public abstract class Flag<T extends DataType> {
    private final FieldId _field;
    private final int _pos;
    private static final Map<Class<? extends Flag>, ClassAssignment> _typeValues = new LinkedHashMap<Class<? extends Flag>, ClassAssignment>();

    @Nonnull
    public FieldId getFieldId() {
        return this._field;
    }

    public int getPos() {
        return this._pos;
    }

    public String toString() {
        return this._field.toString();
    }

    private static void initializeClass(Class c) {
        try {
            Class superClass;
            Class.forName(c.getName(), true, c.getClassLoader());
            Class<?> enclosingClass = c.getEnclosingClass();
            if (enclosingClass != null) {
                Flag.initializeClass(enclosingClass);
            }
            if ((superClass = c.getSuperclass()) != null) {
                Flag.initializeClass(superClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nonnull
    public static <T extends Flag> Collection<Flag> allValues(@Nonnull Class<T> specificClass) {
        Flag.initializeClass(specificClass);
        LinkedHashSet<Flag> ret = new LinkedHashSet<Flag>();
        for (Map.Entry<Class<? extends Flag>, ClassAssignment> entry : _typeValues.entrySet()) {
            Class<? extends Flag> otherClass = entry.getKey();
            if (!otherClass.isAssignableFrom(specificClass)) continue;
            Collection<Flag> states = entry.getValue()._states.values();
            ret.addAll(states);
        }
        return ret;
    }

    @Nonnull
    public static <T extends Flag> Collection<T> values(@Nonnull Class<T> specificClass) {
        Flag.initializeClass(specificClass);
        LinkedHashSet<Flag> ret = new LinkedHashSet<Flag>();
        for (Map.Entry<Class<? extends Flag>, ClassAssignment> entry : _typeValues.entrySet()) {
            Class<? extends Flag> otherClass = entry.getKey();
            if (!otherClass.isAssignableFrom(specificClass)) continue;
            Collection<Flag> states = entry.getValue()._states.values();
            for (Flag state : states) {
                if (!specificClass.isInstance(state)) continue;
                ret.add((Flag)specificClass.cast(state));
            }
        }
        return ret;
    }

    @Nullable
    public static Flag valueByField(@Nonnull Class<? extends Flag> specificClass, @Nonnull FieldId fieldId) {
        for (Flag flag : Flag.values(specificClass)) {
            if (!flag.getFieldId().equals(fieldId)) continue;
            return flag;
        }
        return null;
    }

    public Flag(@Nonnull String fieldIdS, int pos) {
        this._field = FieldId.valueOf(fieldIdS);
        this._pos = pos;
        Class<?> specificClass = this.getClass();
        if (!_typeValues.containsKey(specificClass)) {
            _typeValues.put(specificClass, new ClassAssignment());
        }
        _typeValues.get(specificClass).addState(this.getFieldId(), this);
    }

    private static class ClassAssignment {
        private final Map<FieldId, Flag> _states = new LinkedHashMap<FieldId, Flag>();

        private void addState(@Nonnull FieldId fieldId, @Nonnull Flag state) {
            this._states.put(fieldId, state);
        }

        private ClassAssignment() {
        }
    }
}

