/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.app.ProfileCleaner;
import net.moonlightflower.wc3libs.app.SLKCleaner;
import net.moonlightflower.wc3libs.bin.ObjMod;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.bin.app.DOO;
import net.moonlightflower.wc3libs.bin.app.MapFlag;
import net.moonlightflower.wc3libs.bin.app.W3I;
import net.moonlightflower.wc3libs.bin.app.objMod.W3A;
import net.moonlightflower.wc3libs.bin.app.objMod.W3B;
import net.moonlightflower.wc3libs.bin.app.objMod.W3D;
import net.moonlightflower.wc3libs.bin.app.objMod.W3H;
import net.moonlightflower.wc3libs.bin.app.objMod.W3Q;
import net.moonlightflower.wc3libs.bin.app.objMod.W3T;
import net.moonlightflower.wc3libs.bin.app.objMod.W3U;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.Math;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.misc.Translator;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.slk.RawMetaSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;
import net.moonlightflower.wc3libs.slk.app.doodads.DoodSLK;
import net.moonlightflower.wc3libs.slk.app.meta.AbilityBuffMetaSLK;
import net.moonlightflower.wc3libs.slk.app.meta.AbilityMetaSLK;
import net.moonlightflower.wc3libs.slk.app.meta.DestructableMetaSLK;
import net.moonlightflower.wc3libs.slk.app.meta.UnitMetaSLK;
import net.moonlightflower.wc3libs.slk.app.meta.UpgradeMetaSLK;
import net.moonlightflower.wc3libs.slk.app.objs.AbilSLK;
import net.moonlightflower.wc3libs.slk.app.objs.BuffSLK;
import net.moonlightflower.wc3libs.slk.app.objs.DestructableSLK;
import net.moonlightflower.wc3libs.slk.app.objs.ItemSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitAbilsSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitBalanceSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitDataSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitUISLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitWeaponsSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UpgradeSLK;
import net.moonlightflower.wc3libs.txt.Profile;
import net.moonlightflower.wc3libs.txt.TXTSectionId;
import net.moonlightflower.wc3libs.txt.WTS;
import net.moonlightflower.wc3libs.txt.app.jass.Jass;
import net.moonlightflower.wc3libs.txt.app.profile.CampaignUnitStrings;
import net.moonlightflower.wc3libs.txt.app.profile.CommandFunc;
import org.antlr.v4.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjMerger {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());
    private final Collection<SLK> _inSlks = new LinkedHashSet<SLK>();
    private final Map<File, SLK> _outSlks = new LinkedHashMap<File, SLK>();
    private final RawMetaSLK _metaSlk = new RawMetaSLK();
    private final Collection<Profile> _inProfiles = new LinkedHashSet<Profile>();
    private final Profile _outProfile = new Profile();
    private final Collection<ObjMod> _inObjMods = new LinkedHashSet<ObjMod>();
    private final Map<File, ObjMod> _outObjMods = new LinkedHashMap<File, ObjMod>();
    public Filter FILTER_MODDED_OR_CUSTOM = allIds -> {
        LinkedHashSet<ObjId> moddedIds = new LinkedHashSet<ObjId>();
        for (ObjMod objMod : this._inObjMods) {
            for (ObjMod.Obj obj : objMod.getObjsList()) {
                moddedIds.add(obj.getId());
            }
        }
        return id -> !moddedIds.contains(id);
    };
    private static final Collection<String> _importantObjsS = new LinkedHashSet<String>(Arrays.asList("Avul", "Adda", "Amnz", "Aalr", "Aatk", "ANbu", "AHbu", "AObu", "AEbu", "AUbu", "AGbu", "Abdt", "Argd", "AHer", "Arev", "ARal", "ACsp", "Sloa", "Aetl", "Amov", "Afir", "Afih", "Afio", "Afin", "Afiu", "Aloc", "Aeth", "Abdt", "Apit", "AInv", "Ahrp", "Adtg", "Ane2", "BPSE", "BSTN", "Btlf", "Bdet", "Bvul", "Bspe", "Bfro", "Bsha", "Btrv", "Xbdt", "Xbli", "Xdis", "Xfhs", "Xfhm", "Xfhl", "Xfos", "Xfom", "Xfol", "Xfns", "Xfnm", "Xfnl", "Xfus", "Xfum", "Xful", "nmed", "Bstt", "Bbsk", "Binf", "Bsta", "Btlf", "Bpxf", "Boar"));
    private static final Collection<ObjId> _importantObjs = _importantObjsS.stream().map(ObjId::valueOf).collect(Collectors.toList());
    private final Collection<File> _jFiles = new LinkedHashSet<File>();
    private final Collection<File> _dooFiles = new LinkedHashSet<File>();
    private static final Collection<File> _metaSlkInFiles = Arrays.asList(AbilityBuffMetaSLK.GAME_PATH, AbilityMetaSLK.GAME_PATH, DestructableMetaSLK.GAME_PATH, UnitMetaSLK.GAME_PATH, UpgradeMetaSLK.GAME_PATH);
    private static final Collection<File> _slkInFiles = Arrays.asList(UnitAbilsSLK.GAME_PATH, UnitBalanceSLK.GAME_PATH, UnitDataSLK.GAME_PATH, UnitUISLK.GAME_PATH, UnitWeaponsSLK.GAME_PATH, ItemSLK.GAME_PATH, DestructableSLK.GAME_PATH, AbilSLK.GAME_PATH, BuffSLK.GAME_PATH, UpgradeSLK.GAME_PATH);
    private static final Collection<File> _profileInFiles = ObjMerger.getProfilePaths();
    private static final Collection<File> _objModInFiles = Arrays.asList(W3A.GAME_PATH, W3B.GAME_PATH, W3D.GAME_PATH, W3H.GAME_PATH, W3Q.GAME_PATH, W3T.GAME_PATH, W3U.GAME_PATH);
    private static final File PROFILE_OUTPUT_PATH = CampaignUnitStrings.GAME_PATH;

    private void addSlk(@Nonnull File inFile, @Nonnull SLK otherSlk) {
        this._inSlks.add(otherSlk);
        SLK slk = this._outSlks.computeIfAbsent(inFile, SLK::createFromInFile);
        slk.merge(otherSlk);
    }

    private void addMetaSlk(@Nonnull RawMetaSLK slk) {
        this._metaSlk.merge(slk);
    }

    private void addProfile(@Nonnull Profile otherProfile) {
        this._inProfiles.add(otherProfile);
        this._outProfile.merge(otherProfile);
    }

    private void addObjMod(@Nonnull File inFile, @Nonnull ObjMod<?> otherObjMod) throws Exception {
        this._inObjMods.add(otherObjMod);
        ObjMod.ObjPack pack = otherObjMod.reduce(this._metaSlk, Collections.singletonList(W3D.class));
        Map<ObjId, ObjId> baseObjIds = pack.getBaseObjIds();
        HashSet<ObjId> objIds = new HashSet<ObjId>();
        for (Map.Entry<File, SLK> slkEntry : pack.getSlks().entrySet()) {
            File file = slkEntry.getKey();
            SLK sLK = slkEntry.getValue();
            LinkedHashMap otherObjs = new LinkedHashMap(sLK.getObjs());
            sLK.clearObjs();
            for (Map.Entry objEntry : otherObjs.entrySet()) {
                SLK slk;
                ObjId objId = (ObjId)objEntry.getKey();
                objIds.add(objId);
                SLK.Obj otherObj = (SLK.Obj)objEntry.getValue();
                Object obj = sLK.addObj(objId);
                ((SLK.Obj)obj).clear();
                ObjId baseId = baseObjIds.get(objId);
                if (baseId != null && (slk = this._outSlks.get(file)) != null) {
                    Object baseObj = slk.getObj(baseId);
                    if (baseObj == null) {
                        throw new IllegalStateException("obj " + objId + " is based on " + baseId + " which does not exist");
                    }
                    ((SLK.Obj)obj).merge((SLK.Obj<? extends ObjId>)baseObj);
                }
                ((SLK.Obj)obj).merge(otherObj);
            }
            this.addSlk(file, sLK);
        }
        for (File baseSLKFile : otherObjMod.getSLKs()) {
            SLK newSLK = SLK.createFromInFile(baseSLKFile);
            for (ObjId objId : objIds) {
                Object baseObj;
                ObjId baseId;
                SLK reducedSLK = pack.getSlks().get(baseSLKFile);
                if (reducedSLK != null && reducedSLK.containsObj(objId) || (baseId = baseObjIds.get(objId)) == null || (baseObj = this._outSlks.get(baseSLKFile).getObj(baseId)) == null) continue;
                Object obj = newSLK.addObj(objId);
                ((SLK.Obj)obj).merge((SLK.Obj<? extends ObjId>)baseObj);
            }
            this.addSlk(baseSLKFile, newSLK);
        }
        Profile otherProfile = pack.getProfile();
        LinkedHashMap<TXTSectionId, Profile.Obj> otherObjs = new LinkedHashMap<TXTSectionId, Profile.Obj>(otherProfile.getObjs());
        otherProfile.clearObjs();
        for (Map.Entry entry : otherObjs.entrySet()) {
            Profile.Obj baseObj;
            ObjId objId;
            objId = ObjId.valueOf(((TXTSectionId)entry.getKey()).toString());
            Profile.Obj otherObj = (Profile.Obj)entry.getValue();
            Profile.Obj obj = otherProfile.addObj(TXTSectionId.valueOf(objId.toString()));
            ObjId baseId = baseObjIds.get(objId);
            if (baseId != null && (baseObj = this._outProfile.getObj(TXTSectionId.valueOf(baseId.toString()))) != null) {
                obj.merge(baseObj);
            }
            obj.merge(otherObj);
        }
        this.addProfile(pack.getProfile());
        ObjMod objMod = this._outObjMods.computeIfAbsent(inFile, k -> ObjMod.createFromInFile(inFile));
        objMod.merge(pack.getObjMod());
    }

    private Collection<ObjId> findObjRefs(@Nonnull Id id) {
        LinkedHashSet<ObjId> refs = new LinkedHashSet<ObjId>();
        if (id instanceof ObjId) {
            for (ObjMod objMod : this._outObjMods.values()) {
                if (!objMod.containsObj((ObjId)id)) continue;
                Object objModObj = objMod.getObj((ObjId)id);
                for (ObjMod.Obj.Mod mod : ((ObjMod.Obj)objModObj).getMods()) {
                    DataType realVal = mod.getVal();
                    if (realVal == null) continue;
                    String[] vals = realVal.toString().split(",");
                    for (String valSingle : vals) {
                        ObjId ref = ObjId.valueOf(valSingle);
                        if (ref.toString().length() != 4) continue;
                        refs.add(ref);
                    }
                }
            }
            for (Map.Entry entry : this._outSlks.entrySet()) {
                File slkFile = (File)entry.getKey();
                SLK slk = (SLK)entry.getValue();
                if (!slk.containsObj((ObjId)id)) continue;
                Object slkObj = slk.getObj((ObjId)id);
                Map<SLKState, DataType> stateVals = ((SLK.Obj)slkObj).getStateVals();
                for (Map.Entry entry2 : stateVals.entrySet()) {
                    SLKState state = (SLKState)entry2.getKey();
                    DataType val = (DataType)entry2.getValue();
                    if (val == null) continue;
                    DataTypeInfo stateInfo = state.getInfo();
                    Class<? extends DataType> stateType = stateInfo.getType();
                    if (ObjId.class.isAssignableFrom(stateType)) {
                        try {
                            refs.add((ObjId)stateInfo.tryCastVal(val));
                        }
                        catch (DataTypeInfo.CastException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    if (stateType != DataList.class) continue;
                    for (DataTypeInfo subInfo : stateInfo.getGenerics()) {
                        DataList<ObjId> valList;
                        Class<? extends DataType> subType = subInfo.getType();
                        if (!ObjId.class.isAssignableFrom(subType)) continue;
                        if (val instanceof War3String) {
                            valList = new DataList<ObjId>(ObjId.class);
                            for (String s : val.toString().split(",")) {
                                valList.add(ObjId.valueOf(s));
                            }
                        } else {
                            valList = (DataList<ObjId>)val;
                        }
                        for (Object e : valList) {
                            if (!(e instanceof DataType)) continue;
                            try {
                                refs.add((ObjId)subInfo.tryCastVal((DataType)e));
                            }
                            catch (DataTypeInfo.CastException e2) {
                                log.error(e2.getMessage(), (Throwable)e2);
                            }
                        }
                    }
                }
            }
            if (this._outProfile.containsObj(TXTSectionId.valueOf(id.toString()))) {
                Profile.Obj profileObj = this._outProfile.getObj(TXTSectionId.valueOf(id.toString()));
                for (Map.Entry<FieldId, Profile.Obj.Field> fieldEntry : profileObj.getFields().entrySet()) {
                    FieldId fieldId = fieldEntry.getKey();
                    Profile.Obj.Field field = fieldEntry.getValue();
                    for (DataType val : field.getVals()) {
                        ObjId objId;
                        if (val == null || (objId = ObjId.valueOf(val.toString())).toString().length() != 4) continue;
                        refs.add(objId);
                    }
                }
            }
        }
        return refs;
    }

    public void filter(@Nonnull Filter filter) throws IOException {
        LinkedHashSet<Id> allIds = new LinkedHashSet<Id>();
        log.info("filter slk");
        for (SLK slk : this._outSlks.values()) {
            ArrayList objs = new ArrayList(slk.getObjs().values());
            for (SLK.Obj obj : objs) {
                allIds.add((Id)obj.getId());
            }
        }
        log.info("filter profile");
        for (Profile.Obj obj : this._outProfile.getObjs().values()) {
            TXTSectionId objId = obj.getId();
            if (objId == null || objId.toString().length() != 4) continue;
            allIds.add(objId);
        }
        log.info("calc removed ids");
        Predicate<Id> predicate = filter.calcRemovedIds(allIds);
        LinkedHashSet<Id> removedIds = new LinkedHashSet<Id>(allIds);
        removedIds.removeIf(predicate.negate());
        log.info("remove special ids");
        removedIds.removeAll(_importantObjs);
        log.info("find j refed ids");
        LinkedHashSet<Id> jRefedIds = new LinkedHashSet<Id>();
        for (File file : this._jFiles) {
            Jass j = new Jass(file);
            log.info("examine tokens");
            for (Token token : j.getTokens()) {
                String string;
                int val;
                Id id;
                if (token.getType() != 3 && token.getType() != 2 && token.getType() != 4 && token.getType() != 5 || (id = Id.valueOf(Math.encode(val = (string = token.getText()).startsWith("0x") || string.startsWith("0X") ? Math.decode(string.substring(2).toLowerCase(), "0123456789ABCDEF") : (string.startsWith("$") ? Math.decode(string.substring(1), "0123456789ABCDEF") : (string.startsWith("0") ? Math.decode(string.substring(1), "01234567") : (string.startsWith("'") ? Math.decode(string.substring(1, string.length() - 1), Math.CODE_ASCII) : Math.decode(string, "0123456789")))), Math.CODE_ASCII))).toString().length() != 4) continue;
                jRefedIds.add(id);
            }
        }
        log.info("jRefedIds: " + jRefedIds);
        removedIds.removeAll(jRefedIds);
        log.info("find doo refed ids");
        LinkedHashSet<ObjId> dooRefedIds = new LinkedHashSet<ObjId>();
        for (File file : this._dooFiles) {
            ObjId id;
            DOO doo = new DOO(file);
            for (DOO.Dood dood : doo.getDoods()) {
                id = dood.getTypeId();
                dooRefedIds.add(id);
            }
            for (DOO.SpecialDood specialDood : doo.getSpecialDoods()) {
                id = specialDood.getTypeId();
                dooRefedIds.add(id);
            }
        }
        log.info("dooRefedIds: " + dooRefedIds);
        removedIds.removeAll(dooRefedIds);
        LinkedHashSet<Id> linkedHashSet = new LinkedHashSet<Id>(allIds);
        linkedHashSet.removeAll(removedIds);
        log.info("find link refed ids");
        LinkedHashSet<ObjId> linkRefedIds = new LinkedHashSet<ObjId>();
        for (Id id : new LinkedHashSet<Id>(linkedHashSet)) {
            Collection<ObjId> collection = this.findObjRefs(id);
            linkRefedIds.addAll(collection);
        }
        log.info("linkRefedIds: " + linkRefedIds);
        removedIds.removeAll(linkRefedIds);
        for (SLK sLK : this._outSlks.values()) {
            for (Id id : removedIds) {
                if (!(id instanceof ObjId)) continue;
                sLK.removeObj((ObjId)id);
            }
        }
        for (Id id : removedIds) {
            if (!(id instanceof TXTSectionId)) continue;
            this._outProfile.removeObj((TXTSectionId)id);
        }
    }

    private void addFiles(Map<File, File> metaSlkFiles, Map<File, File> slkFiles, Map<File, File> profileFiles, Map<File, File> objModFiles, File wtsFile, File jFile, File dooFile) throws Exception {
        File outFile;
        File inFile;
        log.info("adding exported files to object merger");
        if (wtsFile == null) {
            log.info("no WTS file");
        } else {
            WTS wts = new WTS(wtsFile);
            Translator translator = new Translator();
            translator.addTXT(wts.toTXT());
            this._outProfile.setTranslator(translator);
        }
        log.info("add meta slks");
        for (Map.Entry<File, File> fileEntry : metaSlkFiles.entrySet()) {
            File outFile2 = fileEntry.getValue();
            RawMetaSLK metaSlk = new RawMetaSLK(outFile2);
            this.addMetaSlk(metaSlk);
        }
        log.info("add slks");
        for (Map.Entry<File, File> fileEntry : slkFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            SLK slk = SLK.createFromInFile(inFile, outFile);
            this.addSlk(inFile, slk);
        }
        log.info("add profiles");
        for (Map.Entry<File, File> fileEntry : profileFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            Profile profile = new Profile(outFile);
            this.addProfile(profile);
        }
        log.info("add objmods");
        for (Map.Entry<File, File> fileEntry : objModFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            ObjMod objMod = ObjMod.createFromInFile(inFile, outFile);
            this.addObjMod(inFile, objMod);
        }
        if (jFile != null) {
            log.info("add j");
            this._jFiles.add(jFile);
        }
        if (dooFile != null) {
            log.info("add doo");
            this._dooFiles.add(dooFile);
        }
    }

    private void exportFiles(File dir, Map<File, File> fileEntries) throws IOException {
        Orient.removeDir(dir);
        Orient.createDir(dir);
        for (Map.Entry<File, File> fileEntry : fileEntries.entrySet()) {
            File inFile = fileEntry.getKey();
            File outFile = fileEntry.getValue();
            Orient.copyFile(outFile, new File(dir, inFile.toString()), true);
        }
    }

    private void exportFiles(File outDir, Map<File, File> metaSlkFiles, Map<File, File> slkFiles, Map<File, File> profileFiles, Map<File, File> objModFiles, File wtsFile, File jFile, File dooFile) throws IOException {
        File outFile;
        File inFile;
        LinkedHashMap<File, File> fileEntries = new LinkedHashMap<File, File>();
        for (Map.Entry<File, File> fileEntry : metaSlkFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            fileEntries.put(inFile, outFile);
        }
        for (Map.Entry<File, File> fileEntry : slkFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            fileEntries.put(inFile, outFile);
        }
        for (Map.Entry<File, File> fileEntry : profileFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            fileEntries.put(inFile, outFile);
        }
        for (Map.Entry<File, File> fileEntry : objModFiles.entrySet()) {
            inFile = fileEntry.getKey();
            outFile = fileEntry.getValue();
            fileEntries.put(inFile, outFile);
        }
        if (wtsFile != null) {
            fileEntries.put(WTS.GAME_PATH, wtsFile);
        }
        if (jFile != null) {
            fileEntries.put(Jass.GAME_PATH, jFile);
        }
        if (dooFile != null) {
            fileEntries.put(DOO.GAME_PATH, dooFile);
        }
        this.exportFiles(outDir, fileEntries);
    }

    private static Collection<File> getProfilePaths() {
        LinkedHashSet<File> ret = new LinkedHashSet<File>(Arrays.asList(Profile.getNativePaths()));
        ret.remove(CommandFunc.GAME_PATH);
        return ret;
    }

    public void addDir(File dir) throws Exception {
        log.info("Adding directory of files to be merged: " + dir.getAbsolutePath());
        LinkedHashMap<File, File> files = new LinkedHashMap<File, File>();
        for (File outFile : Orient.getFiles(dir)) {
            File inFile = new File(outFile.toString().substring(dir.toString().length() + 1));
            files.put(inFile, outFile);
        }
        LinkedHashMap<File, File> metaSlkFiles = new LinkedHashMap<File, File>();
        LinkedHashMap<File, File> slkFiles = new LinkedHashMap<File, File>();
        LinkedHashMap<File, File> profileFiles = new LinkedHashMap<File, File>();
        LinkedHashMap<File, File> objModFiles = new LinkedHashMap<File, File>();
        File wtsFile = null;
        File jFile = null;
        File dooFile = null;
        for (Map.Entry fileEntry : files.entrySet()) {
            File inFile = (File)fileEntry.getKey();
            File outFile = (File)fileEntry.getValue();
            if (_metaSlkInFiles.contains(inFile)) {
                metaSlkFiles.put(inFile, outFile);
            }
            if (_slkInFiles.contains(inFile)) {
                slkFiles.put(inFile, outFile);
            }
            if (_profileInFiles.contains(inFile)) {
                profileFiles.put(inFile, outFile);
            }
            if (_objModInFiles.contains(inFile)) {
                objModFiles.put(inFile, outFile);
            }
            if (WTS.GAME_PATH.equals(inFile)) {
                wtsFile = outFile;
            }
            if (Jass.GAME_PATH.equals(inFile)) {
                jFile = outFile;
            }
            if (!DOO.GAME_PATH.equals(inFile)) continue;
            dooFile = outFile;
        }
        this.addFiles(metaSlkFiles, slkFiles, profileFiles, objModFiles, wtsFile, jFile, dooFile);
    }

    private void addExports(File outDir, MpqPort.Out.Result metaSlkResult, MpqPort.Out.Result slkResult, MpqPort.Out.Result profileResult, MpqPort.Out.Result objModResult, MpqPort.Out.Result wtsResult, MpqPort.Out.Result jResult, MpqPort.Out.Result dooResult) throws Exception {
        LinkedHashMap<File, File> metaSlkFiles = new LinkedHashMap<File, File>();
        this.processSegments(metaSlkResult, metaSlkFiles);
        LinkedHashMap<File, File> slkFiles = new LinkedHashMap<File, File>();
        this.processSegments(slkResult, slkFiles);
        LinkedHashMap<File, File> profileFiles = new LinkedHashMap<File, File>();
        this.processSegments(profileResult, profileFiles);
        LinkedHashMap<File, File> objModFiles = new LinkedHashMap<File, File>();
        this.processSegments(objModResult, objModFiles);
        File wtsFile = null;
        try {
            wtsFile = wtsResult.getFile(WTS.GAME_PATH);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        File jFile = null;
        try {
            jFile = wtsResult.getFile(Jass.GAME_PATH);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        File dooFile = null;
        try {
            dooFile = dooResult.getFile(DOO.GAME_PATH);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        this.exportFiles(outDir, metaSlkFiles, metaSlkFiles, profileFiles, objModFiles, wtsFile, jFile, dooFile);
        this.addFiles(metaSlkFiles, metaSlkFiles, profileFiles, objModFiles, wtsFile, jFile, dooFile);
    }

    private void processSegments(MpqPort.Out.Result metaSlkResult, Map<File, File> metaSlkFiles) throws IOException {
        for (MpqPort.Out.Result.Segment segment : metaSlkResult.getExports().values()) {
            File inFile = segment.getExport().getInFile();
            try {
                File outFile = metaSlkResult.getFile(inFile);
                metaSlkFiles.put(inFile, outFile);
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
    }

    public void writeToDir(File outDir, boolean clean) throws Exception {
        Orient.removeDir(outDir);
        Orient.createDir(outDir);
        this._outSlks.remove(DoodSLK.GAME_PATH);
        LinkedHashSet slkObjIds = new LinkedHashSet();
        for (Map.Entry<File, SLK> slkEntry : this._outSlks.entrySet()) {
            File inFile = slkEntry.getKey();
            SLK slk = slkEntry.getValue();
            if (clean) {
                slk.cleanEmptyColumns();
                SLKCleaner.clean(slk);
            }
            File file = new File(outDir, inFile.toString());
            slk.write(file);
            slk.getObjs().values().stream().forEach(obj -> slkObjIds.add(obj.getId()));
        }
        File emptyFile = new File(outDir, "empty.txt");
        FileOutputStream emptyFileStream = Orient.createFileOutputStream(emptyFile);
        ((OutputStream)emptyFileStream).close();
        for (File inFile : _profileInFiles) {
            File file = new File(outDir, inFile.toString());
            Orient.copyFile(emptyFile, file, true);
        }
        File profileOutFile = new File(outDir, PROFILE_OUTPUT_PATH.toString());
        if (clean) {
            ProfileCleaner.clean(this._outProfile);
        }
        for (ObjId objId : slkObjIds) {
            this._outProfile.addObj(TXTSectionId.valueOf(objId.toString()));
        }
        for (ObjId objId : _importantObjs) {
            this._outProfile.addObj(TXTSectionId.valueOf(objId.toString()));
        }
        this._outProfile.write(profileOutFile);
        for (Map.Entry entry : this._outObjMods.entrySet()) {
            File inFile = (File)entry.getKey();
            ObjMod objMod = (ObjMod)entry.getValue();
            File outFile2 = new File(outDir, inFile.toString());
            Wc3BinOutputStream outStream = new Wc3BinOutputStream(outFile2);
            if (!objMod.getObjs().isEmpty()) {
                objMod.write(outStream);
            }
            outStream.close();
        }
    }

    public void writeToMap(@Nonnull File mapFile, @Nonnull File outDir) throws Exception {
        Orient.removeDir(outDir);
        Orient.createDir(outDir);
        JMpqPort.In portIn = new JMpqPort.In();
        this._outSlks.remove(DoodSLK.GAME_PATH);
        LinkedHashSet slkObjIds = new LinkedHashSet();
        for (Map.Entry<File, SLK> slkEntry : this._outSlks.entrySet()) {
            File file = slkEntry.getKey();
            SLK slk = slkEntry.getValue();
            File outFile = new File(outDir, file.toString());
            slk.cleanEmptyColumns();
            slk.write(outFile);
            portIn.add(outFile, file);
            slk.getObjs().values().stream().forEach(obj -> slkObjIds.add(obj.getId()));
        }
        for (File inFile : _profileInFiles) {
            File file = new File(outDir, inFile.toString());
            new Profile().write(file);
        }
        File profileOutFile = new File(outDir, PROFILE_OUTPUT_PATH.toString());
        for (ObjId objId : slkObjIds) {
            this._outProfile.addObj(TXTSectionId.valueOf(objId.toString()));
        }
        for (ObjId objId : _importantObjs) {
            this._outProfile.addObj(TXTSectionId.valueOf(objId.toString()));
        }
        this._outProfile.write(profileOutFile);
        for (File file : _profileInFiles) {
            File outFile = new File(outDir, file.toString());
            portIn.add(outFile, file);
        }
        for (Map.Entry entry : this._outObjMods.entrySet()) {
            File inFile = (File)entry.getKey();
            ObjMod objMod = (ObjMod)entry.getValue();
            File outFile = new File(outDir, inFile.toString());
            Wc3BinOutputStream outStream = new Wc3BinOutputStream(outFile);
            if (!objMod.getObjs().isEmpty()) {
                objMod.write(outStream);
            }
            outStream.close();
            if (!objMod.getObjs().isEmpty()) {
                portIn.add(outFile, inFile);
                continue;
            }
            portIn.addDel(inFile);
        }
        portIn.commit(mapFile);
    }

    public void exportMap(@Nonnull File mapFile, boolean includeNativeData, @Nonnull File wc3Dir, @Nonnull File outDir) throws Exception {
        log.info("Exporting map: " + mapFile.getAbsolutePath());
        LinkedHashSet<File> filesToExport = new LinkedHashSet<File>();
        filesToExport.addAll(_metaSlkInFiles);
        filesToExport.addAll(_slkInFiles);
        filesToExport.addAll(_profileInFiles);
        filesToExport.addAll(_objModInFiles);
        filesToExport.add(WTS.GAME_PATH);
        filesToExport.add(Jass.GAME_PATH);
        filesToExport.add(DOO.GAME_PATH);
        log.info("try export from map (" + filesToExport + ")");
        LinkedHashMap<File, File> redirectMap = new LinkedHashMap<File, File>();
        LinkedHashMap<File, File> outFiles = new LinkedHashMap<File, File>();
        JMpqPort.Out portOut = new JMpqPort.Out();
        Iterator iterator = filesToExport.iterator();
        while (iterator.hasNext()) {
            File file;
            File file2 = file = (File)iterator.next();
            redirectMap.put(file2, file);
            portOut.add(file2);
        }
        MpqPort.Out.Result portResult = portOut.commit(mapFile);
        portOut.clear();
        for (Map.Entry<File, MpqPort.Out.Result.Segment> entry : portResult.getExports().entrySet()) {
            File redirectedFile = entry.getKey();
            try {
                File file = portResult.getFile(redirectedFile);
                File inFile = (File)redirectMap.get(redirectedFile);
                filesToExport.remove(inFile);
                outFiles.put(inFile, file);
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
        if (!filesToExport.isEmpty()) {
            W3I w3I = W3I.ofMapFile(mapFile);
            W3I.GameDataSet gameDataSet = w3I.getGameDataSet();
            log.info("try export from wc3 mpqs with dataset " + gameDataSet + " (meleeMap=" + w3I.getFlag(MapFlag.MELEE_MAP) + ") (" + filesToExport + ")");
            if (!includeNativeData) {
                filesToExport.clear();
                filesToExport.addAll(_metaSlkInFiles);
            }
            if (!filesToExport.isEmpty()) {
                File inFile;
                File redirectedFile;
                File redirectFile;
                for (File file : filesToExport) {
                    redirectFile = new File(w3I.getGameDataSetPath(), file.toString());
                    redirectMap.put(redirectFile, file);
                    portOut.add(redirectFile);
                }
                portResult = ((MpqPort.Out)portOut).commit(JMpqPort.getWc3Mpqs(wc3Dir));
                portOut.clear();
                for (Map.Entry entry : portResult.getExports().entrySet()) {
                    redirectedFile = (File)entry.getKey();
                    try {
                        File outFile2 = portResult.getFile(redirectedFile);
                        inFile = (File)redirectMap.get(redirectedFile);
                        filesToExport.remove(inFile);
                        outFiles.put(inFile, outFile2);
                    }
                    catch (NoSuchFileException outFile2) {}
                }
                if (!filesToExport.isEmpty()) {
                    log.info("try export from wc3 mpqs standard dataset (" + filesToExport + ")");
                    Iterator<Object> iterator2 = filesToExport.iterator();
                    while (iterator2.hasNext()) {
                        File file;
                        redirectFile = file = (File)iterator2.next();
                        redirectMap.put(redirectFile, file);
                        portOut.add(redirectFile);
                    }
                    portResult = ((MpqPort.Out)portOut).commit(JMpqPort.getWc3Mpqs(wc3Dir));
                    portOut.clear();
                    for (Map.Entry entry : portResult.getExports().entrySet()) {
                        redirectedFile = (File)entry.getKey();
                        try {
                            File outFile = portResult.getFile(redirectedFile);
                            inFile = (File)redirectMap.get(redirectedFile);
                            filesToExport.remove(inFile);
                            outFiles.put(inFile, outFile);
                        }
                        catch (NoSuchFileException noSuchFileException) {}
                    }
                }
            }
        }
        log.info("Extracting following files: " + Arrays.toString(outFiles.values().toArray()));
        this.exportFiles(outDir, outFiles);
    }

    public void exportMap(File mapFile, File outDir) throws Exception {
        this.exportMap(mapFile, true, (File)Context.getService(GameDirFinder.class).get(), outDir);
    }

    public void readFromMap(File mapFile, boolean includeNativeData, File wc3Dir, File outDir) throws Exception {
        Orient.removeDir(outDir);
        Orient.createDir(outDir);
        this.exportMap(mapFile, includeNativeData, wc3Dir, outDir);
        this.addDir(outDir);
    }

    public void readFromMap2(File mapFile, boolean includeNativeData, File wc3Dir, File outDir) throws Exception {
        Vector<File> mpqFiles = new Vector<File>();
        mpqFiles.add(mapFile);
        if (includeNativeData) {
            if (wc3Dir == null) {
                throw new Exception("no wc3Dir");
            }
            mpqFiles.addAll(JMpqPort.getWc3Mpqs(wc3Dir));
        }
        JMpqPort.Out metaSlkPortOut = new JMpqPort.Out();
        for (File inFile : _metaSlkInFiles) {
            metaSlkPortOut.add(inFile);
        }
        MpqPort.Out.Result metaSlkResult = ((MpqPort.Out)metaSlkPortOut).commit(mpqFiles);
        JMpqPort.Out slkPortOut = new JMpqPort.Out();
        ArrayList<File> slkFiles = new ArrayList<File>(_slkInFiles);
        for (File inFile : slkFiles) {
            slkPortOut.add(inFile);
        }
        MpqPort.Out.Result slkResult = ((MpqPort.Out)slkPortOut).commit(mpqFiles);
        ArrayList<File> profileFiles = new ArrayList<File>(_profileInFiles);
        JMpqPort.Out profilePortOut = new JMpqPort.Out();
        for (File inFile : profileFiles) {
            profilePortOut.add(inFile);
        }
        MpqPort.Out.Result profileResult = ((MpqPort.Out)profilePortOut).commit(mpqFiles);
        JMpqPort.Out objModPortOut = new JMpqPort.Out();
        for (File inFile : _objModInFiles) {
            objModPortOut.add(inFile);
        }
        MpqPort.Out.Result objModResult = objModPortOut.commit(mapFile);
        JMpqPort.Out wtsPortOut = new JMpqPort.Out();
        wtsPortOut.add(WTS.GAME_PATH);
        MpqPort.Out.Result wtsResult = wtsPortOut.commit(mapFile);
        JMpqPort.Out jPortOut = new JMpqPort.Out();
        jPortOut.add(Jass.GAME_PATH);
        MpqPort.Out.Result jResult = jPortOut.commit(mapFile);
        JMpqPort.Out dooPortOut = new JMpqPort.Out();
        dooPortOut.add(DOO.GAME_PATH);
        MpqPort.Out.Result dooResult = dooPortOut.commit(mapFile);
        this.addExports(outDir, metaSlkResult, slkResult, profileResult, objModResult, wtsResult, jResult, dooResult);
    }

    public void readFromMap(File mapFile, boolean includeNativeData, File outDir) throws Exception {
        this.readFromMap(mapFile, includeNativeData, (File)Context.getService(GameDirFinder.class).get(), outDir);
    }

    public static interface Filter {
        public Predicate<Id> calcRemovedIds(Collection<Id> var1);
    }
}

