/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser.headers.resources;

import dorkbox.peParser.ByteArray;
import dorkbox.peParser.headers.Header;
import dorkbox.peParser.headers.SectionTableEntry;
import dorkbox.peParser.headers.resources.ResourceDirectoryEntry;
import dorkbox.peParser.types.DWORD;
import dorkbox.peParser.types.TimeDate;
import dorkbox.peParser.types.WORD;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006#"}, d2={"Ldorkbox/peParser/headers/resources/ResourceDirectoryHeader;", "Ldorkbox/peParser/headers/Header;", "bytes", "Ldorkbox/peParser/ByteArray;", "section", "Ldorkbox/peParser/headers/SectionTableEntry;", "level", "", "(Ldorkbox/peParser/ByteArray;Ldorkbox/peParser/headers/SectionTableEntry;I)V", "MAJOR_VERSION", "Ldorkbox/peParser/types/WORD;", "getMAJOR_VERSION", "()Ldorkbox/peParser/types/WORD;", "MINOR_VERSION", "getMINOR_VERSION", "NUM_ID_ENTRIES", "getNUM_ID_ENTRIES", "NUM_NAME_ENTRIES", "getNUM_NAME_ENTRIES", "RSRC_CHARACTERISTICS", "Ldorkbox/peParser/types/DWORD;", "getRSRC_CHARACTERISTICS", "()Ldorkbox/peParser/types/DWORD;", "TIME_STAMP", "Ldorkbox/peParser/types/TimeDate;", "getTIME_STAMP", "()Ldorkbox/peParser/types/TimeDate;", "entries", "", "Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry;", "getEntries", "()[Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry;", "setEntries", "([Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry;)V", "[Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry;", "PeParser"})
public final class ResourceDirectoryHeader
extends Header {
    @NotNull
    private final DWORD RSRC_CHARACTERISTICS;
    @NotNull
    private final TimeDate TIME_STAMP;
    @NotNull
    private final WORD MAJOR_VERSION;
    @NotNull
    private final WORD MINOR_VERSION;
    @NotNull
    private final WORD NUM_NAME_ENTRIES;
    @NotNull
    private final WORD NUM_ID_ENTRIES;
    @NotNull
    private ResourceDirectoryEntry[] entries;

    public ResourceDirectoryHeader(@NotNull ByteArray bytes, @Nullable SectionTableEntry section, int level) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.RSRC_CHARACTERISTICS = new DWORD(bytes.readUInt-OGnWXxg(4), "Resource Characteristics", null);
        this.TIME_STAMP = new TimeDate(bytes.readUInt-OGnWXxg(4), "Date", null);
        this.MAJOR_VERSION = new WORD(bytes.readUShort-BwKQO78(2), "Major Version", null);
        this.MINOR_VERSION = new WORD(bytes.readUShort-BwKQO78(2), "Minor Version", null);
        this.NUM_NAME_ENTRIES = new WORD(bytes.readUShort-BwKQO78(2), "Number of Name Entries", null);
        this.NUM_ID_ENTRIES = new WORD(bytes.readUShort-BwKQO78(2), "Number of ID Entries", null);
        int numberOfNamedEntires = this.NUM_NAME_ENTRIES.get-Mh2AYeg() & 0xFFFF;
        int numberOfIDEntires = this.NUM_ID_ENTRIES.get-Mh2AYeg() & 0xFFFF;
        int numberOfEntries = numberOfNamedEntires + numberOfIDEntires;
        this.entries = new ResourceDirectoryEntry[numberOfEntries];
        for (int i = 0; i < numberOfEntries; ++i) {
            this.entries[i] = new ResourceDirectoryEntry(bytes, section, level + 1);
        }
    }

    @NotNull
    public final DWORD getRSRC_CHARACTERISTICS() {
        return this.RSRC_CHARACTERISTICS;
    }

    @NotNull
    public final TimeDate getTIME_STAMP() {
        return this.TIME_STAMP;
    }

    @NotNull
    public final WORD getMAJOR_VERSION() {
        return this.MAJOR_VERSION;
    }

    @NotNull
    public final WORD getMINOR_VERSION() {
        return this.MINOR_VERSION;
    }

    @NotNull
    public final WORD getNUM_NAME_ENTRIES() {
        return this.NUM_NAME_ENTRIES;
    }

    @NotNull
    public final WORD getNUM_ID_ENTRIES() {
        return this.NUM_ID_ENTRIES;
    }

    @NotNull
    public final ResourceDirectoryEntry[] getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull ResourceDirectoryEntry[] resourceDirectoryEntryArray) {
        Intrinsics.checkNotNullParameter((Object)resourceDirectoryEntryArray, (String)"<set-?>");
        this.entries = resourceDirectoryEntryArray;
    }
}

