/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 g2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0006ghijklB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\b\u0010B\u001a\u00020CH\u0016J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0002J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0002H\u0016J\u0010\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u0003H\u0016J\u000e\u0010I\u001a\u00020C2\u0006\u0010J\u001a\u00020\u0002J\u0006\u0010\n\u001a\u00020\u0011J\u0013\u0010K\u001a\u00020\u00142\b\u0010L\u001a\u0004\u0018\u00010MH\u0096\u0002J\u0017\u0010N\u001a\u0004\u0018\u00010\u00022\b\u0010H\u001a\u0004\u0018\u00010M\u00a2\u0006\u0002\u0010OJ\u0018\u0010N\u001a\u00020\u00022\b\u0010H\u001a\u0004\u0018\u00010M2\u0006\u0010P\u001a\u00020\u0002J\u0018\u0010Q\u001a\u0004\u0018\u00010\u00032\u0006\u0010F\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010RJ\"\u0010Q\u001a\u0004\u0018\u00010\u00032\u0006\u0010F\u001a\u00020\u00022\b\u0010S\u001a\u0004\u0018\u00010\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020\u0002H\u0016J\b\u0010V\u001a\u00020\u0014H\u0016J\u0006\u0010\u001f\u001a\u00020\"J\u0010\u0010W\u001a\u00020\u00022\u0006\u0010F\u001a\u00020\u0002H\u0002J\u0006\u0010X\u001a\u00020\u0014J\u0010\u0010Y\u001a\u00020\u00022\u0006\u0010Z\u001a\u00020\u0002H\u0004J\u001f\u0010[\u001a\u0004\u0018\u00010\u00032\u0006\u0010F\u001a\u00020\u00022\u0006\u0010H\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\\J\u000e\u0010]\u001a\u00020C2\u0006\u0010\b\u001a\u00020\u0000J\u001e\u0010]\u001a\u00020C2\u0014\u0010^\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030_H\u0016J\u0018\u0010`\u001a\u00020C2\u0006\u0010F\u001a\u00020\u00022\u0006\u0010H\u001a\u00020\u0003H\u0002J\u0017\u0010a\u001a\u0004\u0018\u00010\u00032\u0006\u0010F\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010RJ\u0010\u0010b\u001a\u00020C2\u0006\u0010c\u001a\u00020\u0002H\u0002J\u000e\u0010d\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0002J\b\u0010e\u001a\u00020fH\u0016J\u0006\u00106\u001a\u00020;R,\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\f0\u000b8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0004\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u0014\u0010,\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010&R\u000e\u0010.\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0003078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006m"}, d2={"Ldorkbox/collections/IntFloatMap;", "", "", "", "()V", "initialCapacity", "loadFactor", "(IF)V", "map", "(Ldorkbox/collections/IntFloatMap;)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/IntFloatMap$Entries;", "entries2", "hasZeroValue", "", "getHasZeroValue", "()Z", "setHasZeroValue", "(Z)V", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/IntFloatMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "", "getValueTable", "()[F", "setValueTable", "([F)V", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/IntFloatMap$Values;", "values2", "zeroValue", "getZeroValue", "()F", "setZeroValue", "(F)V", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "ensureCapacity", "additionalCapacity", "equals", "other", "", "findKey", "(Ljava/lang/Object;)Ljava/lang/Integer;", "notFound", "get", "(I)Ljava/lang/Float;", "defaultValue", "(ILjava/lang/Float;)Ljava/lang/Float;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "(IF)Ljava/lang/Float;", "putAll", "from", "", "putResize", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
@SourceDebugExtension(value={"SMAP\nIntFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,993:1\n1#2:994\n1855#3,2:995\n*S KotlinDebug\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap\n*L\n298#1:995,2\n*E\n"})
public final class IntFloatMap
implements Map<Integer, Float>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size_;
    @NotNull
    private int[] keyTable;
    @NotNull
    private float[] valueTable;
    private float zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient Entries entries1;
    @Nullable
    private transient Entries entries2;
    @Nullable
    private transient Values values1;
    @Nullable
    private transient Values values2;
    @Nullable
    private transient Keys keys1;
    @Nullable
    private transient Keys keys2;
    @NotNull
    public static final String version = "2.4";

    @NotNull
    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.keyTable = nArray;
    }

    @NotNull
    public final float[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valueTable = fArray;
    }

    public final float getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(float f) {
        this.zeroValue = f;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntFloatMap() {
        this(51, 0.8f);
    }

    public IntFloatMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[tableSize];
        this.valueTable = new float[tableSize];
    }

    public /* synthetic */ IntFloatMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntFloatMap(@NotNull IntFloatMap map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size_ = map.size_;
        this.zeroValue = map.zeroValue;
        this.hasZeroValue = map.hasZeroValue;
    }

    protected final int place(int item) {
        return (int)((long)item * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    @Nullable
    public Float put(int key, float value) {
        if (key == 0) {
            float oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                int n = this.size_;
                this.size_ = n + 1;
            }
            return Float.valueOf(oldValue);
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            float oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return Float.valueOf(oldValue);
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public final void putAll(@NotNull IntFloatMap map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.ensureCapacity(map.size_);
        if (map.hasZeroValue) {
            this.put(0, map.zeroValue);
        }
        int[] keyTable = map.keyTable;
        float[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            this.put(key, valueTable[i]);
        }
    }

    private final void putResize(int key, float value) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Nullable
    public Float get(int key) {
        if (key == 0) {
            return this.hasZeroValue ? Float.valueOf(this.zeroValue) : null;
        }
        int i = this.locateKey(key);
        return i >= 0 ? Float.valueOf(this.valueTable[i]) : null;
    }

    @Nullable
    public final Float get(int key, @Nullable Float defaultValue) {
        if (key == 0) {
            return this.hasZeroValue ? Float.valueOf(this.zeroValue) : defaultValue;
        }
        int i = this.locateKey(key);
        return i >= 0 ? Float.valueOf(this.valueTable[i]) : defaultValue;
    }

    @Nullable
    public Float remove(int key) {
        int n;
        if (key == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            float oldValue = this.zeroValue;
            this.zeroValue = 0.0f;
            int n2 = this.size_;
            this.size_ = n2 + -1;
            return Float.valueOf(oldValue);
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        int[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        float oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        int k = 0;
        while (true) {
            int it = n = keyTable[next];
            boolean bl = false;
            k = it;
            if (n == 0) break;
            int placement = this.place(k);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0;
        valueTable[i] = 0.0f;
        n = this.size_;
        this.size_ = n + -1;
        return Float.valueOf(oldValue);
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public void putAll(@NotNull Map<? extends Integer, ? extends Float> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.size());
        Iterable $this$forEach$iv = from.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            int k = ((Number)entry.getKey()).intValue();
            float v = ((Number)entry.getValue()).floatValue();
            this.put(k, v);
        }
    }

    public final void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public final void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = 0.0f;
        this.resize(tableSize);
    }

    @NotNull
    public Set<Map.Entry<Integer, Float>> getEntries() {
        Entries entries = this.entries();
        Intrinsics.checkNotNull((Object)entries, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<kotlin.Int, kotlin.Float>>");
        return TypeIntrinsics.asMutableSet((Object)entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    @NotNull
    public Set<Integer> getKeys() {
        return this.keys();
    }

    public int getSize() {
        return this.size_;
    }

    @NotNull
    public Collection<Float> getValues() {
        return this.values();
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, 0.0f);
        this.zeroValue = 0.0f;
        this.hasZeroValue = false;
    }

    public boolean containsValue(float value) {
        float[] valueTable = this.valueTable;
        if (value == 0.0f) {
            if (this.hasZeroValue && this.zeroValue == 0.0f) {
                return true;
            }
            int[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == 0 || !(valueTable[i] == 0.0f)) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            if (value == this.zeroValue) {
                return true;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!(valueTable[i = n--] == value)) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return key == 0 ? this.hasZeroValue : this.locateKey(key) >= 0;
    }

    @Nullable
    public final Integer findKey(@Nullable Object value) {
        float[] valueTable = this.valueTable;
        if (value == null) {
            if (this.hasZeroValue && this.zeroValue == 0.0f) {
                return 0;
            }
            int[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == 0 || !(valueTable[i] == 0.0f)) continue;
                    return keyTable[i];
                } while (0 <= n);
            }
        } else {
            if (Intrinsics.areEqual((Object)value, (Object)Float.valueOf(this.zeroValue))) {
                return 0;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)Float.valueOf(valueTable[i = n--]), (Object)value)) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final int findKey(@Nullable Object value, int notFound) {
        Integer n = this.findKey(value);
        return n != null ? n : notFound;
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.size_ + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] oldKeyTable = this.keyTable;
        float[] oldValueTable = this.valueTable;
        this.keyTable = new int[newSize];
        this.valueTable = new float[newSize];
        if (this.size_ > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                int key = oldKeyTable[i];
                if (key == 0) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.size_;
        if (this.hasZeroValue && !(this.zeroValue == 0.0f)) {
            h += Float.hashCode(this.zeroValue);
        }
        int[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            h += key * 31;
            float value = valueTable[i];
            if (value == 0.0f) continue;
            h += Float.hashCode(value);
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IntFloatMap)) {
            return false;
        }
        if (((IntFloatMap)other).size_ != this.size_) {
            return false;
        }
        if (((IntFloatMap)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((IntFloatMap)other).zeroValue == 0.0f ? !(this.zeroValue == 0.0f) : !(((IntFloatMap)other).zeroValue == this.zeroValue))) {
            return false;
        }
        int[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            float value = valueTable[i];
            boolean bl = value == 0.0f;
            if (!(bl ? ((IntFloatMap)other).get((Object)key) != null : !Intrinsics.areEqual((float)value, (Float)((Float)((IntFloatMap)other).get((Object)key))))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        int key;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        int[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i]);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public final Entries entries() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries entries = this.entries1;
        Intrinsics.checkNotNull((Object)entries);
        if (!entries.getValid()) {
            Entries entries2 = this.entries1;
            Intrinsics.checkNotNull((Object)entries2);
            entries2.reset();
            Entries entries3 = this.entries1;
            Intrinsics.checkNotNull((Object)entries3);
            entries3.setValid(true);
            Entries entries4 = this.entries2;
            Intrinsics.checkNotNull((Object)entries4);
            entries4.setValid(false);
            Entries entries5 = this.entries1;
            Intrinsics.checkNotNull((Object)entries5);
            return entries5;
        }
        Entries entries6 = this.entries2;
        Intrinsics.checkNotNull((Object)entries6);
        entries6.reset();
        Entries entries7 = this.entries2;
        Intrinsics.checkNotNull((Object)entries7);
        entries7.setValid(true);
        Entries entries8 = this.entries1;
        Intrinsics.checkNotNull((Object)entries8);
        entries8.setValid(false);
        Entries entries9 = this.entries2;
        Intrinsics.checkNotNull((Object)entries9);
        return entries9;
    }

    @NotNull
    public final Values values() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values values = this.values1;
        Intrinsics.checkNotNull((Object)values);
        if (!values.getValid()) {
            Values values2 = this.values1;
            Intrinsics.checkNotNull((Object)values2);
            values2.reset();
            Values values3 = this.values1;
            Intrinsics.checkNotNull((Object)values3);
            values3.setValid(true);
            Values values4 = this.values2;
            Intrinsics.checkNotNull((Object)values4);
            values4.setValid(false);
            Values values5 = this.values1;
            Intrinsics.checkNotNull((Object)values5);
            return values5;
        }
        Values values6 = this.values2;
        Intrinsics.checkNotNull((Object)values6);
        values6.reset();
        Values values7 = this.values2;
        Intrinsics.checkNotNull((Object)values7);
        values7.setValid(true);
        Values values8 = this.values1;
        Intrinsics.checkNotNull((Object)values8);
        values8.setValid(false);
        Values values9 = this.values2;
        Intrinsics.checkNotNull((Object)values9);
        return values9;
    }

    @NotNull
    public final Keys keys() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\t\u0010\u001a\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ldorkbox/collections/IntFloatMap$Entries;", "", "Ldorkbox/collections/IntFloatMap$Entry;", "Ldorkbox/collections/IntFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "entry", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$Entries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,993:1\n1855#2,2:994\n1855#2,2:996\n288#2,2:998\n288#2,2:1001\n1855#2,2:1004\n13600#3:1000\n13601#3:1003\n*S KotlinDebug\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$Entries\n*L\n703#1:994,2\n724#1:996,2\n745#1:998,2\n755#1:1001,2\n766#1:1004,2\n753#1:1000\n753#1:1003\n*E\n"})
    public static final class Entries
    extends MapIterator<Integer, Entry>
    implements Set<Entry>,
    KMutableSet {
        @NotNull
        private final Entry entry;

        public Entries(@NotNull IntFloatMap map) {
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            super(map);
            this.entry = new Entry(map);
        }

        @Override
        @NotNull
        public Entry next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int[] keyTable = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(keyTable[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(@NotNull Entry element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.getMap().put(element.getKey(), element.getValue().floatValue());
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Entry> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean added = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                this.getMap().put(it.getKey(), it.getValue().floatValue());
                added = true;
            }
            return added;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                int k = ((Number)((Map.Entry)entry).getKey()).intValue();
                float v = ((Number)((Map.Entry)entry).getValue()).floatValue();
                if (Intrinsics.areEqual((Float)((Float)this.getMap().get((Object)k)), (float)v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(@NotNull Entry element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return Intrinsics.areEqual((Float)((Float)this.getMap().get(element.getKey())), (float)element.getValue().floatValue());
        }

        @Override
        @NotNull
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            if (this.getMap().getHasZeroValue()) {
                boolean hasElement;
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv;
                        boolean bl = false;
                        if (!(it.getKey() == 0)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                boolean bl = hasElement = v0 != null;
                if (hasElement) {
                    removed = this.getMap().remove((Object)0) != null;
                }
            }
            int[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean hasElement;
                Object v2;
                int key;
                block6: {
                    int element$iv;
                    key = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (key == 0) continue;
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv2;
                        boolean bl2 = false;
                        if (!(it.getKey() == key)) continue;
                        v2 = element$iv2;
                        break block6;
                    }
                    v2 = null;
                }
                boolean bl = hasElement = v2 != null;
                if (hasElement) continue;
                removed = this.getMap().remove((Object)key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                int k = ((Number)((Map.Entry)entry).getKey()).intValue();
                removed = this.getMap().remove((Object)k) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@NotNull Entry element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            boolean removed = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return removed;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\t\u0010\u0015\u001a\u00020\fH\u0096\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Ldorkbox/collections/IntFloatMap$Values;", "", "", "Ldorkbox/collections/IntFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Float;", "remove", "removeAll", "retainAll", "toArray", "", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$Values\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,993:1\n1855#2,2:994\n1855#2,2:998\n13600#3,2:996\n*S KotlinDebug\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$Values\n*L\n820#1:994,2\n853#1:998,2\n838#1:996,2\n*E\n"})
    public static final class Values
    extends MapIterator<Integer, Float>
    implements Collection<Float>,
    KMutableCollection {
        public Values(@NotNull IntFloatMap map) {
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public Float next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            float value = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return Float.valueOf(value);
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Float> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(float element) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float it = ((Number)element$iv).floatValue();
                boolean bl = false;
                if (this.getMap().containsValue(Float.valueOf(it))) continue;
                return false;
            }
            return true;
        }

        public boolean contains(float element) {
            return this.getMap().containsValue(Float.valueOf(element));
        }

        @Override
        @NotNull
        public Iterator<Float> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            int[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Float value;
                int element$iv;
                int key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (key == 0 || CollectionsKt.contains((Iterable)elements, (Object)(value = (Float)this.getMap().get((Object)key)))) continue;
                this.getMap().remove((Object)key);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float it = ((Number)element$iv).floatValue();
                boolean bl = false;
                Integer key = this.getMap().findKey(Float.valueOf(it));
                if (key == null) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(float element) {
            boolean removed = false;
            Integer key = this.getMap().findKey(Float.valueOf(element));
            if (key != null) {
                removed = this.getMap().remove(key) != null;
            }
            this.reset();
            return removed;
        }

        @NotNull
        public final float[] toArray() {
            float[] array = new float[this.getMap().size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next().floatValue();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\t\u0010\u0014\u001a\u00020\u000bH\u0096\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0096\u0002J\u000e\u0010\u0018\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u001d\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fR\u0014\u0010\u0007\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntFloatMap$Keys;", "", "", "Ldorkbox/collections/IntFloatMap$MapIterator;", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Integer;", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$Keys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,993:1\n1855#2,2:994\n1855#2,2:996\n1855#2,2:1000\n13600#3,2:998\n*S KotlinDebug\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$Keys\n*L\n909#1:994,2\n925#1:996,2\n956#1:1000,2\n943#1:998,2\n*E\n"})
    public static final class Keys
    extends MapIterator<Integer, Integer>
    implements Set<Integer>,
    KMutableSet {
        public Keys(@NotNull IntFloatMap map) {
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public Integer next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int key = this.getNextIndex() == -1 ? 0 : this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return key;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Integer> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean alreadyAdded = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                alreadyAdded = alreadyAdded || this.getMap().put(it, 0.0f) == null;
            }
            return alreadyAdded;
        }

        @Override
        public boolean add(int element) {
            return this.getMap().put(element, 0.0f) == null;
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (this.getMap().containsKey((Object)it)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(int element) {
            return this.getMap().containsKey((Object)element);
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            int[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (elements.contains(it) || this.getMap().remove((Object)it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (this.getMap().remove((Object)it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@Nullable Integer element) {
            return this.getMap().remove(element) == null;
        }

        @NotNull
        public final int[] toArray() {
            int[] array = new int[this.getMap().size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @NotNull
        public final int[] toArray(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/IntFloatMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0007\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Ldorkbox/collections/IntFloatMap$Entry;", "", "", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "key", "getKey", "()Ljava/lang/Integer;", "setKey", "(I)V", "getMap", "()Ldorkbox/collections/IntFloatMap;", "value", "getValue", "()Ljava/lang/Float;", "setValue", "(F)V", "newValue", "(F)Ljava/lang/Float;", "toString", "", "Collections"})
    public static final class Entry
    implements Map.Entry<Integer, Float>,
    KMutableMap.Entry {
        @NotNull
        private final IntFloatMap map;
        private int key;
        private float value;

        public Entry(@NotNull IntFloatMap map) {
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            this.map = map;
        }

        @NotNull
        public final IntFloatMap getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        public void setKey(int n) {
            this.key = n;
        }

        @Override
        @NotNull
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void setValue(float f) {
            this.value = f;
        }

        @Override
        @NotNull
        public Float setValue(float newValue) {
            float oldValue = this.getValue().floatValue();
            Float f = Float.valueOf(newValue);
            ((Map)this.map).put(this.getKey(), f);
            this.setValue(newValue);
            return Float.valueOf(oldValue);
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue().floatValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntFloatMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/IntFloatMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntFloatMap.kt\ndorkbox/collections/IntFloatMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,993:1\n1#2:994\n*E\n"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IntFloatMap map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(@NotNull IntFloatMap map) {
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            this.map = map;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final IntFloatMap getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                int[] keyTable = this.map.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(0.0f);
            } else {
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] keyTable = this.map.getKeyTable();
                float[] valueTable = this.map.getValueTable();
                int mask = this.map.getMask();
                int next = i + 1 & mask;
                int key = 0;
                while (true) {
                    int n;
                    int it = n = keyTable[next];
                    boolean bl = false;
                    key = it;
                    if (n == 0) break;
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        valueTable[i] = valueTable[next];
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0;
                valueTable[i] = 0.0f;
                if (i != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                IntFloatMap intFloatMap = this.map;
                int n = intFloatMap.size_;
                intFloatMap.size_ = n + -1;
            }
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntFloatMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

