/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WurstTypeNamedScope
extends WurstType {
    private final boolean isStaticRef;
    private final List<WurstTypeBoundTypeParam> typeParameters;

    public WurstTypeNamedScope(List<WurstTypeBoundTypeParam> typeParameters, boolean isStaticRef) {
        this.isStaticRef = isStaticRef;
        this.typeParameters = typeParameters;
    }

    public WurstTypeNamedScope(List<WurstTypeBoundTypeParam> typeParameters) {
        this.isStaticRef = false;
        this.typeParameters = typeParameters;
    }

    public WurstTypeNamedScope(boolean isStaticRef) {
        this.isStaticRef = isStaticRef;
        this.typeParameters = Collections.emptyList();
    }

    @Override
    public String getName() {
        NamedScope def = this.getDef();
        if (def == null) {
            return "not found";
        }
        return def.getName();
    }

    public abstract @Nullable NamedScope getDef();

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public boolean isStaticRef() {
        return this.isStaticRef;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType obj, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        WurstTypeNamedScope other;
        if (obj instanceof WurstTypeNamedScope && (other = (WurstTypeNamedScope)obj).getDef() == this.getDef()) {
            return this.matchTypeParams(this.getTypeParameters(), other.getTypeParameters(), location, mapping, variablePosition);
        }
        return null;
    }

    public List<WurstTypeBoundTypeParam> getTypeParameters() {
        return this.typeParameters;
    }

    protected String printTypeParams() {
        if (this.typeParameters.size() == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder("<");
        for (int i = 0; i < this.typeParameters.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.typeParameters.get(i).getName());
        }
        return s + ">";
    }

    @Override
    public VariableBinding getTypeArgBinding() {
        VariableBinding res = VariableBinding.emptyMapping();
        for (WurstTypeBoundTypeParam tp : this.typeParameters) {
            res = res.set(tp.getTypeParamDef(), tp);
        }
        return res;
    }

    @Override
    public WurstType setTypeArgs(@NonNull VariableBinding typeParamBounds) {
        ArrayList newTypes = Lists.newArrayList();
        for (WurstTypeBoundTypeParam t : this.typeParameters) {
            newTypes.add(t.setTypeArgs(typeParamBounds));
        }
        return this.replaceTypeVars(newTypes);
    }

    public abstract WurstType replaceTypeVars(List<WurstTypeBoundTypeParam> var1);

    public WurstType replaceTypeVarsUsingTypeArgs(TypeExprList typeArgs) {
        if (typeArgs.isEmpty()) {
            return this;
        }
        ArrayList<WurstTypeBoundTypeParam> typeParams = new ArrayList<WurstTypeBoundTypeParam>();
        if (typeArgs.size() != this.typeParameters.size()) {
            typeArgs.addError("Expected " + this.typeParameters.size() + " type arguments, but got " + typeArgs.size());
        }
        for (int i = 0; i < typeArgs.size() && i < this.typeParameters.size(); ++i) {
            WurstTypeBoundTypeParam tp = this.typeParameters.get(i);
            TypeParamDef tpDef = tp.getTypeParamDef();
            TypeExpr typeArg = (TypeExpr)typeArgs.get(i);
            WurstType baseType = typeArg.attrTyp().dynamic();
            typeParams.add(new WurstTypeBoundTypeParam(tpDef, baseType, typeArg));
        }
        return this.replaceTypeVars(typeParams);
    }

    protected VariableBinding matchTypeParams(List<WurstTypeBoundTypeParam> list, List<WurstTypeBoundTypeParam> list2, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (list.size() != list2.size()) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            WurstType otherTp;
            WurstType thisTp = list.get(i).normalize();
            mapping = thisTp.matchTypes(otherTp = list2.get(i).normalize(), location, mapping, variablePosition);
            if (mapping != null) continue;
            return null;
        }
        return mapping;
    }

    @Override
    public boolean allowsDynamicDispatch() {
        return !this.isStaticRef();
    }

    public ImmutableMultimap<String, DefLink> nameLinks() {
        ImmutableMultimap<String, DefLink> res = this.getDef().attrNameLinks();
        VariableBinding binding = this.getTypeArgBinding();
        if (!binding.isEmpty()) {
            ImmutableMultimap.Builder resBuilder = ImmutableMultimap.builder();
            for (Map.Entry e : res.entries()) {
                resBuilder.put((Object)((String)e.getKey()), (Object)((DefLink)e.getValue()).withTypeArgBinding(this.getDef(), binding));
            }
            return resBuilder.build();
        }
        return res;
    }

    public ImmutableCollection<DefLink> nameLinks(String name) {
        return this.nameLinks().get((Object)name);
    }

    @Override
    public void addMemberMethods(Element node, String name, List<FuncLink> result) {
        for (DefLink defLink : this.nameLinks(name)) {
            ClassDef nearestClass;
            if (!(defLink instanceof FuncLink)) continue;
            FuncLink f = (FuncLink)defLink;
            if (f.getVisibility().isPublic()) {
                result.add(f);
                continue;
            }
            if (!f.getVisibility().isInherited()) continue;
            NamedScope def = this.getDef();
            if (!(def == null || node.attrNearestPackage() == def.attrNearestPackage() || (nearestClass = node.attrNearestClassDef()) != null && nearestClass.attrTypC().isSubtypeOf(this, node))) {
                f = f.withVisibility(Visibility.PROTECTED_OTHER);
            }
            result.add(f);
        }
    }

    @Override
    public Stream<FuncLink> getMemberMethods(Element node) {
        return this.nameLinks().values().stream().filter(n -> {
            WurstType receiverType = n.getReceiverType();
            return n instanceof FuncLink && receiverType != null;
        }).map(n -> (FuncLink)n);
    }

    @Override
    public boolean isNestedInside(WurstType other) {
        if (other instanceof WurstTypeNamedScope) {
            WurstTypeNamedScope wtns = (WurstTypeNamedScope)other;
            NamedScope scope = wtns.getDef();
            for (Element node = this.getDef(); node != null; node = node.getParent()) {
                if (node != scope) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isNullable() {
        return true;
    }
}

