/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.base.Preconditions;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.intermediatelang.optimizer.SideEffectAnalyzer;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVars;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.Replacer;
import de.peeeq.wurstscript.translation.imtranslation.AssertProperty;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class EliminateTuples {
    public static void eliminateTuplesProg(ImProg imProg, ImTranslator translator) {
        Runnable removeOldGlobals = EliminateTuples.transformVars(imProg.getGlobals(), translator);
        for (ImFunction f : imProg.getFunctions()) {
            EliminateTuples.transformFunctionReturnsAndParameters(f, translator);
        }
        for (ImFunction f : imProg.getFunctions()) {
            EliminateTuples.eliminateTuplesFunc(f, translator);
        }
        removeOldGlobals.run();
        translator.assertProperties(AssertProperty.NOTUPLES);
    }

    private static void transformFunctionReturnsAndParameters(ImFunction f, ImTranslator translator) {
        EliminateTuples.transformVars(f.getParameters(), translator).run();
        translator.setOriginalReturnValue(f, f.getReturnType());
        f.setReturnType(EliminateTuples.getFirstType(f.getReturnType()));
    }

    private static void eliminateTuplesFunc(ImFunction f, ImTranslator translator) {
        EliminateTuples.transformVars(f.getLocals(), translator).run();
        EliminateTuples.tryStep(f, translator, EliminateTuples::toTupleExpressions);
        EliminateTuples.tryStep(f, translator, EliminateTuples::normalizeTuplesInStatementExprs);
        EliminateTuples.tryStep(f, translator, EliminateTuples::removeTupleSelections);
        EliminateTuples.tryStep(f, translator, EliminateTuples::normalizeTuplesInStatementExprs);
        EliminateTuples.tryStep(f, translator, (stmts, translator1, fn) -> EliminateTuples.removeTupleExprs(0, stmts, translator1, fn));
    }

    private static void removeTupleSelections(ImStmts stmts, final ImTranslator tr, ImFunction f) {
        final Replacer replacer = new Replacer();
        stmts.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImTupleSelection ts) {
                super.visit(ts);
                if (!(ts.getTupleExpr() instanceof ImTupleExpr)) {
                    throw new CompileError(ts.attrTrace().attrSource(), "Wrong tuple selection: " + ts);
                }
                ImTupleExpr tupleExpr = (ImTupleExpr)ts.getTupleExpr();
                int ti = ts.getTupleIndex();
                ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
                ImExpr result = null;
                assert (ti >= 0);
                if (ti >= tupleExpr.getExprs().size()) {
                    throw new RuntimeException("invalid selection: " + ts);
                }
                for (int i = 0; i < tupleExpr.getExprs().size(); ++i) {
                    ImExpr te = (ImExpr)tupleExpr.getExprs().get(i);
                    de.peeeq.wurstscript.ast.Element trace = te.attrTrace();
                    te.setParent(null);
                    if (i != ti) {
                        EliminateTuples.extractSideEffect(te, stmts);
                        continue;
                    }
                    result = EliminateTuples.extractSideEffect(te, stmts);
                }
                assert (result != null);
                ImStatementExpr replacement1 = JassIm.ImStatementExpr(stmts, result);
                ImTupleExpr replacement2 = EliminateTuples.normalizeStatementExpr(replacement1, tr);
                if (replacement2 == null) {
                    replacer.replace(ts, replacement1);
                } else {
                    replacer.replace(ts, replacement2);
                }
            }
        });
    }

    private static void tryStep(ImFunction f, ImTranslator translator, Step step) {
        String before = f.toString();
        try {
            step.apply(f.getBody(), translator, f);
        }
        catch (Throwable t) {
            throw new RuntimeException("\n//// Before -----------\n" + before + "\n\n// After -------------------\n" + f, t);
        }
    }

    private static Runnable transformVars(ImVars vars, ImTranslator translator) {
        LinkedHashSet<ImVar> varsToRemove = new LinkedHashSet<ImVar>();
        ListIterator it = vars.listIterator();
        while (it.hasNext()) {
            ImVar v = (ImVar)it.next();
            Preconditions.checkNotNull((Object)v.getParent(), (Object)("null parent: " + v));
            if (!TypesHelper.typeContainsTuples(v.getType())) continue;
            ImTranslator.VarsForTupleResult varsForTuple = translator.getVarsForTuple(v);
            varsToRemove.add(v);
            for (ImVar nv : varsForTuple.allValues()) {
                it.add(nv);
            }
        }
        return () -> vars.removeAll(varsToRemove);
    }

    private static ImType getFirstType(ImType t) {
        if (t instanceof ImTupleType) {
            ImTupleType tt = (ImTupleType)t;
            return EliminateTuples.getFirstType(tt.getTypes().get(0));
        }
        return t;
    }

    private static void toTupleExpressions(ImStmts body, final ImTranslator translator, final ImFunction f) {
        final Replacer replacer = new Replacer();
        body.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess va) {
                if (va.attrTyp() instanceof ImTupleType) {
                    ImVar v = va.getVar();
                    ImTranslator.VarsForTupleResult vars = translator.getVarsForTuple(v);
                    ImExpr expr = vars.map(parts -> JassIm.ImTupleExpr(parts.collect(Collectors.toCollection(() -> JassIm.ImExprs(new ImExpr[0])))), JassIm::ImVarAccess);
                    replacer.replace(va, expr);
                }
            }

            @Override
            public void visit(ImVarArrayAccess va) {
                super.visit(va);
                if (va.attrTyp() instanceof ImTupleType) {
                    ImExprs indexes = va.getIndexes();
                    ImExprs indexExprs = JassIm.ImExprs(new ImExpr[0]);
                    ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
                    boolean sideEffects = indexes.stream().anyMatch(SideEffectAnalyzer::quickcheckHasSideeffects);
                    for (ImExpr ie : indexes) {
                        if (sideEffects) {
                            ImVar tempIndex = JassIm.ImVar(ie.attrTrace(), TypesHelper.imInt(), "tempIndex", false);
                            indexExprs.add(JassIm.ImVarAccess(tempIndex));
                            f.getLocals().add(tempIndex);
                            ie.setParent(null);
                            stmts.add(JassIm.ImSet(va.attrTrace(), JassIm.ImVarAccess(tempIndex), ie));
                            continue;
                        }
                        ie.setParent(null);
                        indexExprs.add(ie);
                    }
                    ImVar v = va.getVar();
                    ImTranslator.VarsForTupleResult vars = translator.getVarsForTuple(v);
                    ImExpr expr = vars.map(parts -> JassIm.ImTupleExpr(parts.collect(Collectors.toCollection(() -> JassIm.ImExprs(new ImExpr[0])))), var -> JassIm.ImVarArrayAccess(va.getTrace(), var, indexExprs.copy()));
                    if (stmts.isEmpty()) {
                        replacer.replace(va, expr);
                    } else {
                        replacer.replace(va, JassIm.ImStatementExpr(stmts, expr));
                    }
                }
            }

            @Override
            public void visit(ImFunctionCall fc) {
                super.visit(fc);
                if (translator.getOriginalReturnValue(fc.getFunc()) instanceof ImTupleType) {
                    Element parent = fc.getParent();
                    fc.setParent(null);
                    ImTranslator.VarsForTupleResult returnVars = translator.getTupleTempReturnVarsFor(fc.getFunc());
                    ImVar firstVar = returnVars.allValuesStream().findFirst().get();
                    ImExpr newFc = returnVars.map(parts -> JassIm.ImTupleExpr(parts.collect(Collectors.toCollection(() -> JassIm.ImExprs(new ImExpr[0])))), var -> var == firstVar ? fc.copy() : JassIm.ImVarAccess(var));
                    replacer.replaceInParent(parent, fc, newFc);
                }
            }
        });
    }

    private static void normalizeTuplesInStatementExprs(ImStmts body, final ImTranslator translator, ImFunction f) {
        final Replacer replacer = new Replacer();
        body.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImStatementExpr se) {
                super.visit(se);
                ImTupleExpr newExpr = EliminateTuples.normalizeStatementExpr(se, translator);
                if (newExpr != null) {
                    replacer.replace(se, newExpr);
                    ((ImExpr)newExpr.getExprs().get(0)).accept(this);
                }
            }
        });
    }

    private static ImTupleExpr normalizeStatementExpr(ImStatementExpr se, ImTranslator translator) {
        if (se.getExpr() instanceof ImTupleExpr) {
            ImTupleExpr te = (ImTupleExpr)se.getExpr();
            translator.assertProperties(Collections.emptySet(), te);
            ImStmts seStmts = se.getStatements();
            seStmts.setParent(null);
            ImExpr firstExpr = (ImExpr)te.getExprs().remove(0);
            ImStatementExpr newStatementExpr = JassIm.ImStatementExpr(seStmts, firstExpr);
            te.getExprs().add(0, newStatementExpr);
            te.setParent(null);
            translator.assertProperties(Collections.emptySet(), te.getExprs());
            return te;
        }
        return null;
    }

    private static void removeTupleExprs(int posHint, Element elem, ImTranslator translator, ImFunction f) {
        if (elem.getParent() == null) {
            throw new RuntimeException("elem not used: " + elem);
        }
        for (int i = 0; i < elem.size(); ++i) {
            Element child = elem.get(i);
            EliminateTuples.removeTupleExprs(i, child, translator, f);
        }
        Replacer replacer = new Replacer();
        for (int i = 0; i < elem.size(); ++i) {
            Element newElem;
            Element child = elem.get(i);
            if (!(child instanceof ImTupleExpr)) continue;
            ImTupleExpr tupleExpr = (ImTupleExpr)child;
            if (elem instanceof ImTupleSelection) {
                newElem = EliminateTuples.inTupleSelection((ImTupleSelection)elem, tupleExpr, f);
            } else if (elem instanceof ImReturn) {
                newElem = EliminateTuples.inReturn((ImReturn)elem, tupleExpr, translator, f);
            } else if (elem instanceof ImSet) {
                ImSet imSet = (ImSet)elem;
                newElem = EliminateTuples.inSet(imSet, f);
            } else {
                List tupleExprs;
                if (elem instanceof ImExprs) {
                    ImExprs exprs = (ImExprs)elem;
                    if (exprs.getParent() instanceof ImOperatorCall) {
                        ImOperatorCall opCall = (ImOperatorCall)exprs.getParent();
                        EliminateTuples.handleTupleInOpCall(replacer, opCall);
                        return;
                    }
                    exprs.remove(i);
                    tupleExprs = tupleExpr.getExprs().removeAll();
                    exprs.addAll(i, (Collection)tupleExprs);
                    --i;
                    continue;
                }
                if (elem instanceof ImStmts) {
                    ImStmts stmts = (ImStmts)elem;
                    stmts.remove(i);
                    tupleExprs = tupleExpr.getExprs().removeAll();
                    stmts.addAll(i, (Collection)tupleExprs);
                    --i;
                    continue;
                }
                throw new CompileError(tupleExpr.attrTrace().attrSource(), "Unhandled tuple position: " + elem.getClass().getSimpleName() + " // " + elem);
            }
            replacer.hintPosition(posHint);
            replacer.replace(elem, newElem);
            return;
        }
    }

    private static void handleTupleInOpCall(Replacer replacer, ImOperatorCall opCall) {
        ImExpr newExpr;
        if (opCall.getParent() == null) {
            throw new RuntimeException("opCall not used: " + opCall);
        }
        ImTupleExpr left = (ImTupleExpr)opCall.getArguments().get(0);
        ImTupleExpr right = (ImTupleExpr)opCall.getArguments().get(1);
        WurstOperator op = opCall.getOp();
        ArrayList<ImOperatorCall> componentComparisons = new ArrayList<ImOperatorCall>();
        for (int i = 0; i < left.getExprs().size(); ++i) {
            ImExpr l2 = (ImExpr)left.getExprs().get(i);
            ImExpr r2 = (ImExpr)right.getExprs().get(i);
            l2.setParent(null);
            r2.setParent(null);
            componentComparisons.add(JassIm.ImOperatorCall(op, JassIm.ImExprs(l2, r2)));
        }
        if (op == WurstOperator.EQ) {
            newExpr = (ImExpr)componentComparisons.stream().reduce((l, r) -> JassIm.ImOperatorCall(WurstOperator.AND, JassIm.ImExprs(l, r))).get();
        } else {
            assert (op == WurstOperator.NOTEQ);
            newExpr = (ImExpr)componentComparisons.stream().reduce((l, r) -> JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(l, r))).get();
        }
        replacer.replace(opCall, newExpr);
    }

    private static ImStatementExpr inSet(ImSet imSet, ImFunction f) {
        if (!(imSet.getLeft() instanceof ImTupleExpr) || !(imSet.getRight() instanceof ImTupleExpr)) {
            throw new RuntimeException("invalid set statement:\n" + imSet);
        }
        ImTupleExpr left = (ImTupleExpr)imSet.getLeft();
        ImTupleExpr right = (ImTupleExpr)imSet.getRight();
        ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
        ArrayList<ImExpr> leftExprs = new ArrayList<ImExpr>();
        for (Object expr : left.getExprs()) {
            leftExprs.add(EliminateTuples.extractSideEffect((ImExpr)expr, stmts));
        }
        ArrayList<ImVar> tempVars = new ArrayList<ImVar>();
        for (ImExpr expr : right.getExprs()) {
            ImVar temp = JassIm.ImVar(expr.attrTrace(), expr.attrTyp(), "tuple_temp", false);
            expr.setParent(null);
            stmts.add(JassIm.ImSet(expr.attrTrace(), JassIm.ImVarAccess(temp), expr));
            tempVars.add(temp);
            f.getLocals().add(temp);
        }
        for (int i = 0; i < leftExprs.size(); ++i) {
            ImLExpr leftE = (ImLExpr)leftExprs.get(i);
            leftE.setParent(null);
            stmts.add(JassIm.ImSet(imSet.getTrace(), leftE, JassIm.ImVarAccess((ImVar)tempVars.get(i))));
        }
        return ImHelper.statementExprVoid(stmts);
    }

    private static ImStatementExpr inReturn(ImReturn parent, ImTupleExpr tupleExpr, ImTranslator translator, ImFunction f) {
        ImTranslator.VarsForTupleResult returnVars1 = translator.getTupleTempReturnVarsFor(f);
        List returnVars = returnVars1.allValuesStream().collect(Collectors.toList());
        ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
        for (int i = 0; i < returnVars.size(); ++i) {
            ImVar rv = (ImVar)returnVars.get(i);
            ImExpr te = (ImExpr)tupleExpr.getExprs().get(i);
            te.setParent(null);
            stmts.add(JassIm.ImSet(parent.getTrace(), JassIm.ImVarAccess(rv), te));
        }
        stmts.add(JassIm.ImReturn(parent.getTrace(), JassIm.ImVarAccess((ImVar)returnVars.get(0))));
        return ImHelper.statementExprVoid(stmts);
    }

    private static Element inTupleSelection(ImTupleSelection ts, ImTupleExpr tupleExpr, ImFunction f) {
        assert (ts.getTupleExpr() == tupleExpr);
        int ti = ts.getTupleIndex();
        ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
        ImExpr result = null;
        for (int i = 0; i < tupleExpr.getExprs().size(); ++i) {
            ImExpr te = (ImExpr)tupleExpr.getExprs().get(i);
            de.peeeq.wurstscript.ast.Element trace = te.attrTrace();
            te.setParent(null);
            if (i != ti) {
                stmts.add(te);
                continue;
            }
            if (i == tupleExpr.getExprs().size() - 1) {
                result = te;
                continue;
            }
            if (ts.isUsedAsLValue()) {
                result = EliminateTuples.extractSideEffect(te, stmts);
                continue;
            }
            ImVar temp = JassIm.ImVar(trace, te.attrTyp(), "tupleSelection", false);
            f.getLocals().add(temp);
            stmts.add(JassIm.ImSet(trace, JassIm.ImVarAccess(temp), te));
            result = JassIm.ImVarAccess(temp);
        }
        assert (result != null);
        return JassIm.ImStatementExpr(stmts, result);
    }

    private static ImExpr extractSideEffect(ImExpr e, List<ImStmt> into) {
        ImExpr firstExpr;
        ImExpr newFirstExpr;
        ImTupleExpr te;
        if (e instanceof ImStatementExpr) {
            ImStatementExpr se = (ImStatementExpr)e;
            for (ImStmt s : se.getStatements()) {
                s.setParent(null);
                into.add(s);
            }
            ImExpr expr = se.getExpr();
            expr.setParent(null);
            return EliminateTuples.extractSideEffect(expr, into);
        }
        if (e instanceof ImTupleExpr && !(te = (ImTupleExpr)e).getExprs().isEmpty() && (newFirstExpr = EliminateTuples.extractSideEffect(firstExpr = (ImExpr)te.getExprs().get(0), into)) != firstExpr) {
            te.getExprs().set(0, (Object)newFirstExpr);
        }
        return e;
    }

    private static ImExprs accessVars(List<ImVar> tempIndexes) {
        return tempIndexes.stream().map(JassIm::ImVarAccess).collect(Collectors.toCollection(() -> JassIm.ImExprs(new ImExpr[0])));
    }

    static interface Step {
        public void apply(ImStmts var1, ImTranslator var2, ImFunction var3);
    }
}

