/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.AstElementWithNameId;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassRelatedExprWithClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarRead;
import de.peeeq.wurstscript.jassIm.ImVars;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtojass.TypeRewriteMatcher;
import de.peeeq.wurstscript.translation.imtojass.TypeRewriter;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ClassManagementVars;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlag;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.IntRange;
import de.peeeq.wurstscript.translation.imtranslation.RecycleCodeGenerator;
import de.peeeq.wurstscript.translation.imtranslation.RecycleCodeGeneratorQueue;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class EliminateClasses {
    public static final String TYPE_ID_TO_TYPE_NAME = "typeIdToTypeName";
    public static final String MAX_TYPE_ID = "maxTypeId";
    public static final String INSTANCE_COUNT = "instanceCount";
    public static final String MAX_INSTANCE_COUNT = "maxInstanceCount";
    private final ImTranslator translator;
    private final ImProg prog;
    private final Map<ImVar, ImVar> fieldToArray = Maps.newLinkedHashMap();
    private final Map<ImMethod, ImFunction> dispatchFuncs = Maps.newLinkedHashMap();
    private final RecycleCodeGenerator recycleCodeGen = new RecycleCodeGeneratorQueue();
    private final boolean checkedDispatch;
    private final Set<String> specialNatives = ImmutableSet.of((Object)"typeIdToTypeName", (Object)"maxTypeId", (Object)"instanceCount", (Object)"maxInstanceCount");
    private ImFunction typeIdToTypeNameFunc;
    private ImFunction maxTypeIdFunc;
    private ImFunction instanceCountFunc;
    private ImFunction maxInstanceCountFunc;

    public EliminateClasses(ImTranslator tr, ImProg prog, boolean checkedDispatch) {
        this.translator = tr;
        this.prog = prog;
        this.checkedDispatch = checkedDispatch;
    }

    public void eliminateClasses() {
        this.createReflectionFunctions();
        this.moveFunctionsOutOfClasses();
        for (ImClass c : this.prog.getClasses()) {
            this.eliminateClass(c);
        }
        for (ImMethod m : this.prog.getMethods()) {
            ImClass c = m.getMethodClass().getClassDef();
            this.createDispatchFunc(c, m);
        }
        for (ImFunction f : this.prog.getFunctions()) {
            this.eliminateClassRelatedExprs(f.getBody());
        }
        this.prog.getClasses().clear();
        this.prog.getMethods().clear();
        this.eliminateClassTypes();
    }

    private void createReflectionFunctions() {
        this.typeIdToTypeNameFunc = this.accessClassManagementVar(TYPE_ID_TO_TYPE_NAME, TypesHelper.imString(), JassIm.ImStringVal("unknown"), c -> JassIm.ImStringVal(EliminateClasses.calculateClassName(c)));
        this.instanceCountFunc = this.accessClassManagementVar(INSTANCE_COUNT, TypesHelper.imInt(), JassIm.ImIntVal(0), c -> JassIm.ImOperatorCall(WurstOperator.MINUS, JassIm.ImExprs(JassIm.ImVarAccess(this.translator.getClassManagementVarsFor((ImClass)c).maxIndex), JassIm.ImVarAccess(this.translator.getClassManagementVarsFor((ImClass)c).freeCount))));
        this.maxInstanceCountFunc = this.accessClassManagementVar(MAX_INSTANCE_COUNT, TypesHelper.imInt(), JassIm.ImIntVal(0), c -> JassIm.ImVarAccess(this.translator.getClassManagementVarsFor((ImClass)c).maxIndex));
        this.maxTypeIdFunc = this.maxTypeIdFunc();
    }

    @NotNull
    private ImFunction maxTypeIdFunc() {
        ImVars parameters = JassIm.ImVars(new ImVar[0]);
        int maxTypeId = EliminateClasses.calculateMaxTypeId(this.prog);
        ImFunction f = JassIm.ImFunction(this.prog.getTrace(), MAX_TYPE_ID, JassIm.ImTypeVars(new ImTypeVar[0]), parameters, TypesHelper.imInt(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(JassIm.ImReturn(this.prog.getTrace(), JassIm.ImIntVal(maxTypeId))), Collections.emptyList());
        this.prog.getFunctions().add(f);
        return f;
    }

    public static int calculateMaxTypeId(ImProg prog) {
        return prog.attrTypeId().values().stream().mapToInt(x -> x).max().orElse(-1);
    }

    @NotNull
    private ImFunction accessClassManagementVar(String funcName, ImType returnType, ImExpr defaultReturn, Function<ImClass, ImExpr> makeAccess) {
        de.peeeq.wurstscript.ast.Element trace = this.prog.getTrace();
        ImVar typeId = JassIm.ImVar(trace, TypesHelper.imInt(), "typeId", false);
        ImVars parameters = JassIm.ImVars(typeId);
        ImVars locals = JassIm.ImVars(new ImVar[0]);
        Map<ImClass, Integer> classId = this.prog.attrTypeId();
        int maxTypeId = EliminateClasses.calculateMaxTypeId(this.prog);
        ImClass[] typeIdToClass = new ImClass[maxTypeId + 1];
        for (Map.Entry<ImClass, Integer> e : classId.entrySet()) {
            typeIdToClass[e.getValue().intValue()] = e.getKey();
        }
        ImStmts body = this.generateBinarySearch(1, maxTypeId, typeId, typeIdToClass, makeAccess);
        body.add(JassIm.ImReturn(trace, defaultReturn));
        ImFunction f = JassIm.ImFunction(trace, funcName, JassIm.ImTypeVars(new ImTypeVar[0]), parameters, returnType, locals, body, Collections.emptyList());
        this.prog.getFunctions().add(f);
        return f;
    }

    private ImStmts generateBinarySearch(int lower, int upper, ImVar typeId, ImClass[] typeIdToClass, Function<ImClass, ImExpr> makeAccess) {
        if (lower > upper) {
            return JassIm.ImStmts(new ImStmt[0]);
        }
        if (lower == upper) {
            return JassIm.ImStmts(JassIm.ImReturn(this.prog.getTrace(), makeAccess.apply(typeIdToClass[lower])));
        }
        int mid = lower + (upper - lower) / 2;
        return JassIm.ImStmts(JassIm.ImIf(this.prog.getTrace(), JassIm.ImOperatorCall(WurstOperator.LESS_EQ, JassIm.ImExprs(JassIm.ImVarAccess(typeId), JassIm.ImIntVal(mid))), this.generateBinarySearch(lower, mid, typeId, typeIdToClass, makeAccess), this.generateBinarySearch(mid + 1, upper, typeId, typeIdToClass, makeAccess)));
    }

    public static String calculateClassName(ImClass c) {
        de.peeeq.wurstscript.ast.Element trace = c.attrTrace();
        if (trace instanceof ClassOrInterface) {
            ClassOrInterface t = (ClassOrInterface)trace;
            return EliminateClasses.makeName(t);
        }
        return c.getName();
    }

    private static String makeName(ClassOrInterface t) {
        ClassOrInterface parent = t.getParent().attrNearestClassOrInterface();
        if (parent != null) {
            return EliminateClasses.makeName(parent) + "." + t.getName();
        }
        PackageOrGlobal p = t.attrNearestPackage();
        if (p instanceof WPackage) {
            return ((WPackage)p).getName() + "." + t.getName();
        }
        return t.getName();
    }

    private void eliminateClassTypes() {
        TypeRewriter.rewriteTypes(this.prog, this::eliminateClassTypes);
    }

    private ImType eliminateClassTypes(ImType imType) {
        return imType.match(new TypeRewriteMatcher(){

            @Override
            public ImType case_ImClassType(ImClassType t) {
                return TypesHelper.imInt();
            }
        });
    }

    private void moveFunctionsOutOfClasses() {
        for (ImClass c : this.prog.getClasses()) {
            this.prog.getFunctions().addAll((Collection)c.getFunctions().removeAll());
        }
    }

    private void eliminateClass(ImClass c) {
        for (ImVar f : c.getFields()) {
            ImType type = ImHelper.toArray(f.getType());
            ImVar v = JassIm.ImVar(f.getTrace(), type, f.getName(), false);
            this.prog.getGlobals().add(v);
            this.fieldToArray.put(f, v);
        }
        for (ImMethod m : c.getMethods()) {
            this.createDispatchFunc(c, m);
        }
        this.recycleCodeGen.createAllocFunc(this.translator, this.prog, c);
        this.recycleCodeGen.createDeallocFunc(this.translator, this.prog, c);
    }

    public void createDispatchFunc(ImClass c, ImMethod m) {
        ImVar resultVar;
        ArrayList methods = Lists.newArrayList();
        this.addSubMethods(m, methods);
        List<Pair<IntRange, ImMethod>> ranges = this.calculateTypeIdRanges(c, methods);
        ArrayList<FunctionFlag> flags = new ArrayList<FunctionFlag>();
        if (m.getImplementation().hasFlag(FunctionFlagEnum.IS_VARARG)) {
            flags.add(FunctionFlagEnum.IS_VARARG);
        }
        ImFunction df = JassIm.ImFunction(m.getTrace(), "dispatch_" + c.getName() + "_" + m.getName(), JassIm.ImTypeVars(new ImTypeVar[0]), m.getImplementation().getParameters().copy(), m.getImplementation().getReturnType(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), flags);
        this.prog.getFunctions().add(df);
        this.dispatchFuncs.put(m, df);
        ImType returnType = df.getReturnType();
        if (ranges.isEmpty()) {
            if (!(returnType instanceof ImVoid)) {
                ImExpr rv = ImHelper.defaultValueForComplexType(returnType);
                df.getBody().add(JassIm.ImReturn(df.getTrace(), rv));
            }
            return;
        }
        if (returnType instanceof ImVoid) {
            resultVar = null;
        } else {
            resultVar = JassIm.ImVar(df.getTrace(), returnType, m.getName() + "_result", false);
            df.getLocals().add(resultVar);
        }
        ClassManagementVars mVars = this.translator.getClassManagementVarsFor(c);
        ImVar thisVar = (ImVar)df.getParameters().get(0);
        ImVarArrayAccess typeId = JassIm.ImVarArrayAccess(m.getTrace(), mVars.typeId, JassIm.ImExprs(JassIm.ImVarAccess(thisVar)));
        if (this.checkedDispatch) {
            de.peeeq.wurstscript.ast.Element trace = m.attrTrace();
            String methodName = this.getMethodName(m);
            df.getBody().add(JassIm.ImIf(df.getTrace(), JassIm.ImOperatorCall(WurstOperator.EQ, JassIm.ImExprs(typeId.copy(), JassIm.ImIntVal(0))), JassIm.ImStmts(JassIm.ImIf(df.getTrace(), JassIm.ImOperatorCall(WurstOperator.EQ, JassIm.ImExprs(JassIm.ImVarAccess(thisVar), JassIm.ImIntVal(0))), JassIm.ImStmts(this.translator.imError(trace, JassIm.ImStringVal("Nullpointer exception when calling " + c.getName() + "." + methodName))), JassIm.ImStmts(this.translator.imError(trace, JassIm.ImStringVal("Called " + c.getName() + "." + methodName + " on invalid object."))))), JassIm.ImStmts(new ImStmt[0])));
        }
        this.createDispatch(df, df.getBody(), resultVar, typeId, ranges, 0, ranges.size() - 1);
        if (resultVar != null) {
            df.getBody().add(JassIm.ImReturn(df.getTrace(), JassIm.ImVarAccess(resultVar)));
        }
    }

    private String getMethodName(ImMethod m) {
        de.peeeq.wurstscript.ast.Element trace = m.attrTrace();
        String methodName = m.getName();
        if (trace instanceof AstElementWithNameId) {
            methodName = ((AstElementWithNameId)trace).getNameId().getName();
        }
        return methodName;
    }

    private void createDispatch(ImFunction df, ImStmts stmts, ImVar resultVar, ImExpr typeId, List<Pair<IntRange, ImMethod>> ranges, int start, int end) {
        if (start == end) {
            ImExprs arguments = JassIm.ImExprs(new ImExpr[0]);
            for (ImVar p : df.getParameters()) {
                arguments.add(JassIm.ImVarAccess(p));
            }
            ImFunctionCall call = JassIm.ImFunctionCall(df.getTrace(), ranges.get(start).getB().getImplementation(), JassIm.ImTypeArguments(new ImTypeArgument[0]), arguments, false, CallType.NORMAL);
            if (resultVar == null) {
                stmts.add(call);
            } else {
                stmts.add(JassIm.ImSet(df.getTrace(), JassIm.ImVarAccess(resultVar), call));
            }
        } else {
            int mid = (start + end) / 2;
            ImStmts thenBlock = JassIm.ImStmts(new ImStmt[0]);
            ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
            ImOperatorCall condition = JassIm.ImOperatorCall(WurstOperator.LESS_EQ, JassIm.ImExprs(typeId.copy(), JassIm.ImIntVal(ranges.get((int)mid).getA().end)));
            stmts.add(JassIm.ImIf(df.getTrace(), condition, thenBlock, elseBlock));
            this.createDispatch(df, thenBlock, resultVar, typeId, ranges, start, mid);
            this.createDispatch(df, elseBlock, resultVar, typeId, ranges, mid + 1, end);
        }
    }

    private void addSubMethods(ImMethod m, List<ImMethod> methods) {
        if (!m.getIsAbstract()) {
            methods.add(m);
        }
        for (ImMethod mm : m.getSubMethods()) {
            this.addSubMethods(mm, methods);
        }
    }

    private List<Pair<IntRange, ImMethod>> calculateTypeIdRanges(ImClass c, List<ImMethod> methods) {
        int i;
        LinkedHashMap typeIdToMethod = Maps.newLinkedHashMap();
        this.calculateTypeIdToMethodHelper(c, methods, null, typeIdToMethod);
        int min = Integer.MAX_VALUE;
        int max = 0;
        Iterator iterator = typeIdToMethod.keySet().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            min = Math.min(min, i);
            max = Math.max(max, i);
        }
        ArrayList result = Lists.newArrayList();
        for (i = min; i <= max; ++i) {
            ImMethod f = (ImMethod)typeIdToMethod.get(i);
            if (f == null) continue;
            int j = i;
            while (typeIdToMethod.get(j) == f) {
                ++j;
            }
            result.add(Pair.create(new IntRange(i, j - 1), f));
            i = j - 1;
        }
        return result;
    }

    private void calculateTypeIdToMethodHelper(ImClass c, List<ImMethod> methods, ImMethod current, Map<Integer, ImMethod> typeIdToMethod) {
        for (ImMethod m : methods) {
            if (m.attrClass() != c) continue;
            current = m;
            break;
        }
        if (current != null) {
            typeIdToMethod.put(c.attrTypeId(), current);
        }
        for (ImClass sc : c.attrSubclasses()) {
            this.calculateTypeIdToMethodHelper(sc, methods, current, typeIdToMethod);
        }
    }

    private void eliminateClassRelatedExprs(Element body) {
        final ArrayList mas = Lists.newArrayList();
        final ArrayList mcs = Lists.newArrayList();
        final ArrayList allocs = Lists.newArrayList();
        final ArrayList deallocs = Lists.newArrayList();
        final ArrayList instaneofs = Lists.newArrayList();
        final ArrayList typeIdObjs = Lists.newArrayList();
        final ArrayList typeIdClasses = Lists.newArrayList();
        final ArrayList nativeCalls = Lists.newArrayList();
        body.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImMemberAccess e) {
                super.visit(e);
                mas.add(e);
            }

            @Override
            public void visit(ImMethodCall e) {
                super.visit(e);
                mcs.add(e);
            }

            @Override
            public void visit(ImAlloc e) {
                super.visit(e);
                allocs.add(e);
            }

            @Override
            public void visit(ImDealloc e) {
                super.visit(e);
                deallocs.add(e);
            }

            @Override
            public void visit(ImInstanceof e) {
                super.visit(e);
                instaneofs.add(e);
            }

            @Override
            public void visit(ImTypeIdOfClass e) {
                super.visit(e);
                typeIdClasses.add(e);
            }

            @Override
            public void visit(ImTypeIdOfObj e) {
                super.visit(e);
                typeIdObjs.add(e);
            }

            @Override
            public void visit(ImFunctionCall fc) {
                super.visit(fc);
                ImFunction func = fc.getFunc();
                if (!func.hasFlag(FunctionFlagEnum.IS_NATIVE)) {
                    return;
                }
                if (EliminateClasses.this.specialNatives.contains(func.getName())) {
                    nativeCalls.add(fc);
                }
            }
        });
        for (ImMemberAccess ma : mas) {
            this.replaceMemberAccess(ma);
        }
        for (ImMethodCall mc : mcs) {
            this.replaceMethodCall(mc);
        }
        for (ImAlloc imAlloc : allocs) {
            this.replaceAlloc(imAlloc);
        }
        for (ImDealloc imDealloc : deallocs) {
            this.replaceDealloc(imDealloc);
        }
        for (ImClassRelatedExprWithClass e : instaneofs) {
            this.replaceInstanceof((ImInstanceof)e);
        }
        for (ImClassRelatedExprWithClass e : typeIdClasses) {
            this.replaceTypeIdOfClass((ImTypeIdOfClass)e);
        }
        for (ImClassRelatedExprWithClass e : typeIdObjs) {
            this.replaceTypeIdOfObj((ImTypeIdOfObj)e);
        }
        for (ImFunctionCall nativeCall : nativeCalls) {
            this.rewriteObjectNative(nativeCall);
        }
    }

    private void rewriteObjectNative(ImFunctionCall nativeCall) {
        ImFunction func = nativeCall.getFunc();
        switch (func.getName()) {
            case "typeIdToTypeName": {
                nativeCall.setFunc(this.typeIdToTypeNameFunc);
                break;
            }
            case "maxTypeId": {
                nativeCall.setFunc(this.maxTypeIdFunc);
                break;
            }
            case "instanceCount": {
                nativeCall.setFunc(this.instanceCountFunc);
                break;
            }
            case "maxInstanceCount": {
                nativeCall.setFunc(this.maxInstanceCountFunc);
                break;
            }
            default: {
                throw new RuntimeException("unhandled case: " + func.getName());
            }
        }
    }

    private void replaceTypeIdOfObj(ImTypeIdOfObj e) {
        ImVar typeIdVar = this.translator.getClassManagementVarsFor((ImClass)e.getClazz().getClassDef()).typeId;
        ImExpr obj = e.getObj();
        obj.setParent(null);
        e.replaceBy(JassIm.ImVarArrayAccess(e.attrTrace(), typeIdVar, JassIm.ImExprs(obj)));
    }

    private void replaceTypeIdOfClass(ImTypeIdOfClass e) {
        e.replaceBy(JassIm.ImIntVal(e.getClazz().getClassDef().attrTypeId()));
    }

    private void replaceInstanceof(ImInstanceof e) {
        ImFunction f = e.getNearestFunc();
        List<ImClass> allSubClasses = this.getAllSubclasses(e.getClazz().getClassDef());
        List<Integer> subClassIds = allSubClasses.stream().map(ImClass::attrTypeId).collect(Collectors.toList());
        List<IntRange> idRanges = IntRange.createFromIntList(subClassIds);
        ImExpr obj = e.getObj();
        obj.setParent(null);
        ImVar typeIdVar = this.translator.getClassManagementVarsFor((ImClass)e.getClazz().getClassDef()).typeId;
        ImVarArrayAccess objTypeId = JassIm.ImVarArrayAccess(e.attrTrace(), typeIdVar, JassIm.ImExprs(obj));
        boolean useTempVar = idRanges.size() >= 2 || idRanges.get((int)0).start < idRanges.get((int)0).end;
        ImVar tempVar = null;
        ImVarRead objTypeIdExpr = objTypeId;
        if (useTempVar) {
            tempVar = JassIm.ImVar(e.attrTrace(), TypesHelper.imInt(), "instanceOfTemp", false);
            f.getLocals().add(tempVar);
            objTypeIdExpr = JassIm.ImVarAccess(tempVar);
        }
        ImExpr newExpr = null;
        for (IntRange intRange : idRanges) {
            newExpr = this.or(newExpr, this.inRange((ImExpr)((Object)objTypeIdExpr), intRange));
        }
        if (useTempVar) {
            newExpr = JassIm.ImStatementExpr(JassIm.ImStmts(JassIm.ImSet(f.getTrace(), JassIm.ImVarAccess(tempVar), objTypeId)), newExpr);
        }
        e.replaceBy(newExpr);
    }

    private ImExpr or(ImExpr a, ImExpr b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(a, b));
    }

    private ImExpr inRange(ImExpr obj, IntRange range) {
        if (range.start == range.end) {
            return JassIm.ImOperatorCall(WurstOperator.EQ, JassIm.ImExprs(obj.copy(), JassIm.ImIntVal(range.start)));
        }
        return JassIm.ImOperatorCall(WurstOperator.AND, JassIm.ImExprs(JassIm.ImOperatorCall(WurstOperator.GREATER_EQ, JassIm.ImExprs(obj.copy(), JassIm.ImIntVal(range.start))), JassIm.ImOperatorCall(WurstOperator.LESS_EQ, JassIm.ImExprs(obj.copy(), JassIm.ImIntVal(range.end)))));
    }

    private List<ImClass> getAllSubclasses(ImClass clazz) {
        ArrayList result = Lists.newArrayList();
        this.getAllSubclassesH(result, clazz);
        return result;
    }

    private void getAllSubclassesH(List<ImClass> result, ImClass clazz) {
        result.add(clazz);
        for (ImClass sc : clazz.attrSubclasses()) {
            this.getAllSubclassesH(result, sc);
        }
    }

    private void replaceDealloc(ImDealloc e) {
        ImFunction deallocFunc = this.translator.deallocFunc.getFor(e.getClazz().getClassDef());
        ImExpr obj = e.getObj();
        obj.setParent(null);
        e.replaceBy(JassIm.ImFunctionCall(e.attrTrace(), deallocFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(obj), false, CallType.NORMAL));
    }

    private void replaceAlloc(ImAlloc e) {
        ImFunction allocFunc = this.translator.allocFunc.getFor(e.getClazz().getClassDef());
        e.replaceBy(JassIm.ImFunctionCall(e.attrTrace(), allocFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL));
    }

    private void replaceMethodCall(ImMethodCall mc) {
        ImExpr receiver = mc.getReceiver();
        receiver.setParent(null);
        ImExprs arguments = JassIm.ImExprs(receiver);
        arguments.addAll((Collection)mc.getArguments().removeAll());
        ImFunction dispatch = this.dispatchFuncs.get(mc.getMethod());
        if (dispatch == null) {
            throw new CompileError(mc.attrTrace().attrSource(), "Could not find dispatch for " + mc.getMethod().getName());
        }
        mc.replaceBy(JassIm.ImFunctionCall(mc.getTrace(), dispatch, JassIm.ImTypeArguments(new ImTypeArgument[0]), arguments, false, CallType.NORMAL));
    }

    private void replaceMemberAccess(ImMemberAccess ma) {
        ImExpr receiver = ma.getReceiver();
        receiver.setParent(null);
        ImVar fieldArray = this.fieldToArray.get(ma.getVar());
        if (fieldArray == null) {
            throw new CompileError(ma, "Could not find field array for " + ma);
        }
        ImExprs indexes = JassIm.ImExprs(receiver);
        indexes.addAll((Collection)ma.getIndexes().removeAll());
        ma.replaceBy(JassIm.ImVarArrayAccess(ma.attrTrace(), fieldArray, indexes));
    }
}

