/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import de.peeeq.datastructures.TransitiveClosure;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImBoolVal;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImGetStackTrace;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImRealVal;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVarDispatch;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SideEffectAnalyzer {
    private final ImProg prog;
    private Multimap<ImFunction, ImFunction> callRelation;
    private TransitiveClosure<ImFunction> callRelationTr;
    private Multimap<ImFunction, ImVar> usedGlobals;

    public SideEffectAnalyzer(ImProg prog) {
        this.prog = prog;
    }

    public static boolean quickcheckHasSideeffects(ImExpr expr) {
        return expr.match(new ImExpr.Matcher<Boolean>(){

            @Override
            public Boolean case_ImFunctionCall(ImFunctionCall imFunctionCall) {
                return true;
            }

            @Override
            public Boolean case_ImTypeIdOfClass(ImTypeIdOfClass imTypeIdOfClass) {
                return false;
            }

            @Override
            public Boolean case_ImVarArrayAccess(ImVarArrayAccess e) {
                return e.getIndexes().stream().anyMatch(SideEffectAnalyzer::quickcheckHasSideeffects);
            }

            @Override
            public Boolean case_ImRealVal(ImRealVal imRealVal) {
                return false;
            }

            @Override
            public Boolean case_ImTupleSelection(ImTupleSelection e) {
                return SideEffectAnalyzer.quickcheckHasSideeffects(e.getTupleExpr());
            }

            @Override
            public Boolean case_ImInstanceof(ImInstanceof e) {
                return SideEffectAnalyzer.quickcheckHasSideeffects(e.getObj());
            }

            @Override
            public Boolean case_ImDealloc(ImDealloc imDealloc) {
                return true;
            }

            @Override
            public Boolean case_ImMemberAccess(ImMemberAccess e) {
                return SideEffectAnalyzer.quickcheckHasSideeffects(e.getReceiver());
            }

            @Override
            public Boolean case_ImBoolVal(ImBoolVal imBoolVal) {
                return false;
            }

            @Override
            public Boolean case_ImTupleExpr(ImTupleExpr e) {
                return e.getExprs().stream().anyMatch(SideEffectAnalyzer::quickcheckHasSideeffects);
            }

            @Override
            public Boolean case_ImNull(ImNull imNull) {
                return false;
            }

            @Override
            public Boolean case_ImGetStackTrace(ImGetStackTrace imGetStackTrace) {
                return true;
            }

            @Override
            public Boolean case_ImTypeVarDispatch(ImTypeVarDispatch imTypeVarDispatch) {
                return true;
            }

            @Override
            public Boolean case_ImOperatorCall(ImOperatorCall e) {
                return e.getArguments().stream().anyMatch(SideEffectAnalyzer::quickcheckHasSideeffects);
            }

            @Override
            public Boolean case_ImStringVal(ImStringVal imStringVal) {
                return false;
            }

            @Override
            public Boolean case_ImMethodCall(ImMethodCall imMethodCall) {
                return true;
            }

            @Override
            public Boolean case_ImAlloc(ImAlloc imAlloc) {
                return true;
            }

            @Override
            public Boolean case_ImCast(ImCast imCast) {
                return SideEffectAnalyzer.quickcheckHasSideeffects(imCast.getExpr());
            }

            @Override
            public Boolean case_ImCompiletimeExpr(ImCompiletimeExpr imCompiletimeExpr) {
                return true;
            }

            @Override
            public Boolean case_ImTypeIdOfObj(ImTypeIdOfObj e) {
                return SideEffectAnalyzer.quickcheckHasSideeffects(e.getObj());
            }

            @Override
            public Boolean case_ImVarAccess(ImVarAccess imVarAccess) {
                return false;
            }

            @Override
            public Boolean case_ImIntVal(ImIntVal imIntVal) {
                return false;
            }

            @Override
            public Boolean case_ImFuncRef(ImFuncRef imFuncRef) {
                return false;
            }

            @Override
            public Boolean case_ImStatementExpr(ImStatementExpr imStatementExpr) {
                return true;
            }
        });
    }

    public Multimap<ImFunction, ImFunction> getCallRelation() {
        if (this.callRelation != null) {
            return this.callRelation;
        }
        this.callRelation = LinkedListMultimap.create();
        for (ImFunction caller : ImHelper.calculateFunctionsOfProg(this.prog)) {
            this.callRelation.putAll((Object)caller, this.directlyCalledFunctions(caller));
        }
        return this.callRelation;
    }

    public TransitiveClosure<ImFunction> getCallRelationTr() {
        if (this.callRelationTr != null) {
            return this.callRelationTr;
        }
        this.callRelationTr = new TransitiveClosure<ImFunction>(this.getCallRelation());
        return this.callRelationTr;
    }

    public Multimap<ImFunction, ImVar> getUsedGlobals() {
        if (this.usedGlobals != null) {
            return this.usedGlobals;
        }
        this.usedGlobals = LinkedHashMultimap.create();
        for (ImFunction function : ImHelper.calculateFunctionsOfProg(this.prog)) {
            for (ImVar v : this.directlyUsedVariables(function)) {
                if (!v.isGlobal()) continue;
                this.usedGlobals.put((Object)function, (Object)v);
            }
        }
        return this.usedGlobals;
    }

    public Set<ImFunction> calledFunctions(Element e) {
        return this.calledFunctionsStream(e).collect(Collectors.toSet());
    }

    private Stream<ImFunction> calledFunctionsStream(Element e) {
        return this.directlyCalledFunctions(e).stream().flatMap(f -> Stream.concat(Stream.of(f), this.getCallRelationTr().get((ImFunction)f)));
    }

    public Set<ImFunction> calledNatives(Element e) {
        return this.calledFunctionsStream(e).filter(ImFunction::isNative).collect(Collectors.toSet());
    }

    public Set<ImVar> usedVariables(Element e) {
        Stream indirectGlobals = this.calledFunctionsStream(e).flatMap(f -> this.getUsedGlobals().get(f).stream());
        return Stream.concat(indirectGlobals, this.directlyUsedVariables(e).stream()).collect(Collectors.toSet());
    }

    public Set<ImFunction> directlyCalledFunctions(Element e) {
        final LinkedHashSet<ImFunction> calledFunctions = new LinkedHashSet<ImFunction>();
        e.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImFunctionCall c) {
                super.visit(c);
                calledFunctions.add(c.getFunc());
            }

            @Override
            public void visit(ImMethodCall c) {
                super.visit(c);
                calledFunctions.add(c.getMethod().getImplementation());
            }
        });
        return calledFunctions;
    }

    public Set<ImVar> directlyUsedVariables(Element e) {
        final LinkedHashSet<ImVar> imVars = new LinkedHashSet<ImVar>();
        e.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess va) {
                super.visit(va);
                imVars.add(va.getVar());
            }

            @Override
            public void visit(ImVarArrayAccess va) {
                super.visit(va);
                imVars.add(va.getVar());
            }

            @Override
            public void visit(ImMemberAccess va) {
                super.visit(va);
                imVars.add(va.getVar());
            }

            @Override
            public void visit(ImSet va) {
                super.visit(va);
                ImLExpr assignable = va.getLeft();
                SideEffectAnalyzer.this.collectVars(imVars, assignable);
            }

            @Override
            public void visit(ImVarargLoop va) {
                super.visit(va);
                imVars.add(va.getLoopVar());
            }
        });
        return imVars;
    }

    private void collectVars(final Collection<ImVar> imVars, ImLExpr assignable) {
        assignable.match(new ImLExpr.MatcherVoid(){

            @Override
            public void case_ImVarAccess(ImVarAccess v) {
                imVars.add(v.getVar());
            }

            @Override
            public void case_ImStatementExpr(ImStatementExpr imStatementExpr) {
                throw new RuntimeException("TODO");
            }

            @Override
            public void case_ImTupleSelection(ImTupleSelection v) {
                SideEffectAnalyzer.this.collectVars(imVars, (ImLExpr)v.getTupleExpr());
            }

            @Override
            public void case_ImVarArrayAccess(ImVarArrayAccess v) {
                imVars.add(v.getVar());
            }

            @Override
            public void case_ImMemberAccess(ImMemberAccess v) {
                imVars.add(v.getVar());
            }

            @Override
            public void case_ImTupleExpr(ImTupleExpr te) {
                for (ImExpr e : te.getExprs()) {
                    ((ImLExpr)e).match(this);
                }
            }
        });
    }

    public Set<ImVar> directlyAccessedVariables(Element e) {
        final LinkedHashSet<ImVar> imVars = new LinkedHashSet<ImVar>();
        e.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess va) {
                super.visit(va);
                imVars.add(va.getVar());
            }

            @Override
            public void visit(ImVarArrayAccess va) {
                super.visit(va);
                imVars.add(va.getVar());
            }

            @Override
            public void visit(ImMemberAccess va) {
                super.visit(va);
                imVars.add(va.getVar());
            }
        });
        return imVars;
    }

    public Set<ImVar> directlySetVariables(Element e) {
        final LinkedHashSet<ImVar> imVars = new LinkedHashSet<ImVar>();
        e.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImSet va) {
                super.visit(va);
                SideEffectAnalyzer.this.collectVars(imVars, va.getLeft());
            }

            @Override
            public void visit(ImVarargLoop va) {
                super.visit(va);
                imVars.add(va.getLoopVar());
            }
        });
        return imVars;
    }

    public boolean mightAffect(ImStmt stmt1, ImStmt stmt2) {
        if (!this.calledNatives(stmt1).isEmpty() || !this.calledNatives(stmt2).isEmpty()) {
            return true;
        }
        Set<ImVar> used1 = this.usedVariables(stmt1);
        Set<ImVar> used2 = this.usedVariables(stmt2);
        return used1.stream().anyMatch(used2::contains);
    }

    public boolean cannotUseVar(ImStmt s, ImVar v) {
        if (v.isGlobal()) {
            Set<ImVar> imVars = this.usedVariables(s);
            Set<ImFunction> imFunctions = this.calledNatives(s);
            return !imVars.contains(v) && imFunctions.isEmpty();
        }
        Set<ImVar> imVars = this.directlyUsedVariables(s);
        return !imVars.contains(v);
    }

    public boolean hasSideEffects(Element elem) {
        Set<ImFunction> natives = this.calledNatives(elem);
        Set<ImFunction> directFuncs = this.calledFunctions(elem);
        Set<ImVar> imVars = this.directlySetVariables(elem);
        return natives.size() + directFuncs.size() + imVars.size() > 0;
    }
}

