/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.validation.WurstValidator;

public class OverriddenFunctions {
    public static FunctionDefinition getRealFuncDef(ExtensionFuncDef f) {
        return f;
    }

    public static FunctionDefinition getRealFuncDef(NativeFunc f) {
        return f;
    }

    public static FunctionDefinition getRealFuncDef(FuncDef f) {
        if (f.attrIsPrivate()) {
            return f;
        }
        if (!OverriddenFunctions.isInModuleInstantiation(f)) {
            return f;
        }
        if (f.attrNearestNamedScope() == null) {
            return f;
        }
        if (f.attrNearestNamedScope().getParent() == null) {
            return f;
        }
        WScope scope = f.attrNearestNamedScope().getParent().attrNearestScope();
        return OverriddenFunctions.getRealFuncDef(f, scope);
    }

    private static boolean isInModuleInstantiation(Element e) {
        while (e != null) {
            if (e instanceof ModuleInstanciation) {
                return true;
            }
            e = e.getParent();
        }
        return false;
    }

    private static FunctionDefinition getRealFuncDef(FuncDef f, WScope scope) {
        if (scope instanceof StructureDef) {
            StructureDef c = (StructureDef)scope;
            FuncLink fNameLink = FuncLink.create(f, f.attrNearestScope());
            if (c.attrNameLinks().containsKey((Object)f.getName())) {
                for (DefLink nl : c.attrNameLinks().get((Object)f.getName())) {
                    if (nl.getLevel() != c.attrLevel() || !(nl.getDef() instanceof FunctionDefinition) || !(nl instanceof FuncLink) || !WurstValidator.canOverride((FuncLink)nl, fNameLink, true)) continue;
                    return ((FuncLink)nl).getDef().attrRealFuncDef();
                }
            }
            if (scope.getParent() != null) {
                return OverriddenFunctions.getRealFuncDef(f, scope.getParent().attrNearestNamedScope());
            }
        }
        return f;
    }

    public static FunctionDefinition getRealFuncDef(TupleDef t) {
        return t;
    }
}

