/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.ast;

import com.google.common.collect.ImmutableCollection;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeRef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrImportedPackage;
import de.peeeq.wurstscript.attributes.AttrNameDef;
import de.peeeq.wurstscript.attributes.AttrNearest;
import de.peeeq.wurstscript.attributes.AttrPos;
import de.peeeq.wurstscript.attributes.AttrTypeDef;
import de.peeeq.wurstscript.attributes.AttrTypeExprType;
import de.peeeq.wurstscript.attributes.Description;
import de.peeeq.wurstscript.attributes.DescriptionHtml;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.attributes.ErrorHandling;
import de.peeeq.wurstscript.attributes.IsDynamicContext;
import de.peeeq.wurstscript.attributes.PathDescription;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.UsedPackages;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameResolution;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyPrinter;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.types.WurstType;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class TypeExprArrayImpl
implements TypeExprArray {
    private Element parent;
    private WPos source;
    private TypeExpr base;
    private OptExpr arraySize;
    private int zzattr_attrTyp_state = 0;
    private WurstType zzattr_attrTyp_cache;
    private int zzattr_attrTypRaw_state = 0;
    private WurstType zzattr_attrTypRaw_cache;
    private int zzattr_attrTypeDef_state = 0;
    private @Nullable TypeDef zzattr_attrTypeDef_cache;

    TypeExprArrayImpl(WPos source, TypeExpr base, OptExpr arraySize) {
        if (source == null) {
            throw new IllegalArgumentException("Element source must not be null.");
        }
        if (base == null) {
            throw new IllegalArgumentException("Element base must not be null.");
        }
        if (arraySize == null) {
            throw new IllegalArgumentException("Element arraySize must not be null.");
        }
        this.source = source;
        this.base = base;
        this.arraySize = arraySize;
        base.setParent(this);
        arraySize.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setSource(WPos source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
    }

    @Override
    public WPos getSource() {
        return this.source;
    }

    @Override
    public void setBase(TypeExpr base) {
        if (base == null) {
            throw new IllegalArgumentException();
        }
        this.base.setParent(null);
        base.setParent(this);
        this.base = base;
    }

    @Override
    public TypeExpr getBase() {
        return this.base;
    }

    @Override
    public void setArraySize(OptExpr arraySize) {
        if (arraySize == null) {
            throw new IllegalArgumentException();
        }
        this.arraySize.setParent(null);
        arraySize.setParent(this);
        this.arraySize = arraySize;
    }

    @Override
    public OptExpr getArraySize() {
        return this.arraySize;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.base;
            }
            case 1: {
                return this.arraySize;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                TypeExpr oldElem = this.base;
                this.setBase((TypeExpr)newElem);
                return oldElem;
            }
            case 1: {
                OptExpr oldElem = this.arraySize;
                this.setArraySize((OptExpr)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.base);
        action.accept(this.arraySize);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public TypeExprArray copy() {
        TypeExprArrayImpl result = new TypeExprArrayImpl(this.source, this.base.copy(), this.arraySize.copy());
        return result;
    }

    @Override
    public TypeExprArray copyWithRefs() {
        TypeExprArray res = this.copy();
        return res;
    }

    @Override
    public void clearAttributes() {
        this.base.clearAttributes();
        this.arraySize.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
        this.zzattr_attrTyp_state = 0;
        this.zzattr_attrTypRaw_state = 0;
        this.zzattr_attrTypeDef_state = 0;
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(TypeRef.Matcher<T> matcher) {
        return matcher.case_TypeExprArray(this);
    }

    @Override
    public void match(TypeRef.MatcherVoid matcher) {
        matcher.case_TypeExprArray(this);
    }

    @Override
    public <T> T match(AstElementWithSource.Matcher<T> matcher) {
        return matcher.case_TypeExprArray(this);
    }

    @Override
    public void match(AstElementWithSource.MatcherVoid matcher) {
        matcher.case_TypeExprArray(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_TypeExprArray(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_TypeExprArray(this);
    }

    @Override
    public <T> T match(TypeExpr.Matcher<T> matcher) {
        return matcher.case_TypeExprArray(this);
    }

    @Override
    public void match(TypeExpr.MatcherVoid matcher) {
        matcher.case_TypeExprArray(this);
    }

    @Override
    public <T> T match(OptTypeExpr.Matcher<T> matcher) {
        return matcher.case_TypeExprArray(this);
    }

    @Override
    public void match(OptTypeExpr.MatcherVoid matcher) {
        matcher.case_TypeExprArray(this);
    }

    public String toString() {
        return "TypeExprArray(" + this.source + ", " + this.base + ", " + this.arraySize + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof TypeExprArray) {
            TypeExprArray o = (TypeExprArray)e;
            return this.base.structuralEquals(o.getBase()) && this.arraySize.structuralEquals(o.getArraySize());
        }
        return false;
    }

    @Override
    public WurstType attrTyp() {
        if (this.zzattr_attrTyp_state == 0) {
            try {
                this.zzattr_attrTyp_state = 1;
                this.zzattr_attrTyp_cache = AttrTypeExprType.normalizedType(this);
            }
            finally {
                this.zzattr_attrTyp_state = 0;
            }
            this.zzattr_attrTyp_state = 2;
        } else if (this.zzattr_attrTyp_state == 1) {
            throw new CyclicDependencyError(this, "attrTyp");
        }
        return this.zzattr_attrTyp_cache;
    }

    @Override
    public WurstType attrTypRaw() {
        if (this.zzattr_attrTypRaw_state == 0) {
            try {
                this.zzattr_attrTypRaw_state = 1;
                this.zzattr_attrTypRaw_cache = AttrTypeExprType.calculate(this);
            }
            finally {
                this.zzattr_attrTypRaw_state = 0;
            }
            this.zzattr_attrTypRaw_state = 2;
        } else if (this.zzattr_attrTypRaw_state == 1) {
            throw new CyclicDependencyError(this, "attrTypRaw");
        }
        return this.zzattr_attrTypRaw_cache;
    }

    @Override
    public boolean attrIsDynamicContext() {
        return IsDynamicContext.calculate(this);
    }

    @Override
    public @Nullable PackageOrGlobal attrNearestPackage() {
        return AttrNearest.nearestPackage(this);
    }

    @Override
    public @Nullable NamedScope attrNearestNamedScope() {
        return AttrNearest.nearestNamedScope(this);
    }

    @Override
    public @Nullable WScope attrNearestScope() {
        return AttrNearest.nearestScope(this);
    }

    @Override
    public String attrPathDescription() {
        return PathDescription.get(this);
    }

    @Override
    public CompilationUnit attrCompilationUnit() {
        return AttrNearest.nearestCompilationUnit(this);
    }

    @Override
    public @Nullable ClassDef attrNearestClassDef() {
        return AttrNearest.nearestClassDef(this);
    }

    @Override
    public @Nullable ClassOrInterface attrNearestClassOrInterface() {
        return AttrNearest.nearestClassOrInterface(this);
    }

    @Override
    public @Nullable ClassOrModule attrNearestClassOrModule() {
        return AttrNearest.nearestClassOrModule(this);
    }

    @Override
    public @Nullable StructureDef attrNearestStructureDef() {
        return AttrNearest.nearestStructureDef(this);
    }

    @Override
    public @Nullable FunctionImplementation attrNearestFuncDef() {
        return AttrNearest.nearestFuncDef(this);
    }

    @Override
    public @Nullable ExprClosure attrNearestExprClosure() {
        return AttrNearest.nearestExprClosure(this);
    }

    @Override
    public @Nullable ExprStatementsBlock attrNearestExprStatementsBlock() {
        return AttrNearest.nearestExprStatementsBlock(this);
    }

    @Override
    public @Nullable NameDef tryGetNameDef() {
        return AttrNameDef.tryGetNameDef(this);
    }

    @Override
    public WPos attrSource() {
        return AttrPos.getPos(this);
    }

    @Override
    public WPos attrErrorPos() {
        return AttrPos.getErrorPos(this);
    }

    @Override
    public WurstModel getModel() {
        return AttrImportedPackage.getModel(this);
    }

    @Override
    public void addError(String msg) {
        ErrorHandling.addError(this, msg);
    }

    @Override
    public void addWarning(String msg) {
        ErrorHandling.addWarning(this, msg);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return ErrorHandling.getErrorHandler(this);
    }

    @Override
    public @Nullable TypeDef attrTypeDef() {
        if (this.zzattr_attrTypeDef_state == 0) {
            try {
                this.zzattr_attrTypeDef_state = 1;
                this.zzattr_attrTypeDef_cache = AttrTypeDef.calculate(this);
            }
            finally {
                this.zzattr_attrTypeDef_state = 0;
            }
            this.zzattr_attrTypeDef_state = 2;
        } else if (this.zzattr_attrTypeDef_state == 1) {
            throw new CyclicDependencyError(this, "attrTypeDef");
        }
        return this.zzattr_attrTypeDef_cache;
    }

    @Override
    public @Nullable TypeDef lookupType(String name, boolean showErrors) {
        return NameResolution.lookupType(this, name, showErrors);
    }

    @Override
    public PackageLink lookupPackage(String name, boolean showErrors) {
        return NameResolution.lookupPackage(this, name, showErrors);
    }

    @Override
    public NameLink lookupVar(String name, boolean showErrors) {
        return NameResolution.lookupVar(this, name, showErrors);
    }

    @Override
    public NameLink lookupVarNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupVarNoConfig(this, name, showErrors);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberVar(this, receiverType, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name, boolean showErrors) {
        return NameResolution.lookupFuncs(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncsNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupFuncsNoConfig(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberFuncs(this, receiverType, name, showErrors);
    }

    @Override
    public @Nullable TypeDef lookupType(String name) {
        return NameResolution.lookupTypeShort(this, name);
    }

    @Override
    public PackageLink lookupPackage(String name) {
        return NameResolution.lookupPackageShort(this, name);
    }

    @Override
    public NameLink lookupVar(String name) {
        return NameResolution.lookupVarShort(this, name);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name) {
        return NameResolution.lookupMemberVarShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name) {
        return NameResolution.lookupFuncsShort(this, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncsShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<WPackage> attrUsedPackages() {
        return UsedPackages.usedPackages(this);
    }

    @Override
    public String description() {
        return Description.description(this);
    }

    @Override
    public String descriptionHtml() {
        return DescriptionHtml.description(this);
    }

    @Override
    public boolean isModuleUseTypeArg() {
        return SmallHelpers.isModuleUseTypeArg(this);
    }

    @Override
    public boolean isSubtreeOf(Element other) {
        return SmallHelpers.isSubtreeOf(this, other);
    }

    @Override
    public void prettyPrint(Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(this, spacer, sb, indent);
    }
}

