/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.SomeSuperConstructorCall;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.Utils;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class GetDefinition
extends UserRequest<Either<List<? extends Location>, List<? extends LocationLink>>> {
    private final WFile filename;
    private final String buffer;
    private final int line;
    private final int column;

    public GetDefinition(TextDocumentPositionParams position, BufferManager bufferManager) {
        this.filename = WFile.create(position.getTextDocument().getUri());
        this.buffer = bufferManager.getBuffer(position.getTextDocument());
        this.line = position.getPosition().getLine() + 1;
        this.column = position.getPosition().getCharacter() + 1;
    }

    @Override
    public Either<List<? extends Location>, List<? extends LocationLink>> execute(ModelManager modelManager) {
        return Either.forLeft(this.execute2(modelManager));
    }

    private List<? extends Location> execute2(ModelManager modelManager) {
        CompilationUnit cu = modelManager.replaceCompilationUnitContent(this.filename, this.buffer, false);
        if (cu == null) {
            return Collections.emptyList();
        }
        Element e = Utils.getAstElementAtPos(cu, this.line, this.column, false).get();
        WLogger.info("get definition at: " + e.getClass().getSimpleName());
        if (e instanceof FuncRef) {
            FuncRef funcRef = (FuncRef)e;
            FunctionDefinition decl = funcRef.attrFuncDef();
            return this.linkTo(decl);
        }
        if (e instanceof NameRef) {
            NameRef nameRef = (NameRef)e;
            NameDef decl = nameRef.attrNameDef();
            return this.linkTo(decl);
        }
        if (e instanceof TypeExpr) {
            TypeExpr typeExpr = (TypeExpr)e;
            TypeDef decl = typeExpr.attrTypeDef();
            return this.linkTo(decl);
        }
        if (e instanceof WImport) {
            WImport wImport = (WImport)e;
            WPackage p = wImport.attrImportedPackage();
            if (p == null) {
                return Collections.emptyList();
            }
            return this.linkTo(p);
        }
        if (e instanceof ExprNewObject) {
            ExprNewObject exprNew = (ExprNewObject)e;
            ConstructorDef def = exprNew.attrConstructorDef();
            return this.linkTo(def);
        }
        if (e instanceof ModuleUse) {
            ModuleUse use = (ModuleUse)e;
            ModuleDef def = use.attrModuleDef();
            return this.linkTo(def);
        }
        if (e instanceof ExprBinary) {
            ExprBinary eb = (ExprBinary)e;
            FunctionDefinition def = eb.attrFuncDef();
            return this.linkTo(def);
        }
        if (e instanceof SomeSuperConstructorCall) {
            SomeSuperConstructorCall sc = (SomeSuperConstructorCall)e;
            ConstructorDef constructor = (ConstructorDef)sc.getParent();
            ConstructorDef superConstructor = constructor.attrSuperConstructor();
            return this.linkTo(superConstructor);
        }
        return Collections.emptyList();
    }

    private List<? extends Location> linkTo(AstElementWithSource decl) {
        if (decl == null) {
            return Collections.emptyList();
        }
        WPos pos = decl.attrErrorPos();
        return Collections.singletonList(Convert.posToLocation(pos));
    }

    static class DefinitionInfo {
        private final String filename;
        private final int line;
        private final int column;

        public DefinitionInfo(String filename, int line, int column) {
            this.filename = filename;
            this.line = line;
            this.column = column;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

