/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.DebouncingTimer;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.ModelManagerImpl;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.HoverInfo;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.utils.Utils;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;

public class LanguageWorker
implements Runnable {
    private final Map<WFile, PendingChange> changes = new LinkedHashMap<WFile, PendingChange>();
    private final AtomicLong currentTime = new AtomicLong();
    private final Queue<UserRequest<?>> userRequests = new LinkedList();
    private final Thread thread;
    public final Duration reconcileWaitTime;
    private ModelManager modelManager;
    private WFile rootPath;
    private final Object lock = new Object();
    private ModelManager.Changes changesToReconcile = ModelManager.Changes.empty();
    private final DebouncingTimer packagesToReconcileTimer = new DebouncingTimer(() -> {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    });
    private final BufferManager bufferManager = new BufferManager();
    private LanguageClient languageClient;

    public void setRootPath(WFile rootPath) {
        this.rootPath = rootPath;
    }

    public LanguageWorker() {
        Optional<String> waitTime = Utils.getEnvOrConfig("WURST_RECONCILE_WAIT_TIME");
        this.reconcileWaitTime = waitTime.map(Duration::parse).orElse(Duration.ofSeconds(3L));
        this.thread = new Thread(this);
        this.thread.setName("Wurst LanguageWorker");
        this.thread.start();
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public void setLanguageClient(LanguageClient languageClient) {
        this.languageClient = languageClient;
    }

    public void stop() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Workitem work;
                    Object object = this.lock;
                    synchronized (object) {
                        work = this.getNextWorkItem();
                        if (work == null) {
                            this.lock.wait(10000L);
                            work = this.getNextWorkItem();
                        }
                    }
                    if (work == null) continue;
                    try {
                        work.run();
                        continue block7;
                    }
                    catch (Throwable e) {
                        this.languageClient.showMessage(new MessageParams(MessageType.Error, "Request '" + work + "' could not be processed (see log for details): " + e));
                        WLogger.severe(e);
                        System.err.println("Error in request '" + work + "' (see log for details): " + e.getMessage());
                    }
                }
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        WLogger.info("Language Worker interrupted");
    }

    private Workitem getNextWorkItem() {
        if (this.modelManager == null) {
            if (this.rootPath != null) {
                WLogger.info("LanguageWorker start init");
                return new Workitem("init", () -> this.doInit(this.rootPath));
            }
            WLogger.info("LanguageWorker is waiting for init ... ");
        } else {
            if (!this.userRequests.isEmpty()) {
                UserRequest<?> req = this.userRequests.remove();
                return new Workitem(req.toString(), () -> req.run(this.modelManager));
            }
            if (!this.changes.isEmpty()) {
                PendingChange change = this.removeFirst(this.changes);
                return new Workitem(change.toString(), () -> {
                    ModelManager.Changes affected = null;
                    if (this.isWurstDependencyFile(change)) {
                        if (!(change instanceof FileReconcile)) {
                            this.modelManager.clean();
                        }
                    } else if (change instanceof FileDeleted) {
                        affected = this.modelManager.removeCompilationUnit(change.getFilename());
                    } else if (change instanceof FileUpdated) {
                        affected = this.modelManager.syncCompilationUnit(change.getFilename());
                    } else if (change instanceof FileReconcile) {
                        FileReconcile fr = (FileReconcile)change;
                        affected = this.modelManager.syncCompilationUnitContent(fr.getFilename(), fr.getContents());
                    } else {
                        WLogger.info("unhandled change request: " + change);
                    }
                    if (affected != null) {
                        this.changesToReconcile = this.changesToReconcile.mergeWith(affected);
                        this.packagesToReconcileTimer.start(this.reconcileWaitTime);
                    }
                });
            }
            if (!this.changesToReconcile.isEmpty() && this.packagesToReconcileTimer.isReady()) {
                this.packagesToReconcileTimer.stop();
                ModelManager.Changes changes = this.changesToReconcile;
                this.changesToReconcile = ModelManager.Changes.empty();
                return new Workitem("reconcile files", () -> this.modelManager.reconcile(changes));
            }
        }
        return null;
    }

    private boolean isWurstDependencyFile(PendingChange change) {
        return change.getFilename().getUriString().endsWith("wurst.dependencies");
    }

    private PendingChange removeFirst(Map<WFile, PendingChange> changes) {
        Iterator<Map.Entry<WFile, PendingChange>> it = changes.entrySet().iterator();
        Map.Entry<WFile, PendingChange> e = it.next();
        it.remove();
        return e.getValue();
    }

    private void doInit(WFile rootPath) {
        try {
            this.log("Handle init " + rootPath);
            this.modelManager = new ModelManagerImpl(rootPath.getFile(), this.bufferManager);
            this.modelManager.onCompilationResult(this::onCompilationResult);
            this.log("Start building " + rootPath);
            this.modelManager.buildProject();
            this.log("Finished building " + rootPath);
        }
        catch (Exception e) {
            WLogger.severe(e);
        }
    }

    private void onCompilationResult(PublishDiagnosticsParams compilationResult) {
        this.languageClient.publishDiagnostics(compilationResult);
    }

    private void log(String s) {
        WLogger.info(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFileChanged(DidChangeWatchedFilesParams params) {
        Object object = this.lock;
        synchronized (object) {
            for (FileEvent fileEvent : params.getChanges()) {
                this.bufferManager.handleFileChange(fileEvent);
                WFile file = WFile.create(fileEvent.getUri());
                if (fileEvent.getType() == FileChangeType.Deleted) {
                    this.changes.put(file, new FileDeleted(file));
                    continue;
                }
                this.changes.put(file, new FileUpdated(file));
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleChange(DidChangeTextDocumentParams params) {
        Object object = this.lock;
        synchronized (object) {
            this.bufferManager.handleChange(params);
            WFile file = WFile.create(params.getTextDocument().getUri());
            this.changes.put(file, new FileReconcile(file, this.bufferManager.getBuffer((TextDocumentIdentifier)params.getTextDocument())));
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Res> CompletableFuture<Res> handle(UserRequest<Res> request) {
        Object object = this.lock;
        synchronized (object) {
            if (!request.keepDuplicateRequests()) {
                Iterator it = this.userRequests.iterator();
                while (it.hasNext()) {
                    UserRequest o = (UserRequest)it.next();
                    if (!o.getClass().equals(request.getClass())) continue;
                    o.cancel();
                    it.remove();
                }
            }
            this.userRequests.add(request);
            this.lock.notifyAll();
            CompletableFuture<Res> fut = request.getFuture();
            CompletableFuture resFut = new CompletableFuture();
            fut.whenComplete((res, err) -> {
                if (err != null) {
                    request.handleException(this.languageClient, (Throwable)err, resFut);
                } else if (res == null) {
                    System.err.println("Request returned null: " + request);
                    if (!(request instanceof HoverInfo)) {
                        this.languageClient.showMessage(new MessageParams(MessageType.Error, "Request returned null: " + request));
                    }
                    resFut.completeExceptionally(new RuntimeException("Request returned null: " + request));
                } else {
                    resFut.complete(res);
                }
            });
            return resFut;
        }
    }

    class FileReconcile
    extends PendingChange {
        private final String contents;

        public FileReconcile(WFile filename, String contents) {
            super(filename);
            this.contents = contents;
        }

        public String getContents() {
            return this.contents;
        }

        public String toString() {
            return "FileReconcile(" + this.getFilename() + ")";
        }
    }

    class FileDeleted
    extends PendingChange {
        public FileDeleted(WFile filename) {
            super(filename);
        }

        public String toString() {
            return "FileDeleted(" + this.getFilename() + ")";
        }
    }

    class FileUpdated
    extends PendingChange {
        public FileUpdated(WFile filename) {
            super(filename);
        }

        public String toString() {
            return "FileUpdated(" + this.getFilename() + ")";
        }
    }

    abstract class PendingChange {
        private final long time;
        private final WFile filename;

        public PendingChange(WFile filename) {
            this.time = LanguageWorker.this.currentTime.incrementAndGet();
            this.filename = filename;
        }

        public long getTime() {
            return this.time;
        }

        public WFile getFilename() {
            return this.filename;
        }
    }

    private static class Workitem {
        private final String description;
        private final Runnable runnable;

        public Workitem(String description, Runnable runnable) {
            this.description = description;
            this.runnable = runnable;
        }

        void run() {
            this.runnable.run();
        }

        public String toString() {
            return this.description;
        }
    }
}

