/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.jassinterpreter.providers;

import com.google.common.collect.LinkedListMultimap;
import de.peeeq.wurstio.jassinterpreter.Implements;
import de.peeeq.wurstio.jassinterpreter.providers.NameProvider;
import de.peeeq.wurstio.jassinterpreter.providers.Provider;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.ILconstString;
import de.peeeq.wurstscript.intermediatelang.IlConstHandle;
import de.peeeq.wurstscript.intermediatelang.interpreter.AbstractInterpreter;
import java.util.Objects;

public class HashtableProvider
extends Provider {
    public HashtableProvider(AbstractInterpreter interpreter) {
        super(interpreter);
    }

    public IlConstHandle InitHashtable() {
        return new IlConstHandle(NameProvider.getRandomName("ht"), LinkedListMultimap.create());
    }

    @Implements(funcNames={"SaveInteger", "SaveStr", "SaveReal", "SaveBoolean", "SavePlayerHandle", "SaveWidgetHandle", "SaveDestructableHandle", "SaveItemHandle", "SaveUnitHandle", "SaveAbilityHandle", "SaveTimerHandle", "SaveTriggerHandle", "SaveTriggerConditionHandle", "SaveTriggerActionHandle", "SaveTriggerEventHandle", "SaveForceHandle", "SaveGroupHandle", "SaveLocationHandle", "SaveRectHandle", "SaveBooleanExprHandle", "SaveSoundHandle", "SaveEffectHandle", "SaveUnitPoolHandle", "SaveItemPoolHandle", "SaveQuestHandle", "SaveQuestItemHandle", "SaveDefeatConditionHandle", "SaveTimerDialogHandle", "SaveLeaderboardHandle", "SaveMultiboardHandle", "SaveMultiboardItemHandle", "SaveTrackableHandle", "SaveDialogHandle", "SaveButtonHandle", "SaveTextTagHandle", "SaveLightningHandle", "SaveImageHandle", "SaveUbersplatHandle", "SaveRegionHandle", "SaveFogStateHandle", "SaveFogModifierHandle", "SaveAgentHandle", "SaveHashtableHandle"})
    public void Save(IlConstHandle ht, ILconstInt key1, ILconstInt key2, ILconst value) {
        LinkedListMultimap map = (LinkedListMultimap)ht.getObj();
        KeyPair keyPair = new KeyPair(key1.getVal(), key2.getVal());
        HashtableProvider.deleteIfPresent((LinkedListMultimap<KeyPair, Object>)map, keyPair, value.getClass());
        map.put((Object)keyPair, (Object)value);
    }

    public ILconstInt LoadInteger(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return this.haveSaved(ht, key1, key2, ILconstInt.class) ? this.load(ht, key1, key2, ILconstInt.class) : ILconstInt.create(0);
    }

    public ILconstReal LoadReal(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return this.haveSaved(ht, key1, key2, ILconstReal.class) ? this.load(ht, key1, key2, ILconstReal.class) : new ILconstReal(0.0);
    }

    public ILconstString LoadStr(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return this.haveSaved(ht, key1, key2, ILconstString.class) ? this.load(ht, key1, key2, ILconstString.class) : new ILconstString("");
    }

    public ILconstBool LoadBoolean(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return this.haveSaved(ht, key1, key2, ILconstBool.class) ? this.load(ht, key1, key2, ILconstBool.class) : ILconstBool.FALSE;
    }

    @Implements(funcNames={"LoadPlayerHandle", "LoadWidgetHandle", "LoadDestructableHandle", "LoadItemHandle", "LoadUnitHandle", "LoadAbilityHandle", "LoadTimerHandle", "LoadTriggerHandle", "LoadTriggerConditionHandle", "LoadTriggerActionHandle", "LoadTriggerEventHandle", "LoadForceHandle", "LoadGroupHandle", "LoadLocationHandle", "LoadRectHandle", "LoadBooleanExprHandle", "LoadSoundHandle", "LoadEffectHandle", "LoadUnitPoolHandle", "LoadItemPoolHandle", "LoadQuestHandle", "LoadQuestItemHandle", "LoadDefeatConditionHandle", "LoadTimerDialogHandle", "LoadLeaderboardHandle", "LoadMultiboardHandle", "LoadMultiboardItemHandle", "LoadTrackableHandle", "LoadDialogHandle", "LoadButtonHandle", "LoadTextTagHandle", "LoadLightningHandle", "LoadImageHandle", "LoadUbersplatHandle", "LoadRegionHandle", "LoadFogStateHandle", "LoadFogModifierHandle", "LoadHashtableHandle"})
    public IlConstHandle LoadHandle(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return this.load(ht, key1, key2, IlConstHandle.class);
    }

    public void FlushParentHashtable(IlConstHandle ht) {
        LinkedListMultimap map = (LinkedListMultimap)ht.getObj();
        map.clear();
    }

    public void FlushChildHashtable(IlConstHandle ht, ILconstInt parentKey) {
        LinkedListMultimap map = (LinkedListMultimap)ht.getObj();
        map.entries().removeIf(entry -> ((KeyPair)entry.getKey()).parentkey == parentKey.getVal());
    }

    public void RemoveSavedInteger(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        this.removeSaved(ht, key1, key2, ILconstInt.class);
    }

    public void RemoveSavedReal(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        this.removeSaved(ht, key1, key2, ILconstReal.class);
    }

    public void RemoveSavedBoolean(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        this.removeSaved(ht, key1, key2, ILconstBool.class);
    }

    public void RemoveSavedString(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        this.removeSaved(ht, key1, key2, ILconstString.class);
    }

    public void RemoveSavedHandle(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        this.removeSaved(ht, key1, key2, IlConstHandle.class);
    }

    public ILconstBool HaveSavedString(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstString.class));
    }

    public ILconstBool HaveSavedInteger(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstInt.class));
    }

    public ILconstBool HaveSavedReal(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstReal.class));
    }

    public ILconstBool HaveSavedBoolean(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstBool.class));
    }

    public ILconstBool HaveSavedHandle(IlConstHandle ht, ILconstInt key1, ILconstInt key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, IlConstHandle.class));
    }

    private <T> T load(IlConstHandle ht, ILconstInt key1, ILconstInt key2, Class<T> clazz) {
        KeyPair keyPair;
        LinkedListMultimap map = (LinkedListMultimap)ht.getObj();
        if (HashtableProvider.hasValueOfType((LinkedListMultimap<KeyPair, Object>)map, keyPair = new KeyPair(key1.getVal(), key2.getVal()), clazz)) {
            return HashtableProvider.getValueOfType((LinkedListMultimap<KeyPair, Object>)map, keyPair, clazz);
        }
        return null;
    }

    private <T> void removeSaved(IlConstHandle ht, ILconstInt key1, ILconstInt key2, T type) {
        LinkedListMultimap map = (LinkedListMultimap)ht.getObj();
        KeyPair keyPair = new KeyPair(key1.getVal(), key2.getVal());
        HashtableProvider.deleteIfPresent((LinkedListMultimap<KeyPair, Object>)map, keyPair, type);
    }

    private <T> boolean haveSaved(IlConstHandle ht, ILconstInt key1, ILconstInt key2, Class<T> clazz) {
        LinkedListMultimap map = (LinkedListMultimap)ht.getObj();
        KeyPair keyPair = new KeyPair(key1.getVal(), key2.getVal());
        return HashtableProvider.hasValueOfType((LinkedListMultimap<KeyPair, Object>)map, keyPair, clazz);
    }

    private static <T> T getValueOfType(LinkedListMultimap<KeyPair, Object> map, KeyPair key, Class<T> clazz) {
        for (Object o : map.get((Object)key)) {
            if (o.getClass() != clazz) continue;
            return (T)o;
        }
        return null;
    }

    private static <T> boolean hasValueOfType(LinkedListMultimap<KeyPair, Object> map, KeyPair key, Class<T> type) {
        for (Object o : map.get((Object)key)) {
            if (o.getClass() != type) continue;
            return true;
        }
        return false;
    }

    private static <T> void deleteIfPresent(LinkedListMultimap<KeyPair, Object> map, KeyPair key, T type) {
        Object toRemove = null;
        for (Object o : map.get((Object)key)) {
            if (o.getClass() != type) continue;
            toRemove = o;
            break;
        }
        if (toRemove != null && !map.remove((Object)key, toRemove)) {
            throw new Error("object was found but not deleted");
        }
    }

    public static class KeyPair {
        private final int parentkey;
        private final int childkey;

        KeyPair(int parentkey, int childkey) {
            this.parentkey = parentkey;
            this.childkey = childkey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyPair keyPair = (KeyPair)o;
            return this.parentkey == keyPair.parentkey && this.childkey == keyPair.childkey;
        }

        public int hashCode() {
            return Objects.hash(this.parentkey, this.childkey);
        }

        public int getParentkey() {
            return this.parentkey;
        }

        public int getChildkey() {
            return this.childkey;
        }
    }
}

