/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import de.peeeq.wurstio.Data;
import de.peeeq.wurstio.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class Checksums {
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("usage: 1. folder, 2. output file");
        }
        File dir = new File(args[0]);
        File outFile = new File(args[1]);
        List<Data> data = Checksums.getData(dir);
        String out = Checksums.printData(data);
        try {
            FileUtils.write(out, outFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String printData(List<Data> data) {
        StringBuilder sb = new StringBuilder();
        for (Data d : data) {
            sb.append(d.filePath);
            sb.append("\n");
            sb.append(d.md5);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static List<Data> getData(File f) {
        ArrayList<Data> result = new ArrayList<Data>();
        for (File p : f.listFiles()) {
            Checksums.getDataRec(result, "", p);
        }
        return result;
    }

    private static void getDataRec(List<Data> result, String path, File f) {
        if (f.isDirectory()) {
            for (File p : f.listFiles()) {
                Checksums.getDataRec(result, path + "/" + f.getName(), p);
            }
        } else {
            result.add(new Data(path + "/" + f.getName(), Checksums.md5(f)));
        }
    }

    private static String md5(File f) {
        try {
            byte[] buf = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);
                 DigestInputStream dis = new DigestInputStream(is, md);){
                while (dis.read(buf) >= 0) {
                }
            }
            byte[] digest = md.digest();
            return Checksums.bytesToHex(digest);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

