/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinState;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.bin.app.MapFlag;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.Controller;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.dataTypes.app.LoadingScreenBackground;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.TerrainFog;
import net.moonlightflower.wc3libs.dataTypes.app.TerrainFogType;
import net.moonlightflower.wc3libs.dataTypes.app.Tileset;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.WeatherId;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.txt.app.jass.FuncDecl;
import net.moonlightflower.wc3libs.txt.app.jass.FuncImpl;
import net.moonlightflower.wc3libs.txt.app.jass.JassScript;
import net.moonlightflower.wc3libs.txt.app.jass.Param;
import net.moonlightflower.wc3libs.txt.app.jass.VarDecl;
import net.moonlightflower.wc3libs.txt.app.jass.statement.Statement;

public class W3I {
    public static final File GAME_PATH = new File("war3map.w3i");
    private int _fileVersion = 0;
    private final Map<State, DataType> _vals = new LinkedHashMap<State, DataType>();
    private int _editorVersion = 0;
    private long _gameVersion_major = 0L;
    private long _gameVersion_minor;
    private long _gameVersion_rev;
    private long _gameVersion_build;
    private String _mapName;
    private String _mapAuthor;
    @Nullable
    private String _mapDescription;
    private String _playersRecommendedAmount;
    private Coords2DF _cameraBounds1 = new Coords2DF(0.0f, 0.0f);
    private Coords2DF _cameraBounds2 = new Coords2DF(0.0f, 0.0f);
    private Coords2DF _cameraBounds3 = new Coords2DF(0.0f, 0.0f);
    private Coords2DF _cameraBounds4 = new Coords2DF(0.0f, 0.0f);
    private Bounds _margins = new Bounds(0, 0, 0, 0);
    private int _width = 32;
    private int _height = 32;
    private Flags _flags = Flags.valueOf(0);
    private Tileset _tileset;
    private LoadingScreen _loadingScreen;
    private PrologueScreen _prologueScreen;
    private GameDataSet _gameData = GameDataSet.STANDARD;
    private TerrainFog _terrainFog;
    private Id _globalWeatherId;
    private SoundLabel _soundEnv;
    private Tileset _tilesetLightEnv;
    private Color _waterColor = Color.fromRGBA255(255, 255, 255, 255);
    private ScriptLang _scriptLang = ScriptLang.JASS;
    private Graphics _graphics = Graphics.SD_AND_HD;
    private GameDataVersion _gameDataVersion = GameDataVersion.TFT;
    private List<Player> _players = new ArrayList<Player>();
    private final List<Force> _forces = new ArrayList<Force>();
    private final List<UpgradeMod> _upgradeMods = new ArrayList<UpgradeMod>();
    private List<TechMod> _techMods = new ArrayList<TechMod>();
    private List<UnitTable> _unitTables = new ArrayList<UnitTable>();
    private List<ItemTable> _itemTables = new ArrayList<ItemTable>();
    private static final Pattern funcStartPattern = Pattern.compile("^\\s*function\\s+(\\w+)");
    private static final Pattern funcStartPatternLua = Pattern.compile("^\\s*function\\(");
    private static final Pattern funcEndPatternLua = Pattern.compile("^\\s*end");
    private static final Pattern funcEndPattern = Pattern.compile("^\\s*endfunction");

    public int getFileVersion() {
        return this._fileVersion;
    }

    public void setFileVersion(int fileVersion) {
        this._fileVersion = fileVersion;
    }

    public <T extends DataType> T get(@Nonnull State<T> state) {
        return state.getVal(this._vals.get(state));
    }

    public <T extends DataType> void set(@Nonnull State<T> state, T val) {
        this._vals.put(state, val);
    }

    public War3Int getSavesAmount() {
        return this.get(State.SAVES_AMOUNT);
    }

    public void setSavesAmount(@Nonnull War3Int val) {
        this.set(State.SAVES_AMOUNT, val);
    }

    public int getEditorVersion() {
        return this._editorVersion;
    }

    public void setEditorVersion(int val) {
        this._editorVersion = val;
    }

    public long getGameVersion_major() {
        return this._gameVersion_major;
    }

    public void setGameVersion_major(long val) {
        this._gameVersion_major = val;
    }

    public long getGameVersion_minor() {
        return this._gameVersion_minor;
    }

    public void setGameVersion_minor(long val) {
        this._gameVersion_minor = val;
    }

    public long getGameVersion_rev() {
        return this._gameVersion_rev;
    }

    public void setGameVersion_rev(long val) {
        this._gameVersion_rev = val;
    }

    public long getGameVersion_build() {
        return this._gameVersion_build;
    }

    public void setGameVersion_build(long val) {
        this._gameVersion_build = val;
    }

    @Nonnull
    public String getMapName() {
        return this._mapName;
    }

    public void setMapName(@Nonnull String val) {
        this._mapName = val;
    }

    @Nullable
    public String getMapAuthor() {
        return this._mapAuthor;
    }

    public void setMapAuthor(@Nullable String val) {
        this._mapAuthor = val;
    }

    public String getMapDescription() {
        return this._mapDescription;
    }

    public void setMapDescription(@Nullable String val) {
        this._mapDescription = val;
    }

    @Nullable
    public String getPlayersRecommendedAmount() {
        return this._playersRecommendedAmount;
    }

    public void setPlayersRecommendedAmount(@Nullable String val) {
        this._playersRecommendedAmount = val;
    }

    @Nonnull
    public Coords2DF getCameraBounds1() {
        return this._cameraBounds1;
    }

    @Nonnull
    public Coords2DF getCameraBounds2() {
        return this._cameraBounds2;
    }

    @Nonnull
    public Coords2DF getCameraBounds3() {
        return this._cameraBounds3;
    }

    @Nonnull
    public Coords2DF getCameraBounds4() {
        return this._cameraBounds4;
    }

    public void setCameraBounds(@Nonnull Coords2DF pos1, @Nonnull Coords2DF pos2, @Nonnull Coords2DF pos3, @Nonnull Coords2DF pos4) {
        this._cameraBounds1 = pos1;
        this._cameraBounds2 = pos2;
        this._cameraBounds3 = pos3;
        this._cameraBounds4 = pos4;
    }

    @Nonnull
    public Bounds getMargins() {
        return this._margins;
    }

    public void setMargins(@Nonnull Bounds val) {
        this._margins = val;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    @Nonnull
    public Bounds getWorldBounds() {
        Size size = new Size(this.getWidth() + this.getMargins().getMinX() + this.getMargins().getMaxX(), this.getHeight() + this.getMargins().getMinY() + this.getMargins().getMaxY());
        return new Bounds(size);
    }

    public void setDimensions(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public Flags getFlags() {
        return this._flags;
    }

    public void setFlags(Flags val) {
        this._flags = val;
    }

    public boolean getFlag(MapFlag flag) {
        return this._flags.containsFlag(flag);
    }

    public void setFlag(MapFlag flag, boolean val) {
        this._flags.setFlag(flag, val);
    }

    @Nonnull
    public Tileset getTileset() {
        return this._tileset;
    }

    public void setTileset(@Nonnull Tileset val) {
        this._tileset = val;
    }

    public LoadingScreen getLoadingScreen() {
        return this._loadingScreen;
    }

    public void setLoadingScreen(LoadingScreen val) {
        this._loadingScreen = val;
    }

    @Nullable
    public PrologueScreen getPrologueScreen() {
        return this._prologueScreen;
    }

    public void setPrologueScreen(@Nullable PrologueScreen val) {
        this._prologueScreen = val;
    }

    @Nonnull
    public GameDataSet getGameDataSet() {
        return this._gameData;
    }

    public static File getGameDataSetPath(@Nonnull GameDataSet dataSet, boolean isMeleeMap) {
        if (dataSet.equals(GameDataSet.CUSTOM_V1)) {
            return new File("Custom_V1");
        }
        if (dataSet.equals(GameDataSet.MELEE_V1)) {
            return new File("Melee_V0");
        }
        if (isMeleeMap) {
            return new File("Melee_V0");
        }
        return new File("Custom_V1");
    }

    public File getGameDataSetPath() {
        return W3I.getGameDataSetPath(this._gameData, this.getFlag(MapFlag.MELEE_MAP));
    }

    public void setGameDataSet(@Nonnull GameDataSet val) {
        this._gameData = val;
    }

    @Nullable
    public TerrainFog getTerrainFog() {
        return this._terrainFog;
    }

    public void setTerrainFog(@Nullable TerrainFog val) {
        this._terrainFog = val;
    }

    @Nullable
    public Id getGlobalWeatherId() {
        return this._globalWeatherId;
    }

    public void setGlobalWeatherId(@Nullable WeatherId val) {
        this._globalWeatherId = val;
    }

    @Nullable
    public SoundLabel getSoundEnv() {
        return this._soundEnv;
    }

    public void setSoundEnv(@Nullable SoundLabel val) {
        this._soundEnv = val;
    }

    @Nullable
    public Tileset getTilesetLightEnv() {
        return this._tilesetLightEnv;
    }

    public void setTilesetLightEnv(@Nullable Tileset val) {
        this._tilesetLightEnv = val;
    }

    @Nonnull
    public Color getWaterColor() {
        return this._waterColor;
    }

    public void setWaterColor(@Nonnull Color val) {
        this._waterColor = val;
    }

    @Nonnull
    public ScriptLang getScriptLang() {
        return this._scriptLang;
    }

    public void setScriptLang(@Nonnull ScriptLang val) {
        this._scriptLang = val;
    }

    @Nonnull
    public Graphics getGraphics() {
        return this._graphics;
    }

    public void setGraphics(@Nonnull Graphics val) {
        this._graphics = val;
    }

    @Nonnull
    public GameDataVersion getGameDataVersion() {
        return this._gameDataVersion;
    }

    public void setGameDataVersion(@Nonnull GameDataVersion val) {
        this._gameDataVersion = val;
    }

    @Nonnull
    public List<Player> getPlayers() {
        return this._players;
    }

    @Nullable
    public Player getPlayerFromNum(int num) {
        for (Player p : this._players) {
            if (p.getNum() != num) continue;
            return p;
        }
        return null;
    }

    public void addPlayer(@Nonnull Player val) {
        this._players.add(val);
    }

    @Nonnull
    public List<Force> getForces() {
        return new ArrayList<Force>(this._forces);
    }

    public void addForce(@Nonnull Force val) {
        this._forces.add(val);
    }

    public void removeForce(@Nonnull Force force) {
        this._forces.remove(force);
    }

    public void clearForces() {
        this._forces.clear();
    }

    @Nonnull
    public List<UpgradeMod> getUpgradeMods() {
        return new ArrayList<UpgradeMod>(this._upgradeMods);
    }

    public void addUpgradeMod(@Nonnull UpgradeMod val) {
        this._upgradeMods.add(val);
    }

    @Nonnull
    public List<TechMod> getTechMods() {
        return new ArrayList<TechMod>(this._techMods);
    }

    public void addTechMod(@Nonnull TechMod val) {
        this._techMods.add(val);
    }

    @Nonnull
    public List<UnitTable> getUnitTables() {
        return new ArrayList<UnitTable>(this._unitTables);
    }

    public void addUnitTable(@Nonnull UnitTable val) {
        this._unitTables.add(val);
    }

    @Nonnull
    public List<ItemTable> getItemTables() {
        return new ArrayList<ItemTable>(this._itemTables);
    }

    public void addItemTable(@Nonnull ItemTable val) {
        this._itemTables.add(val);
    }

    public void print(@Nonnull PrintStream outStream) {
        outStream.println(String.format("savesAmount: %s", this.getSavesAmount()));
        outStream.println(String.format("editorVersion: %d", this.getEditorVersion()));
        outStream.println(String.format("mapName: %s", this.getMapName()));
        outStream.println(String.format("mapAuthor: %s", this.getMapAuthor()));
        outStream.println(String.format("mapDescription: %s", this.getMapDescription()));
        outStream.println(String.format("playersRecommended: %s", this.getPlayersRecommendedAmount()));
        outStream.println(String.format("camBounds: [%s,%s,%s,%s]", this.getCameraBounds1(), this.getCameraBounds2(), this.getCameraBounds3(), this.getCameraBounds4()));
        outStream.println(String.format("margins: %s", this.getMargins()));
        outStream.println(String.format("dimensions: [width=%d height=%d]", this.getWidth(), this.getHeight()));
        outStream.println(String.format("flags: %s", this.getFlags()));
        outStream.println(String.format("tileset: %s", this.getTileset()));
        outStream.println(String.format("loadingScreen: %s", this.getLoadingScreen()));
        outStream.println(String.format("gameDataSet: %s", this.getGameDataSet()));
        outStream.println(String.format("gameDataVersion: %s", new Object[]{this.getGameDataVersion()}));
        outStream.println(String.format("scriptLang: %s", new Object[]{this.getScriptLang()}));
        outStream.println(String.format("graphics: %s", new Object[]{this.getGraphics()}));
        outStream.println(String.format("prologueScreen: %s", this.getPrologueScreen()));
        outStream.println(String.format("terrainFog: %s", this.getTerrainFog()));
        outStream.println(String.format("globalWeatherId: %s", this.getGlobalWeatherId()));
        outStream.println(String.format("soundEnv: %s", this.getSoundEnv()));
        outStream.println(String.format("tilesetLightEnv: %s", this.getTilesetLightEnv()));
        outStream.println(String.format("waterColor: %s", this.getWaterColor()));
        outStream.println(String.format("players: [%s]", this.getPlayers().stream().map(Player::toString).collect(Collectors.joining(" "))));
        outStream.println(String.format("forces: [%s]", this.getForces().stream().map(Force::toString).collect(Collectors.joining(" "))));
        outStream.println(String.format("upgradeMods: [%s]", this.getUpgradeMods().stream().map(UpgradeMod::toString).collect(Collectors.joining(" "))));
        outStream.println(String.format("techMods: [%s]", this.getTechMods().stream().map(TechMod::toString).collect(Collectors.joining(" "))));
        outStream.println(String.format("unitTables: [%s]", this.getUnitTables().stream().map(UnitTable::toString).collect(Collectors.joining(" "))));
        outStream.println(String.format("itemTables: [%s]", this.getItemTables().stream().map(ItemTable::toString).collect(Collectors.joining(" "))));
    }

    public void print() {
        this.print(System.out);
    }

    private void read_0x12(@Nonnull Wc3BinInputStream stream) throws Exception {
        this._fileVersion = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3I_0x12.getVersion(), this._fileVersion);
        this.set(State.SAVES_AMOUNT, War3Int.valueOf(stream.readInt32("savesAmount")));
        this.setEditorVersion(stream.readInt32("editorVersion"));
        this.setMapName(stream.readString("mapName"));
        this.setMapAuthor(stream.readString("mapAuthor"));
        this.setMapDescription(stream.readString("mapDescription"));
        this.setPlayersRecommendedAmount(stream.readString("playersRecommendedAmount"));
        this.setCameraBounds(new Coords2DF(stream.readFloat32("camA").floatValue(), stream.readFloat32("camB").floatValue()), new Coords2DF(stream.readFloat32("camC").floatValue(), stream.readFloat32("camD").floatValue()), new Coords2DF(stream.readFloat32("camE").floatValue(), stream.readFloat32("camF").floatValue()), new Coords2DF(stream.readFloat32("camG").floatValue(), stream.readFloat32("camH").floatValue()));
        this.setMargins(new Bounds(-stream.readInt32("marginA").intValue(), stream.readInt32("marginB"), -stream.readInt32("marginC").intValue(), stream.readInt32("marginD")));
        this.setDimensions(stream.readInt32("width"), stream.readInt32("height"));
        this.setFlags(Flags.valueOf(stream.readInt32("flags")));
        this.setTileset(Tileset.valueOf(stream.readChar("tileset").charValue()));
        this.setLoadingScreen(new LoadingScreen(stream, EncodingFormat.W3I_0x12));
        this.setGameDataSet(GameDataSet.valueOf(stream.readInt32("gameDataSet")));
        this.setPrologueScreen(new PrologueScreen(null, stream.readString("prologueScreenText"), stream.readString("prologueScreenTitle"), stream.readString("prologueScreenSubtitle")));
        int playersCount = stream.readInt32("playersCount");
        for (int i = 0; i < playersCount; ++i) {
            this.addPlayer(new Player(stream, EncodingFormat.W3I_0x12));
        }
        int forcesCount = stream.readInt32("forcesCount");
        for (int i = 0; i < forcesCount; ++i) {
            this.addForce(new Force(stream, EncodingFormat.W3I_0x12));
        }
        int upgradeModsCount = stream.readInt32("upgradeModsCount");
        for (int i = 0; i < upgradeModsCount; ++i) {
            this.addUpgradeMod(new UpgradeMod(stream, EncodingFormat.W3I_0x12));
        }
        int techModsCount = stream.readInt32("techModsCount");
        for (int i = 0; i < techModsCount; ++i) {
            this.addTechMod(new TechMod(stream, EncodingFormat.W3I_0x12));
        }
        int unitTablesCount = stream.readInt32("unitTablesCount");
        for (int i = 0; i < unitTablesCount; ++i) {
            this.addUnitTable(new UnitTable(stream, EncodingFormat.W3I_0x12));
        }
    }

    private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.W3I_0x12.getVersion());
        stream.writeInt32(this.getSavesAmount());
        stream.writeInt32(this.getEditorVersion());
        stream.writeString(this.getMapName());
        stream.writeString(this.getMapAuthor());
        stream.writeString(this.getMapDescription());
        stream.writeString(this.getPlayersRecommendedAmount());
        Coords2DF camBounds1 = this.getCameraBounds1();
        Coords2DF camBounds2 = this.getCameraBounds2();
        Coords2DF camBounds3 = this.getCameraBounds3();
        Coords2DF camBounds4 = this.getCameraBounds4();
        stream.writeFloat32(camBounds1.getX());
        stream.writeFloat32(camBounds1.getY());
        stream.writeFloat32(camBounds2.getX());
        stream.writeFloat32(camBounds2.getY());
        stream.writeFloat32(camBounds3.getX());
        stream.writeFloat32(camBounds3.getY());
        stream.writeFloat32(camBounds4.getX());
        stream.writeFloat32(camBounds4.getY());
        stream.writeInt32(-this.getMargins().getMinX());
        stream.writeInt32(this.getMargins().getMaxX());
        stream.writeInt32(-this.getMargins().getMinY());
        stream.writeInt32(this.getMargins().getMaxY());
        stream.writeInt32(this.getWidth());
        stream.writeInt32(this.getHeight());
        stream.writeInt32(this.getFlags().toInt());
        stream.writeChar(this.getTileset().getChar());
        this.getLoadingScreen().write(stream, EncodingFormat.W3I_0x12);
        stream.writeInt32(this.getGameDataSet().getIndex());
        PrologueScreen prologueScreen = this.getPrologueScreen();
        stream.writeString(prologueScreen != null ? prologueScreen.getText() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getTitle() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getSubtitle() : null);
        stream.writeInt32(this._players.size());
        for (Player player : this._players) {
            player.write(stream, EncodingFormat.W3I_0x12);
        }
        stream.writeInt32(this._forces.size());
        for (Force force : this._forces) {
            force.write(stream, EncodingFormat.W3I_0x12);
        }
        stream.writeInt32(this._upgradeMods.size());
        for (UpgradeMod upgradeMod : this._upgradeMods) {
            upgradeMod.write(stream, EncodingFormat.W3I_0x12);
        }
        stream.writeInt32(this._techMods.size());
        for (TechMod techMod : this._techMods) {
            techMod.write(stream, EncodingFormat.W3I_0x12);
        }
        stream.writeInt32(this._unitTables.size());
        for (UnitTable unitTable : this._unitTables) {
            unitTable.write(stream, EncodingFormat.W3I_0x12);
        }
    }

    private void read_0x19(@Nonnull Wc3BinInputStream stream) throws Exception {
        this._fileVersion = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3I_0x19.getVersion(), this._fileVersion);
        this.set(State.SAVES_AMOUNT, War3Int.valueOf(stream.readInt32("savesAmount")));
        this.setEditorVersion(stream.readInt32("editorVersion"));
        this.setMapName(stream.readString("mapName"));
        this.setMapAuthor(stream.readString("mapAuthor"));
        this.setMapDescription(stream.readString("mapDescription"));
        this.setPlayersRecommendedAmount(stream.readString("playersRecommendedAmount"));
        this.setCameraBounds(new Coords2DF(stream.readFloat32("camA").floatValue(), stream.readFloat32("camB").floatValue()), new Coords2DF(stream.readFloat32("camC").floatValue(), stream.readFloat32("camD").floatValue()), new Coords2DF(stream.readFloat32("camE").floatValue(), stream.readFloat32("camF").floatValue()), new Coords2DF(stream.readFloat32("camG").floatValue(), stream.readFloat32("camH").floatValue()));
        this.setMargins(new Bounds(-stream.readInt32("marginA").intValue(), stream.readInt32("marginB"), -stream.readInt32("marginC").intValue(), stream.readInt32("marginD")));
        this.setDimensions(stream.readInt32("width"), stream.readInt32("height"));
        this.setFlags(Flags.valueOf(stream.readInt32("flags")));
        this.setTileset(Tileset.valueOf(stream.readChar("tileset").charValue()));
        this.setLoadingScreen(new LoadingScreen(stream, EncodingFormat.W3I_0x19));
        this.setGameDataSet(GameDataSet.valueOf(stream.readInt32("gameDataSet")));
        this.setPrologueScreen(new PrologueScreen(stream.readString("prologueScreenPath"), stream.readString("prologueScreenText"), stream.readString("prologueScreenTitle"), stream.readString("prologueScreenSubtitle")));
        TerrainFogType terrainFogType = TerrainFogType.valueOf(stream.readInt32("terrainFogType"));
        War3Real terrainFogZStart = stream.readReal("terrainFogZStart");
        War3Real terrainFogZEnd = stream.readReal("terrainFogZEnd");
        War3Real terrainFogDensity = stream.readReal("terrainFogDensity");
        Color terrainFogColor = Color.fromRGBA255(stream.readUByte("terrainFogRed").shortValue(), stream.readUByte("terrainFogGreen").shortValue(), stream.readUByte("terrainFogBlue").shortValue(), stream.readUByte("terrainFogAlpha").shortValue());
        this.setTerrainFog(new TerrainFog(terrainFogType, terrainFogZStart, terrainFogZEnd, terrainFogDensity, terrainFogColor));
        this.setGlobalWeatherId(WeatherId.valueOf(stream.readId("globalWeatherId")));
        this.setSoundEnv(SoundLabel.valueOf(stream.readString("soundEnv")));
        this.setTilesetLightEnv(Tileset.valueOf(stream.readChar("tilesetLightEnv").charValue()));
        this.setWaterColor(Color.fromRGBA255(stream.readUByte("waterRed").shortValue(), stream.readUByte("waterGreen").shortValue(), stream.readUByte("waterBlue").shortValue(), stream.readUByte("waterAlpha").shortValue()));
        int playersCount = stream.readInt32("playersCount");
        for (int i = 0; i < playersCount; ++i) {
            this.addPlayer(new Player(stream, EncodingFormat.W3I_0x19));
        }
        if (stream.eof()) {
            return;
        }
        int forcesCount = stream.readInt32("forcesCount");
        for (int i = 0; i < forcesCount; ++i) {
            this.addForce(new Force(stream, EncodingFormat.W3I_0x19));
        }
        if (stream.eof()) {
            return;
        }
        if (stream.readUByte() == 255) {
            return;
        }
        stream.rewind(1L);
        int upgradeModsCount = stream.readInt32("upgradeModsCount");
        for (int i = 0; i < upgradeModsCount; ++i) {
            this.addUpgradeMod(new UpgradeMod(stream, EncodingFormat.W3I_0x19));
        }
        if (stream.eof()) {
            return;
        }
        int techModsCount = stream.readInt32("techModsCount");
        for (int i = 0; i < techModsCount; ++i) {
            this.addTechMod(new TechMod(stream, EncodingFormat.W3I_0x19));
        }
        if (stream.eof()) {
            return;
        }
        int unitTablesCount = stream.readInt32("unitTablesCount");
        for (int i = 0; i < unitTablesCount; ++i) {
            this.addUnitTable(new UnitTable(stream, EncodingFormat.W3I_0x19));
        }
        if (stream.eof()) {
            return;
        }
        int itemTablesCount = stream.readInt32("itemTablesCount");
        for (int i = 0; i < itemTablesCount; ++i) {
            this.addItemTable(new ItemTable(stream, EncodingFormat.W3I_0x19));
        }
    }

    private void write_0x19(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.W3I_0x19.getVersion());
        stream.writeInt32(this.getSavesAmount());
        stream.writeInt32(this.getEditorVersion());
        stream.writeString(this.getMapName());
        stream.writeString(this.getMapAuthor());
        stream.writeString(this.getMapDescription());
        stream.writeString(this.getPlayersRecommendedAmount());
        Coords2DF camBounds1 = this.getCameraBounds1();
        Coords2DF camBounds2 = this.getCameraBounds2();
        Coords2DF camBounds3 = this.getCameraBounds3();
        Coords2DF camBounds4 = this.getCameraBounds4();
        stream.writeFloat32(camBounds1.getX());
        stream.writeFloat32(camBounds1.getY());
        stream.writeFloat32(camBounds2.getX());
        stream.writeFloat32(camBounds2.getY());
        stream.writeFloat32(camBounds3.getX());
        stream.writeFloat32(camBounds3.getY());
        stream.writeFloat32(camBounds4.getX());
        stream.writeFloat32(camBounds4.getY());
        stream.writeInt32(-this.getMargins().getMinX());
        stream.writeInt32(this.getMargins().getMaxX());
        stream.writeInt32(-this.getMargins().getMinY());
        stream.writeInt32(this.getMargins().getMaxY());
        stream.writeInt32(this.getWidth());
        stream.writeInt32(this.getHeight());
        stream.writeInt32(this.getFlags().toInt());
        stream.writeChar(this.getTileset().getChar());
        this.getLoadingScreen().write(stream, EncodingFormat.W3I_0x19);
        stream.writeInt32(this.getGameDataSet().getIndex());
        PrologueScreen prologueScreen = this.getPrologueScreen();
        stream.writeString(prologueScreen != null ? prologueScreen.getPath() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getText() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getTitle() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getSubtitle() : null);
        TerrainFog terrainFog = this.getTerrainFog();
        TerrainFogType terrainFogType = terrainFog != null ? terrainFog.getType() : null;
        stream.writeInt32(terrainFogType != null ? terrainFogType.getVal() : 0);
        stream.writeReal(terrainFog != null ? terrainFog.getZStart() : null);
        stream.writeReal(terrainFog != null ? terrainFog.getZEnd() : null);
        stream.writeReal(terrainFog != null ? terrainFog.getDensity() : null);
        Color terrainFogColor = terrainFog != null ? terrainFog.getColor() : null;
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getRed255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getGreen255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getBlue255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getAlpha255() : 0);
        stream.writeId(this.getGlobalWeatherId());
        stream.writeString(this.getSoundEnv());
        stream.writeChar(this.getTilesetLightEnv() != null ? this.getTilesetLightEnv().getChar() : null);
        Color waterColor = this.getWaterColor();
        stream.writeUByte(waterColor.getRed255());
        stream.writeUByte(waterColor.getGreen255());
        stream.writeUByte(waterColor.getBlue255());
        stream.writeUByte(waterColor.getAlpha255());
        stream.writeInt32(this._players.size());
        for (Player player : this._players) {
            player.write(stream, EncodingFormat.W3I_0x19);
        }
        stream.writeInt32(this._forces.size());
        for (Force force : this._forces) {
            force.write(stream, EncodingFormat.W3I_0x19);
        }
        stream.writeInt32(this._upgradeMods.size());
        for (UpgradeMod upgradeMod : this._upgradeMods) {
            upgradeMod.write(stream, EncodingFormat.W3I_0x19);
        }
        stream.writeInt32(this._techMods.size());
        for (TechMod techMod : this._techMods) {
            techMod.write(stream, EncodingFormat.W3I_0x19);
        }
        stream.writeInt32(this._unitTables.size());
        for (UnitTable unitTable : this._unitTables) {
            unitTable.write(stream, EncodingFormat.W3I_0x19);
        }
        stream.writeInt32(this._itemTables.size());
        for (ItemTable itemTable : this._itemTables) {
            itemTable.write(stream, EncodingFormat.W3I_0x19);
        }
    }

    private void read_0x1C(@Nonnull Wc3BinInputStream stream) throws Exception {
        this._fileVersion = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3I_0x1C.getVersion(), this._fileVersion);
        this.set(State.SAVES_AMOUNT, War3Int.valueOf(stream.readInt32("savesAmount")));
        this.setEditorVersion(stream.readInt32("editorVersion"));
        this.setGameVersion_major(stream.readUInt32("gameVersion_major"));
        this.setGameVersion_minor(stream.readUInt32("gameVersion_minor"));
        this.setGameVersion_rev(stream.readUInt32("gameVersion_rev"));
        this.setGameVersion_build(stream.readUInt32("gameVersion_build"));
        this.setMapName(stream.readString("mapName"));
        this.setMapAuthor(stream.readString("mapAuthor"));
        this.setMapDescription(stream.readString("mapDescription"));
        this.setPlayersRecommendedAmount(stream.readString("playersRecommendedAmount"));
        this.setCameraBounds(new Coords2DF(stream.readFloat32("camA").floatValue(), stream.readFloat32("camB").floatValue()), new Coords2DF(stream.readFloat32("camC").floatValue(), stream.readFloat32("camD").floatValue()), new Coords2DF(stream.readFloat32("camE").floatValue(), stream.readFloat32("camF").floatValue()), new Coords2DF(stream.readFloat32("camG").floatValue(), stream.readFloat32("camH").floatValue()));
        this.setMargins(new Bounds(-stream.readInt32("marginA").intValue(), stream.readInt32("marginB"), -stream.readInt32("marginC").intValue(), stream.readInt32("marginD")));
        this.setDimensions(stream.readInt32("width"), stream.readInt32("height"));
        this.setFlags(Flags.valueOf(stream.readInt32("flags")));
        this.setTileset(Tileset.valueOf(stream.readChar("tileset").charValue()));
        this.setLoadingScreen(new LoadingScreen(stream, EncodingFormat.W3I_0x1C));
        this.setGameDataSet(GameDataSet.valueOf(stream.readInt32("gameDataSet")));
        this.setPrologueScreen(new PrologueScreen(stream.readString("prologueScreenPath"), stream.readString("prologueScreenText"), stream.readString("prologueScreenTitle"), stream.readString("prologueScreenSubtitle")));
        TerrainFogType terrainFogType = TerrainFogType.valueOf(stream.readInt32("terrainFogType"));
        War3Real terrainFogZStart = stream.readReal("terrainFogZStart");
        War3Real terrainFogZEnd = stream.readReal("terrainFogZEnd");
        War3Real terrainFogDensity = stream.readReal("terrainFogDensity");
        Color terrainFogColor = Color.fromRGBA255(stream.readUByte("terrainFogRed").shortValue(), stream.readUByte("terrainFogGreen").shortValue(), stream.readUByte("terrainFogBlue").shortValue(), stream.readUByte("terrainFogAlpha").shortValue());
        this.setTerrainFog(new TerrainFog(terrainFogType, terrainFogZStart, terrainFogZEnd, terrainFogDensity, terrainFogColor));
        this.setGlobalWeatherId(WeatherId.valueOf(stream.readId("globalWeatherId")));
        this.setSoundEnv(SoundLabel.valueOf(stream.readString("soundEnv")));
        this.setTilesetLightEnv(Tileset.valueOf(stream.readChar("tilesetLightEnv").charValue()));
        this.setWaterColor(Color.fromRGBA255(stream.readUByte("waterRed").shortValue(), stream.readUByte("waterGreen").shortValue(), stream.readUByte("waterBlue").shortValue(), stream.readUByte("waterAlpha").shortValue()));
        this.setScriptLang(stream.readUInt32("scriptLang") == 0L ? ScriptLang.JASS : ScriptLang.LUA);
        int playersCount = stream.readInt32("playersCount");
        for (int i = 0; i < playersCount; ++i) {
            this.addPlayer(new Player(stream, EncodingFormat.W3I_0x1C));
        }
        if (stream.eof()) {
            return;
        }
        int forcesCount = stream.readInt32("forcesCount");
        for (int i = 0; i < forcesCount; ++i) {
            this.addForce(new Force(stream, EncodingFormat.W3I_0x1C));
        }
        if (stream.eof()) {
            return;
        }
        if (stream.readUByte() == 255) {
            return;
        }
        stream.rewind(1L);
        int upgradeModsCount = stream.readInt32("upgradeModsCount");
        for (int i = 0; i < upgradeModsCount; ++i) {
            this.addUpgradeMod(new UpgradeMod(stream, EncodingFormat.W3I_0x1C));
        }
        if (stream.eof()) {
            return;
        }
        int techModsCount = stream.readInt32("techModsCount");
        for (int i = 0; i < techModsCount; ++i) {
            this.addTechMod(new TechMod(stream, EncodingFormat.W3I_0x1C));
        }
        if (stream.eof()) {
            return;
        }
        int unitTablesCount = stream.readInt32("unitTablesCount");
        for (int i = 0; i < unitTablesCount; ++i) {
            this.addUnitTable(new UnitTable(stream, EncodingFormat.W3I_0x1C));
        }
        if (stream.eof()) {
            return;
        }
        int itemTablesCount = stream.readInt32("itemTablesCount");
        for (int i = 0; i < itemTablesCount; ++i) {
            this.addItemTable(new ItemTable(stream, EncodingFormat.W3I_0x1C));
        }
    }

    private void write_0x1C(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.W3I_0x1C.getVersion());
        stream.writeInt32(this.getSavesAmount());
        stream.writeInt32(this.getEditorVersion());
        stream.writeUInt32(this.getGameVersion_major());
        stream.writeUInt32(this.getGameVersion_minor());
        stream.writeUInt32(this.getGameVersion_rev());
        stream.writeUInt32(this.getGameVersion_build());
        stream.writeString(this.getMapName());
        stream.writeString(this.getMapAuthor());
        stream.writeString(this.getMapDescription());
        stream.writeString(this.getPlayersRecommendedAmount());
        Coords2DF camBounds1 = this.getCameraBounds1();
        Coords2DF camBounds2 = this.getCameraBounds2();
        Coords2DF camBounds3 = this.getCameraBounds3();
        Coords2DF camBounds4 = this.getCameraBounds4();
        stream.writeFloat32(camBounds1.getX());
        stream.writeFloat32(camBounds1.getY());
        stream.writeFloat32(camBounds2.getX());
        stream.writeFloat32(camBounds2.getY());
        stream.writeFloat32(camBounds3.getX());
        stream.writeFloat32(camBounds3.getY());
        stream.writeFloat32(camBounds4.getX());
        stream.writeFloat32(camBounds4.getY());
        stream.writeInt32(-this.getMargins().getMinX());
        stream.writeInt32(this.getMargins().getMaxX());
        stream.writeInt32(-this.getMargins().getMinY());
        stream.writeInt32(this.getMargins().getMaxY());
        stream.writeInt32(this.getWidth());
        stream.writeInt32(this.getHeight());
        stream.writeInt32(this.getFlags().toInt());
        stream.writeChar(this.getTileset().getChar());
        this.getLoadingScreen().write(stream, EncodingFormat.W3I_0x1C);
        stream.writeInt32(this.getGameDataSet().getIndex());
        PrologueScreen prologueScreen = this.getPrologueScreen();
        stream.writeString(prologueScreen != null ? prologueScreen.getPath() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getText() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getTitle() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getSubtitle() : null);
        TerrainFog terrainFog = this.getTerrainFog();
        TerrainFogType terrainFogType = terrainFog != null ? terrainFog.getType() : null;
        stream.writeInt32(terrainFogType != null ? terrainFogType.getVal() : 0);
        stream.writeReal(terrainFog != null ? terrainFog.getZStart() : null);
        stream.writeReal(terrainFog != null ? terrainFog.getZEnd() : null);
        stream.writeReal(terrainFog != null ? terrainFog.getDensity() : null);
        Color terrainFogColor = terrainFog != null ? terrainFog.getColor() : null;
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getRed255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getGreen255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getBlue255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getAlpha255() : 0);
        stream.writeId(this.getGlobalWeatherId());
        stream.writeString(this.getSoundEnv());
        stream.writeChar(this.getTilesetLightEnv() != null ? this.getTilesetLightEnv().getChar() : null);
        Color waterColor = this.getWaterColor();
        stream.writeUByte(waterColor.getRed255());
        stream.writeUByte(waterColor.getGreen255());
        stream.writeUByte(waterColor.getBlue255());
        stream.writeUByte(waterColor.getAlpha255());
        stream.writeUInt32(this.getScriptLang() == ScriptLang.LUA ? 1L : 0L);
        stream.writeInt32(this._players.size());
        for (Player player : this._players) {
            player.write(stream, EncodingFormat.W3I_0x1C);
        }
        stream.writeInt32(this._forces.size());
        for (Force force : this._forces) {
            force.write(stream, EncodingFormat.W3I_0x1C);
        }
        stream.writeInt32(this._upgradeMods.size());
        for (UpgradeMod upgradeMod : this._upgradeMods) {
            upgradeMod.write(stream, EncodingFormat.W3I_0x1C);
        }
        stream.writeInt32(this._techMods.size());
        for (TechMod techMod : this._techMods) {
            techMod.write(stream, EncodingFormat.W3I_0x1C);
        }
        stream.writeInt32(this._unitTables.size());
        for (UnitTable unitTable : this._unitTables) {
            unitTable.write(stream, EncodingFormat.W3I_0x1C);
        }
        stream.writeInt32(this._itemTables.size());
        for (ItemTable itemTable : this._itemTables) {
            itemTable.write(stream, EncodingFormat.W3I_0x1C);
        }
    }

    private void read_0x1F(@Nonnull Wc3BinInputStream stream) throws Exception {
        this._fileVersion = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.W3I_0x1F.getVersion(), this._fileVersion);
        this.set(State.SAVES_AMOUNT, War3Int.valueOf(stream.readInt32("savesAmount")));
        this.setEditorVersion(stream.readInt32("editorVersion"));
        this.setGameVersion_major(stream.readUInt32("gameVersion_major"));
        this.setGameVersion_minor(stream.readUInt32("gameVersion_minor"));
        this.setGameVersion_rev(stream.readUInt32("gameVersion_rev"));
        this.setGameVersion_build(stream.readUInt32("gameVersion_build"));
        this.setMapName(stream.readString("mapName"));
        this.setMapAuthor(stream.readString("mapAuthor"));
        this.setMapDescription(stream.readString("mapDescription"));
        this.setPlayersRecommendedAmount(stream.readString("playersRecommendedAmount"));
        this.setCameraBounds(new Coords2DF(stream.readFloat32("camA").floatValue(), stream.readFloat32("camB").floatValue()), new Coords2DF(stream.readFloat32("camC").floatValue(), stream.readFloat32("camD").floatValue()), new Coords2DF(stream.readFloat32("camE").floatValue(), stream.readFloat32("camF").floatValue()), new Coords2DF(stream.readFloat32("camG").floatValue(), stream.readFloat32("camH").floatValue()));
        this.setMargins(new Bounds(-stream.readInt32("marginA").intValue(), stream.readInt32("marginB"), -stream.readInt32("marginC").intValue(), stream.readInt32("marginD")));
        this.setDimensions(stream.readInt32("width"), stream.readInt32("height"));
        this.setFlags(Flags.valueOf(stream.readInt32("flags")));
        this.setTileset(Tileset.valueOf(stream.readChar("tileset").charValue()));
        this.setLoadingScreen(new LoadingScreen(stream, EncodingFormat.W3I_0x1F));
        this.setGameDataSet(GameDataSet.valueOf(stream.readInt32("gameDataSet")));
        this.setPrologueScreen(new PrologueScreen(stream.readString("prologueScreenPath"), stream.readString("prologueScreenText"), stream.readString("prologueScreenTitle"), stream.readString("prologueScreenSubtitle")));
        TerrainFogType terrainFogType = TerrainFogType.valueOf(stream.readInt32("terrainFogType"));
        War3Real terrainFogZStart = stream.readReal("terrainFogZStart");
        War3Real terrainFogZEnd = stream.readReal("terrainFogZEnd");
        War3Real terrainFogDensity = stream.readReal("terrainFogDensity");
        Color terrainFogColor = Color.fromRGBA255(stream.readUByte("terrainFogRed").shortValue(), stream.readUByte("terrainFogGreen").shortValue(), stream.readUByte("terrainFogBlue").shortValue(), stream.readUByte("terrainFogAlpha").shortValue());
        this.setTerrainFog(new TerrainFog(terrainFogType, terrainFogZStart, terrainFogZEnd, terrainFogDensity, terrainFogColor));
        this.setGlobalWeatherId(WeatherId.valueOf(stream.readId("globalWeatherId")));
        this.setSoundEnv(SoundLabel.valueOf(stream.readString("soundEnv")));
        this.setTilesetLightEnv(Tileset.valueOf(stream.readChar("tilesetLightEnv").charValue()));
        this.setWaterColor(Color.fromRGBA255(stream.readUByte("waterRed").shortValue(), stream.readUByte("waterGreen").shortValue(), stream.readUByte("waterBlue").shortValue(), stream.readUByte("waterAlpha").shortValue()));
        this.setScriptLang(stream.readUInt32("scriptLang") == 0L ? ScriptLang.JASS : ScriptLang.LUA);
        this.setGraphics(((Function<Long, Graphics>)val -> {
            if (val == 1L) {
                return Graphics.SD;
            }
            if (val == 2L) {
                return Graphics.HD;
            }
            if (val == 3L) {
                return Graphics.SD_AND_HD;
            }
            return Graphics.SD;
        }).apply(stream.readUInt32("graphics")));
        this.setGameDataVersion(stream.readUInt32("gameDataVersion") == 0L ? GameDataVersion.ROC : GameDataVersion.TFT);
        int playersCount = stream.readInt32("playersCount");
        for (int i = 0; i < playersCount; ++i) {
            this.addPlayer(new Player(stream, EncodingFormat.W3I_0x1F));
        }
        if (stream.eof()) {
            return;
        }
        int forcesCount = stream.readInt32("forcesCount");
        for (int i = 0; i < forcesCount; ++i) {
            this.addForce(new Force(stream, EncodingFormat.W3I_0x1F));
        }
        if (stream.eof()) {
            return;
        }
        if (stream.readUByte() == 255) {
            return;
        }
        stream.rewind(1L);
        int upgradeModsCount = stream.readInt32("upgradeModsCount");
        for (int i = 0; i < upgradeModsCount; ++i) {
            this.addUpgradeMod(new UpgradeMod(stream, EncodingFormat.W3I_0x1F));
        }
        if (stream.eof()) {
            return;
        }
        int techModsCount = stream.readInt32("techModsCount");
        for (int i = 0; i < techModsCount; ++i) {
            this.addTechMod(new TechMod(stream, EncodingFormat.W3I_0x1F));
        }
        if (stream.eof()) {
            return;
        }
        int unitTablesCount = stream.readInt32("unitTablesCount");
        for (int i = 0; i < unitTablesCount; ++i) {
            this.addUnitTable(new UnitTable(stream, EncodingFormat.W3I_0x1F));
        }
        if (stream.eof()) {
            return;
        }
        int itemTablesCount = stream.readInt32("itemTablesCount");
        for (int i = 0; i < itemTablesCount; ++i) {
            this.addItemTable(new ItemTable(stream, EncodingFormat.W3I_0x1F));
        }
    }

    private void write_0x1F(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.W3I_0x1F.getVersion());
        stream.writeInt32(this.getSavesAmount());
        stream.writeInt32(this.getEditorVersion());
        stream.writeUInt32(this.getGameVersion_major());
        stream.writeUInt32(this.getGameVersion_minor());
        stream.writeUInt32(this.getGameVersion_rev());
        stream.writeUInt32(this.getGameVersion_build());
        stream.writeString(this.getMapName());
        stream.writeString(this.getMapAuthor());
        stream.writeString(this.getMapDescription());
        stream.writeString(this.getPlayersRecommendedAmount());
        Coords2DF camBounds1 = this.getCameraBounds1();
        Coords2DF camBounds2 = this.getCameraBounds2();
        Coords2DF camBounds3 = this.getCameraBounds3();
        Coords2DF camBounds4 = this.getCameraBounds4();
        stream.writeFloat32(camBounds1.getX());
        stream.writeFloat32(camBounds1.getY());
        stream.writeFloat32(camBounds2.getX());
        stream.writeFloat32(camBounds2.getY());
        stream.writeFloat32(camBounds3.getX());
        stream.writeFloat32(camBounds3.getY());
        stream.writeFloat32(camBounds4.getX());
        stream.writeFloat32(camBounds4.getY());
        stream.writeInt32(-this.getMargins().getMinX());
        stream.writeInt32(this.getMargins().getMaxX());
        stream.writeInt32(-this.getMargins().getMinY());
        stream.writeInt32(this.getMargins().getMaxY());
        stream.writeInt32(this.getWidth());
        stream.writeInt32(this.getHeight());
        stream.writeInt32(this.getFlags().toInt());
        stream.writeChar(this.getTileset().getChar());
        this.getLoadingScreen().write(stream, EncodingFormat.W3I_0x1F);
        stream.writeInt32(this.getGameDataSet().getIndex());
        PrologueScreen prologueScreen = this.getPrologueScreen();
        stream.writeString(prologueScreen != null ? prologueScreen.getPath() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getText() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getTitle() : null);
        stream.writeString(prologueScreen != null ? prologueScreen.getSubtitle() : null);
        TerrainFog terrainFog = this.getTerrainFog();
        TerrainFogType terrainFogType = terrainFog != null ? terrainFog.getType() : null;
        stream.writeInt32(terrainFogType != null ? terrainFogType.getVal() : 0);
        stream.writeReal(terrainFog != null ? terrainFog.getZStart() : null);
        stream.writeReal(terrainFog != null ? terrainFog.getZEnd() : null);
        stream.writeReal(terrainFog != null ? terrainFog.getDensity() : null);
        Color terrainFogColor = terrainFog != null ? terrainFog.getColor() : null;
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getRed255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getGreen255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getBlue255() : 0);
        stream.writeUByte(terrainFogColor != null ? terrainFogColor.getAlpha255() : 0);
        stream.writeId(this.getGlobalWeatherId());
        stream.writeString(this.getSoundEnv());
        stream.writeChar(this.getTilesetLightEnv() != null ? this.getTilesetLightEnv().getChar() : null);
        Color waterColor = this.getWaterColor();
        stream.writeUByte(waterColor.getRed255());
        stream.writeUByte(waterColor.getGreen255());
        stream.writeUByte(waterColor.getBlue255());
        stream.writeUByte(waterColor.getAlpha255());
        stream.writeUInt32(this.getScriptLang() == ScriptLang.LUA ? 1L : 0L);
        stream.writeUInt32(((Function<Graphics, Long>)val -> {
            if (val == Graphics.SD) {
                return 1L;
            }
            if (val == Graphics.HD) {
                return 2L;
            }
            if (val == Graphics.SD_AND_HD) {
                return 3L;
            }
            return 1L;
        }).apply(this.getGraphics()));
        stream.writeUInt32(this.getGameDataVersion() == GameDataVersion.TFT ? 1L : 0L);
        stream.writeInt32(this._players.size());
        for (Player player : this._players) {
            player.write(stream, EncodingFormat.W3I_0x1F);
        }
        stream.writeInt32(this._forces.size());
        for (Force force : this._forces) {
            force.write(stream, EncodingFormat.W3I_0x1F);
        }
        stream.writeInt32(this._upgradeMods.size());
        for (UpgradeMod upgradeMod : this._upgradeMods) {
            upgradeMod.write(stream, EncodingFormat.W3I_0x1F);
        }
        stream.writeInt32(this._techMods.size());
        for (TechMod techMod : this._techMods) {
            techMod.write(stream, EncodingFormat.W3I_0x1F);
        }
        stream.writeInt32(this._unitTables.size());
        for (UnitTable unitTable : this._unitTables) {
            unitTable.write(stream, EncodingFormat.W3I_0x1F);
        }
        stream.writeInt32(this._itemTables.size());
        for (ItemTable itemTable : this._itemTables) {
            itemTable.write(stream, EncodingFormat.W3I_0x1F);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws Exception {
        int version = stream.readInt32("version");
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws Exception {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case W3I_0x12: {
                this.read_0x12(stream);
                break;
            }
            case W3I_0x19: {
                this.read_0x19(stream);
                break;
            }
            case W3I_0x1C: {
                this.read_0x1C(stream);
                break;
            }
            case W3I_0x1F: {
                this.read_0x1F(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                format = EncodingFormat.valueOf(this._fileVersion);
                if (format == null) {
                    throw new IllegalArgumentException("no writer for " + this._fileVersion);
                }
                this.write(stream, format);
                break;
            }
            case W3I_0x1F: {
                this.write_0x1F(stream);
                break;
            }
            case W3I_0x1C: {
                this.write_0x1C(stream);
                break;
            }
            case W3I_0x19: {
                this.write_0x19(stream);
                break;
            }
            case W3I_0x12: {
                this.write_0x12(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public W3I() {
        for (State state : State.values(State.class)) {
            this.set(state, state.getDefVal());
        }
    }

    public W3I(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream);
    }

    public W3I(@Nonnull byte[] bytes) throws Exception {
        this.read(new Wc3BinInputStream(new ByteArrayInputStream(bytes)));
    }

    public W3I(@Nonnull File file) throws Exception {
        this.read(new Wc3BinInputStream(file));
    }

    @Nonnull
    public static W3I ofMapFile(@Nonnull File mapFile) throws Exception {
        Orient.checkFileExists(mapFile);
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(GAME_PATH);
        MpqPort.Out.Result portResult = port.commit(mapFile);
        if (!portResult.getExports().containsKey(GAME_PATH)) {
            throw new IOException("could not extract info file");
        }
        Wc3BinInputStream inStream = new Wc3BinInputStream(portResult.getInputStream(GAME_PATH));
        W3I w3i = new W3I();
        w3i.read(inStream);
        inStream.close();
        return w3i;
    }

    public FuncImpl makeInitCustomPlayerSlots(boolean isLua) {
        FuncDecl funcDecl = new FuncDecl(false, "InitCustomPlayerSlots", new ArrayList<Param>(), null);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        for (Player player : this.getPlayers()) {
            stmts.add(Statement.create("call SetPlayerStartLocation(Player(" + player.getNum() + "), " + player.getNum() + ")"));
            if (player.getStartPosFixed() == 1) {
                stmts.add(Statement.create("call ForcePlayerStartLocation(Player(" + player.getNum() + "), " + player.getNum() + ")"));
            }
            stmts.add(Statement.create("call SetPlayerColor(Player(" + player.getNum() + "), ConvertPlayerColor(" + player.getNum() + "))"));
            stmts.add(Statement.create("call SetPlayerRacePreference(Player(" + player.getNum() + "), " + player.getRace().getJassExpr() + ")"));
            stmts.add(Statement.create("call SetPlayerRaceSelectable(Player(" + player.getNum() + "), " + (player.getRace().equals(Player.UnitRace.SELECTABLE) || !this.getFlag(MapFlag.FIXED_PLAYER_FORCE_SETTING) ? "true" : "false") + ")"));
            stmts.add(Statement.create("call SetPlayerController(Player(" + player.getNum() + "), " + player.getType().getJassExpr() + ")"));
        }
        FuncImpl.Body body = new FuncImpl.Body(new ArrayList<VarDecl>(), stmts);
        FuncImpl funcImpl = new FuncImpl(funcDecl, body);
        return funcImpl;
    }

    public FuncImpl makeInitCustomTeams(boolean isLua) {
        Player player;
        FuncDecl funcDecl = new FuncDecl(false, "InitCustomTeams", new ArrayList<Param>(), null);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        LinkedHashMap<Integer, Player> numToPlayerMap = new LinkedHashMap<Integer, Player>();
        for (Player player2 : this.getPlayers()) {
            numToPlayerMap.put(player2.getNum(), player2);
        }
        for (Force force : this.getForces()) {
            for (Integer playerNum : force.getPlayerNums(this.getPlayers())) {
                player = (Player)numToPlayerMap.get(playerNum);
                stmts.add(Statement.create("call SetPlayerTeam(Player(" + player.getNum() + "), " + this.getForces().indexOf(force) + ")"));
            }
        }
        for (Force force : this.getForces()) {
            for (Integer playerNum : force.getPlayerNums(this.getPlayers())) {
                player = (Player)numToPlayerMap.get(playerNum);
                if (force.getFlag(Force.Flags.Flag.ALLIED)) {
                    for (Integer playerNum2 : force.getPlayerNums(this.getPlayers())) {
                        if (playerNum.equals(playerNum2)) continue;
                        stmts.add(Statement.create("call SetPlayerAllianceStateAllyBJ(Player(" + player.getNum() + "), Player(" + playerNum2 + "), true)"));
                    }
                }
                if (!force.getFlag(Force.Flags.Flag.SHARED_VISION)) continue;
                for (Integer playerNum2 : force.getPlayerNums(this.getPlayers())) {
                    if (playerNum.equals(playerNum2)) continue;
                    stmts.add(Statement.create("call SetPlayerAllianceStateVisionBJ(Player(" + player.getNum() + "), Player(" + playerNum2 + "), true)"));
                }
            }
        }
        FuncImpl.Body body = new FuncImpl.Body(new ArrayList<VarDecl>(), stmts);
        FuncImpl funcImpl = new FuncImpl(funcDecl, body);
        return funcImpl;
    }

    public FuncImpl makeInitAllyPriorities(@Nonnull GameVersion gameVersion, boolean isLua) {
        FuncDecl funcDecl = new FuncDecl(false, "InitAllyPriorities", new ArrayList<Param>(), null);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        for (Player player : this.getPlayers()) {
            int otherPlayerNum;
            int playerNum = player.getNum();
            Set<Integer> allyLowNums = player.getAllyLowPrioPlayerNums();
            Set<Integer> allyHighNums = player.getAllyHighPrioPlayerNums();
            stmts.add(Statement.create(String.format("call SetStartLocPrioCount(%d, %d)", playerNum, allyLowNums.size() + allyHighNums.size())));
            int c = 0;
            for (Player otherPlayer : this.getPlayers()) {
                otherPlayerNum = otherPlayer.getNum();
                if (playerNum == otherPlayerNum) continue;
                if (allyLowNums.contains(otherPlayerNum)) {
                    stmts.add(Statement.create(String.format("call SetStartLocPrio(%d, %d, %d, %s)", playerNum, c, otherPlayerNum, "MAP_LOC_PRIO_LOW")));
                } else if (allyHighNums.contains(otherPlayerNum)) {
                    stmts.add(Statement.create(String.format("call SetStartLocPrio(%d, %d, %d, %s)", playerNum, c, otherPlayerNum, "MAP_LOC_PRIO_HIGH")));
                }
                ++c;
            }
            if (gameVersion.compareTo(GameVersion.VERSION_1_32) < 0) continue;
            Set<Integer> enemyLowNums = player.getEnemyLowPrioPlayerNums();
            Set<Integer> enemyHighNums = player.getEnemyHighPrioPlayerNums();
            stmts.add(Statement.create(String.format("call SetEnemyStartLocPrioCount(%d, %d)", playerNum, enemyLowNums.size() + enemyHighNums.size())));
            c = 0;
            for (Player otherPlayer : this.getPlayers()) {
                otherPlayerNum = otherPlayer.getNum();
                if (playerNum == otherPlayerNum) continue;
                if (enemyLowNums.contains(otherPlayerNum)) {
                    stmts.add(Statement.create(String.format("call SetEnemyStartLocPrio(%d, %d, %d, %s)", playerNum, c, otherPlayerNum, "MAP_LOC_PRIO_LOW")));
                } else if (enemyHighNums.contains(otherPlayerNum)) {
                    stmts.add(Statement.create(String.format("call SetEnemyStartLocPrio(%d, %d, %d, %s)", playerNum, c, otherPlayerNum, "MAP_LOC_PRIO_HIGH")));
                }
                ++c;
            }
        }
        FuncImpl.Body body = new FuncImpl.Body(new ArrayList<VarDecl>(), stmts);
        FuncImpl funcImpl = new FuncImpl(funcDecl, body);
        return funcImpl;
    }

    public FuncImpl makeConfig(boolean isLua) {
        FuncDecl funcDecl = new FuncDecl(false, "config", new ArrayList<Param>(), null);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        Function<String, String> enquote = s -> "\"" + s + "\"";
        stmts.add(Statement.create("call SetMapName(" + enquote.apply(this.getMapName()) + ")"));
        if (isLua) {
            stmts.add(Statement.create("call SetMapDescription(" + enquote.apply(this.getMapDescription().replaceAll("\n", "\\\\n")) + ")"));
        } else {
            stmts.add(Statement.create("call SetMapDescription(" + enquote.apply(this.getMapDescription()) + ")"));
        }
        stmts.add(Statement.create("call SetPlayers(" + this.getPlayers().size() + ")"));
        stmts.add(Statement.create("call SetTeams(" + this.getForces().size() + ")"));
        stmts.add(Statement.create("call SetGamePlacement(MAP_PLACEMENT_TEAMS_TOGETHER)"));
        for (Player player : this.getPlayers()) {
            stmts.add(Statement.create("call DefineStartLocation(" + player.getNum() + ", " + player.getStartPos().getX() + ", " + player.getStartPos().getY() + ")"));
        }
        stmts.add(Statement.create("call InitCustomPlayerSlots()"));
        stmts.add(Statement.create("call InitCustomTeams()"));
        stmts.add(Statement.create("call InitAllyPriorities()"));
        FuncImpl.Body body = new FuncImpl.Body(new ArrayList<VarDecl>(), stmts);
        FuncImpl funcImpl = new FuncImpl(funcDecl, body);
        return funcImpl;
    }

    public void injectConfigsInJassScript(@Nonnull JassScript jassScript, @Nonnull GameVersion gameVersion) {
        ArrayList<String> funcNames = new ArrayList<String>();
        funcNames.add("config");
        funcNames.add("InitCustomPlayerSlots");
        funcNames.add("InitCustomTeams");
        funcNames.add("InitAllyPriorities");
        ArrayList<FuncImpl> funcImplsToRemove = new ArrayList<FuncImpl>();
        for (FuncImpl funcImpl : jassScript.getFuncImpls()) {
            if (!funcNames.contains(funcImpl.getDecl().getName())) continue;
            funcImplsToRemove.add(funcImpl);
        }
        for (FuncImpl funcImpl : funcImplsToRemove) {
            jassScript.removeFuncImpl(funcImpl);
        }
        FuncImpl initCustomPlayerSlots = this.makeInitCustomPlayerSlots(false);
        FuncImpl initCustomTeams = this.makeInitCustomTeams(false);
        FuncImpl initAllyPriorities = this.makeInitAllyPriorities(gameVersion, false);
        FuncImpl config = this.makeConfig(false);
        jassScript.addFuncImpl(initCustomPlayerSlots);
        jassScript.addFuncImpl(initCustomTeams);
        jassScript.addFuncImpl(initAllyPriorities);
        jassScript.addFuncImpl(config);
    }

    public void removeConfigsInScript(@Nonnull InputStream inStream, @Nonnull StringWriter sw, boolean isLua) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> toBeRemovedFuncs = new ArrayList<String>();
            toBeRemovedFuncs.add("config");
            toBeRemovedFuncs.add("InitCustomPlayerSlots");
            toBeRemovedFuncs.add("InitCustomTeams");
            toBeRemovedFuncs.add("InitAllyPriorities");
            boolean first = true;
            boolean skip = false;
            while ((line = reader.readLine()) != null) {
                String funcName;
                Matcher funcStartMatcher = (isLua ? funcStartPatternLua : funcStartPattern).matcher(line);
                if (funcStartMatcher.find() && toBeRemovedFuncs.contains(funcName = funcStartMatcher.group(1))) {
                    skip = true;
                }
                if (skip) {
                    Matcher funcEndMatcher = (isLua ? funcEndPatternLua : funcEndPattern).matcher(line);
                    if (!funcEndMatcher.find()) continue;
                    skip = false;
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    sw.write("\n");
                }
                sw.write(line);
            }
        }
    }

    public void injectConfigsInLuaScript(@Nonnull InputStream inStream, @Nonnull StringWriter sw) throws IOException {
        this.injectConfigsInScript(inStream, sw, GameVersion.VERSION_1_32, true);
    }

    public void injectConfigsInJassScript(@Nonnull InputStream inStream, @Nonnull StringWriter sw, @Nonnull GameVersion gameVersion) throws IOException {
        this.injectConfigsInScript(inStream, sw, gameVersion, false);
    }

    public void injectConfigsInScript(@Nonnull InputStream inStream, @Nonnull StringWriter sw, @Nonnull GameVersion gameVersion, boolean isLua) throws IOException {
        this.removeConfigsInScript(inStream, sw, isLua);
        ArrayList<FuncImpl> toBeAddedFuncImpls = new ArrayList<FuncImpl>();
        toBeAddedFuncImpls.add(this.makeInitCustomPlayerSlots(isLua));
        toBeAddedFuncImpls.add(this.makeInitCustomTeams(isLua));
        toBeAddedFuncImpls.add(this.makeInitAllyPriorities(gameVersion, isLua));
        toBeAddedFuncImpls.add(this.makeConfig(isLua));
        for (FuncImpl funcImpl : toBeAddedFuncImpls) {
            sw.write("\n");
            funcImpl.write(sw, isLua);
        }
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat W3I_0x1F = new EncodingFormat(Enum.W3I_0x1F, 31);
        public static final EncodingFormat W3I_0x1C = new EncodingFormat(Enum.W3I_0x1C, 28);
        public static final EncodingFormat W3I_0x19 = new EncodingFormat(Enum.W3I_0x19, 25);
        public static final EncodingFormat W3I_0x12 = new EncodingFormat(Enum.W3I_0x12, 18);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            W3I_0x1F,
            W3I_0x1C,
            W3I_0x19,
            W3I_0x12;

        }
    }

    public static class ItemTable {
        private int _index = 0;
        private String _name;
        private List<Set> _sets = new ArrayList<Set>();

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int val) {
            this._index = val;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String val) {
            this._name = val;
        }

        @Nonnull
        public List<Set> getSets() {
            return new ArrayList<Set>(this._sets);
        }

        public void addSet(@Nonnull Set val) {
            this._sets.add(val);
        }

        public String toString() {
            return String.format("index=%s name=%s sets=[%s]", this._index, this._name, this._sets.stream().map(Set::toString).collect(Collectors.joining(" ")));
        }

        private void read_0x19(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setIndex(stream.readInt32("index"));
            this.setName(stream.readString("name"));
            int setsCount = stream.readInt32("setsCount");
            for (int i = 0; i < setsCount; ++i) {
                this.addSet(new Set(stream, EncodingFormat.W3I_0x19));
            }
        }

        private void write_0x19(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getIndex());
            stream.writeString(this.getName());
            stream.writeInt32(this._sets.size());
            for (Set set : this._sets) {
                set.write(stream, EncodingFormat.W3I_0x19);
            }
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: {
                    this.read_0x19(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case AUTO: {
                    this.write_0x19(stream);
                }
            }
        }

        public ItemTable(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public ItemTable(int index, @Nonnull String name) {
            this._index = index;
            this._name = name;
        }

        public static class Set {
            private List<Item> _items = new ArrayList<Item>();

            @Nonnull
            public List<Item> getItems() {
                return new ArrayList<Item>(this._items);
            }

            public void addItem(@Nonnull Item val) {
                this._items.add(val);
            }

            public String toString() {
                return String.format("items=[%s]", this._items.stream().map(Item::toString).collect(Collectors.joining(" ")));
            }

            private void read_0x19(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                int itemsCount = stream.readInt32("itemsCount");
                for (int i = 0; i < itemsCount; ++i) {
                    this.addItem(new Item(stream, EncodingFormat.W3I_0x19));
                }
            }

            private void write_0x19(@Nonnull Wc3BinOutputStream stream) {
                stream.writeInt32(this._items.size());
                for (Item item : this._items) {
                    item.write(stream, EncodingFormat.W3I_0x19);
                }
            }

            private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case W3I_0x1F: 
                    case W3I_0x1C: 
                    case W3I_0x19: {
                        this.read_0x19(stream);
                    }
                }
            }

            private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case W3I_0x1F: 
                    case W3I_0x1C: 
                    case W3I_0x19: 
                    case AUTO: {
                        this.write_0x19(stream);
                    }
                }
            }

            public Set(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                this.read(stream, format);
            }

            public Set() {
            }

            public static class Item {
                private int _chance = 100;
                private Id _typeId;

                public int getChance() {
                    return this._chance;
                }

                public void setChance(int val) {
                    this._chance = val;
                }

                @Nonnull
                public Id getTypeId() {
                    return this._typeId;
                }

                public void setTypeId(@Nonnull Id val) {
                    this._typeId = val;
                }

                public String toString() {
                    return String.format("chance=%s typeId=%s", this._chance, this._typeId);
                }

                private void read_0x19(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                    this.setChance(stream.readInt32("chance"));
                    this.setTypeId(stream.readId("typeId"));
                }

                private void write_0x19(@Nonnull Wc3BinOutputStream stream) {
                    stream.writeInt32(this.getChance());
                    stream.writeId(this.getTypeId());
                }

                private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                    switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                        case W3I_0x1F: 
                        case W3I_0x1C: 
                        case W3I_0x19: {
                            this.read_0x19(stream);
                        }
                    }
                }

                private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                    switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                        case W3I_0x1F: 
                        case W3I_0x1C: 
                        case W3I_0x19: 
                        case AUTO: {
                            this.write_0x19(stream);
                        }
                    }
                }

                public Item(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                    this.read(stream, format);
                }

                public Item(@Nonnull Id typeId, int chance) {
                    this._typeId = typeId;
                    this._chance = chance;
                }
            }
        }
    }

    public static class UnitTable {
        private int _index = 0;
        private String _name;
        private Map<Integer, PositionType> _positionTypes = new LinkedHashMap<Integer, PositionType>();
        private List<Set> _sets = new ArrayList<Set>();

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int val) {
            this._index = val;
        }

        @Nullable
        public String getName() {
            return this._name;
        }

        public void setName(@Nullable String val) {
            this._name = val;
        }

        @Nonnull
        public PositionType getPositionType(int index) {
            return this._positionTypes.get(index);
        }

        public void setPositionType(int index, @Nonnull PositionType val) {
            this._positionTypes.put(index, val);
        }

        @Nonnull
        public List<Set> getSets() {
            return new ArrayList<Set>(this._sets);
        }

        public void addSet(@Nonnull Set val) {
            this._sets.add(val);
        }

        public String toString() {
            return String.format("index=%s name=%s positionTypes=[%s] sets=[%s]", this._index, this._name, this._positionTypes.entrySet().stream().map(entry -> String.format("%s->%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(" ")), this._sets.stream().map(Set::toString).collect(Collectors.joining(" ")));
        }

        private void read_0x12(@Nonnull Wc3BinInputStream stream) throws Exception {
            this.setIndex(stream.readInt32("index"));
            this.setName(stream.readString("name"));
            int positionsCount = stream.readInt32("posCount");
            for (int i = 0; i < positionsCount; ++i) {
                int posTypeI = stream.readInt32("posType");
                PositionType posType = PositionType.valueOf(posTypeI);
                if (posType == null) {
                    throw new Exception(String.format("unknown type %x", posTypeI));
                }
                this.setPositionType(i, posType);
            }
            int setsCount = stream.readInt32("setsCount");
            for (int i = 0; i < setsCount; ++i) {
                this.addSet(new Set(stream, EncodingFormat.W3I_0x19, this));
            }
        }

        private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
            int positionsCount = this._positionTypes.size();
            stream.writeInt32(positionsCount);
            for (int i = 0; i < positionsCount; ++i) {
                stream.writeInt32(this.getPositionType(i).getVal());
            }
            for (Set set : this._sets) {
                set.write(stream, EncodingFormat.W3I_0x19);
            }
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws Exception {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: {
                    this.read_0x12(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: 
                case AUTO: {
                    this.write_0x12(stream);
                }
            }
        }

        public UnitTable(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws Exception {
            this.read(stream, format);
        }

        public UnitTable(int index, @Nonnull String name) {
            this._index = index;
            this._name = name;
        }

        public static class Set {
            private UnitTable _parent;
            private int _chance = 100;
            private Map<Integer, Id> _typeIds = new LinkedHashMap<Integer, Id>();

            public int getChance() {
                return this._chance;
            }

            public void setChance(int val) {
                this._chance = val;
            }

            public Id getTypeId(int pos) {
                return this._typeIds.get(pos);
            }

            public void setTypeId(int pos, Id val) {
                this._typeIds.put(pos, val);
            }

            public String toString() {
                return String.format("chance=%s typeIds=[%s]", this._chance, this._typeIds.entrySet().stream().map(entry -> String.format("%s->%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(" ")));
            }

            private void read_0x12(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                this.setChance(stream.readInt32("chance"));
                for (int i = 0; i < this._parent._positionTypes.size(); ++i) {
                    this.setTypeId(i, stream.readId("typeId"));
                }
            }

            private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
                stream.writeInt32(this.getChance());
                for (int i = 0; i < this._parent._positionTypes.size(); ++i) {
                    stream.writeId(this.getTypeId(i));
                }
            }

            private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case W3I_0x1F: 
                    case W3I_0x1C: 
                    case W3I_0x19: 
                    case W3I_0x12: {
                        this.read_0x12(stream);
                    }
                }
            }

            private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case W3I_0x1F: 
                    case W3I_0x1C: 
                    case W3I_0x19: 
                    case W3I_0x12: 
                    case AUTO: {
                        this.write_0x12(stream);
                    }
                }
            }

            public Set(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format, @Nonnull UnitTable parent) throws BinStream.StreamException {
                this._parent = parent;
                this.read(stream, format);
            }

            public Set(int chance) {
                this._chance = chance;
            }
        }

        public static enum PositionType {
            UNIT(0),
            STRUCTURE(1),
            ITEM(2);

            private int _val;
            private static final Map<Integer, PositionType> _valToPositionTypeMap;

            public int getVal() {
                return this._val;
            }

            private PositionType(int val) {
                this._val = val;
            }

            @Nullable
            public static PositionType valueOf(int val) {
                return _valToPositionTypeMap.get(val);
            }

            static {
                _valToPositionTypeMap = new LinkedHashMap<Integer, PositionType>();
                _valToPositionTypeMap.put(0, UNIT);
                _valToPositionTypeMap.put(1, STRUCTURE);
                _valToPositionTypeMap.put(2, ITEM);
            }
        }
    }

    public static class TechMod {
        private int _players = 0;
        private Id _id;

        public int getPlayers() {
            return this._players;
        }

        public void setPlayers(int val) {
            this._players = val;
        }

        @Nonnull
        public Id getId() {
            return this._id;
        }

        public void setId(@Nonnull Id val) {
            this._id = val;
        }

        public String toString() {
            return String.format("id=%s players=%s", this._id, this._players);
        }

        private void read_0x12(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setPlayers(stream.readInt32("techPlayers"));
            this.setId(stream.readId("techId"));
        }

        private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getPlayers());
            stream.writeId(this.getId());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: {
                    this.read_0x12(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: 
                case AUTO: {
                    this.write_0x12(stream);
                }
            }
        }

        public TechMod(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public TechMod() {
        }
    }

    public static class UpgradeMod {
        private int _players = 0;
        private Id _id;
        private int _level = 1;
        private int _avail = 0;

        public int getPlayers() {
            return this._players;
        }

        public void setPlayers(int val) {
            this._players = val;
        }

        public Id getId() {
            return this._id;
        }

        public void setId(Id val) {
            this._id = val;
        }

        public int getLevel() {
            return this._level;
        }

        public void setLevel(int val) {
            this._level = val;
        }

        public int getAvail() {
            return this._avail;
        }

        public void setAvail(int val) {
            this._avail = val;
        }

        public String toString() {
            return String.format("avail=%s id=%s level=%s players=%s", this._avail, this._id, this._level, this._players);
        }

        private void read_0x12(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setPlayers(stream.readInt32("abilPlayers"));
            this.setId(stream.readId("abilId"));
            this.setLevel(stream.readInt32("level"));
            this.setAvail(stream.readInt32("avail"));
        }

        private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getPlayers());
            stream.writeId(this.getId());
            stream.writeInt32(this.getLevel());
            stream.writeInt32(this.getAvail());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: {
                    this.read_0x12(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: 
                case AUTO: {
                    this.write_0x12(stream);
                }
            }
        }

        public UpgradeMod(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public UpgradeMod() {
        }
    }

    public static class Force {
        private Flags _flags = Flags.valueOf(0);
        private BitSet _players = new BitSet();
        private String _name;

        @Nonnull
        public Flags getFlags() {
            return this._flags;
        }

        public void setFlags(@Nonnull Flags val) {
            this._flags = val;
        }

        public boolean getFlag(@Nonnull Flags.Flag flag) {
            return this._flags.containsFlag(flag);
        }

        public void setFlag(@Nonnull Flags.Flag flag, boolean val) {
            this._flags.setFlag(flag, val);
        }

        @Nonnull
        public BitSet getPlayers() {
            return this._players;
        }

        public void setPlayers(@Nonnull BitSet val) {
            this._players = val;
        }

        public Set<Integer> getPlayerNums() {
            LinkedHashSet<Integer> ret = new LinkedHashSet<Integer>(this._players.stream().boxed().collect(Collectors.toList()));
            return ret;
        }

        public Set<Integer> getPlayerNums(@Nonnull List<Player> definedPlayers) {
            Set definedPlayerNums = definedPlayers.stream().map(Player::getNum).collect(Collectors.toSet());
            Set<Integer> ret = this.getPlayerNums();
            ret.removeIf(playerNum -> !definedPlayerNums.contains(playerNum));
            return ret;
        }

        public void removePlayerNums(int ... players) {
            for (int player : players) {
                this._players.clear(player);
            }
        }

        public void addPlayerNums(int ... players) {
            for (int player : players) {
                this._players.set(player);
            }
        }

        @Nullable
        public String getName() {
            return this._name;
        }

        public void setName(@Nullable String val) {
            this._name = val;
        }

        public String toString() {
            String playersS = String.format("%12s", this._players);
            playersS = playersS.substring(playersS.length() - 12).replaceAll(" ", "0");
            return String.format("name=%s players=%s flags=%s", this.getName(), playersS, this.getFlags());
        }

        private void read_0x12(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setFlags(Flags.valueOf(stream.readInt32("forceFlags")));
            long playersL = stream.readUInt32("forcePlayers");
            BitSet players = BitSet.valueOf(new long[]{playersL});
            this.setPlayers(players);
            this.setName(stream.readString("forceName"));
        }

        private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getFlags().toInt());
            long playersL = this._players.toLongArray().length != 0 ? this._players.toLongArray()[0] : Long.parseLong("0", 2);
            stream.writeUInt32(playersL);
            stream.writeString(this.getName());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: {
                    this.read_0x12(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: 
                case AUTO: {
                    this.write_0x12(stream);
                }
            }
        }

        public Force(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Force() {
        }

        public static class Flags
        extends FlagsInt {
            @Override
            public DataType decode(Object val) {
                return null;
            }

            @Override
            public Object toSLKVal() {
                return null;
            }

            @Override
            public Object toTXTVal() {
                return null;
            }

            public String toString() {
                return String.format("%5s", Integer.toBinaryString(this.toInt())).replaceAll(" ", "0");
            }

            protected Flags(int val) {
                super(val);
            }

            public static Flags valueOf(int val) {
                return new Flags(val);
            }

            public static class Flag
            extends FlagsInt.Flag {
                public static final Flag ALLIED = new Flag("allied", 0);
                public static final Flag ALLIED_VICTORY = new Flag("allied_victory", 1);
                public static final Flag SHARED_VISION = new Flag("shared_vision", 2);
                public static final Flag SHARED_UNIT_CONTROL = new Flag("shared_unit_control", 4);
                public static final Flag SHARED_UNIT_CONTROL_ADVANCED = new Flag("shared_unit_control_advanced", 5);

                private Flag(@Nonnull String label, int pos) {
                    super(label, pos);
                }
            }
        }
    }

    public static class Player {
        private int _num = 0;
        private Controller _type = Controller.USER;
        private UnitRace _race = UnitRace.SELECTABLE;
        private int _startPosFixed = 0;
        private String _name;
        private Coords2DF _startPos = new Coords2DF(0.0f, 0.0f);
        private FlagsInt _allyLowPrioFlags = AllyFlags.valueOf(new BitSet());
        private FlagsInt _allyHighPrioFlags = AllyFlags.valueOf(0);
        private FlagsInt _enemyLowPrioFlags = EnemyFlags.valueOf(new BitSet());
        private FlagsInt _enemyHighPrioFlags = EnemyFlags.valueOf(0);

        public int getNum() {
            return this._num;
        }

        public void setNum(int val) {
            this._num = val;
        }

        @Nonnull
        public Controller getType() {
            return this._type;
        }

        public void setType(@Nonnull Controller val) {
            this._type = val;
        }

        @Nonnull
        public UnitRace getRace() {
            return this._race;
        }

        public void setRace(@Nonnull UnitRace val) {
            this._race = val;
        }

        public int getStartPosFixed() {
            return this._startPosFixed;
        }

        public void setStartPosFixed(int val) {
            this._startPosFixed = val;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String val) {
            this._name = val;
        }

        @Nonnull
        public Coords2DF getStartPos() {
            return this._startPos;
        }

        public void setStartPos(@Nonnull Coords2DF val) {
            this._startPos = val;
        }

        public int getAllyLowPrioFlags() {
            return this._allyLowPrioFlags.toInt();
        }

        public void setAllyLowPrioFlags(int val) {
            this._allyLowPrioFlags.setVal(val);
        }

        public void setAllyLowPrioFlag(int index, boolean val) {
            this._allyLowPrioFlags.setPos(index, val);
        }

        @Nonnull
        public Set<Integer> getAllyLowPrioPlayerNums() {
            return this._allyLowPrioFlags.getPoses();
        }

        public void removeAllyLowPrioPlayers(int ... players) {
            this._allyLowPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), false);
        }

        public void addAllyLowPrioPlayerNums(int ... players) {
            this._allyLowPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), true);
        }

        public int getAllyHighPrioFlags() {
            return this._allyHighPrioFlags.toInt();
        }

        public void setAllyHighPrioFlags(int val) {
            this._allyHighPrioFlags.setVal(val);
        }

        public void setAllyHighPrioFlag(int index, boolean val) {
            this._allyHighPrioFlags.setPos(index, val);
        }

        @Nonnull
        public Set<Integer> getAllyHighPrioPlayerNums() {
            return this._allyHighPrioFlags.getPoses();
        }

        public void removeAllyHighPrioPlayers(int ... players) {
            this._allyHighPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), false);
        }

        public void addAllyHighPrioPlayerNums(int ... players) {
            this._allyHighPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), true);
        }

        public int getEnemyLowPrioFlags() {
            return this._enemyLowPrioFlags.toInt();
        }

        public void setEnemyLowPrioFlags(int val) {
            this._enemyLowPrioFlags.setVal(val);
        }

        public void setEnemyLowPrioFlag(int index, boolean val) {
            this._enemyLowPrioFlags.setPos(index, val);
        }

        @Nonnull
        public Set<Integer> getEnemyLowPrioPlayerNums() {
            return this._enemyLowPrioFlags.getPoses();
        }

        public void removeEnemyLowPrioPlayers(int ... players) {
            this._enemyLowPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), false);
        }

        public void addEnemyLowPrioPlayerNums(int ... players) {
            this._enemyLowPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), true);
        }

        public int getEnemyHighPrioFlags() {
            return this._enemyHighPrioFlags.toInt();
        }

        public void setEnemyHighPrioFlags(int val) {
            this._enemyHighPrioFlags.setVal(val);
        }

        public void setEnemyHighPrioFlag(int index, boolean val) {
            this._enemyHighPrioFlags.setPos(index, val);
        }

        @Nonnull
        public Set<Integer> getEnemyHighPrioPlayerNums() {
            return this._enemyHighPrioFlags.getPoses();
        }

        public void removeEnemyHighPrioPlayers(int ... players) {
            this._enemyHighPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), false);
        }

        public void addEnemyHighPrioPlayerNums(int ... players) {
            this._enemyHighPrioFlags.setPoses(Arrays.stream(players).boxed().collect(Collectors.toSet()), true);
        }

        public String toString() {
            String allyLowPrioFlagsS = String.format("%12s", Integer.toBinaryString(this.getAllyLowPrioFlags()));
            String allyHighPrioFlagsS = String.format("%12s", Integer.toBinaryString(this.getAllyHighPrioFlags()));
            allyLowPrioFlagsS = allyLowPrioFlagsS.substring(allyLowPrioFlagsS.length() - 12).replaceAll(" ", "0");
            allyHighPrioFlagsS = allyHighPrioFlagsS.substring(allyHighPrioFlagsS.length() - 12).replaceAll(" ", "0");
            String enemyLowPrioFlagsS = String.format("%12s", Integer.toBinaryString(this.getEnemyLowPrioFlags()));
            String enemyHighPrioFlagsS = String.format("%12s", Integer.toBinaryString(this.getEnemyHighPrioFlags()));
            enemyLowPrioFlagsS = enemyLowPrioFlagsS.substring(enemyLowPrioFlagsS.length() - 12).replaceAll(" ", "0");
            enemyHighPrioFlagsS = enemyHighPrioFlagsS.substring(enemyHighPrioFlagsS.length() - 12).replaceAll(" ", "0");
            return String.format("%s [num=%d controller=%s race=%s startPosFixed=%s startPos=%s allyLowPrioFlags=%s allyHighPrioFlags=%s enemyLowPrioFlags=%s enemyHighPrioFlags=%s]", this.getName(), this.getNum(), this.getType(), this.getRace(), this.getStartPosFixed(), this.getStartPos(), allyLowPrioFlagsS, allyHighPrioFlagsS, enemyLowPrioFlagsS, enemyHighPrioFlagsS);
        }

        private void read_0x12(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            UnitRace race;
            this.setNum(stream.readInt32("playerNum"));
            Controller controller = Controller.valueOf(stream.readInt32("controller"));
            if (controller != null) {
                this.setType(controller);
            }
            if ((race = UnitRace.valueOf(stream.readInt32("race"))) != null) {
                this.setRace(race);
            }
            this.setStartPosFixed(stream.readInt32("startPosFixed"));
            this.setName(stream.readString("playerName"));
            this.setStartPos(new Coords2DF(stream.readFloat32("startPosX").floatValue(), stream.readFloat32("startPosY").floatValue()));
            this.setAllyLowPrioFlags(stream.readInt32("allyLowPrioFlags"));
            this.setAllyHighPrioFlags(stream.readInt32("allyHighPrioFlags"));
        }

        private void read_0x1F(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            UnitRace race;
            this.setNum(stream.readInt32("playerNum"));
            Controller controller = Controller.valueOf(stream.readInt32("controller"));
            if (controller != null) {
                this.setType(controller);
            }
            if ((race = UnitRace.valueOf(stream.readInt32("race"))) != null) {
                this.setRace(race);
            }
            this.setStartPosFixed(stream.readInt32("startPosFixed"));
            this.setName(stream.readString("playerName"));
            this.setStartPos(new Coords2DF(stream.readFloat32("startPosX").floatValue(), stream.readFloat32("startPosY").floatValue()));
            this.setAllyLowPrioFlags(stream.readInt32("allyLowPrioFlags"));
            this.setAllyHighPrioFlags(stream.readInt32("allyHighPrioFlags"));
            this.setEnemyLowPrioFlags(stream.readInt32("enemyLowPrioFlags"));
            this.setEnemyHighPrioFlags(stream.readInt32("enemyHighPrioFlags"));
        }

        private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getNum());
            stream.writeInt32(this.getType().getVal());
            stream.writeInt32(this.getRace().getVal());
            stream.writeInt32(this.getStartPosFixed());
            stream.writeString(this.getName());
            Coords2DF startPos = this.getStartPos();
            stream.writeFloat32(startPos.getX());
            stream.writeFloat32(startPos.getY());
            stream.writeInt32(this.getAllyLowPrioFlags());
            stream.writeInt32(this.getAllyHighPrioFlags());
        }

        private void write_0x1F(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getNum());
            stream.writeInt32(this.getType().getVal());
            stream.writeInt32(this.getRace().getVal());
            stream.writeInt32(this.getStartPosFixed());
            stream.writeString(this.getName());
            Coords2DF startPos = this.getStartPos();
            stream.writeFloat32(startPos.getX());
            stream.writeFloat32(startPos.getY());
            stream.writeInt32(this.getAllyLowPrioFlags());
            stream.writeInt32(this.getAllyHighPrioFlags());
            stream.writeInt32(this.getEnemyLowPrioFlags());
            stream.writeInt32(this.getEnemyHighPrioFlags());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: {
                    this.read_0x1F(stream);
                    break;
                }
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: {
                    this.read_0x12(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case AUTO: {
                    this.write_0x1F(stream);
                    break;
                }
                case W3I_0x1C: 
                case W3I_0x19: 
                case W3I_0x12: {
                    this.write_0x12(stream);
                }
            }
        }

        public Player(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Player() {
        }

        public static class EnemyFlags
        extends FlagsInt {
            private EnemyFlags(int val) {
                super(val);
            }

            private EnemyFlags(@Nonnull BitSet val) {
                super(val);
            }

            public static EnemyFlags valueOf(int val) {
                return new EnemyFlags(val);
            }

            public static EnemyFlags valueOf(@Nonnull BitSet val) {
                return new EnemyFlags(val);
            }

            @Override
            public DataType decode(Object val) {
                return null;
            }

            @Override
            public Object toSLKVal() {
                return null;
            }

            @Override
            public Object toTXTVal() {
                return null;
            }
        }

        public static class AllyFlags
        extends FlagsInt {
            private AllyFlags(int val) {
                super(val);
            }

            private AllyFlags(@Nonnull BitSet val) {
                super(val);
            }

            public static AllyFlags valueOf(int val) {
                return new AllyFlags(val);
            }

            public static AllyFlags valueOf(@Nonnull BitSet val) {
                return new AllyFlags(val);
            }

            @Override
            public DataType decode(Object val) {
                return null;
            }

            @Override
            public Object toSLKVal() {
                return null;
            }

            @Override
            public Object toTXTVal() {
                return null;
            }
        }

        public static class UnitRace
        extends War3Int {
            private static final Map<Integer, UnitRace> _map = new LinkedHashMap<Integer, UnitRace>();
            private static final Map<String, UnitRace> _smap = new LinkedHashMap<String, UnitRace>();
            public static final UnitRace NIGHT_ELF = new UnitRace(4, "NIGHT_ELF", "RACE_PREF_NIGHTELF");
            public static final UnitRace HUMAN = new UnitRace(1, "HUMAN", "RACE_PREF_HUMAN");
            public static final UnitRace ORC = new UnitRace(2, "ORC", "RACE_PREF_ORC");
            public static final UnitRace SELECTABLE = new UnitRace(0, "SELECTABLE", "RACE_PREF_RANDOM");
            public static final UnitRace UNDEAD = new UnitRace(3, "UNDEAD", "RACE_PREF_UNDEAD");
            private String _label;
            private String _jassExpr;

            public String getLabel() {
                return this._label;
            }

            public String getJassExpr() {
                return this._jassExpr;
            }

            @Override
            public String toString() {
                return this.getLabel();
            }

            public UnitRace(int val, String label, String jassExpr) {
                super(val);
                _map.put(val, this);
                _smap.put(label, this);
                this._label = label;
                this._jassExpr = jassExpr;
            }

            @Nullable
            public static UnitRace valueOf(@Nonnull Integer val) {
                return _map.get(val);
            }

            @Nullable
            public static UnitRace valueOf(@Nonnull String val) {
                return _smap.get(val);
            }
        }
    }

    public static enum GameDataVersion {
        ROC,
        TFT;

    }

    public static enum Graphics {
        SD,
        HD,
        SD_AND_HD;

    }

    public static enum ScriptLang {
        JASS,
        LUA;

    }

    public static class GameDataSet {
        private static final Map<Integer, GameDataSet> _map = new LinkedHashMap<Integer, GameDataSet>();
        public static final GameDataSet MAX = new GameDataSet(-1, "MAX");
        public static final GameDataSet STANDARD = new GameDataSet(0, "DEFAULT");
        public static final GameDataSet CUSTOM_V1 = new GameDataSet(1, "CUSTOM_V1");
        public static final GameDataSet MELEE_V1 = new GameDataSet(2, "MELEE_V1");
        private int _index;
        private String _label;

        public int getIndex() {
            return this._index;
        }

        @Nullable
        public static GameDataSet valueOf(int index) {
            return _map.getOrDefault(index, STANDARD);
        }

        public String getLabel() {
            return this._label;
        }

        public String toString() {
            return this._label;
        }

        protected GameDataSet(int index, String label) {
            _map.put(index, this);
            this._index = index;
            this._label = String.format("WESTRING_GAMEDATASET_%s", label);
        }
    }

    public static class PrologueScreen {
        private String _path;
        private String _text;
        private String _title;
        private String _subtitle;

        public String getPath() {
            return this._path;
        }

        public void setPath(String val) {
            this._path = val;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String val) {
            this._text = val;
        }

        public String getTitle() {
            return this._title;
        }

        public void setTitle(String val) {
            this._title = val;
        }

        public String getSubtitle() {
            return this._subtitle;
        }

        public void setSubtitle(String val) {
            this._subtitle = val;
        }

        public String toString() {
            return String.format("path=%s text=%s title=%s subtitle=%s", this.getPath(), this.getText(), this.getTitle(), this.getSubtitle());
        }

        public PrologueScreen(String path, String text, String title, String subtitle) {
            this.setPath(path);
            this.setText(text);
            this.setTitle(title);
            this.setSubtitle(subtitle);
        }
    }

    public static class LoadingScreen {
        private LoadingScreenBackground _background;
        private String _text;
        private String _title;
        private String _subtitle;
        private int _campaignBackgroundIndex = 0;

        public LoadingScreenBackground getBackground() {
            return this._background;
        }

        public void setBackground(LoadingScreenBackground val) {
            this._background = val;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String val) {
            this._text = val;
        }

        public String getTitle() {
            return this._title;
        }

        public void setTitle(String val) {
            this._title = val;
        }

        public String getSubtitle() {
            return this._subtitle;
        }

        public void setSubtitle(String val) {
            this._subtitle = val;
        }

        public int getCampaignBackgroundIndex() {
            return this._campaignBackgroundIndex;
        }

        public void setCampaignBackgroundIndex(int val) {
            this._campaignBackgroundIndex = val;
        }

        public String toString() {
            return String.format("background=%s text=%s title=%s subtitle=%s campaignBackgroundIndex=%d", this.getBackground(), this.getText(), this.getTitle(), this.getSubtitle(), this.getCampaignBackgroundIndex());
        }

        private void set(int campaignBackgroundIndex, String customPath, String text, String title, String subtitle) {
            LoadingScreenBackground background = null;
            if (campaignBackgroundIndex < 0) {
                if (customPath != null && !customPath.isEmpty()) {
                    background = new LoadingScreenBackground.CustomBackground(new File(customPath));
                }
            } else {
                background = LoadingScreenBackground.PresetBackground.valueOf(campaignBackgroundIndex);
            }
            this.setBackground(background);
            this.setCampaignBackgroundIndex(campaignBackgroundIndex);
            this.setText(text);
            this.setTitle(title);
            this.setSubtitle(subtitle);
        }

        private void read_0x12(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.set(stream.readInt32("campaignBackgroundIndex"), null, stream.readString("loadingScreenText"), stream.readString("loadingScreenTitle"), stream.readString("loadingScreenSubtitle"));
        }

        private void write_0x12(@Nonnull Wc3BinOutputStream stream) {
            LoadingScreenBackground background = this.getBackground();
            stream.writeInt32(background instanceof LoadingScreenBackground.PresetBackground ? ((LoadingScreenBackground.PresetBackground)background).getIndex() : -1);
            stream.writeString(this.getText());
            stream.writeString(this.getTitle());
            stream.writeString(this.getSubtitle());
        }

        private void read_0x19(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.set(stream.readInt32("campaignBackgroundIndex"), stream.readString("loadingScreenModel"), stream.readString("loadingScreenText"), stream.readString("loadingScreenTitle"), stream.readString("loadingScreenSubtitle"));
        }

        private void write_0x19(@Nonnull Wc3BinOutputStream stream) {
            LoadingScreenBackground background = this.getBackground();
            if (background != null) {
                stream.writeInt32(background instanceof LoadingScreenBackground.PresetBackground ? ((LoadingScreenBackground.PresetBackground)background).getIndex() : -1);
                stream.writeString(background instanceof LoadingScreenBackground.CustomBackground ? ((LoadingScreenBackground.CustomBackground)background).getCustomPath().toString() : null);
            } else {
                stream.writeInt32(-1);
                stream.writeString((String)null);
            }
            stream.writeString(this.getText());
            stream.writeString(this.getTitle());
            stream.writeString(this.getSubtitle());
        }

        private void read_0x1C(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.set(stream.readInt32("campaignBackgroundIndex"), stream.readString("loadingScreenModel"), stream.readString("loadingScreenText"), stream.readString("loadingScreenTitle"), stream.readString("loadingScreenSubtitle"));
        }

        private void write_0x1C(@Nonnull Wc3BinOutputStream stream) {
            LoadingScreenBackground background = this.getBackground();
            if (background != null) {
                stream.writeInt32(background instanceof LoadingScreenBackground.PresetBackground ? ((LoadingScreenBackground.PresetBackground)background).getIndex() : -1);
                stream.writeString(background instanceof LoadingScreenBackground.CustomBackground ? ((LoadingScreenBackground.CustomBackground)background).getCustomPath().toString() : null);
            } else {
                stream.writeInt32(-1);
                stream.writeString((String)null);
            }
            stream.writeString(this.getText());
            stream.writeString(this.getTitle());
            stream.writeString(this.getSubtitle());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: {
                    this.read_0x19(stream);
                    break;
                }
                case W3I_0x12: {
                    this.read_0x12(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case W3I_0x1F: 
                case W3I_0x1C: 
                case W3I_0x19: 
                case AUTO: {
                    this.write_0x19(stream);
                    break;
                }
                case W3I_0x12: {
                    this.write_0x12(stream);
                }
            }
        }

        public LoadingScreen(LoadingScreenBackground background, String text, String title, String subtitle, int campaignBackgroundIndex) {
            this.setBackground(background);
            this.setCampaignBackgroundIndex(campaignBackgroundIndex);
            this.setText(text);
            this.setTitle(title);
            this.setSubtitle(subtitle);
        }

        public LoadingScreen(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }
    }

    public static class Flags
    extends FlagsInt {
        @Override
        public DataType decode(Object val) {
            return null;
        }

        @Override
        public Object toSLKVal() {
            return null;
        }

        @Override
        public Object toTXTVal() {
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            Collection<MapFlag> flags = MapFlag.values();
            if (!flags.isEmpty()) {
                for (MapFlag flag : flags) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(String.format("%s=%s", flag.toString(), this.containsFlag(flag)));
                }
            }
            return String.format("%s [%s]", Integer.toBinaryString(this.toInt()), sb.toString());
        }

        protected Flags(int val) {
            super(val);
        }

        public static Flags valueOf(int val) {
            return new Flags(val);
        }
    }

    public static class State<T extends DataType>
    extends BinState<T> {
        public static State<War3Int> SAVES_AMOUNT = new State<War3Int>("savesAmount", War3Int.class, War3Int.valueOf(0));

        public State(@Nonnull String fieldIdS, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(fieldIdS, typeInfo, defVal);
        }

        public State(@Nonnull String fieldIdS, @Nonnull DataTypeInfo typeInfo) {
            super(fieldIdS, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

