/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.peeeq.wurstio.ModelChangedException;
import de.peeeq.wurstio.WurstCompilerJassImpl;
import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.ModelManagerException;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.utils.FileUtils;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrModuleInstanciation;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.gui.WurstGuiLogger;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public class ModelManagerImpl
implements ModelManager {
    private final BufferManager bufferManager;
    private volatile @Nullable WurstModel model;
    private final File projectPath;
    private final Set<File> dependencies = Sets.newLinkedHashSet();
    private final List<Consumer<PublishDiagnosticsParams>> onCompilationResultListeners = new ArrayList<Consumer<PublishDiagnosticsParams>>();
    private final Map<WFile, List<CompileError>> parseErrors = new LinkedHashMap<WFile, List<CompileError>>();
    private final Map<WFile, List<CompileError>> otherErrors = new LinkedHashMap<WFile, List<CompileError>>();
    private final Map<WFile, Integer> fileHashcodes = new HashMap<WFile, Integer>();
    private final WeakHashMap<CompilationUnit, WFile> compilationunitFile = new WeakHashMap();

    public ModelManagerImpl(File projectPath, BufferManager bufferManager) {
        this.projectPath = projectPath;
        this.bufferManager = bufferManager;
    }

    private WurstModel newModel(CompilationUnit cu, WurstGui gui) {
        try {
            CompilationUnit commonJ = this.compileFromJar(gui, "common.j");
            CompilationUnit blizzardJ = this.compileFromJar(gui, "blizzard.j");
            return Ast.WurstModel(blizzardJ, commonJ, cu);
        }
        catch (IOException e) {
            WLogger.severe(e);
            return Ast.WurstModel(cu);
        }
    }

    private List<CompilationUnit> getJassdocCUs(Path jassdoc, WurstGui gui) {
        ArrayList<CompilationUnit> units = new ArrayList<CompilationUnit>();
        WurstCompilerJassImpl comp = new WurstCompilerJassImpl(this.projectPath, gui, null, RunArgs.defaults());
        for (File f : jassdoc.toFile().listFiles()) {
            if (!f.getName().endsWith(".j") || f.getName().startsWith("builtin-types")) continue;
            try (FileReader reader = new FileReader(f);){
                CompilationUnit cu = comp.parse(f.getAbsolutePath(), reader);
                cu.getCuInfo().setFile(this.getCanonicalPath(f));
                units.add(cu);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return units;
    }

    @Override
    public ModelManager.Changes removeCompilationUnit(WFile resource) {
        this.parseErrors.remove(resource);
        WurstModel model2 = this.model;
        if (model2 == null) {
            return ModelManager.Changes.empty();
        }
        this.syncCompilationUnitContent(resource, "");
        List toRemove = model2.stream().filter(cu -> this.wFile((CompilationUnit)cu).equals(resource)).collect(Collectors.toList());
        model2.removeAll((Collection)toRemove);
        return new ModelManager.Changes(toRemove.stream().map(this::wFile), toRemove.stream().flatMap(cu -> cu.getPackages().stream()).map(WPackage::getName));
    }

    @Override
    public void clean() {
        this.fileHashcodes.clear();
        this.parseErrors.clear();
        this.model = null;
        this.dependencies.clear();
        WLogger.info("Clean done.");
    }

    @Override
    public void buildProject() {
        try {
            WurstGuiLogger gui = new WurstGuiLogger();
            this.readDependencies(gui);
            if (!this.projectPath.exists()) {
                throw new RuntimeException("Folder " + this.projectPath + " does not exist!");
            }
            File wurstFolder = new File(this.projectPath, "wurst");
            if (!wurstFolder.exists()) {
                System.err.println("No wurst folder found, using complete directory instead.");
                wurstFolder = this.projectPath;
            }
            this.processWurstFiles(wurstFolder);
            this.resolveImports(gui);
            this.doTypeCheck(gui);
        }
        catch (IOException e) {
            WLogger.severe(e);
            throw new ModelManagerException(e);
        }
    }

    private void processWurstFiles(File dir) {
        for (File f : this.getFiles(dir)) {
            if (f.isDirectory()) {
                this.processWurstFiles(f);
                continue;
            }
            if (!f.getName().endsWith(".wurst") && !f.getName().endsWith(".jurst") && !f.getName().endsWith(".j")) continue;
            this.processWurstFile(WFile.create(f));
        }
    }

    private File[] getFiles(File dir) {
        File[] res = dir.listFiles();
        if (res == null) {
            return new File[0];
        }
        return res;
    }

    private void processWurstFile(WFile f) {
        WLogger.info("processing file " + f);
        this.replaceCompilationUnit(f);
    }

    private void readDependencies(WurstGui gui) throws IOException {
        this.dependencies.clear();
        File depFile = new File(this.projectPath, "wurst.dependencies");
        if (!depFile.exists()) {
            WLogger.info("no dependency file found.");
            return;
        }
        this.dependencies.addAll((Collection<File>)WurstCompilerJassImpl.checkDependencyFile(depFile, gui));
        WurstCompilerJassImpl.addDependenciesFromFolder(this.projectPath, this.dependencies);
    }

    private String getCanonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            WLogger.info(e);
            return f.getAbsolutePath();
        }
    }

    private List<CompilationUnit> getCompilationUnits(List<WFile> fileNames) {
        WurstModel model2 = this.model;
        if (model2 == null) {
            return Collections.emptyList();
        }
        return model2.stream().filter(cu -> fileNames.contains(this.wFile((CompilationUnit)cu))).collect(Collectors.toList());
    }

    private List<WFile> getfileNames(Collection<CompilationUnit> compilationUnits) {
        return compilationUnits.stream().map(this::wFile).collect(Collectors.toList());
    }

    private void clearCompilationUnits(Collection<CompilationUnit> toCheck) {
        WurstModel model2 = this.model;
        if (model2 == null) {
            return;
        }
        model2.clearAttributesLocal();
        for (CompilationUnit cu : toCheck) {
            this.clearCompilationUnit(cu);
        }
    }

    private void clearCompilationUnit(CompilationUnit cu) {
        cu.clearAttributes();
        for (WPackage p : cu.getPackages()) {
            for (WEntity elem : p.getElements()) {
                if (!(elem instanceof ClassOrModuleInstanciation)) continue;
                this.clearModuleInstantiation((ClassOrModuleInstanciation)elem);
            }
        }
    }

    private void clearModuleInstantiation(ClassOrModuleInstanciation elem) {
        elem.getP_moduleInstanciations().clear();
        for (ClassDef innerClass : elem.getInnerClasses()) {
            this.clearModuleInstantiation(innerClass);
        }
    }

    private boolean imports(CompilationUnit cu, Set<String> packageNames) {
        for (WPackage p : cu.getPackages()) {
            if (!this.imports(p, packageNames, false, Sets.newHashSet())) continue;
            return true;
        }
        return false;
    }

    private boolean imports(WPackage p, Set<String> packageNames, boolean onlyPublic, HashSet<WPackage> visited) {
        if (visited.contains(p)) {
            return false;
        }
        visited.add(p);
        for (WImport imp : p.getImports()) {
            if ((!onlyPublic || imp.getIsPublic()) && packageNames.contains(imp.getPackagename())) {
                return true;
            }
            WPackage importedPackage = imp.attrImportedPackage();
            if (onlyPublic && !imp.getIsPublic() || importedPackage == null || !this.imports(importedPackage, packageNames, true, visited)) continue;
            return true;
        }
        return false;
    }

    private void doTypeCheck(WurstGui gui) {
        WurstCompilerJassImpl comp = this.getCompiler(gui);
        long time = System.currentTimeMillis();
        if (gui.getErrorCount() > 0) {
            this.reportErrorsForProject("build project, doTypecheck, early", gui);
            WLogger.info("finished typechecking* in " + (System.currentTimeMillis() - time) + "ms");
            return;
        }
        @Nullable WurstModel model2 = this.model;
        if (model2 == null) {
            return;
        }
        try {
            model2.clearAttributes();
            comp.addImportedLibs(model2, this::addCompilationUnit);
            comp.checkProg(model2);
        }
        catch (CompileError e) {
            gui.sendError(e);
        }
        WLogger.info("finished typechecking in " + (System.currentTimeMillis() - time) + "ms");
        this.reportErrorsForProject("build project, doTypecheck, end", gui);
    }

    private CompilationUnit addCompilationUnit(File file) {
        WFile wFile = WFile.create(file);
        try {
            String contents = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            return this.replaceCompilationUnit(wFile, contents, true);
        }
        catch (IOException e) {
            WLogger.severe(e);
            return null;
        }
    }

    private void reportErrorsForProject(String extra, WurstGui gui) {
        ArrayListMultimap typeErrors = ArrayListMultimap.create();
        for (CompileError e : gui.getErrorsAndWarnings()) {
            typeErrors.put((Object)WFile.create(e.getSource().getFile()), (Object)e);
        }
        ImmutableSet files = ImmutableSet.builder().addAll(this.parseErrors.keySet()).addAll((Iterable)typeErrors.keySet()).build();
        for (WFile file : files) {
            ImmutableList errors = ImmutableList.builder().addAll((Iterable)this.parseErrors.getOrDefault(file, Collections.emptyList())).addAll((Iterable)typeErrors.get((Object)file)).build();
            this.reportErrors(extra, file, (List<CompileError>)errors);
        }
    }

    private void reportErrorsForFiles(List<WFile> filenames, WurstGui gui) {
        ArrayListMultimap typeErrors = ArrayListMultimap.create();
        for (CompileError e : gui.getErrorsAndWarnings()) {
            typeErrors.put((Object)WFile.create(e.getSource().getFile()), (Object)e);
        }
        for (WFile file : filenames) {
            ArrayList<CompileError> errors = new ArrayList<CompileError>(this.parseErrors.getOrDefault(file, Collections.emptyList()));
            errors.addAll(typeErrors.get((Object)file));
            this.reportErrors("partial ", file, errors);
        }
    }

    private void reportErrors(String extra, WFile filename, List<CompileError> errors) {
        PublishDiagnosticsParams cr = Convert.createDiagnostics(extra, filename, errors);
        this.otherErrors.put(filename, (List<CompileError>)ImmutableList.copyOf(errors));
        for (Consumer<PublishDiagnosticsParams> consumer : this.onCompilationResultListeners) {
            consumer.accept(cr);
        }
    }

    private WurstCompilerJassImpl getCompiler(WurstGui gui) {
        RunArgs runArgs = RunArgs.defaults();
        runArgs.addLibDirs(this.dependencies);
        WurstCompilerJassImpl comp = new WurstCompilerJassImpl(this.projectPath, gui, null, runArgs);
        comp.setHasCommonJ(true);
        return comp;
    }

    private void updateModel(CompilationUnit cu, WurstGui gui) {
        WLogger.trace("update model with " + cu.getCuInfo().getFile());
        this.parseErrors.put(this.wFile(cu), new ArrayList<CompileError>(gui.getErrorsAndWarnings()));
        WurstModel model2 = this.model;
        if (model2 == null) {
            this.model = this.newModel(cu, gui);
        } else {
            ListIterator it = model2.listIterator();
            boolean updated = false;
            while (it.hasNext()) {
                CompilationUnit c = (CompilationUnit)it.next();
                if (!this.wFile(c).equals(this.wFile(cu))) continue;
                Set<String> oldPackages = this.providedPackages(c);
                Set<CompilationUnit> mustUpdate = this.calculateCUsToUpdate(Collections.singletonList(cu), oldPackages, model2);
                this.clearCompilationUnits(mustUpdate);
                it.set(cu);
                updated = true;
                break;
            }
            if (!updated) {
                model2.add(cu);
            }
        }
    }

    private Set<String> providedPackages(CompilationUnit c) {
        return c.getPackages().stream().map(WPackage::getName).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationUnit compileFromJar(WurstGui gui, String filename) throws IOException {
        File sourceFile;
        InputStream source = this.getClass().getResourceAsStream("/" + filename);
        if (source == null) {
            WLogger.severe("could not find " + filename + " in jar");
            System.err.println("could not find " + filename + " in jar");
            sourceFile = new File("./resources/" + filename);
        } else {
            try {
                File buildDir = this.getBuildDir();
                buildDir.mkdirs();
                sourceFile = new File(buildDir, filename);
                if (!sourceFile.exists()) {
                    Files.copy(source, sourceFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            finally {
                source.close();
            }
        }
        WurstCompilerJassImpl comp = this.getCompiler(gui);
        try (FileReader reader = new FileReader(sourceFile);){
            CompilationUnit cu = comp.parse(sourceFile.getAbsolutePath(), reader);
            cu.getCuInfo().setFile(this.getCanonicalPath(sourceFile));
            CompilationUnit compilationUnit = cu;
            return compilationUnit;
        }
    }

    private File getBuildDir() {
        return new File(this.projectPath, "_build");
    }

    private void resolveImports(WurstGui gui) {
        WurstCompilerJassImpl comp = this.getCompiler(gui);
        try {
            WurstModel m = this.model;
            if (m == null) {
                return;
            }
            m.clearAttributes();
            comp.addImportedLibs(m, this::addCompilationUnit);
        }
        catch (CompileError e) {
            gui.sendError(e);
        }
    }

    private void replaceCompilationUnit(WFile filename) {
        File f;
        try {
            f = filename.getFile();
        }
        catch (FileNotFoundException e) {
            WLogger.info("Cannot replaceCompilationUnit for " + filename + "\n" + e);
            return;
        }
        if (!f.exists()) {
            this.removeCompilationUnit(filename);
            return;
        }
        try {
            String contents = com.google.common.io.Files.toString((File)f, (Charset)Charsets.UTF_8);
            this.bufferManager.updateFile(WFile.create(f), contents);
            this.replaceCompilationUnit(filename, contents, true);
            WLogger.info("replaceCompilationUnit 3 " + f);
        }
        catch (IOException e) {
            WLogger.severe(e);
            throw new ModelManagerException(e);
        }
    }

    @Override
    public ModelManager.Changes syncCompilationUnitContent(WFile filename, String contents) {
        WLogger.info("sync contents for " + filename);
        Set<String> oldPackages = this.declaredPackages(filename);
        this.replaceCompilationUnit(filename, contents, false);
        return new ModelManager.Changes((Iterable<WFile>)io.vavr.collection.HashSet.of((Object)filename), oldPackages);
    }

    private Set<String> declaredPackages(WFile f) {
        WurstModel model = this.model;
        if (model == null) {
            return Collections.emptySet();
        }
        for (CompilationUnit cu : model) {
            if (!this.wFile(cu).equals(f)) continue;
            return cu.getPackages().stream().map(WPackage::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public CompilationUnit replaceCompilationUnitContent(WFile filename, String contents, boolean reportErrors) {
        return this.replaceCompilationUnit(filename, contents, reportErrors);
    }

    @Override
    public ModelManager.Changes syncCompilationUnit(WFile f) {
        WLogger.info("syncCompilationUnit File " + f);
        Set<String> oldPackages = this.declaredPackages(f);
        this.replaceCompilationUnit(f);
        WLogger.info("replaced file " + f);
        WurstGuiLogger gui = new WurstGuiLogger();
        this.doTypeCheckPartial(gui, (List<WFile>)ImmutableList.of((Object)f), oldPackages);
        return new ModelManager.Changes((Iterable<WFile>)io.vavr.collection.HashSet.of((Object)f), oldPackages);
    }

    private CompilationUnit replaceCompilationUnit(WFile filename, String contents, boolean reportErrors) {
        if (!this.isInWurstFolder(filename)) {
            return null;
        }
        if (this.fileHashcodes.containsKey(filename)) {
            int oldHash = this.fileHashcodes.get(filename);
            if (oldHash == contents.hashCode()) {
                WLogger.trace("CU " + filename + " was unchanged.");
                return this.getCompilationUnit(filename);
            }
            WLogger.info("CU changed. oldHash = " + oldHash + " == " + contents.hashCode());
        }
        WLogger.trace("replace CU " + filename);
        WurstGuiLogger gui = new WurstGuiLogger();
        WurstCompilerJassImpl c = this.getCompiler(gui);
        CompilationUnit cu = c.parse(filename.toString(), new StringReader(contents));
        cu.getCuInfo().setFile(filename.toString());
        this.updateModel(cu, gui);
        this.fileHashcodes.put(filename, contents.hashCode());
        if (reportErrors) {
            if (gui.getErrorCount() > 0) {
                WLogger.info("found " + gui.getErrorCount() + " errors in file " + filename);
            }
            ImmutableList.Builder errors = ImmutableList.builder().addAll(gui.getErrorsAndWarnings());
            if (this.otherErrors.containsKey(filename)) {
                errors.addAll((Iterable)this.otherErrors.get(filename));
            }
            this.reportErrors("sync cu " + filename, filename, (List<CompileError>)errors.build());
        }
        return cu;
    }

    @Override
    public CompilationUnit getCompilationUnit(WFile filename) {
        List<CompilationUnit> matches = this.getCompilationUnits(Collections.singletonList(filename));
        if (matches.isEmpty()) {
            WLogger.info("compilation unit not found: " + filename);
            return null;
        }
        return matches.get(0);
    }

    @Override
    public WurstModel getModel() {
        return this.model;
    }

    @Override
    public boolean hasErrors() {
        return this.errorStream().findAny().isPresent();
    }

    @Override
    public String getFirstErrorDescription() {
        Optional<CompileError> first = this.errorStream().findFirst();
        return first.map(CompileError::toString).orElse("no errors");
    }

    @Override
    public List<CompileError> getParseErrors() {
        return this.parseErrorStream().collect(Collectors.toList());
    }

    private Stream<CompileError> parseErrorStream() {
        return this.parseErrors.values().stream().flatMap(Collection::stream).filter(err -> err.getErrorType() == CompileError.ErrorType.ERROR);
    }

    private Stream<CompileError> otherErrorStream() {
        return this.otherErrors.values().stream().flatMap(Collection::stream).filter(err -> err.getErrorType() == CompileError.ErrorType.ERROR);
    }

    private Stream<CompileError> errorStream() {
        return Streams.concat((Stream[])new Stream[]{this.parseErrorStream(), this.otherErrorStream()});
    }

    @Override
    public void onCompilationResult(Consumer<PublishDiagnosticsParams> f) {
        this.onCompilationResultListeners.add(f);
    }

    private void doTypeCheckPartial(WurstGui gui, List<WFile> toCheckFilenames, Set<String> oldPackages) {
        WLogger.info("do typecheck partial of " + toCheckFilenames);
        WurstCompilerJassImpl comp = this.getCompiler(gui);
        List<CompilationUnit> toCheck = this.getCompilationUnits(toCheckFilenames);
        WurstModel model2 = this.model;
        if (model2 == null) {
            return;
        }
        Set<CompilationUnit> toCheckRec = this.calculateCUsToUpdate(toCheck, oldPackages, model2);
        this.partialTypecheck(model2, toCheckRec, gui, comp);
    }

    @Override
    public void reconcile(ModelManager.Changes changes) {
        WurstModel model2 = this.model;
        if (model2 == null) {
            return;
        }
        Collection toCheck1 = model2.stream().filter(cu -> changes.getAffectedFiles().contains((Object)WFile.create(cu.getCuInfo().getFile()))).collect(Collectors.toSet());
        HashSet oldPackageNames = changes.getAffectedPackageNames().toJavaSet();
        Set<CompilationUnit> toCheckRec = this.calculateCUsToUpdate(toCheck1, oldPackageNames, model2);
        WurstGuiLogger gui = new WurstGuiLogger();
        WurstCompilerJassImpl comp = this.getCompiler(gui);
        this.partialTypecheck(model2, toCheckRec, gui, comp);
    }

    private void partialTypecheck(WurstModel model2, Collection<CompilationUnit> toCheckRec, WurstGui gui, WurstCompilerJassImpl comp) {
        try {
            this.clearCompilationUnits(toCheckRec);
            comp.addImportedLibs(model2, this::addCompilationUnit);
            comp.checkProg(model2, toCheckRec);
        }
        catch (ModelChangedException e) {
            return;
        }
        catch (CompileError e) {
            gui.sendError(e);
        }
        List<WFile> fileNames = this.getfileNames(toCheckRec);
        this.reportErrorsForFiles(fileNames, gui);
    }

    private Set<CompilationUnit> calculateCUsToUpdate(Collection<CompilationUnit> changed, Set<String> oldPackages, WurstModel model) {
        TreeSet<CompilationUnit> result = new TreeSet<CompilationUnit>(Comparator.comparing(cu -> cu.getCuInfo().getFile()));
        result.addAll(changed);
        if (changed.stream().anyMatch(cu -> cu.getCuInfo().getFile().endsWith(".j"))) {
            result.addAll(model);
            return result;
        }
        Stream<String> providedPackages = changed.stream().flatMap(cu -> cu.getPackages().stream()).map(WPackage::getName);
        Set<String> affectedPackages = Stream.concat(providedPackages, oldPackages.stream()).collect(Collectors.toSet());
        this.addPossiblyAffectedPackages(affectedPackages, model, result);
        return result;
    }

    private void addPossiblyAffectedPackages(Collection<String> providedPackages, WurstModel model, Set<CompilationUnit> result) {
        block0: for (CompilationUnit compilationUnit : model) {
            if (result.contains(compilationUnit)) continue;
            for (WPackage p : compilationUnit.getPackages()) {
                for (WImport imp : p.getImports()) {
                    String importedPackage = imp.getPackagenameId().getName();
                    if (!providedPackages.contains(importedPackage)) continue;
                    result.add(compilationUnit);
                    continue block0;
                }
            }
        }
        this.addTransitiveDeps(result, model);
    }

    private void addTransitiveDeps(Set<CompilationUnit> result, WurstModel model) {
        Multimap<CompilationUnit, CompilationUnit> dependencyMap = this.calculateDirectDependencies(model);
        ArrayDeque<CompilationUnit> todo = new ArrayDeque<CompilationUnit>(result);
        while (!todo.isEmpty()) {
            CompilationUnit cu = todo.remove();
            Collection directDeps = dependencyMap.get((Object)cu);
            for (CompilationUnit c : directDeps) {
                if (!result.add(c)) continue;
                todo.add(c);
            }
        }
    }

    private Multimap<CompilationUnit, CompilationUnit> calculateDirectDependencies(WurstModel model) {
        HashMultimap result = HashMultimap.create();
        HashMap<String, CompilationUnit> cuForPackage = new HashMap<String, CompilationUnit>();
        for (CompilationUnit cu : model) {
            for (WPackage p : cu.getPackages()) {
                cuForPackage.put(p.getName(), cu);
            }
        }
        for (CompilationUnit cu : model) {
            for (WPackage p : cu.getPackages()) {
                for (WImport i : p.getImports()) {
                    CompilationUnit dep = (CompilationUnit)cuForPackage.get(i.getPackagename());
                    if (dep == null) continue;
                    result.put((Object)dep, (Object)cu);
                }
            }
        }
        return result;
    }

    @Override
    public synchronized Set<File> getDependencyWurstFiles() {
        HashSet result = Sets.newHashSet();
        for (File dep : this.dependencies) {
            this.addDependencyWurstFiles(result, dep);
        }
        return result;
    }

    private void addDependencyWurstFiles(Set<File> result, File file) {
        if (file.isDirectory()) {
            for (File child : this.getFiles(file)) {
                this.addDependencyWurstFiles(result, child);
            }
        } else if (Utils.isWurstFile(file)) {
            result.add(file);
        }
    }

    private WFile wFile(CompilationUnit cu) {
        return this.compilationunitFile.computeIfAbsent(cu, c -> WFile.create(cu.getCuInfo().getFile()));
    }

    private boolean isInWurstFolder(WFile file) {
        return Stream.concat(Stream.of(this.projectPath), this.dependencies.stream()).anyMatch(p -> FileUtils.isInDirectoryTrans(file, WFile.create(new File((File)p, "wurst"))));
    }

    @Override
    public File getProjectPath() {
        return this.projectPath;
    }
}

