// 1 "runtime/instruction.j"
// 1 "<built-in>"
// 1 "<command-line>"
// 31 "<command-line>"
// 1 "/usr/include/stdc-predef.h" 1 3 4
// 32 "<command-line>" 2
// 1 "runtime/instruction.j"



globals

    constant integer JHCR_Ins_Lt = 1
    constant integer JHCR_Ins_Le = 2
    constant integer JHCR_Ins_Gt = 3
    constant integer JHCR_Ins_Ge = 4
    constant integer JHCR_Ins_Eq = 5
    constant integer JHCR_Ins_Neq = 6

    constant integer JHCR_Ins_Add = 7
    constant integer JHCR_Ins_Sub = 8
    constant integer JHCR_Ins_Mul = 9
    constant integer JHCR_Ins_Div = 10
    constant integer JHCR_Ins_Mod = 11

    constant integer JHCR_Ins_SetLocalArray = 12
    constant integer JHCR_Ins_GetLocalArray = 13
    constant integer JHCR_Ins_SetGlobalArray = 14
    constant integer JHCR_Ins_GetGlobalArray = 15

    constant integer JHCR_Ins_Negate = 16
    constant integer JHCR_Ins_Set = 17
    constant integer JHCR_Ins_SetGlobal = 18
    constant integer JHCR_Ins_GetGlobal = 19
    constant integer JHCR_Ins_Bind = 20

    constant integer JHCR_Ins_Lit = 21
    constant integer JHCR_Ins_Call = 22
    constant integer JHCR_Ins_Convert = 23


    constant integer JHCR_Ins_Label = 24
    constant integer JHCR_Ins_Jmp = 25
    constant integer JHCR_Ins_Fun = 26
    constant integer JHCR_Ins_JmpT = 27

    constant integer JHCR_Ins_Not = 28

    constant integer JHCR_Ins_Ret = 29



    string array JHCR_Ins_OpNames


// 1 "runtime/alloc-globals.j" 1

integer JHCR_Ins_F = 0
integer array JHCR_Ins_V
integer JHCR_Ins_I = 0
// 50 "runtime/instruction.j" 2
// 63 "runtime/instruction.j"
    integer array JHCR_Ins_next
    integer array JHCR_Ins_op
    integer array JHCR_Ins_type

    integer array JHCR_Ins_a1
    integer array JHCR_Ins_a2
    integer array JHCR_Ins_a3


    string array JHCR_Ins_string
    integer array JHCR_Ins_integer
    real array JHCR_Ins_real
    boolean array JHCR_Ins_boolean

endglobals

// 1 "runtime/alloc.j" 1

function JHCR_Ins_alloc takes nothing returns integer
    local integer JHCR_Ins_this = JHCR_Ins_F
    if JHCR_Ins_this != 0 then
        set JHCR_Ins_F = JHCR_Ins_V[JHCR_Ins_this]
    else
        set JHCR_Ins_I = JHCR_Ins_I+1
        set JHCR_Ins_this = JHCR_Ins_I
    endif

    if JHCR_Ins_this >= JASS_MAX_ARRAY_SIZE then
        call JHCR_Print_print("no more free instances " + "JHCR_Ins__BASE_FILE__")
        return 0
    endif

    set JHCR_Ins_V[JHCR_Ins_this] = -1
    return JHCR_Ins_this
endfunction

function JHCR_Ins_free takes integer JHCR_Ins_this returns nothing
    if JHCR_Ins_this == 0 then
        call JHCR_Print_print("free of nullptr " + "JHCR_Ins__BASE_FILE__")
        return
    elseif JHCR_Ins_V[JHCR_Ins_this] != -1 then
        call JHCR_Print_print("Double free in " + "JHCR_Ins__BASE_FILE__")
        return
    endif
    set JHCR_Ins_V[JHCR_Ins_this] = JHCR_Ins_F
    set JHCR_Ins_F = JHCR_Ins_this
endfunction
// 80 "runtime/instruction.j" 2

function JHCR_Ins_repr takes integer JHCR_Ins_ins returns string
    return I2S(JHCR_Ins_op[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_type[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a2[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a3[JHCR_Ins_ins])
endfunction

function JHCR_Ins_toString takes integer JHCR_Ins_ins returns string
    if JHCR_Ins_op[JHCR_Ins_ins] <= JHCR_Ins_GetLocalArray then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a2[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a3[JHCR_Ins_ins]))
    elseif JHCR_Ins_op[JHCR_Ins_ins] <= JHCR_Ins_Bind then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a2[JHCR_Ins_ins]) )
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Lit then
        if JHCR_Ins_type[JHCR_Ins_ins] == JHCR_Types_string then
            return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ (JHCR_Ins_string[JHCR_Ins_ins]) )
        elseif JHCR_Ins_type[JHCR_Ins_ins] == JHCR_Types_integer then
            return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_integer[JHCR_Ins_ins]) )
        elseif JHCR_Ins_type[JHCR_Ins_ins] == JHCR_Types_real then
            return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ R2S(JHCR_Ins_real[JHCR_Ins_ins]) )
        elseif JHCR_Ins_type[JHCR_Ins_ins] == JHCR_Types_boolean then
            return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ JHCR_Print_b2s(JHCR_Ins_boolean[JHCR_Ins_ins]) )
        else
            return JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" null"
        endif
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Call then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a2[JHCR_Ins_ins]) )
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Convert then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ JHCR_Types_TypeNames[JHCR_Ins_a2[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a3[JHCR_Ins_ins]))
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Label then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) )
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Jmp then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) )
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Fun then
        if JHCR_Ins_a1[JHCR_Ins_ins] < 0 then
            return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ JHCR_Ins_string[JHCR_Ins_ins])
        else
            return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) )
        endif
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_JmpT then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a2[JHCR_Ins_ins]) )
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Not then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ I2S(JHCR_Ins_a1[JHCR_Ins_ins]) +" "+ I2S(JHCR_Ins_a2[JHCR_Ins_ins]) )
    elseif JHCR_Ins_op[JHCR_Ins_ins] == JHCR_Ins_Ret then
        return(JHCR_Ins_OpNames[JHCR_Ins_op[JHCR_Ins_ins]] +" "+ JHCR_Types_TypeNames[JHCR_Ins_type[JHCR_Ins_ins]] )
    else
        return("unknown op " +I2S(JHCR_Ins_op[JHCR_Ins_ins]))
    endif

endfunction

function JHCR_Ins_destroy takes integer JHCR_Ins_ins returns nothing
    loop
    exitwhen JHCR_Ins_ins == 0
        call JHCR_Ins_free(JHCR_Ins_ins)
        set JHCR_Ins_ins = JHCR_Ins_next[JHCR_Ins_ins]
    endloop
endfunction

function JHCR_Ins_print takes integer JHCR_Ins_i returns nothing

    call JHCR_Print_print(JHCR_Ins_toString(JHCR_Ins_i))
endfunction

function JHCR_Ins_init takes nothing returns nothing
    set JHCR_Ins_OpNames[JHCR_Ins_Not]="not"
    set JHCR_Ins_OpNames[JHCR_Ins_Neq]="neq"
    set JHCR_Ins_OpNames[JHCR_Ins_JmpT]="jmpt"
    set JHCR_Ins_OpNames[JHCR_Ins_Jmp]="jmp"
    set JHCR_Ins_OpNames[JHCR_Ins_Lit]="lit"
    set JHCR_Ins_OpNames[JHCR_Ins_Bind]="bind"
    set JHCR_Ins_OpNames[JHCR_Ins_Set]="set"
    set JHCR_Ins_OpNames[JHCR_Ins_Call]="call"
    set JHCR_Ins_OpNames[JHCR_Ins_Add]="add"
    set JHCR_Ins_OpNames[JHCR_Ins_Mul]="mul"
    set JHCR_Ins_OpNames[JHCR_Ins_Div]="div"
    set JHCR_Ins_OpNames[JHCR_Ins_Sub]="sub"
    set JHCR_Ins_OpNames[JHCR_Ins_Mod]="mod"
    set JHCR_Ins_OpNames[JHCR_Ins_Negate]="neg"
    set JHCR_Ins_OpNames[JHCR_Ins_SetLocalArray]="sla"
    set JHCR_Ins_OpNames[JHCR_Ins_GetLocalArray]="gla"
    set JHCR_Ins_OpNames[JHCR_Ins_SetGlobalArray]="sga"
    set JHCR_Ins_OpNames[JHCR_Ins_GetGlobalArray]="gga"
    set JHCR_Ins_OpNames[JHCR_Ins_SetGlobal]="sg"
    set JHCR_Ins_OpNames[JHCR_Ins_GetGlobal]="gg"
    set JHCR_Ins_OpNames[JHCR_Ins_Ret]="ret"
    set JHCR_Ins_OpNames[JHCR_Ins_Label]="lbl"
    set JHCR_Ins_OpNames[JHCR_Ins_Eq]="eq"
    set JHCR_Ins_OpNames[JHCR_Ins_Lt]="lt"
    set JHCR_Ins_OpNames[JHCR_Ins_Le]="le"
    set JHCR_Ins_OpNames[JHCR_Ins_Ge]="ge"
    set JHCR_Ins_OpNames[JHCR_Ins_Gt]="gt"
    set JHCR_Ins_OpNames[JHCR_Ins_Convert]="conv"
    set JHCR_Ins_OpNames[JHCR_Ins_Fun]="fun"

endfunction
