/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.file.SimpleDataInput;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackBitmapIndexV1
extends BasePackBitmapIndex {
    static final byte[] MAGIC = new byte[]{66, 73, 84, 77};
    static final int OPT_FULL = 1;
    private static final int MAX_XOR_OFFSET = 126;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory baseFactory = Executors.defaultThreadFactory();
        private final AtomicInteger threadNumber = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread2 = this.baseFactory.newThread(runnable);
            thread2.setName("JGit-PackBitmapIndexV1-" + this.threadNumber.getAndIncrement());
            thread2.setDaemon(true);
            return thread2;
        }
    });
    private final PackIndex packIndex;
    private final PackReverseIndex reverseIndex;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap> bitmaps = this.getBitmaps();

    PackBitmapIndexV1(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        this(fd, () -> packIndex, () -> reverseIndex, false);
    }

    PackBitmapIndexV1(InputStream fd, PackBitmapIndex.SupplierWithIOException<PackIndex> packIndexSupplier, PackBitmapIndex.SupplierWithIOException<PackReverseIndex> reverseIndexSupplier, boolean loadParallelRevIndex) throws IOException {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        PackReverseIndex computedReverseIndex;
        Future<PackReverseIndex> reverseIndexFuture = null;
        if (loadParallelRevIndex) {
            reverseIndexFuture = executor.submit(reverseIndexSupplier::get);
        }
        byte[] scratch = new byte[32];
        IO.readFully(fd, scratch, 0, scratch.length);
        int i = 0;
        while (i < MAGIC.length) {
            if (scratch[i] != MAGIC[i]) {
                byte[] actual = new byte[MAGIC.length];
                System.arraycopy(scratch, 0, actual, 0, MAGIC.length);
                throw new IOException(MessageFormat.format(JGitText.get().expectedGot, Arrays.toString(MAGIC), Arrays.toString(actual)));
            }
            ++i;
        }
        int version = NB.decodeUInt16(scratch, 4);
        if (version != 1) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, version));
        }
        int opts = NB.decodeUInt16(scratch, 6);
        if ((opts & 1) == 0) {
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, 1, opts));
        }
        long numEntries = NB.decodeUInt32(scratch, 8);
        if (numEntries > Integer.MAX_VALUE) {
            throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
        }
        this.packChecksum = new byte[20];
        System.arraycopy(scratch, 12, this.packChecksum, 0, this.packChecksum.length);
        SimpleDataInput dataInput = new SimpleDataInput(fd);
        this.commits = PackBitmapIndexV1.readBitmap(dataInput);
        this.trees = PackBitmapIndexV1.readBitmap(dataInput);
        this.blobs = PackBitmapIndexV1.readBitmap(dataInput);
        this.tags = PackBitmapIndexV1.readBitmap(dataInput);
        ArrayList<IdxPositionBitmap> idxPositionBitmapList = new ArrayList<IdxPositionBitmap>();
        IdxPositionBitmap[] recentBitmaps = new IdxPositionBitmap[126];
        int i2 = 0;
        while (i2 < (int)numEntries) {
            int index;
            IO.readFully(fd, scratch, 0, 6);
            int nthObjectId = NB.decodeInt32(scratch, 0);
            byte xorOffset = scratch[4];
            byte flags = scratch[5];
            EWAHCompressedBitmap bitmap = PackBitmapIndexV1.readBitmap(dataInput);
            if (nthObjectId < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(nthObjectId)));
            }
            if (xorOffset < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(xorOffset)));
            }
            if (xorOffset > 126) {
                throw new IOException(MessageFormat.format(JGitText.get().expectedLessThanGot, String.valueOf(126), String.valueOf(xorOffset)));
            }
            if (xorOffset > i2) {
                throw new IOException(MessageFormat.format(JGitText.get().expectedLessThanGot, String.valueOf(i2), String.valueOf(xorOffset)));
            }
            IdxPositionBitmap xorIdxPositionBitmap = null;
            if (xorOffset > 0 && (xorIdxPositionBitmap = recentBitmaps[(index = i2 - xorOffset) % recentBitmaps.length]) == null) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(xorOffset)));
            }
            IdxPositionBitmap idxPositionBitmap = new IdxPositionBitmap(nthObjectId, xorIdxPositionBitmap, bitmap, flags);
            idxPositionBitmapList.add(idxPositionBitmap);
            recentBitmaps[i2 % recentBitmaps.length] = idxPositionBitmap;
            ++i2;
        }
        this.packIndex = packIndexSupplier.get();
        i2 = 0;
        while (i2 < idxPositionBitmapList.size()) {
            BasePackBitmapIndex.StoredBitmap sb;
            IdxPositionBitmap idxPositionBitmap = (IdxPositionBitmap)idxPositionBitmapList.get(i2);
            ObjectId objectId = this.packIndex.getObjectId(idxPositionBitmap.nthObjectId);
            idxPositionBitmap.sb = sb = new BasePackBitmapIndex.StoredBitmap(objectId, idxPositionBitmap.bitmap, idxPositionBitmap.getXorStoredBitmap(), idxPositionBitmap.flags);
            this.bitmaps.add(sb);
            ++i2;
        }
        if (loadParallelRevIndex && reverseIndexFuture != null) {
            try {
                computedReverseIndex = reverseIndexFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                computedReverseIndex = reverseIndexSupplier.get();
            }
        } else {
            computedReverseIndex = reverseIndexSupplier.get();
        }
        this.reverseIndex = computedReverseIndex;
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        long offset = this.packIndex.findOffset(objectId);
        if (offset == -1L) {
            return -1;
        }
        return this.reverseIndex.findPosition(offset);
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectId objectId = this.reverseIndex.findObjectByPosition(position);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    @Override
    public int getObjectCount() {
        return (int)this.packIndex.getObjectCount();
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type2) {
        switch (type2) {
            case 3: {
                return this.blobs.and(bitmap);
            }
            case 2: {
                return this.trees.and(bitmap);
            }
            case 1: {
                return this.commits.and(bitmap);
            }
            case 4: {
                return this.tags.and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getBitmapCount() {
        return this.bitmaps.size();
    }

    public boolean equals(Object o) {
        if (o instanceof PackBitmapIndexV1) {
            return this.getPackIndex() == ((PackBitmapIndexV1)o).getPackIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.getPackIndex().hashCode();
    }

    PackIndex getPackIndex() {
        return this.packIndex;
    }

    private static EWAHCompressedBitmap readBitmap(DataInput dataInput) throws IOException {
        EWAHCompressedBitmap bitmap = new EWAHCompressedBitmap();
        bitmap.deserialize(dataInput);
        return bitmap;
    }

    private static final class IdxPositionBitmap {
        int nthObjectId;
        IdxPositionBitmap xorIdxPositionBitmap;
        EWAHCompressedBitmap bitmap;
        int flags;
        BasePackBitmapIndex.StoredBitmap sb;

        IdxPositionBitmap(int nthObjectId, @Nullable IdxPositionBitmap xorIdxPositionBitmap, EWAHCompressedBitmap bitmap, int flags) {
            this.nthObjectId = nthObjectId;
            this.xorIdxPositionBitmap = xorIdxPositionBitmap;
            this.bitmap = bitmap;
            this.flags = flags;
        }

        BasePackBitmapIndex.StoredBitmap getXorStoredBitmap() {
            return this.xorIdxPositionBitmap == null ? null : this.xorIdxPositionBitmap.sb;
        }
    }
}

