/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;

public final class Moduli {
    public static final String INTERNAL_MODULI_RESPATH = "/org/apache/sshd/moduli";
    public static final int MODULI_TYPE_SAFE = 2;
    public static final int MODULI_TESTS_COMPOSITE = 1;
    private static final AtomicReference<Map.Entry<String, List<DhGroup>>> INTERNAL_MODULI_HOLDER = new AtomicReference();

    private Moduli() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Map.Entry<String, List<DhGroup>> clearInternalModuliCache() {
        return INTERNAL_MODULI_HOLDER.getAndSet(null);
    }

    public static List<DhGroup> loadInternalModuli(URL url) throws IOException {
        String lastResource;
        if (url == null) {
            throw new FileNotFoundException("No internal moduli resource specified");
        }
        String moduliStr = url.toExternalForm();
        Map.Entry<String, List<DhGroup>> lastModuli = INTERNAL_MODULI_HOLDER.get();
        String string = lastResource = lastModuli == null ? null : lastModuli.getKey();
        if (Objects.equals(lastResource, moduliStr)) {
            return lastModuli.getValue();
        }
        List<DhGroup> groups2 = Moduli.parseModuli(url);
        groups2 = GenericUtils.isEmpty(groups2) ? Collections.emptyList() : Collections.unmodifiableList(groups2);
        INTERNAL_MODULI_HOLDER.set(new AbstractMap.SimpleImmutableEntry<String, List<DhGroup>>(moduliStr, groups2));
        return groups2;
    }

    public static List<DhGroup> parseModuli(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            List<DhGroup> list = Moduli.parseModuli(inputStream);
            return list;
        }
    }

    public static List<DhGroup> parseModuli(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            List<DhGroup> list = Moduli.parseModuli(reader);
            return list;
        }
    }

    public static List<DhGroup> parseModuli(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return Moduli.parseModuli((BufferedReader)reader);
        }
        try (BufferedReader r = new BufferedReader(reader);){
            List<DhGroup> list = Moduli.parseModuli(r);
            return list;
        }
    }

    public static List<DhGroup> parseModuli(BufferedReader r) throws IOException {
        ArrayList<DhGroup> groups2 = new ArrayList<DhGroup>();
        String line = r.readLine();
        while (line != null) {
            int tries;
            int tests;
            int type2;
            String[] parts;
            if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#' && (parts = line.split("\\s+")).length == 7 && (type2 = Integer.parseInt(parts[1])) == 2 && ((tests = Integer.parseInt(parts[2])) & 1) == 0 && (tests & 0xFFFFFFFE) != 0 && (tries = Integer.parseInt(parts[3])) != 0) {
                DhGroup group = new DhGroup(Integer.parseInt(parts[4]) + 1, new BigInteger(parts[5], 16), new BigInteger(parts[6], 16));
                groups2.add(group);
            }
            line = r.readLine();
        }
        return groups2;
    }

    public static class DhGroup {
        private final int size;
        private final BigInteger g;
        private final BigInteger p;

        public DhGroup(int size, BigInteger g, BigInteger p) {
            this.size = size;
            this.g = Objects.requireNonNull(g, "No G value provided");
            this.p = Objects.requireNonNull(p, "No P value provided");
        }

        public int getSize() {
            return this.size;
        }

        public BigInteger getG() {
            return this.g;
        }

        public BigInteger getP() {
            return this.p;
        }

        public String toString() {
            return "[size=" + this.getSize() + ", G=" + this.getG() + ", P=" + this.getP() + "]";
        }
    }
}

