/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JScrollPane;
import tablelayout.BaseTableLayout;
import tablelayout.Cell;
import tablelayout.Table;
import tablelayout.TableLayout;
import tablelayout.Toolkit;

class SwingToolkit
extends Toolkit<Component, Table, TableLayout> {
    static Timer timer;
    static ArrayList<TableLayout> debugLayouts;

    SwingToolkit() {
    }

    @Override
    public Cell obtainCell(TableLayout layout) {
        Cell cell = new Cell();
        cell.setLayout(layout);
        return cell;
    }

    @Override
    public void freeCell(Cell cell) {
    }

    @Override
    public void addChild(Component parent, Component child) {
        if (parent instanceof JScrollPane) {
            ((JScrollPane)parent).setViewportView(child);
        } else {
            ((Container)parent).add(child);
        }
    }

    @Override
    public void removeChild(Component parent, Component child) {
        ((Container)parent).remove(child);
    }

    @Override
    public float getMinWidth(Component widget) {
        return widget.getMinimumSize().width;
    }

    @Override
    public float getMinHeight(Component widget) {
        return widget.getMinimumSize().height;
    }

    @Override
    public float getPrefWidth(Component widget) {
        return widget.getPreferredSize().width;
    }

    @Override
    public float getPrefHeight(Component widget) {
        return widget.getPreferredSize().height;
    }

    @Override
    public float getMaxWidth(Component widget) {
        return widget.getMaximumSize().width;
    }

    @Override
    public float getMaxHeight(Component widget) {
        return widget.getMaximumSize().height;
    }

    @Override
    public float getWidth(Component widget) {
        return widget.getWidth();
    }

    @Override
    public float getHeight(Component widget) {
        return widget.getHeight();
    }

    @Override
    public void clearDebugRectangles(TableLayout layout) {
        if (layout.debugRects != null) {
            debugLayouts.remove(this);
        }
        layout.debugRects = null;
    }

    @Override
    public void addDebugRectangle(TableLayout layout, BaseTableLayout.Debug type2, float x, float y, float w, float h) {
        if (layout.debugRects == null) {
            layout.debugRects = new ArrayList();
            debugLayouts.add(layout);
        }
        layout.debugRects.add(new DebugRect(type2, x, y, w, h));
    }

    static void startDebugTimer() {
        if (timer != null) {
            return;
        }
        timer = new Timer("TableLayout Debug", true);
        timer.schedule(SwingToolkit.newDebugTask(), 100L);
    }

    static TimerTask newDebugTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(this);
                    return;
                }
                for (TableLayout layout : debugLayouts) {
                    layout.drawDebug();
                }
                timer.schedule(SwingToolkit.newDebugTask(), 250L);
            }
        };
    }

    static {
        debugLayouts = new ArrayList(0);
    }

    static class DebugRect {
        final BaseTableLayout.Debug type;
        final int x;
        final int y;
        final int width;
        final int height;

        public DebugRect(BaseTableLayout.Debug type2, float x, float y, float width, float height) {
            this.x = (int)x;
            this.y = (int)y;
            this.width = (int)(width - 1.0f);
            this.height = (int)(height - 1.0f);
            this.type = type2;
        }
    }
}

