/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.internal.transport.sshd.proxy.AuthenticationChallenge;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatusLine;
import org.eclipse.jgit.util.HttpSupport;

public final class HttpParser {
    private HttpParser() {
    }

    public static StatusLine parseStatusLine(String line) throws ParseException {
        int resultCode;
        int firstBlank = line.indexOf(32);
        if (firstBlank < 0) {
            throw new ParseException();
        }
        int secondBlank = line.indexOf(32, firstBlank + 1);
        if (secondBlank < 0) {
            secondBlank = line.length();
        }
        try {
            resultCode = Integer.parseUnsignedInt(line.substring(firstBlank + 1, secondBlank));
        }
        catch (NumberFormatException e) {
            throw new ParseException(e);
        }
        String reason = "";
        if (secondBlank < line.length()) {
            reason = line.substring(secondBlank + 1);
        }
        return new StatusLine(line.substring(0, firstBlank), resultCode, reason);
    }

    public static List<AuthenticationChallenge> getAuthenticationHeaders(List<String> reply, String authenticationHeader) {
        ArrayList<AuthenticationChallenge> challenges = new ArrayList<AuthenticationChallenge>();
        Iterator<String> lines = reply.iterator();
        lines.next();
        StringBuilder value = null;
        while (lines.hasNext()) {
            int firstColon;
            String line = lines.next();
            if (line.isEmpty()) break;
            if (Character.isWhitespace(line.charAt(0))) {
                if (value == null) continue;
                int i = HttpParser.skipWhiteSpace(line, 1);
                value.append(' ').append(line, i, line.length());
                continue;
            }
            if (value != null) {
                HttpParser.parseChallenges(challenges, value.toString());
                value = null;
            }
            if ((firstColon = line.indexOf(58)) <= 0 || !authenticationHeader.equalsIgnoreCase(line.substring(0, firstColon + 1))) continue;
            value = new StringBuilder(line.substring(firstColon + 1));
        }
        if (value != null) {
            HttpParser.parseChallenges(challenges, value.toString());
        }
        return challenges;
    }

    private static void parseChallenges(List<AuthenticationChallenge> challenges, String header) {
        int length = header.length();
        int i = 0;
        while (i < length) {
            int start = HttpParser.skipWhiteSpace(header, i);
            int end = HttpSupport.scanToken(header, start);
            if (end <= start) break;
            AuthenticationChallenge challenge = new AuthenticationChallenge(header.substring(start, end));
            challenges.add(challenge);
            i = HttpParser.parseChallenge(challenge, header, end);
        }
    }

    private static int parseChallenge(AuthenticationChallenge challenge, String header, int from) {
        int length = header.length();
        boolean first = true;
        int start = from;
        while (start <= length) {
            int end = HttpSupport.scanToken(header, start = HttpParser.skipWhiteSpace(header, start));
            if (end == start) {
                if (start < header.length() && header.charAt(start) == ',') {
                    return start + 1;
                }
                return start;
            }
            int next = HttpParser.skipWhiteSpace(header, end);
            if (next >= length || header.charAt(next) != '=') {
                if (first) {
                    challenge.setToken(header.substring(start, end));
                    if (next < length && header.charAt(next) == ',') {
                        ++next;
                    }
                    return next;
                }
                return start;
            }
            int nextStart = HttpParser.skipWhiteSpace(header, next + 1);
            if (nextStart >= length) {
                if (next == end) {
                    challenge.setToken(header.substring(start, end + 1));
                } else {
                    challenge.addArgument(header.substring(start, end), null);
                }
                return nextStart;
            }
            if (nextStart == end + 1 && header.charAt(nextStart) == '=') {
                end = nextStart + 1;
                while (end < length && header.charAt(end) == '=') {
                    ++end;
                }
                challenge.setToken(header.substring(start, end));
                end = HttpParser.skipWhiteSpace(header, end);
                if (end < length && header.charAt(end) == ',') {
                    ++end;
                }
                return end;
            }
            if (header.charAt(nextStart) == ',') {
                if (next == end) {
                    challenge.setToken(header.substring(start, end + 1));
                    return nextStart + 1;
                }
                challenge.addArgument(header.substring(start, end), null);
                start = nextStart + 1;
            } else {
                if (header.charAt(nextStart) == '\"') {
                    int[] nextEnd = new int[]{nextStart + 1};
                    String value = HttpParser.scanQuotedString(header, nextStart + 1, nextEnd);
                    challenge.addArgument(header.substring(start, end), value);
                    start = nextEnd[0];
                } else {
                    int nextEnd = HttpSupport.scanToken(header, nextStart);
                    challenge.addArgument(header.substring(start, end), header.substring(nextStart, nextEnd));
                    start = nextEnd;
                }
                start = HttpParser.skipWhiteSpace(header, start);
                if (start < length && header.charAt(start) == ',') {
                    ++start;
                }
            }
            first = false;
        }
        return length;
    }

    private static int skipWhiteSpace(String header, int i) {
        int length = header.length();
        while (i < length && Character.isWhitespace(header.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static String scanQuotedString(String header, int from, int[] to) {
        StringBuilder result2 = new StringBuilder();
        int length = header.length();
        boolean quoted = false;
        int i = from;
        while (i < length) {
            char c = header.charAt(i++);
            if (quoted) {
                result2.append(c);
                quoted = false;
                continue;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (c == '\"') break;
            result2.append(c);
        }
        to[0] = i;
        return result2.toString();
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -1634090143702048640L;

        public ParseException() {
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

