/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import javax.security.auth.DestroyFailedException;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.sshd.KeyCache;

public class CachingKeyPairProvider
extends FileKeyPairProvider
implements Iterable<KeyPair> {
    public static final AttributeRepository.AttributeKey<Map<String, Path>> KEY_PATHS_BY_FINGERPRINT = new AttributeRepository.AttributeKey();
    private final KeyCache cache;

    public CachingKeyPairProvider(List<Path> paths, KeyCache cache2) {
        super(paths);
        this.cache = cache2;
    }

    @Override
    public Iterator<KeyPair> iterator() {
        return this.iterator(null);
    }

    private Iterator<KeyPair> iterator(SessionContext session) {
        Collection<? extends Path> resources = this.getPaths();
        if (resources.isEmpty()) {
            return Collections.emptyListIterator();
        }
        return new CancellingKeyPairIterator(session, resources);
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session) {
        return () -> this.iterator(session);
    }

    static String getKeyId(ClientSession session, KeyPair identity) {
        Path path;
        String fingerprint = KeyUtils.getFingerPrint(identity.getPublic());
        Map<String, Path> registered = session.getAttribute(KEY_PATHS_BY_FINGERPRINT);
        if (registered != null && (path = registered.get(fingerprint)) != null) {
            Path home = session.resolveAttribute(JGitSshClient.HOME_DIRECTORY);
            if (home != null && path.startsWith(home)) {
                try {
                    path = home.relativize(path);
                    String pathString = path.toString();
                    if (!pathString.isEmpty()) {
                        return "~" + File.separator + pathString;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return path.toString();
        }
        return fingerprint;
    }

    private KeyPair loadKey(SessionContext session, Path path) throws IOException, GeneralSecurityException {
        if (!Files.exists(path, new LinkOption[0])) {
            this.log.warn(MessageFormat.format(SshdText.get().identityFileNotFound, path));
            return null;
        }
        IoResource<Path> resource = this.getIoResource(session, path);
        if (this.cache == null) {
            return this.loadKey(session, resource, path, this.getPasswordFinder());
        }
        Throwable[] t = new Throwable[1];
        KeyPair key = this.cache.get(path, p -> {
            try {
                return this.loadKey(session, resource, (Path)p, this.getPasswordFinder());
            }
            catch (IOException | GeneralSecurityException e) {
                throwableArray[0] = e;
                return null;
            }
        });
        if (t[0] != null) {
            if (t[0] instanceof CancellationException) {
                throw (CancellationException)t[0];
            }
            throw new IOException(MessageFormat.format(SshdText.get().keyLoadFailed, resource), t[0]);
        }
        return key;
    }

    private KeyPair loadKey(SessionContext session, NamedResource resource, Path path, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            Iterable<KeyPair> ids = SecurityUtils.loadKeyPairIdentities(session, resource, stream, passwordProvider);
            if (ids == null) {
                throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileNoKey, path));
            }
            Iterator<KeyPair> keys2 = ids.iterator();
            if (!keys2.hasNext()) {
                throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileUnsupportedFormat, path));
            }
            KeyPair result2 = keys2.next();
            PublicKey pk = result2.getPublic();
            if (pk != null) {
                Map<String, Path> registered = session.getAttribute(KEY_PATHS_BY_FINGERPRINT);
                if (registered == null) {
                    registered = new HashMap<String, Path>();
                    session.setAttribute(KEY_PATHS_BY_FINGERPRINT, registered);
                }
                registered.put(KeyUtils.getFingerPrint(pk), path);
            }
            if (keys2.hasNext()) {
                this.log.warn(MessageFormat.format(SshdText.get().identityFileMultipleKeys, path));
                keys2.forEachRemaining(k -> {
                    PrivateKey priv = k.getPrivate();
                    if (priv != null) {
                        try {
                            priv.destroy();
                        }
                        catch (DestroyFailedException destroyFailedException) {
                            // empty catch block
                        }
                    }
                });
            }
            return result2;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class CancellingKeyPairIterator
    implements Iterator<KeyPair> {
        private final SessionContext context;
        private final Iterator<Path> paths;
        private KeyPair nextItem;
        private boolean nextSet;

        public CancellingKeyPairIterator(SessionContext session, Collection<? extends Path> resources) {
            ArrayList<? extends Path> copy2 = new ArrayList<Path>(resources.size());
            copy2.addAll(resources);
            this.paths = copy2.iterator();
            this.context = session;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return this.nextItem != null;
            }
            this.nextSet = true;
            while (this.nextItem == null && this.paths.hasNext()) {
                try {
                    this.nextItem = CachingKeyPairProvider.this.loadKey(this.context, this.paths.next());
                }
                catch (CancellationException cancelled) {
                    throw cancelled;
                }
                catch (Exception other) {
                    CachingKeyPairProvider.this.log.warn(other.getMessage(), other);
                }
            }
            return this.nextItem != null;
        }

        @Override
        public KeyPair next() {
            if (!this.nextSet && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyPair result2 = this.nextItem;
            this.nextItem = null;
            this.nextSet = false;
            if (result2 == null) {
                throw new NoSuchElementException();
            }
            return result2;
        }
    }
}

